/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesComponentImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantBuilderImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureNameWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.ProjectOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Bc\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J6\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00062\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/DynamicFeatureTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantBuilderImpl;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantImpl;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/api/component/impl/TestComponentImpl;", "testFixturesComponents", "Lcom/android/build/api/component/impl/TestFixturesComponentImpl;", "hasFlavors", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "extension", "Lcom/android/build/gradle/BaseExtension;", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/BaseExtension;Lcom/android/build/gradle/internal/scope/ProjectInfo;)V", "createDynamicBundleTask", "", "variantProperties", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "doCreateTasksForVariant", "variantInfo", "allVariants", "gradle-core"})
public final class DynamicFeatureTaskManager
extends AbstractAppTaskManager<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> {
    public DynamicFeatureTaskManager(@NotNull List<? extends ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl>> variants, @NotNull List<? extends TestComponentImpl> testComponents, @NotNull List<? extends TestFixturesComponentImpl> testFixturesComponents, boolean hasFlavors, @NotNull ProjectOptions projectOptions, @NotNull GlobalScope globalScope, @NotNull BaseExtension extension, @NotNull ProjectInfo projectInfo) {
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        Intrinsics.checkParameterIsNotNull(testComponents, (String)"testComponents");
        Intrinsics.checkParameterIsNotNull(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)projectInfo, (String)"projectInfo");
        super(variants, testComponents, testFixturesComponents, hasFlavors, projectOptions, globalScope, extension, projectInfo);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> variantInfo, @NotNull List<? extends ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl>> allVariants) {
        Intrinsics.checkParameterIsNotNull(variantInfo, (String)"variantInfo");
        Intrinsics.checkParameterIsNotNull(allVariants, (String)"allVariants");
        this.createCommonTasks(variantInfo, allVariants);
        DynamicFeatureVariantImpl variant2 = variantInfo.getVariant();
        this.createDynamicBundleTask(variant2);
        this.taskFactory.register(new FeatureSplitDeclarationWriterTask.CreationAction(variant2));
        if (variant2.getBuildFeatures().getDataBinding()) {
            this.taskFactory.register(new DataBindingExportFeatureInfoTask.CreationAction(variant2));
        }
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureNameWriterTask.CreationAction(variant2));
    }

    private final void createDynamicBundleTask(DynamicFeatureVariantImpl variantProperties) {
        if (variantProperties.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variantProperties));
        if (!variantProperties.getDebuggable()) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variantProperties));
        }
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
    }
}

