/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.utils.FileUtils;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \"2\u00020\u0001:\u0004!\"#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00178G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkSetArchive", "Lorg/gradle/api/file/RegularFileProperty;", "getApkSetArchive", "()Lorg/gradle/api/file/RegularFileProperty;", "apksFromBundleIdeModel", "getApksFromBundleIdeModel", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "<set-?>", "Ljava/io/File;", "deviceConfig", "getDeviceConfig", "()Ljava/io/File;", "dynamicModulesToInstall", "Lorg/gradle/api/provider/ListProperty;", "getDynamicModulesToInstall", "()Lorg/gradle/api/provider/ListProperty;", "", "extractInstant", "getExtractInstant", "()Z", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "BundleToolRunnable", "Companion", "CreationAction", "Params", "gradle-core"})
public abstract class ExtractApksTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private File deviceConfig;
    private boolean extractInstant;
    @NotNull
    public static final String namePrefix = "extractApksFor";

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getApkSetArchive();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @Nullable
    public final File getDeviceConfig() {
        return this.deviceConfig;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApksFromBundleIdeModel();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getDynamicModulesToInstall();

    @Input
    public final boolean getExtractInstant() {
        return this.extractInstant;
    }

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ ExtractApksTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getApkSetArchive().set((Provider)this.this$0.getApkSetArchive());
                File file = this.this$0.getDeviceConfig();
                if (file == null) {
                    throw new RuntimeException("Calling ExtractApk with no device config");
                }
                it.getDeviceConfig().set((Object)file);
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
                it.getExtractInstant().set((Object)this.this$0.getExtractInstant());
                it.getApksFromBundleIdeModel().set((Provider)this.this$0.getApksFromBundleIdeModel());
                it.getApplicationId().set((Provider)this.this$0.getApplicationId());
                it.getVariantName().set((Object)this.this$0.getVariantName());
                boolean bl = false;
                it.getOptionalListOfDynamicModulesToInstall().set(this.this$0.getDynamicModulesToInstall().orElse((Object)CollectionsKt.emptyList()));
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Companion;", "", "()V", "namePrefix", "", "getTaskName", "componentImpl", "Lcom/android/build/api/component/impl/ComponentImpl;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTaskName(@NotNull ComponentImpl componentImpl) {
            Intrinsics.checkParameterIsNotNull((Object)componentImpl, (String)"componentImpl");
            return componentImpl.computeTaskName(ExtractApksTask.namePrefix);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "apkSetArchive", "Lorg/gradle/api/file/RegularFileProperty;", "getApkSetArchive", "()Lorg/gradle/api/file/RegularFileProperty;", "apksFromBundleIdeModel", "getApksFromBundleIdeModel", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "deviceConfig", "Ljava/io/File;", "getDeviceConfig", "extractInstant", "", "getExtractInstant", "optionalListOfDynamicModulesToInstall", "Lorg/gradle/api/provider/ListProperty;", "getOptionalListOfDynamicModulesToInstall", "()Lorg/gradle/api/provider/ListProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "variantName", "getVariantName", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getApkSetArchive();

        @NotNull
        public abstract Property<File> getDeviceConfig();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract Property<Boolean> getExtractInstant();

        @NotNull
        public abstract RegularFileProperty getApksFromBundleIdeModel();

        @NotNull
        public abstract Property<String> getApplicationId();

        @NotNull
        public abstract Property<String> getVariantName();

        @NotNull
        public abstract ListProperty<String> getOptionalListOfDynamicModulesToInstall();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "()V", "run", "", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileUtils.cleanOutputDir((File)((File)((Params)this.getParameters()).getOutputDir().getAsFile().get()));
            Object object = Devices.DeviceSpec.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"newBuilder()");
            Devices.DeviceSpec.Builder builder = object;
            object = Files.newBufferedReader(((File)((Params)this.getParameters()).getDeviceConfig().get()).toPath(), Charsets.UTF_8);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl3 = false;
                JsonFormat.parser().merge((Reader)it, (Message.Builder)builder);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            ExtractApksCommand.Builder builder2 = ExtractApksCommand.builder().setApksArchivePath(((File)((Params)this.getParameters()).getApkSetArchive().getAsFile().get()).toPath()).setDeviceSpec(builder.build()).setOutputDirectory(((File)((Params)this.getParameters()).getOutputDir().getAsFile().get()).toPath());
            Object object2 = ((Params)this.getParameters()).getExtractInstant().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.extractInstant.get()");
            object2 = builder2.setInstant(((Boolean)object2).booleanValue());
            boolean bl4 = false;
            boolean bl5 = false;
            Object it = object2;
            boolean bl6 = false;
            Object object3 = ((Params)this.getParameters()).getOptionalListOfDynamicModulesToInstall().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.optionalListOfDynamicModulesToInstall.get()");
            object3 = (Collection)object3;
            boolean bl7 = false;
            if (!object3.isEmpty()) {
                object3 = ((Params)this.getParameters()).getOptionalListOfDynamicModulesToInstall().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.optionalListOfDynamicModulesToInstall.get()");
                it.setModules(GuavaKtxKt.toImmutableSet((Iterable)object3));
            }
            Object command = object2;
            command.build().execute();
            Artifact artifact = (Artifact)InternalArtifactType.EXTRACTED_APKS.INSTANCE;
            object2 = ((Params)this.getParameters()).getApplicationId().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.applicationId.get()");
            String string = (String)object2;
            object2 = ((Params)this.getParameters()).getVariantName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.variantName.get()");
            String string2 = (String)object2;
            object2 = ((File)((Params)this.getParameters()).getOutputDir().getAsFile().get()).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.outputDir.asFile.get().absolutePath");
            BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsImpl(0, artifact, string, string2, CollectionsKt.listOf((Object)BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, (String)object2, null, null, null, null, 30, null)), null, 33, null);
            object2 = ((Params)this.getParameters()).getApksFromBundleIdeModel().getAsFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.apksFromBundleIdeModel.asFile.get()");
            builtArtifactsImpl.saveToFile((File)object2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractApksTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, ExtractApksTask.namePrefix, null, 2, null);
        }

        @Override
        @NotNull
        public Class<ExtractApksTask> getType() {
            return ExtractApksTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractApksTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.EXTRACTED_APKS.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("output-metadata.json").on(InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractApksTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE, (Property)task.getApkSetArchive());
            String devicePath = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_SELECT_CONFIG);
            if (devicePath != null) {
                task.deviceConfig = new File(devicePath);
            }
            task.extractInstant = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.IDE_EXTRACT_INSTANT);
            HasConfigurableValuesKt.setDisallowChanges(task.getApplicationId(), ((ApkCreationConfig)this.creationConfig).getApplicationId());
            String optionalListOfDynamicModulesToInstall = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_INSTALL_DYNAMIC_MODULES_LIST);
            Object object = optionalListOfDynamicModulesToInstall;
            boolean bl = false;
            boolean bl2 = false;
            if (!(object == null || object.length() == 0)) {
                object = new char[1];
                object[0] = 44;
                task.getDynamicModulesToInstall().addAll((Iterable)StringsKt.split$default((CharSequence)optionalListOfDynamicModulesToInstall, (char[])object, (boolean)false, (int)0, (int)6, null));
            }
            task.getDynamicModulesToInstall().disallowChanges();
        }
    }
}

