/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.InAndOutDirectoryOperationRequest;
import com.android.build.api.artifact.impl.InAndOutDirectoryOperationRequestImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTask;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTaskKt;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.workeractions.DecoratedWorkParameters;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0015R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00130\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "enableResourceObfuscation", "Lorg/gradle/api/provider/Property;", "", "getEnableResourceObfuscation", "()Lorg/gradle/api/provider/Property;", "inputProcessedRes", "Lorg/gradle/api/file/DirectoryProperty;", "getInputProcessedRes", "()Lorg/gradle/api/file/DirectoryProperty;", "optimizedProcessedRes", "getOptimizedProcessedRes", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "variantOutputs", "Lorg/gradle/api/provider/ListProperty;", "Lcom/android/build/api/variant/impl/VariantOutputImpl;", "getVariantOutputs", "()Lorg/gradle/api/provider/ListProperty;", "doTaskAction", "", "Aapt2OptimizeWorkAction", "CreateAction", "OptimizeResourcesParams", "gradle-core"})
public abstract class OptimizeResourcesTask
extends NonIncrementalTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputProcessedRes();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableResourceObfuscation();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<OptimizeResourcesTask>> getTransformationRequest();

    @Nested
    @NotNull
    public abstract ListProperty<VariantOutputImpl> getVariantOutputs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOptimizedProcessedRes();

    @Override
    @TaskAction
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getTransformationRequest().get();
        Task task = (Task)this;
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkExpressionValueIsNotNull((Object)workQueue2, (String)"workerExecutor.noIsolation()");
        artifactTransformationRequest.submit(task, workQueue2, Aapt2OptimizeWorkAction.class, (Function3)new Function3<BuiltArtifact, Directory, OptimizeResourcesParams, File>(this){
            final /* synthetic */ OptimizeResourcesTask this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final File invoke(@NotNull BuiltArtifact builtArtifact, @NotNull Directory outputLocation, @NotNull OptimizeResourcesParams parameters) {
                Object v1;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)builtArtifact, (String)"builtArtifact");
                    Intrinsics.checkParameterIsNotNull((Object)outputLocation, (String)"outputLocation");
                    Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
                    Object object = this.this$0.getVariantOutputs().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"variantOutputs.get()");
                    object = (Iterable)object;
                    boolean bl = false;
                    Object object2 = object;
                    boolean bl2 = false;
                    Iterator<T> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        T t = iterator.next();
                        VariantOutputImpl it = (VariantOutputImpl)t;
                        boolean bl3 = false;
                        boolean bl4 = it.getVariantOutputConfiguration().getOutputType() == builtArtifact.getOutputType() && Intrinsics.areEqual(it.getVariantOutputConfiguration().getFilters(), (Object)builtArtifact.getFilters());
                        if (!bl4) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                Object object = v1;
                if (object == null) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot find variant output for ", (Object)builtArtifact));
                }
                VariantOutputImpl variantOutput = object;
                parameters.getInputResFile().set(new File(builtArtifact.getOutputFile()));
                parameters.getAapt2Executable().set(Aapt2Daemon.getAapt2Executable(this.this$0.getAapt2()).toFile());
                parameters.getEnableResourceObfuscation().set(this.this$0.getEnableResourceObfuscation().get());
                parameters.getOutputResFile().set(new File(outputLocation.getAsFile(), "resources-" + variantOutput.getBaseName() + "-optimize.ap_"));
                object = ((RegularFile)parameters.getOutputResFile().get()).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.outputResFile.get().asFile");
                return object;
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005R\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;", "Lcom/android/build/gradle/internal/workeractions/DecoratedWorkParameters;", "aapt2Executable", "Lorg/gradle/api/file/RegularFileProperty;", "getAapt2Executable", "()Lorg/gradle/api/file/RegularFileProperty;", "enableResourceObfuscation", "Lorg/gradle/api/provider/Property;", "", "getEnableResourceObfuscation", "()Lorg/gradle/api/provider/Property;", "inputResFile", "getInputResFile", "outputResFile", "getOutputResFile", "gradle-core"})
    public static interface OptimizeResourcesParams
    extends DecoratedWorkParameters {
        @NotNull
        public RegularFileProperty getAapt2Executable();

        @NotNull
        public RegularFileProperty getInputResFile();

        @NotNull
        public Property<Boolean> getEnableResourceObfuscation();

        @NotNull
        public RegularFileProperty getOutputResFile();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$Aapt2OptimizeWorkAction;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;", "params", "(Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;)V", "doExecute", "", "gradle-core"})
    public static abstract class Aapt2OptimizeWorkAction
    implements WorkActionAdapter<OptimizeResourcesParams> {
        @NotNull
        private final OptimizeResourcesParams params;

        @Inject
        public Aapt2OptimizeWorkAction(@NotNull OptimizeResourcesParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }

        @Override
        public void doExecute() {
            OptimizeResourcesTaskKt.doFullTaskAction(this.params);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$CreateAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreateAction
    extends VariantTaskCreationAction<OptimizeResourcesTask, ComponentCreationConfig> {
        private ArtifactTransformationRequest<OptimizeResourcesTask> transformationRequest;

        public CreateAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("optimize", "Resources");
        }

        @Override
        @NotNull
        public Class<OptimizeResourcesTask> getType() {
            return OptimizeResourcesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<OptimizeResourcesTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            boolean resourceShrinkingEnabled = this.creationConfig.useResourceShrinker();
            InAndOutDirectoryOperationRequest operationRequest2 = this.creationConfig.getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories((Function1)handleProvider.operationRequest.1.INSTANCE, (Function1)handleProvider.operationRequest.2.INSTANCE);
            this.transformationRequest = resourceShrinkingEnabled ? (ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$default((InAndOutDirectoryOperationRequestImpl)operationRequest2, InternalArtifactType.SHRUNK_PROCESSED_RES.INSTANCE, InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, null, 4, null) : (ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$default((InAndOutDirectoryOperationRequestImpl)operationRequest2, InternalArtifactType.PROCESSED_RES.INSTANCE, InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, null, 4, null);
        }

        @Override
        public void configure(@NotNull OptimizeResourcesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            List<VariantOutputImpl> enabledVariantOutputs = this.creationConfig.getOutputs().getEnabledVariantOutputs();
            this.creationConfig.getServices().initializeAapt2Input(task.getAapt2());
            HasConfigurableValuesKt.setDisallowChanges(task.getEnableResourceObfuscation(), false);
            ArtifactTransformationRequest<OptimizeResourcesTask> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
                throw null;
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getTransformationRequest(), artifactTransformationRequest);
            HasConfigurableValuesKt.setDisallowChanges(task.getVariantOutputs(), (Iterable)enabledVariantOutputs);
        }
    }
}

