/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.DynamicFeatureCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.tools.build.libraries.metadata.AppDependencies;
import com.android.tools.build.libraries.metadata.Library;
import com.android.tools.build.libraries.metadata.LibraryDependencies;
import com.android.tools.build.libraries.metadata.MavenLibrary;
import com.android.tools.build.libraries.metadata.ModuleDependencies;
import com.google.protobuf.ByteString;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "dependenciesList", "Lorg/gradle/api/file/RegularFileProperty;", "getDependenciesList", "()Lorg/gradle/api/file/RegularFileProperty;", "moduleName", "Lorg/gradle/api/provider/Property;", "", "getModuleName", "()Lorg/gradle/api/provider/Property;", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "runtimeClasspathArtifacts", "getRuntimeClasspathArtifacts", "()Lorg/gradle/api/file/FileCollection;", "runtimeClasspathName", "getRuntimeClasspathName", "convertDependencyToMavenLibrary", "Ljava/lang/Integer;", "moduleVersion", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "digest", "Lcom/google/protobuf/ByteString;", "librariesToIndexMap", "Ljava/util/Dictionary;", "Lcom/android/tools/build/libraries/metadata/Library;", "libraries", "Ljava/util/LinkedList;", "doTaskAction", "", "getFileDigest", "file", "Ljava/io/File;", "CreationAction", "gradle-core"})
public abstract class PerModuleReportDependenciesTask
extends NonIncrementalTask {
    private FileCollection runtimeClasspathArtifacts;
    @NotNull
    private final RegularFileProperty dependenciesList;

    @Inject
    public PerModuleReportDependenciesTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.dependenciesList = regularFileProperty;
    }

    @Internal
    @NotNull
    public abstract Property<String> getRuntimeClasspathName();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getRuntimeClasspathArtifacts() {
        FileCollection fileCollection2 = this.runtimeClasspathArtifacts;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspathArtifacts");
        throw null;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getDependenciesList() {
        return this.dependenciesList;
    }

    @Input
    @NotNull
    public abstract Property<String> getModuleName();

    private final Integer convertDependencyToMavenLibrary(ModuleVersionIdentifier moduleVersion, ByteString digest, Dictionary<Library, Integer> librariesToIndexMap, LinkedList<Library> libraries) {
        if (moduleVersion != null) {
            Library lib;
            Integer index;
            Library.Builder libBuilder = Library.newBuilder().setMavenLibrary(MavenLibrary.newBuilder().setGroupId(moduleVersion.getGroup()).setArtifactId(moduleVersion.getName()).setVersion(moduleVersion.getVersion()).build());
            if (digest != null) {
                libBuilder.setDigests(Library.Digests.newBuilder().setSha256(digest));
            }
            if ((index = librariesToIndexMap.get(lib = libBuilder.build())) == null) {
                index = new Integer(libraries.size());
                libraries.add(lib);
                librariesToIndexMap.put(lib, index);
            }
            return index;
        }
        return null;
    }

    private final ByteString getFileDigest(File file) {
        ByteString byteString = ByteString.copyFrom((byte[])MessageDigest.getInstance("SHA-256").digest(FilesKt.readBytes((File)file)));
        Intrinsics.checkExpressionValueIsNotNull((Object)byteString, (String)"copyFrom(MessageDigest.getInstance(\"SHA-256\").digest(file.readBytes()))");
        return byteString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        void $this$filterTo$iv$iv;
        Iterable iterable;
        Object index;
        DependencyResult dependency2;
        Dictionary librariesToIndexMap = new Hashtable();
        LinkedList<Library> libraries = new LinkedList<Library>();
        LinkedList<LibraryDependencies> libraryDependencies = new LinkedList<LibraryDependencies>();
        Set directDependenciesIndices = new HashSet();
        Configuration runtimeClasspath = this.getProject().getConfigurations().getByName((String)this.getRuntimeClasspathName().get());
        ArtifactCollection artifacts2 = runtimeClasspath.getIncoming().artifactView((Action)doTaskAction.artifacts.1.INSTANCE).getArtifacts();
        HashMap<ComponentIdentifier, ByteString> componentDigestMap = new HashMap<ComponentIdentifier, ByteString>();
        for (ResolvedArtifactResult artifact : artifacts2) {
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            File file = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact.file");
            componentDigestMap.put(componentIdentifier, this.getFileDigest(file));
        }
        for (DependencyResult dependency2 : runtimeClasspath.getIncoming().getResolutionResult().getAllDependencies()) {
            Object libDep2;
            Object libraryDependency;
            LibraryDependencies it;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            ResolvedComponentResult resolvedComponent;
            if (!(dependency2 instanceof ResolvedDependencyResult) || !(((ResolvedDependencyResult)dependency2).getRequested() instanceof ModuleComponentSelector) || (index = this.convertDependencyToMavenLibrary((resolvedComponent = ((ResolvedDependencyResult)dependency2).getSelected()).getModuleVersion(), (ByteString)componentDigestMap.get(resolvedComponent.getId()), librariesToIndexMap, libraries)) == null) continue;
            Iterable $this$filter$iv = libraryDependencies;
            boolean $i$f$filter = false;
            iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (LibraryDependencies)element$iv$iv;
                boolean bl = false;
                if (!(it.getLibraryIndex() == ((Integer)index).intValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if (((List)destination$iv$iv).isEmpty()) {
                libraryDependency = LibraryDependencies.newBuilder().setLibraryIndex((Integer)index);
                for (Object libDep2 : resolvedComponent.getDependencies()) {
                    Integer depIndex;
                    if (!(libDep2 instanceof ResolvedDependencyResult) || !(((ResolvedDependencyResult)libDep2).getRequested() instanceof ModuleComponentSelector) || (depIndex = this.convertDependencyToMavenLibrary(((ResolvedDependencyResult)libDep2).getSelected().getModuleVersion(), (ByteString)componentDigestMap.get(((ResolvedDependencyResult)libDep2).getSelected().getId()), librariesToIndexMap, libraries)) == null) continue;
                    ((LibraryDependencies.Builder)libraryDependency).addLibraryDepIndex(depIndex);
                }
                if (((LibraryDependencies.Builder)libraryDependency).getLibraryDepIndexCount() > 0) {
                    libraryDependencies.add(((LibraryDependencies.Builder)libraryDependency).build());
                }
            }
            libraryDependency = ((ResolvedDependencyResult)dependency2).getFrom().getSelectionReason().getDescriptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryDependency, (String)"dependency.from.selectionReason.descriptions");
            $this$filter$iv = (Iterable)libraryDependency;
            $i$f$filter = false;
            libDep2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (ComponentSelectionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(it.getCause() == ComponentSelectionCause.ROOT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            if (!(!$this$filter$iv.isEmpty())) continue;
            directDependenciesIndices.add(((Integer)index).intValue());
        }
        dependency2 = componentDigestMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependency2, (String)"componentDigestMap.keys");
        Iterable $this$filter$iv = (Iterable)dependency2;
        boolean $i$f$filter = false;
        index = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComponentIdentifier it = (ComponentIdentifier)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ProjectComponentIdentifier) && !(it instanceof ModuleComponentIdentifier))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileComponentIds = (List)destination$iv$iv;
        for (ComponentIdentifier fileComponentId : fileComponentIds) {
            Library library = Library.newBuilder().setDigests(Library.Digests.newBuilder().setSha256((ByteString)componentDigestMap.get(fileComponentId))).build();
            int index2 = libraries.size();
            libraries.add(library);
            LibraryDependencies.Builder libraryDependency = LibraryDependencies.newBuilder().setLibraryIndex(index2);
            libraryDependencies.add(libraryDependency.build());
            directDependenciesIndices.add(index2);
        }
        ModuleDependencies.Builder moduleDependency = ModuleDependencies.newBuilder().setModuleName((String)this.getModuleName().get());
        Iterator fileComponentId = directDependenciesIndices.iterator();
        while (fileComponentId.hasNext()) {
            int index3 = ((Number)fileComponentId.next()).intValue();
            moduleDependency.addDependencyIndex(index3);
        }
        AppDependencies appDependencies = AppDependencies.newBuilder().addAllLibrary((Iterable<? extends Library>)libraries).addAllLibraryDependencies((Iterable<? extends LibraryDependencies>)libraryDependencies).addModuleDependencies(moduleDependency.build()).build();
        Closeable closeable = new FileOutputStream(((RegularFile)this.dependenciesList.get()).getAsFile());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl3 = false;
            appDependencies.writeTo(it);
            iterable = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PerModuleReportDependenciesTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PerModuleReportDependenciesTask, ApkCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<PerModuleReportDependenciesTask> type;

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.name = this.computeTaskName("collect", "Dependencies");
            this.type = PerModuleReportDependenciesTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PerModuleReportDependenciesTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PerModuleReportDependenciesTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("dependencies.pb").on(InternalArtifactType.METADATA_LIBRARY_DEPENDENCIES_REPORT.INSTANCE);
        }

        @Override
        public void configure(@NotNull PerModuleReportDependenciesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.getRuntimeClasspathName().set((Object)((ApkCreationConfig)this.creationConfig).getVariantDependencies().getRuntimeClasspath().getName());
            FileCollection fileCollection2 = VariantDependencies.getArtifactCollection$default(((ApkCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAR, null, 8, null).getArtifactFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"creationConfig.variantDependencies.getArtifactCollection(\n                AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH,\n                AndroidArtifacts.ArtifactScope.EXTERNAL,\n                // Query for JAR instead of PROCESSED_JAR as this task works with unprocessed jars\n                AndroidArtifacts.ArtifactType.JAR\n            ).artifactFiles");
            task.runtimeClasspathArtifacts = fileCollection2;
            if (this.creationConfig instanceof DynamicFeatureCreationConfig) {
                HasConfigurableValuesKt.setDisallowChanges(task.getModuleName(), ((DynamicFeatureCreationConfig)this.creationConfig).getFeatureName());
            } else {
                HasConfigurableValuesKt.setDisallowChanges(task.getModuleName(), "base");
            }
        }
    }
}

