/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.utils.AgpRepositoryChecker;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/utils/AgpRepositoryChecker;", "", "()V", "CHECK_PERFORMED", "", "JCENTER_URL", "maxProjectsToShow", "", "checkRepositories", "", "project", "Lorg/gradle/api/Project;", "gradle-core"})
public final class AgpRepositoryChecker {
    @NotNull
    public static final AgpRepositoryChecker INSTANCE = new AgpRepositoryChecker();
    @NotNull
    private static final String CHECK_PERFORMED = "android.agp.repository.check.performed";
    private static final int maxProjectsToShow = 3;
    @NotNull
    private static final String JCENTER_URL = "https://jcenter.bintray.com/";

    private AgpRepositoryChecker() {
    }

    public final void checkRepositories(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Project rootProject = project2.getRootProject();
        if (rootProject.getExtensions().getExtraProperties().has(CHECK_PERFORMED)) {
            return;
        }
        rootProject.getExtensions().getExtraProperties().set(CHECK_PERFORMED, (Object)true);
        project2.getGradle().projectsEvaluated((Action)new Action<Gradle>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(Gradle gradle) {
                Object reposWithProjects2;
                boolean bl = false;
                Map flatDirReposToUsages = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                Set projectsUsingJCenter = new LinkedHashSet<E>();
                gradle.allprojects((Action)new Action<Project>((Map<String, Set<String>>)flatDirReposToUsages, (Set<String>)projectsUsingJCenter){
                    final /* synthetic */ Map<String, Set<String>> $flatDirReposToUsages;
                    final /* synthetic */ Set<String> $projectsUsingJCenter;
                    {
                        this.$flatDirReposToUsages = $flatDirReposToUsages;
                        this.$projectsUsingJCenter = $projectsUsingJCenter;
                    }

                    public final void execute(Project p) {
                        p.getBuildscript().getRepositories().all((Action)new Action<ArtifactRepository>(p, this.$flatDirReposToUsages, this.$projectsUsingJCenter){
                            final /* synthetic */ Project $p;
                            final /* synthetic */ Map<String, Set<String>> $flatDirReposToUsages;
                            final /* synthetic */ Set<String> $projectsUsingJCenter;
                            {
                                this.$p = $p;
                                this.$flatDirReposToUsages = $flatDirReposToUsages;
                                this.$projectsUsingJCenter = $projectsUsingJCenter;
                            }

                            public final void execute(ArtifactRepository it) {
                                String string = this.$p.getDisplayName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.displayName");
                                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                                checkRepositories.1.access$execute$checkSingleRepo(this.$flatDirReposToUsages, this.$projectsUsingJCenter, string, it);
                            }
                        });
                        p.getRepositories().all((Action)new Action<ArtifactRepository>(p, this.$flatDirReposToUsages, this.$projectsUsingJCenter){
                            final /* synthetic */ Project $p;
                            final /* synthetic */ Map<String, Set<String>> $flatDirReposToUsages;
                            final /* synthetic */ Set<String> $projectsUsingJCenter;
                            {
                                this.$p = $p;
                                this.$flatDirReposToUsages = $flatDirReposToUsages;
                                this.$projectsUsingJCenter = $projectsUsingJCenter;
                            }

                            public final void execute(ArtifactRepository it) {
                                String string = this.$p.getDisplayName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.displayName");
                                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                                checkRepositories.1.access$execute$checkSingleRepo(this.$flatDirReposToUsages, this.$projectsUsingJCenter, string, it);
                            }
                        });
                    }
                });
                try {
                    if (gradle == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.GradleInternal");
                    }
                    ((GradleInternal)gradle).getSettings().getPluginManagement().getRepositories().all((Action)new Action<ArtifactRepository>((Map<String, Set<String>>)flatDirReposToUsages, (Set<String>)projectsUsingJCenter){
                        final /* synthetic */ Map<String, Set<String>> $flatDirReposToUsages;
                        final /* synthetic */ Set<String> $projectsUsingJCenter;
                        {
                            this.$flatDirReposToUsages = $flatDirReposToUsages;
                            this.$projectsUsingJCenter = $projectsUsingJCenter;
                        }

                        public final void execute(ArtifactRepository it) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                            checkRepositories.1.access$execute$checkSingleRepo(this.$flatDirReposToUsages, this.$projectsUsingJCenter, "Gradle Settings", it);
                        }
                    });
                    ((GradleInternal)gradle).getSettings().getDependencyResolutionManagement().getRepositories().all((Action)new Action<ArtifactRepository>((Map<String, Set<String>>)flatDirReposToUsages, (Set<String>)projectsUsingJCenter){
                        final /* synthetic */ Map<String, Set<String>> $flatDirReposToUsages;
                        final /* synthetic */ Set<String> $projectsUsingJCenter;
                        {
                            this.$flatDirReposToUsages = $flatDirReposToUsages;
                            this.$projectsUsingJCenter = $projectsUsingJCenter;
                        }

                        public final void execute(ArtifactRepository it) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                            checkRepositories.1.access$execute$checkSingleRepo(this.$flatDirReposToUsages, this.$projectsUsingJCenter, "Gradle Settings", it);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object object = this.$project.getGradle().getSharedServices();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.gradle.sharedServices");
                SyncIssueReporterImpl.GlobalSyncIssueService globalIssues = (SyncIssueReporterImpl.GlobalSyncIssueService)BuildServicesKt.getBuildService((BuildServiceRegistry)object, SyncIssueReporterImpl.GlobalSyncIssueService.class).get();
                object = flatDirReposToUsages;
                boolean bl3 = false;
                if (!object.isEmpty()) {
                    Iterable iterable = flatDirReposToUsages.entrySet();
                    String string = System.lineSeparator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator()");
                    reposWithProjects2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)checkRepositories.reposWithProjects.1.INSTANCE, (int)30, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalIssues, (String)"globalIssues");
                    IssueReporter.reportWarning$default((IssueReporter)globalIssues, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                            Using flatDirs should be avoided because it doesn't support any meta-data formats.\n                            Currently detected usages:\n                            " + (String)reposWithProjects2 + "\n                            ")), null, null, (int)12, null);
                }
                reposWithProjects2 = projectsUsingJCenter;
                bl3 = false;
                if (!reposWithProjects2.isEmpty()) {
                    String listOfProjects = CollectionsKt.joinToString$default((Iterable)projectsUsingJCenter, null, null, null, (int)3, null, null, (int)55, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalIssues, (String)"globalIssues");
                    IssueReporter.reportWarning$default((IssueReporter)globalIssues, (IssueReporter.Type)IssueReporter.Type.JCENTER_IS_DEPRECATED, (String)StringsKt.trimIndent((String)("\n                Please remove usages of `jcenter()` Maven repository from your build scripts and migrate your build to other Maven repositories.\n                This repository is deprecated and it will be shut down in the future.\n                See http://developer.android.com/r/tools/jcenter-end-of-service for more information.\n                Currently detected usages in: " + listOfProjects + "\n                ")), null, null, (int)12, null);
                }
            }

            private static final void execute$checkSingleRepo(Map<String, Set<String>> $flatDirReposToUsages, Set<String> $projectsUsingJCenter, String displayName, ArtifactRepository repo) {
                if (repo instanceof FlatDirectoryArtifactRepository) {
                    Set set;
                    Object object = $flatDirReposToUsages.get(((FlatDirectoryArtifactRepository)repo).getName());
                    if (object == null) {
                        boolean bl = false;
                        set = new LinkedHashSet<E>();
                    } else {
                        set = object;
                    }
                    Set projectPaths = set;
                    projectPaths.add((String)displayName);
                    object = $flatDirReposToUsages;
                    String string = ((FlatDirectoryArtifactRepository)repo).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repo.name");
                    boolean bl = false;
                    object.put(string, projectPaths);
                }
                if (repo instanceof MavenArtifactRepository && Intrinsics.areEqual((Object)((MavenArtifactRepository)repo).getUrl().toString(), (Object)"https://jcenter.bintray.com/")) {
                    $projectsUsingJCenter.add(displayName);
                }
            }

            public static final /* synthetic */ void access$execute$checkSingleRepo(Map $flatDirReposToUsages, Set $projectsUsingJCenter, String displayName, ArtifactRepository repo) {
                checkRepositories.1.execute$checkSingleRepo($flatDirReposToUsages, $projectsUsingJCenter, displayName, repo);
            }
        });
    }
}

