/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.tasks.JavaCompileKt;
import com.android.build.gradle.tasks.JavaCompileUtils;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0016\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/tasks/JavaCompileCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lorg/gradle/api/tasks/compile/JavaCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "usingKapt", "", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Z)V", "annotationProcessorOutputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "kotlin.jvm.PlatformType", "classesOutputDirectory", "dataBindingArtifactDir", "dataBindingExportClassListFile", "Lorg/gradle/api/file/RegularFileProperty;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "name", "", "getName", "()Ljava/lang/String;", "project", "Lorg/gradle/api/Project;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
public final class JavaCompileCreationAction
extends TaskCreationAction<JavaCompile> {
    @NotNull
    private final ComponentCreationConfig creationConfig;
    private final boolean usingKapt;
    @NotNull
    private final GlobalScope globalScope;
    @NotNull
    private final Project project;
    private final DirectoryProperty classesOutputDirectory;
    private final DirectoryProperty annotationProcessorOutputDirectory;
    private final DirectoryProperty dataBindingArtifactDir;
    private final RegularFileProperty dataBindingExportClassListFile;

    public JavaCompileCreationAction(@NotNull ComponentCreationConfig creationConfig, boolean usingKapt) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        this.creationConfig = creationConfig;
        this.usingKapt = usingKapt;
        this.globalScope = this.creationConfig.getGlobalScope();
        this.project = this.creationConfig.getServices().getProjectInfo().getProject();
        this.classesOutputDirectory = this.project.getObjects().directoryProperty();
        this.annotationProcessorOutputDirectory = this.project.getObjects().directoryProperty();
        this.dataBindingArtifactDir = this.project.getObjects().directoryProperty();
        this.dataBindingExportClassListFile = this.project.getObjects().fileProperty();
    }

    @Override
    @NotNull
    public String getName() {
        return this.creationConfig.computeTaskName("compile", "JavaWithJavac");
    }

    @Override
    @NotNull
    public Class<JavaCompile> getType() {
        return JavaCompile.class;
    }

    @Override
    public void handleProvider(@NotNull TaskProvider<JavaCompile> taskProvider) {
        Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
        super.handleProvider(taskProvider);
        this.creationConfig.getTaskContainer().setJavacTask(taskProvider);
        ArtifactsImpl artifacts2 = this.creationConfig.getArtifacts();
        artifacts2.setInitialProvider(taskProvider, (Function1)new Function1<JavaCompile, FileSystemLocationProperty<Directory>>(this){
            final /* synthetic */ JavaCompileCreationAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FileSystemLocationProperty<Directory> invoke(@NotNull JavaCompile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DirectoryProperty directoryProperty = JavaCompileCreationAction.access$getClassesOutputDirectory$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"classesOutputDirectory");
                return (FileSystemLocationProperty)directoryProperty;
            }
        }).withName("classes").on(InternalArtifactType.JAVAC.INSTANCE);
        artifacts2.setInitialProvider(taskProvider, (Function1)new Function1<JavaCompile, FileSystemLocationProperty<Directory>>(this){
            final /* synthetic */ JavaCompileCreationAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FileSystemLocationProperty<Directory> invoke(@NotNull JavaCompile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DirectoryProperty directoryProperty = JavaCompileCreationAction.access$getAnnotationProcessorOutputDirectory$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"annotationProcessorOutputDirectory");
                return (FileSystemLocationProperty)directoryProperty;
            }
        }).withName("out").on(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE);
        if (this.creationConfig.getBuildFeatures().getDataBinding()) {
            DirectoryProperty directoryProperty = this.dataBindingArtifactDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"dataBindingArtifactDir");
            DirectoryProperty directoryProperty2 = directoryProperty;
            directoryProperty = this.dataBindingExportClassListFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"dataBindingExportClassListFile");
            JavaCompileKt.registerDataBindingOutputs(directoryProperty2, (RegularFileProperty)directoryProperty, this.creationConfig.getVariantType().isExportDataBindingClassList(), taskProvider, artifacts2, true);
        }
    }

    @Override
    public void configure(@NotNull JavaCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Object[] objectArray = new Object[]{this.creationConfig.getTaskContainer().getPreBuildTask()};
        task.dependsOn(objectArray);
        task.getExtensions().add("AGP_VARIANT_NAME", (Object)this.creationConfig.getName());
        JavaCompileUtils.configureProperties(task, this.creationConfig, task);
        JavaCompileUtils.configurePropertiesForAnnotationProcessing(task, this.creationConfig);
        Callable sourcesToCompile2 = new Callable<List<? extends List<? extends ConfigurableFileTree>>>(this){
            final /* synthetic */ JavaCompileCreationAction this$0;
            {
                this.this$0 = $receiver;
            }

            public final List<List<ConfigurableFileTree>> call() {
                return CollectionsKt.listOf(JavaCompileCreationAction.access$getCreationConfig$p(this.this$0).getJavaSources());
            }
        };
        Object object = new String[]{"**/*.java"};
        PatternSet javaSourcesFilter = new PatternSet().include((String[])object);
        object = new Object[]{sourcesToCompile2};
        task.setSource(task.getProject().files((Object[])object).getAsFileTree().matching((PatternFilterable)javaSourcesFilter));
        if (JavaVersion.current().isJava8Compatible() && this.creationConfig.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            task.getOptions().getCompilerArgs().add("-parameters");
        }
        task.getOptions().setIncremental((object = this.globalScope.getExtension().getCompileOptions().getIncremental()) == null ? true : (Boolean)object);
        if (!this.usingKapt) {
            Provider apList = this.creationConfig.getArtifacts().get(InternalArtifactType.ANNOTATION_PROCESSOR_LIST.INSTANCE);
            Object[] objectArray2 = new Object[]{apList};
            task.getInputs().files(objectArray2).withPathSensitivity(PathSensitivity.NONE).withPropertyName("annotationProcessorList");
            String string = this.creationConfig.getName();
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object2 = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object2).getService();
            Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
            JavaCompileKt.access$recordAnnotationProcessors(task, apList, string, provider2);
        }
        task.setDestinationDir(this.classesOutputDirectory.getAsFile());
        object = new String[]{"out"};
        task.getOptions().setAnnotationProcessorGeneratedSourcesDirectory(this.creationConfig.getArtifacts().getOutputPath$gradle_core((Artifact)InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE, (String[])object));
        task.getOutputs().dir((Object)this.classesOutputDirectory).withPropertyName("classesOutputDirectory");
        task.getOutputs().dir((Object)this.annotationProcessorOutputDirectory).withPropertyName("annotationProcessorOutputDirectory");
        if (this.creationConfig.getBuildFeatures().getDataBinding() && !this.usingKapt) {
            task.getOutputs().dir((Object)this.dataBindingArtifactDir).withPropertyName("dataBindingArtifactDir");
            if (this.creationConfig.getVariantType().isExportDataBindingClassList()) {
                task.getOutputs().file((Object)this.dataBindingExportClassListFile).withPropertyName("dataBindingExportClassListFile");
            }
        }
        task.getLogger().debug("Configuring Java sources compilation for '" + task.getName() + "' with source level " + task.getSourceCompatibility() + " and target level " + task.getTargetCompatibility() + '.');
    }

    public static final /* synthetic */ DirectoryProperty access$getClassesOutputDirectory$p(JavaCompileCreationAction $this) {
        return $this.classesOutputDirectory;
    }

    public static final /* synthetic */ DirectoryProperty access$getAnnotationProcessorOutputDirectory$p(JavaCompileCreationAction $this) {
        return $this.annotationProcessorOutputDirectory;
    }

    public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(JavaCompileCreationAction $this) {
        return $this.creationConfig;
    }
}

