/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.api.variant.impl.VariantOutputListKt;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dependency.AndroidAttributes;
import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.build.gradle.internal.manifest.ManifestDataKt;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.InternalMultipleArtifactType;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.ModuleMetadata;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTaskKt;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.workeractions.DecoratedWorkParameters;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import com.android.builder.files.IncrementalChanges;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.CodeShrinker;
import com.android.builder.packaging.DexPackagingMode;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.IOExceptionWrapper;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.jvm.functions.Function3;
import org.gradle.api.Task;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileType;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

public abstract class PackageAndroidArtifact
extends NewIncrementalTask {
    protected Artifact<Directory> manifestType;
    private boolean jniDebugBuild;
    private SigningConfigDataProvider signingConfigData;
    protected String projectBaseName;
    protected String buildTargetAbi;
    protected String buildTargetDensity;
    protected Integer targetApi;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    protected ApkCreatorType apkCreatorType;
    private static final IssueReporter MANIFEST_DATA_ISSUE_REPORTER = new IssueReporter(){

        protected void reportIssue(IssueReporter.Type type, IssueReporter.Severity severity, EvalIssueException exception) {
            if (severity == IssueReporter.Severity.ERROR) {
                throw exception;
            }
        }

        public boolean hasIssue(IssueReporter.Type type) {
            return false;
        }
    };

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getManifests();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getResourceFiles();

    @Input
    public abstract SetProperty<String> getAbiFilters();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    public abstract ConfigurableFileCollection getBaseModuleMetadata();

    @InputFile
    @Incremental
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    public abstract RegularFileProperty getAppMetadata();

    @OutputDirectory
    public abstract DirectoryProperty getIncrementalFolder();

    @Input
    public String getManifestTypeName() {
        return this.manifestType.name();
    }

    @Classpath
    @Incremental
    public abstract ConfigurableFileCollection getJavaResourceFiles();

    @Classpath
    @Incremental
    public abstract ConfigurableFileCollection getFeatureJavaResourceFiles();

    @Classpath
    @Incremental
    public abstract ConfigurableFileCollection getJniFolders();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getDexFolders();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getFeatureDexFolder();

    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getAssets();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getDependencyDataFile();

    @Input
    public abstract Property<String> getCreatedBy();

    @Input
    public abstract ListProperty<String> getAaptOptionsNoCompress();

    @Input
    public abstract Property<Boolean> getJniLibsUseLegacyPackaging();

    @Input
    public abstract Property<Boolean> getDexUseLegacyPackaging();

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    @Optional
    public Integer getTargetApi() {
        return this.targetApi;
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public abstract Property<Boolean> getDebugBuild();

    @Input
    public abstract Property<Boolean> getIsInvokedFromIde();

    @Nested
    public SigningConfigDataProvider getSigningConfigData() {
        return this.signingConfigData;
    }

    void setSigningConfigData(SigningConfigDataProvider signingConfigData) {
        this.signingConfigData = signingConfigData;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getSigningConfigVersions();

    @Input
    public abstract Property<Integer> getMinSdkVersion();

    @Input
    public abstract Property<String> getApplicationId();

    @Input
    public List<String> getNativeLibrariesAndDexPackagingModeNames() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((Directory)this.getManifests().get()).getAsFileTree().getFiles().forEach(manifest -> {
            if (manifest.isFile() && manifest.getName().equals("AndroidManifest.xml")) {
                DefaultManifestParser parser2 = new DefaultManifestParser(manifest, () -> true, true, null);
                String nativeLibsPackagingMode = PackagingUtils.getNativeLibrariesLibrariesPackagingMode((Boolean)parser2.getExtractNativeLibs()).toString();
                listBuilder.add((Object)nativeLibsPackagingMode);
                String dexPackagingMode = PackagingUtils.getDexPackagingMode((Boolean)parser2.getUseEmbeddedDex(), (boolean)((Boolean)this.getDexUseLegacyPackaging().get())).toString();
                listBuilder.add((Object)dexPackagingMode);
            }
        });
        return listBuilder.build();
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @OutputFile
    public abstract RegularFileProperty getIdeModelOutputFile();

    @Nested
    public abstract ListProperty<VariantOutputImpl> getVariantOutputs();

    @Input
    public abstract ArtifactTransformationRequest getTransformationRequest();

    private static File computeBuildOutputFile(VariantOutputImpl variantOutput, File outputDirectory) {
        return new File(outputDirectory, (String)variantOutput.getOutputFileName().get());
    }

    @Input
    public ApkCreatorType getApkCreatorType() {
        return this.apkCreatorType;
    }

    @Internal
    public abstract Property<String> getProjectPath();

    @Override
    public void doTaskAction(InputChanges changes) {
        if (!changes.isIncremental()) {
            this.checkFileNameUniqueness();
        }
        HashSet<File> changedResourceFiles = new HashSet<File>();
        for (FileChange fileChange : changes.getFileChanges((Provider)this.getResourceFiles())) {
            if (fileChange.getFileType() != FileType.FILE) continue;
            changedResourceFiles.add(fileChange.getFile());
        }
        this.getTransformationRequest().submit((Task)this, this.getWorkerExecutor().noIsolation(), IncrementalSplitterRunnable.class, this.configure(changedResourceFiles, changes));
    }

    private Function3<BuiltArtifact, Directory, SplitterParams, File> configure(HashSet<File> changedResourceFiles, InputChanges changes) {
        return (builtArtifact, directory2, parameter) -> {
            VariantOutputImpl variantOutput = VariantOutputListKt.getVariantOutput((List)this.getVariantOutputs().get(), ((BuiltArtifactImpl)builtArtifact).getVariantOutputConfiguration());
            File outputFile = PackageAndroidArtifact.computeBuildOutputFile(variantOutput, ((Directory)this.getOutputDirectory().get()).getAsFile());
            parameter.getVariantOutput().set((Object)variantOutput.toSerializedForm());
            parameter.getAndroidResourcesFile().set(new File(builtArtifact.getOutputFile()));
            parameter.getAndroidResourcesChanged().set((Object)changedResourceFiles.contains(new File(builtArtifact.getOutputFile())));
            parameter.getProjectPath().set((Object)((String)this.getProjectPath().get()));
            parameter.getApkCreatorType().set((Object)this.apkCreatorType);
            parameter.getOutputFile().set(outputFile);
            parameter.getIncrementalFolder().set((Provider)this.getIncrementalFolder());
            if (this.getFeatureDexFolder().isEmpty()) {
                parameter.getDexFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)this.getDexFolders()));
                parameter.getJavaResourceFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)this.getJavaResourceFiles()));
            } else {
                parameter.getDexFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)this.getFeatureDexFolder()));
                parameter.getJavaResourceFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)this.getFeatureJavaResourceFiles()));
            }
            parameter.getAssetsFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (Provider<? extends FileSystemLocation>)this.getAssets()));
            parameter.getJniFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (FileCollection)this.getJniFolders()));
            if (this.getAppMetadata().isPresent()) {
                parameter.getAppMetadataFiles().set((Object)IncrementalChangesUtils.getChangesInSerializableForm(changes, (Provider<? extends FileSystemLocation>)this.getAppMetadata()));
            } else {
                parameter.getAppMetadataFiles().set((Object)new SerializableInputChanges((List)ImmutableList.of(), (Collection)ImmutableSet.of()));
            }
            parameter.getManifestType().set(this.manifestType);
            parameter.getSigningConfigData().set((Object)this.signingConfigData.convertToParams());
            parameter.getSigningConfigVersionsFile().set(this.getSigningConfigVersions().getSingleFile());
            if (this.getBaseModuleMetadata().isEmpty()) {
                parameter.getAbiFilters().set(this.getAbiFilters());
            } else {
                List<String> appAbiFilters;
                try {
                    appAbiFilters = ModuleMetadata.load(this.getBaseModuleMetadata().getSingleFile()).getAbiFilters();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (appAbiFilters.isEmpty()) {
                    parameter.getAbiFilters().set(this.getAbiFilters());
                } else {
                    parameter.getAbiFilters().set(appAbiFilters);
                }
            }
            parameter.getJniFolders().set((Iterable)this.getJniFolders().getFiles());
            parameter.getManifestDirectory().set((Provider)this.getManifests());
            parameter.getAaptOptionsNoCompress().set((Iterable)this.getAaptOptionsNoCompress().get());
            parameter.getJniLibsUseLegacyPackaging().set((Object)((Boolean)this.getJniLibsUseLegacyPackaging().get()));
            parameter.getDexUseLegacyPackaging().set((Object)((Boolean)this.getDexUseLegacyPackaging().get()));
            parameter.getCreatedBy().set((Object)((String)this.getCreatedBy().get()));
            parameter.getMinSdkVersion().set((Object)((Integer)this.getMinSdkVersion().get()));
            parameter.getIsDebuggableBuild().set((Object)((Boolean)this.getDebugBuild().get()));
            parameter.getIsInvokedFromIde().set((Object)((Boolean)this.getIsInvokedFromIde().get()));
            parameter.getIsJniDebuggableBuild().set((Object)this.getJniDebugBuild());
            parameter.getDependencyDataFile().set((Provider)this.getDependencyDataFile());
            parameter.getPackagerMode().set((Object)(changes.isIncremental() ? IncrementalPackagerBuilder.BuildType.INCREMENTAL : IncrementalPackagerBuilder.BuildType.CLEAN));
            return outputFile;
        };
    }

    private void checkFileNameUniqueness() {
        PackageAndroidArtifact.checkFileNameUniqueness(new BuiltArtifactsLoaderImpl().load((Directory)this.getResourceFiles().get()));
    }

    @VisibleForTesting
    static void checkFileNameUniqueness(BuiltArtifactsImpl builtArtifacts) {
        if (builtArtifacts == null) {
            return;
        }
        Collection fileOutputs = builtArtifacts.getElements().stream().map(builtArtifact -> new File(builtArtifact.getOutputFile())).collect(Collectors.toList());
        java.util.Optional<String> repeatingFileNameOptional = fileOutputs.stream().filter(fileOutput -> Collections.frequency(fileOutputs, fileOutput) > 1).map(File::getName).findFirst();
        if (repeatingFileNameOptional.isPresent()) {
            String repeatingFileName = repeatingFileNameOptional.get();
            List conflictingApks = builtArtifacts.getElements().stream().filter(buildOutput -> new File(buildOutput.getOutputFile()).getName().equals(repeatingFileName)).map(buildOutput -> {
                if (buildOutput.getFilters().isEmpty()) {
                    return buildOutput.getOutputType().toString();
                }
                return Joiner.on((String)"-").join(buildOutput.getFilters());
            }).collect(Collectors.toList());
            throw new RuntimeException(String.format("Several variant outputs are configured to use the same file name \"%1$s\", filters : %2$s", repeatingFileName, Joiner.on((String)":").join(conflictingApks)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries2 = inFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                if (zipEntry.getName().endsWith(".class") || !ZipEntryUtils.isValidZipEntryName((ZipEntry)zipEntry)) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    private static void doTask(File incrementalDirForSplit, File outputFile, KeyedFileCache cache2, BuiltArtifactsImpl manifestOutputs, Map<RelativeFile, FileStatus> changedDex, Map<RelativeFile, FileStatus> changedJavaResources, Collection<SerializableChange> changedAssets, Map<RelativeFile, FileStatus> changedAndroidResources, Map<RelativeFile, FileStatus> changedNLibs, Collection<SerializableChange> changedAppMetadata, SplitterParams params) throws IOException {
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        BuiltArtifactImpl manifestForSplit = manifestOutputs.getBuiltArtifact(((VariantOutputImpl.SerializedForm)params.getVariantOutput().get()).getVariantOutputConfiguration());
        if (manifestForSplit == null) {
            throw new RuntimeException("Found a .ap_ for split " + params.getVariantOutput().get() + " but no " + params.getManifestType().get() + " associated manifest file");
        }
        FileUtils.mkdirs((File)outputFile.getParentFile());
        ManifestData manifestData2 = ManifestDataKt.parseManifest(new File(manifestForSplit.getOutputFile()), true, () -> true, MANIFEST_DATA_ISSUE_REPORTER);
        NativeLibrariesPackagingMode nativeLibsPackagingMode = PackagingUtils.getNativeLibrariesLibrariesPackagingMode((Boolean)manifestData2.getExtractNativeLibs());
        LoggerWrapper logger = new LoggerWrapper(Logging.getLogger(PackageAndroidArtifact.class));
        if (((Boolean)params.getJniLibsUseLegacyPackaging().get()).booleanValue()) {
            if (nativeLibsPackagingMode == NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED) {
                logger.warning("PackagingOptions.jniLibs.useLegacyPackaging should be set to false because android:extractNativeLibs is set to \"false\" in AndroidManifest.xml. Avoid setting android:extractNativeLibs=\"false\" explicitly in AndroidManifest.xml, and instead set android.packagingOptions.jniLibs.useLegacyPackaging to false in the build.gradle file.", new Object[0]);
            }
        } else if (nativeLibsPackagingMode == NativeLibrariesPackagingMode.COMPRESSED) {
            logger.warning("PackagingOptions.jniLibs.useLegacyPackaging should be set to true because android:extractNativeLibs is set to \"true\" in AndroidManifest.xml.", new Object[0]);
        }
        Boolean useEmbeddedDex = manifestData2.getUseEmbeddedDex();
        DexPackagingMode dexPackagingMode = PackagingUtils.getDexPackagingMode((Boolean)useEmbeddedDex, (boolean)((Boolean)params.getDexUseLegacyPackaging().get()));
        if (((Boolean)params.getDexUseLegacyPackaging().get()).booleanValue() && Boolean.TRUE.equals(useEmbeddedDex)) {
            logger.warning("PackagingOptions.dex.useLegacyPackaging should be set to false because android:useEmbeddedDex is set to \"true\" in AndroidManifest.xml.", new Object[0]);
        }
        byte[] dependencyData = params.getDependencyDataFile().isPresent() ? Files.readAllBytes(((RegularFile)params.getDependencyDataFile().get()).getAsFile().toPath()) : null;
        try (IncrementalPackager packager = new IncrementalPackagerBuilder((IncrementalPackagerBuilder.BuildType)((Object)params.getPackagerMode().get())).withOutputFile(outputFile).withSigning(((SigningConfigProviderParams)params.getSigningConfigData().get()).resolve(), SigningConfigUtils.loadSigningConfigVersions(((RegularFile)params.getSigningConfigVersionsFile().get()).getAsFile()), (Integer)params.getMinSdkVersion().get(), dependencyData).withCreatedBy((String)params.getCreatedBy().get()).withNativeLibraryPackagingMode(nativeLibsPackagingMode).withNoCompressPredicate(PackagingUtils.getNoCompressPredicate((Collection)((Collection)params.getAaptOptionsNoCompress().get()), (NativeLibrariesPackagingMode)nativeLibsPackagingMode, (DexPackagingMode)dexPackagingMode)).withIntermediateDir(incrementalDirForSplit).withDebuggableBuild((Boolean)params.getIsDebuggableBuild().get()).withDeterministicEntryOrder((Boolean)params.getIsInvokedFromIde().get() == false).withAcceptedAbis(PackageAndroidArtifact.getAcceptedAbis(params)).withJniDebuggableBuild((Boolean)params.getIsJniDebuggableBuild().get()).withApkCreatorType((ApkCreatorType)params.getApkCreatorType().get()).withChangedDexFiles(changedDex).withChangedJavaResources(changedJavaResources).withChangedAssets(changedAssets).withChangedAndroidResources(changedAndroidResources).withChangedNativeLibs(changedNLibs).withChangedAppMetadata(changedAppMetadata).build();){
            packager.updateFiles();
        }
        Stream.concat(changedDex.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).filter(it -> it.getType() == RelativeFile.Type.JAR).map(RelativeFile::getBase).distinct().forEach(f -> {
            try {
                cache2.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
    }

    private static Set<String> getAcceptedAbis(SplitterParams params) {
        Sets.SetView missingAbis;
        FilterConfiguration splitAbiFilter = ((VariantOutputImpl.SerializedForm)params.getVariantOutput().get()).getVariantOutputConfiguration().getFilter(FilterConfiguration.FilterType.ABI);
        ImmutableSet acceptedAbis = splitAbiFilter != null ? ImmutableSet.of((Object)splitAbiFilter.getIdentifier()) : ImmutableSet.copyOf((Collection)((Collection)params.getAbiFilters().get()));
        HashSet<String> availableAbis = new HashSet<String>();
        for (File jniFolder : (List)params.getJniFolders().get()) {
            File[] libDirs = jniFolder.listFiles();
            if (libDirs == null) continue;
            for (File libDir : libDirs) {
                File[] abiDirs = libDir.listFiles();
                if (!"lib".equals(libDir.getName()) || abiDirs == null) continue;
                for (File abiDir : abiDirs) {
                    File[] soFiles = abiDir.listFiles();
                    if (soFiles == null || soFiles.length <= 0) continue;
                    availableAbis.add(abiDir.getName());
                }
            }
        }
        if (!(acceptedAbis.isEmpty() || availableAbis.isEmpty() || (missingAbis = Sets.difference((Set)acceptedAbis, availableAbis)).isEmpty())) {
            LoggerWrapper logger = new LoggerWrapper(Logging.getLogger(PackageAndroidArtifact.class));
            logger.warning(String.format("There are no .so files available to package in the APK for %s.", Joiner.on((String)", ").join((Iterable)missingAbis.stream().sorted().collect(Collectors.toList()))), new Object[0]);
        }
        return acceptedAbis;
    }

    public static abstract class CreationAction<TaskT extends PackageAndroidArtifact>
    extends VariantTaskCreationAction<TaskT, ApkCreationConfig> {
        protected final Provider<Directory> manifests;
        protected boolean useResourceShrinker;
        private final Artifact<Directory> manifestType;

        public CreationAction(ApkCreationConfig creationConfig, boolean useResourceShrinker, Provider<Directory> manifests, Artifact<Directory> manifestType) {
            super(creationConfig);
            this.useResourceShrinker = useResourceShrinker;
            this.manifests = manifests;
            this.manifestType = manifestType;
        }

        @Override
        public void configure(TaskT packageAndroidArtifact) {
            super.configure(packageAndroidArtifact);
            GlobalScope globalScope = ((ApkCreationConfig)this.creationConfig).getGlobalScope();
            VariantDslInfo variantDslInfo = ((ApkCreationConfig)this.creationConfig).getVariantDslInfo();
            ((PackageAndroidArtifact)packageAndroidArtifact).getMinSdkVersion().set(packageAndroidArtifact.getProject().provider(() -> ((ApkCreationConfig)this.creationConfig).getMinSdkVersion().getApiLevel()));
            ((PackageAndroidArtifact)packageAndroidArtifact).getMinSdkVersion().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).getApplicationId().set(((ApkCreationConfig)this.creationConfig).getApplicationId());
            ((PackageAndroidArtifact)packageAndroidArtifact).getApplicationId().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).getVariantOutputs().set((Iterable)((ApkCreationConfig)this.creationConfig).getOutputs());
            ((PackageAndroidArtifact)packageAndroidArtifact).getIncrementalFolder().set(new File(((ApkCreationConfig)this.creationConfig).getPaths().getIncrementalDir(packageAndroidArtifact.getName()), "tmp"));
            ((PackageAndroidArtifact)packageAndroidArtifact).getAaptOptionsNoCompress().set(((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAaptOptions().getNoCompress());
            ((PackageAndroidArtifact)packageAndroidArtifact).getAaptOptionsNoCompress().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).getJniLibsUseLegacyPackaging().set((Provider)((ApkCreationConfig)this.creationConfig).getPackaging().getJniLibs().getUseLegacyPackaging());
            ((PackageAndroidArtifact)packageAndroidArtifact).getJniLibsUseLegacyPackaging().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).getDexUseLegacyPackaging().set((Provider)((ApkCreationConfig)this.creationConfig).getPackaging().getDex().getUseLegacyPackaging());
            ((PackageAndroidArtifact)packageAndroidArtifact).getDexUseLegacyPackaging().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).getManifests().set(this.manifests);
            ((PackageAndroidArtifact)packageAndroidArtifact).getDexFolders().from(new Object[]{this.getDexFolders((ApkCreationConfig)this.creationConfig)});
            String projectPath = packageAndroidArtifact.getProject().getPath();
            FileCollection featureDexFolder = this.getFeatureDexFolder((ApkCreationConfig)this.creationConfig, projectPath);
            if (featureDexFolder != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getFeatureDexFolder().from(new Object[]{featureDexFolder});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getJavaResourceFiles().from(new Object[]{this.getJavaResources((ApkCreationConfig)this.creationConfig)});
            FileCollection featureJavaResources = this.getFeatureJavaResources((ApkCreationConfig)this.creationConfig, projectPath);
            if (featureJavaResources != null) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getFeatureJavaResourceFiles().from(new Object[]{featureJavaResources});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getFeatureJavaResourceFiles().disallowChanges();
            if (this.creationConfig instanceof ApplicationCreationConfig) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APP_METADATA.INSTANCE, ((PackageAndroidArtifact)packageAndroidArtifact).getAppMetadata());
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getAssets().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.COMPRESSED_ASSETS.INSTANCE));
            ((PackageAndroidArtifact)packageAndroidArtifact).setJniDebugBuild(variantDslInfo.isJniDebuggable());
            ((PackageAndroidArtifact)packageAndroidArtifact).getDebugBuild().set((Object)((ApkCreationConfig)this.creationConfig).getDebuggable());
            ((PackageAndroidArtifact)packageAndroidArtifact).getDebugBuild().disallowChanges();
            ProjectOptions projectOptions = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions();
            ((PackageAndroidArtifact)packageAndroidArtifact).getIsInvokedFromIde().set(projectOptions.getProvider(BooleanOption.IDE_INVOKED_FROM_IDE));
            ((PackageAndroidArtifact)packageAndroidArtifact).getIsInvokedFromIde().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).projectBaseName = ((ApkCreationConfig)this.creationConfig).getServices().getProjectInfo().getProjectBaseName();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifestType = this.manifestType;
            String string = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetAbi = globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            if (((ApkCreationConfig)this.creationConfig).getVariantType().isDynamicFeature()) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getBaseModuleMetadata().from(new Object[]{((ApkCreationConfig)this.creationConfig).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.BASE_MODULE_METADATA)});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getBaseModuleMetadata().disallowChanges();
            if (!variantDslInfo.getSupportedAbis().isEmpty()) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getAbiFilters().set(variantDslInfo.getSupportedAbis());
            } else {
                ((PackageAndroidArtifact)packageAndroidArtifact).getAbiFilters().set((Iterable)(projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? CreationAction.firstValidInjectedAbi(projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) : ImmutableSet.of()));
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getAbiFilters().disallowChanges();
            ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetDensity = globalScope.getExtension().getSplits().getDensity().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY) : null;
            ((PackageAndroidArtifact)packageAndroidArtifact).targetApi = projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API);
            ((PackageAndroidArtifact)packageAndroidArtifact).apkCreatorType = ((ApkCreationConfig)this.creationConfig).getVariantScope().getApkCreatorType();
            ((PackageAndroidArtifact)packageAndroidArtifact).getCreatedBy().set((Object)globalScope.getCreatedBy());
            if (((ApkCreationConfig)this.creationConfig).getVariantType().isBaseModule() && ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.SDK_DEPENDENCY_DATA.INSTANCE, ((PackageAndroidArtifact)packageAndroidArtifact).getDependencyDataFile());
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getProjectPath().set((Object)packageAndroidArtifact.getProject().getPath());
            if (((ApkCreationConfig)this.creationConfig).getVariantType().isDynamicFeature() || this.creationConfig instanceof TestComponentImpl && ((ApkCreationConfig)this.creationConfig).getTestedConfig().getVariantType().isDynamicFeature()) {
                ((PackageAndroidArtifact)packageAndroidArtifact).getSigningConfigVersions().from(new Object[]{((ApkCreationConfig)this.creationConfig).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_SIGNING_CONFIG_VERSIONS)});
            } else {
                ((PackageAndroidArtifact)packageAndroidArtifact).getSigningConfigVersions().from(new Object[]{((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.SIGNING_CONFIG_VERSIONS.INSTANCE)});
            }
            ((PackageAndroidArtifact)packageAndroidArtifact).getSigningConfigVersions().disallowChanges();
            this.finalConfigure(packageAndroidArtifact);
        }

        protected void finalConfigure(TaskT task) {
            ((PackageAndroidArtifact)task).getJniFolders().from(new Object[]{PerModuleBundleTaskKt.getNativeLibsFiles(this.creationConfig)});
            ((PackageAndroidArtifact)task).setSigningConfigData(SigningConfigDataProvider.create((ApkCreationConfig)this.creationConfig));
        }

        public FileCollection getDexFolders(ApkCreationConfig creationConfig) {
            ArtifactsImpl artifacts2 = creationConfig.getArtifacts();
            if (creationConfig.getVariantScope().consumesFeatureJars()) {
                return creationConfig.getServices().fileCollection(artifacts2.get(InternalArtifactType.BASE_DEX.INSTANCE)).plus(this.getDesugarLibDexIfExists(creationConfig));
            }
            return creationConfig.getServices().fileCollection(artifacts2.getAll(InternalMultipleArtifactType.DEX.INSTANCE)).plus(this.getDesugarLibDexIfExists(creationConfig));
        }

        private FileCollection getJavaResources(ApkCreationConfig creationConfig) {
            ArtifactsImpl artifacts2 = creationConfig.getArtifacts();
            if (creationConfig.getCodeShrinker() == CodeShrinker.R8) {
                Provider<RegularFile> mergedJavaResProvider = artifacts2.get(InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE);
                return creationConfig.getServices().fileCollection(mergedJavaResProvider);
            }
            if (creationConfig.getNeedsMergedJavaResStream()) {
                return creationConfig.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            }
            Provider<RegularFile> mergedJavaResProvider = artifacts2.get(InternalArtifactType.MERGED_JAVA_RES.INSTANCE);
            return creationConfig.getServices().fileCollection(mergedJavaResProvider);
        }

        public FileCollection getFeatureDexFolder(ApkCreationConfig creationConfig, String projectPath) {
            if (!creationConfig.getVariantType().isDynamicFeature()) {
                return null;
            }
            return creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_DEX, new AndroidAttributes((Pair<? extends Attribute<String>, String>)new Pair(AndroidArtifacts.MODULE_PATH, (Object)projectPath)));
        }

        public FileCollection getFeatureJavaResources(ApkCreationConfig creationConfig, String projectPath) {
            if (!creationConfig.getVariantType().isDynamicFeature()) {
                return null;
            }
            return creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_SHRUNK_JAVA_RES, new AndroidAttributes((Pair<? extends Attribute<String>, String>)new Pair(AndroidArtifacts.MODULE_PATH, (Object)projectPath)));
        }

        private static Set<String> firstValidInjectedAbi(String abis2) {
            if (abis2 == null) {
                return ImmutableSet.of();
            }
            Set allowedAbis = Abi.getDefaultValues().stream().map(Abi::getTag).collect(Collectors.toSet());
            java.util.Optional<String> firstValidAbi = Arrays.stream(abis2.split(",")).map(String::trim).filter(allowedAbis::contains).findFirst();
            return (Set)firstValidAbi.map(ImmutableSet::of).orElseGet(ImmutableSet::of);
        }

        private FileCollection getDesugarLibDexIfExists(ApkCreationConfig creationConfig) {
            if (!creationConfig.getShouldPackageDesugarLibDex()) {
                return creationConfig.getServices().fileCollection();
            }
            return creationConfig.getServices().fileCollection(creationConfig.getArtifacts().get(InternalArtifactType.DESUGAR_LIB_DEX.INSTANCE));
        }
    }

    public static abstract class IncrementalSplitterRunnable
    implements WorkActionAdapter<SplitterParams> {
        @Inject
        public IncrementalSplitterRunnable(SplitterParams splitterParams) {
        }

        @Override
        public void doExecute() {
            SplitterParams params = (SplitterParams)this.getParameters();
            try {
                File incrementalDirForSplit = new File(((Directory)params.getIncrementalFolder().get()).getAsFile(), ((VariantOutputImpl.SerializedForm)params.getVariantOutput().get()).getFullName());
                File cacheDir = new File(incrementalDirForSplit, PackageAndroidArtifact.ZIP_DIFF_CACHE_DIR);
                if (!cacheDir.exists()) {
                    FileUtils.mkdirs((File)cacheDir);
                }
                HashMap<File, String> cacheKeyMap = new HashMap<File, String>();
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "dex", (SerializableInputChanges)params.getDexFiles().get());
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "javaResources", (SerializableInputChanges)params.getJavaResourceFiles().get());
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "assets", (SerializableInputChanges)params.getAssetsFiles().get());
                cacheKeyMap.put(((RegularFile)params.getAndroidResourcesFile().get()).getAsFile(), "androidResources");
                IncrementalSplitterRunnable.addCacheKeys(cacheKeyMap, "jniLibs", (SerializableInputChanges)params.getJniFiles().get());
                KeyedFileCache cache2 = new KeyedFileCache(cacheDir, file -> Objects.requireNonNull((String)cacheKeyMap.get(file)));
                HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
                Map changedDexFiles = IncrementalChanges.classpathToRelativeFileSet((SerializableInputChanges)((SerializableInputChanges)params.getDexFiles().get()), (KeyedFileCache)cache2, cacheUpdates);
                Map<RelativeFile, FileStatus> changedJavaResources = IncrementalSplitterRunnable.getChangedJavaResources(params, cacheKeyMap, cache2, cacheUpdates);
                Object changedAndroidResources = (Boolean)params.getAndroidResourcesChanged().get() != false ? IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)new ZipCentralDirectory(((RegularFile)params.getAndroidResourcesFile().get()).getAsFile()), (KeyedFileCache)cache2, cacheUpdates) : ImmutableMap.of();
                Map changedJniLibs = IncrementalChanges.classpathToRelativeFileSet((SerializableInputChanges)((SerializableInputChanges)params.getJniFiles().get()), (KeyedFileCache)cache2, cacheUpdates);
                BuiltArtifactsImpl manifestOutputs = new BuiltArtifactsLoaderImpl().load((Provider<Directory>)params.getManifestDirectory());
                PackageAndroidArtifact.doTask(incrementalDirForSplit, ((RegularFile)params.getOutputFile().get()).getAsFile(), cache2, manifestOutputs, changedDexFiles, changedJavaResources, ((SerializableInputChanges)params.getAssetsFiles().get()).getChanges(), (Map)changedAndroidResources, changedJniLibs, ((SerializableInputChanges)params.getAppMetadataFiles().get()).getChanges(), params);
                cacheUpdates.forEach(Runnable::run);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (params.getPackagerMode().get() == IncrementalPackagerBuilder.BuildType.CLEAN) {
                    PackageApplication.recordMetrics((String)params.getProjectPath().get(), ((RegularFile)params.getOutputFile().get()).getAsFile(), ((RegularFile)params.getAndroidResourcesFile().get()).getAsFile(), (AnalyticsService)params.getAnalyticsService().get());
                }
            }
        }

        private static void addCacheKeys(Map<File, String> builder, String prefix, SerializableInputChanges changes) {
            List roots = changes.getRoots();
            for (int i2 = 0; i2 < roots.size(); ++i2) {
                builder.put((File)roots.get(i2), prefix + i2);
            }
        }

        private static Map<RelativeFile, FileStatus> getChangedJavaResources(SplitterParams params, Map<File, String> cacheKeyMap, KeyedFileCache cache2, Set<Runnable> cacheUpdates) throws IOException {
            HashMap changedJavaResources = new HashMap();
            for (SerializableChange change : ((SerializableInputChanges)params.getJavaResourceFiles().get()).getChanges()) {
                if (change.getNormalizedPath().isEmpty()) {
                    try {
                        IncrementalChanges.addZipChanges(changedJavaResources, (File)change.getFile(), (KeyedFileCache)cache2, cacheUpdates);
                    }
                    catch (Zip64NotSupportedException e) {
                        File nonZip64 = PackageAndroidArtifact.copyJavaResourcesOnly(((Directory)params.getIncrementalFolder().get()).getAsFile(), change.getFile());
                        cacheKeyMap.put(nonZip64, cacheKeyMap.get(change.getFile()));
                        IncrementalChanges.addZipChanges(changedJavaResources, (File)nonZip64, (KeyedFileCache)cache2, cacheUpdates);
                    }
                    continue;
                }
                IncrementalChanges.addFileChange(changedJavaResources, (SerializableChange)change);
            }
            return Collections.unmodifiableMap(changedJavaResources);
        }
    }

    public static abstract class SplitterParams
    implements DecoratedWorkParameters {
        public abstract Property<VariantOutputImpl.SerializedForm> getVariantOutput();

        public abstract Property<String> getProjectPath();

        public abstract RegularFileProperty getAndroidResourcesFile();

        public abstract Property<Boolean> getAndroidResourcesChanged();

        public abstract RegularFileProperty getOutputFile();

        public abstract DirectoryProperty getIncrementalFolder();

        public abstract Property<SerializableInputChanges> getDexFiles();

        public abstract Property<SerializableInputChanges> getAssetsFiles();

        public abstract Property<SerializableInputChanges> getJniFiles();

        public abstract Property<SerializableInputChanges> getJavaResourceFiles();

        public abstract Property<SerializableInputChanges> getAppMetadataFiles();

        public abstract Property<Artifact<Directory>> getManifestType();

        @Optional
        protected abstract Property<SigningConfigProviderParams> getSigningConfigData();

        public abstract RegularFileProperty getSigningConfigVersionsFile();

        public abstract SetProperty<String> getAbiFilters();

        public abstract ListProperty<File> getJniFolders();

        public abstract DirectoryProperty getManifestDirectory();

        public abstract ListProperty<String> getAaptOptionsNoCompress();

        public abstract Property<Boolean> getJniLibsUseLegacyPackaging();

        public abstract Property<Boolean> getDexUseLegacyPackaging();

        @Optional
        public abstract Property<String> getCreatedBy();

        public abstract Property<Integer> getMinSdkVersion();

        public abstract Property<Boolean> getIsDebuggableBuild();

        public abstract Property<Boolean> getIsInvokedFromIde();

        public abstract Property<Boolean> getIsJniDebuggableBuild();

        public abstract Property<IncrementalPackagerBuilder.BuildType> getPackagerMode();

        public abstract Property<ApkCreatorType> getApkCreatorType();

        @Optional
        public abstract RegularFileProperty getDependencyDataFile();
    }
}

