/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.ResValue;
import com.android.build.api.variant.impl.ResValueKeyImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.api.SourceKind;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.InternalBaseVariant;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantImpl
implements BaseVariant,
InternalBaseVariant {
    public static final String TASK_ACCESS_DEPRECATION_URL = "https://d.android.com/r/tools/task-configuration-avoidance";
    public static final String USE_PROPERTIES_DEPRECATION_URL = "https://d.android.com/r/tools/use-properties";
    protected final ComponentImpl component;
    protected final BaseServices services;
    protected final ReadOnlyObjectProvider readOnlyObjectProvider;
    protected final NamedDomainObjectContainer<BaseVariantOutput> outputs;

    BaseVariantImpl(ComponentImpl component2, BaseServices services, ReadOnlyObjectProvider readOnlyObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        this.component = component2;
        this.services = services;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
        this.outputs = outputs;
    }

    protected abstract BaseVariantData getVariantData();

    public void addOutputs(List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    public String getName() {
        return this.component.getName();
    }

    @Override
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    public String getDirName() {
        return this.component.getDirName();
    }

    @Override
    public String getBaseName() {
        return this.component.getBaseName();
    }

    @Override
    public String getFlavorName() {
        return this.component.getFlavorName();
    }

    @Override
    public DomainObjectCollection<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public BuildType getBuildType() {
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)this.component.getVariantDslInfo();
        return this.readOnlyObjectProvider.getBuildType(variantDslInfo.getBuildTypeObj());
    }

    @Override
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.component.getVariantDslInfo().getProductFlavorList(), this.readOnlyObjectProvider);
    }

    @Override
    public InternalBaseVariant.MergedFlavor getMergedFlavor() {
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)this.component.getVariantDslInfo();
        return variantDslInfo.getMergedFlavor();
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.component.getVariantDslInfo().getJavaCompileOptions();
    }

    @Override
    public List<SourceProvider> getSourceSets() {
        return this.component.getVariantSources().getSortedSourceProviders();
    }

    @Override
    public List<ConfigurableFileTree> getSourceFolders(SourceKind folderType) {
        switch (folderType) {
            case JAVA: {
                return this.component.getJavaSources();
            }
        }
        this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Unknown SourceKind value: " + (Object)((Object)folderType));
        return ImmutableList.of();
    }

    @Override
    public Configuration getCompileConfiguration() {
        return this.getVariantData().getVariantDependencies().getCompileClasspath();
    }

    @Override
    public Configuration getRuntimeConfiguration() {
        return this.getVariantData().getVariantDependencies().getRuntimeClasspath();
    }

    @Override
    public Configuration getAnnotationProcessorConfiguration() {
        return this.getVariantData().getVariantDependencies().getAnnotationProcessorConfiguration();
    }

    @Override
    public String getApplicationId() {
        if (this.component.getVariantType().isDynamicFeature()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "variant.getApplicationId() is not supported by dynamic-feature plugins as it cannot handle delayed setting of the application ID. Please use getApplicationIdTextResource() instead.");
        }
        return (String)this.component.getApplicationId().get();
    }

    @Override
    public TextResource getApplicationIdTextResource() {
        this.services.getDeprecationReporter().reportDeprecatedApi("VariantProperties.applicationId", "BaseVariant.getApplicationIdTextResource", "TBD", DeprecationReporter.DeprecationTarget.VERSION_7_0);
        return this.getVariantData().applicationIdTextResource;
    }

    @Override
    public Task getPreBuild() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getPreBuildProvider()", "variant.getPreBuild()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.component.getTaskContainer().getPreBuildTask().get();
    }

    @Override
    public TaskProvider<Task> getPreBuildProvider() {
        return this.component.getTaskContainer().getPreBuildTask();
    }

    @Override
    public Task getCheckManifest() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getCheckManifestProvider()", "variant.getCheckManifest()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.component.getTaskContainer().getCheckManifestTask().get();
    }

    @Override
    public TaskProvider<Task> getCheckManifestProvider() {
        return this.component.getTaskContainer().getCheckManifestTask();
    }

    @Override
    public AidlCompile getAidlCompile() {
        if (!this.component.getBuildFeatures().getAidl()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "aidl support is disabled via buildFeatures.");
            return null;
        }
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getAidlCompileProvider()", "variant.getAidlCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (AidlCompile)this.component.getTaskContainer().getAidlCompileTask().get();
    }

    @Override
    public TaskProvider<AidlCompile> getAidlCompileProvider() {
        if (!this.component.getBuildFeatures().getAidl()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "aidl support is disabled via buildFeatures.");
            return null;
        }
        return this.component.getTaskContainer().getAidlCompileTask();
    }

    @Override
    public RenderscriptCompile getRenderscriptCompile() {
        if (!this.component.getBuildFeatures().getRenderScript()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "renderscript support is disabled via buildFeatures.");
            return null;
        }
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getRenderscriptCompileProvider()", "variant.getRenderscriptCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (RenderscriptCompile)this.component.getTaskContainer().getRenderscriptCompileTask().get();
    }

    @Override
    public TaskProvider<RenderscriptCompile> getRenderscriptCompileProvider() {
        if (!this.component.getBuildFeatures().getRenderScript()) {
            this.services.getIssueReporter().reportError(IssueReporter.Type.GENERIC, "renderscript support is disabled via buildFeatures.");
            return null;
        }
        return this.getVariantData().getTaskContainer().getRenderscriptCompileTask();
    }

    @Override
    public MergeResources getMergeResources() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMergeResourcesProvider()", "variant.getMergeResources()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (MergeResources)this.component.getTaskContainer().getMergeResourcesTask().getOrNull();
    }

    @Override
    public TaskProvider<MergeResources> getMergeResourcesProvider() {
        return this.component.getTaskContainer().getMergeResourcesTask();
    }

    @Override
    public MergeSourceSetFolders getMergeAssets() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMergeAssetsProvider()", "variant.getMergeAssets()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (MergeSourceSetFolders)this.component.getTaskContainer().getMergeAssetsTask().getOrNull();
    }

    @Override
    public TaskProvider<MergeSourceSetFolders> getMergeAssetsProvider() {
        return this.getVariantData().getTaskContainer().getMergeAssetsTask();
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getGenerateBuildConfigProvider()", "variant.getGenerateBuildConfig()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (GenerateBuildConfig)this.component.getTaskContainer().getGenerateBuildConfigTask().get();
    }

    @Override
    public TaskProvider<GenerateBuildConfig> getGenerateBuildConfigProvider() {
        return this.component.getTaskContainer().getGenerateBuildConfigTask();
    }

    @Override
    public JavaCompile getJavaCompile() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getJavaCompileProvider()", "variant.getJavaCompile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (JavaCompile)this.component.getTaskContainer().getJavacTask().get();
    }

    @Override
    public TaskProvider<JavaCompile> getJavaCompileProvider() {
        return this.getVariantData().getTaskContainer().getJavacTask();
    }

    @Override
    public Task getJavaCompiler() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getJavaCompileProvider()", "variant.getJavaCompiler()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.component.getTaskContainer().getJavacTask().get();
    }

    @Override
    public Collection<ExternalNativeBuildTask> getExternalNativeBuildTasks() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getExternalNativeBuildProviders()", "variant.getExternalNativeBuildTask()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return this.getExternalNativeBuildProviders().stream().map(Provider::get).collect(Collectors.toList());
    }

    @Override
    public Collection<TaskProvider<ExternalNativeBuildTask>> getExternalNativeBuildProviders() {
        TaskProvider<? extends ExternalNativeBuildTask> provider2 = this.component.getTaskContainer().getExternalNativeBuildTask();
        if (provider2 == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(provider2);
    }

    @Override
    public Task getObfuscation() {
        return null;
    }

    @Override
    public File getMappingFile() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getMappingFileProvider()", "variant.getMappingFile()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        RegularFile mappingFile = (RegularFile)this.component.getArtifacts().get(SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE).getOrNull();
        return mappingFile != null ? mappingFile.getAsFile() : null;
    }

    @Override
    public Provider<FileCollection> getMappingFileProvider() {
        return this.component.getServices().provider(() -> this.component.getServices().fileCollection(this.component.getArtifacts().get(SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE)));
    }

    public Sync getProcessJavaResources() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getProcessJavaResourcesProvider()", "variant.getProcessJavaResources()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Sync)this.component.getTaskContainer().getProcessJavaResourcesTask().get();
    }

    @Override
    public TaskProvider<AbstractCopyTask> getProcessJavaResourcesProvider() {
        return this.getVariantData().getTaskContainer().getProcessJavaResourcesTask();
    }

    @Override
    public Task getAssemble() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variant.getAssembleProvider()", "variant.getAssemble()", TASK_ACCESS_DEPRECATION_URL, DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.component.getTaskContainer().getAssembleTask().get();
    }

    @Override
    public TaskProvider<Task> getAssembleProvider() {
        return this.component.getTaskContainer().getAssembleTask();
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, Arrays.asList(sourceFolders));
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(TaskProvider<? extends Task> taskProvider, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(taskProvider, Arrays.asList(sourceFolders));
    }

    @Override
    public void registerJavaGeneratingTask(TaskProvider<? extends Task> taskProvider, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(taskProvider, sourceFolders);
    }

    @Override
    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        this.getVariantData().registerExternalAptJavaOutput(folder);
    }

    @Override
    public void registerGeneratedResFolders(FileCollection folders) {
        this.getVariantData().registerGeneratedResFolders(folders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection2) {
        return this.getVariantData().registerPreJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    @Deprecated
    public Object registerGeneratedBytecode(FileCollection fileCollection2) {
        return this.registerPreJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection2) {
        this.getVariantData().registerPostJavacGeneratedBytecode(fileCollection2);
    }

    @Override
    public FileCollection getCompileClasspath(Object generatorKey) {
        return this.component.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, generatorKey);
    }

    @Override
    public ArtifactCollection getCompileClasspathArtifacts(Object generatorKey) {
        return this.component.getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES_JAR, generatorKey);
    }

    @Override
    public void buildConfigField(String type, String name, String value) {
        if (!(this.component instanceof VariantImpl)) {
            throw new RuntimeException("Variant " + this.component.getVariantType().getName() + " do not support adding BuildConfig fields");
        }
        ((VariantImpl)this.component).addBuildConfigField(type, name, (Serializable)((Object)value), "Field from the variant API");
    }

    @Override
    public void resValue(String type, String name, String value) {
        if (!(this.component instanceof VariantImpl)) {
            throw new RuntimeException("Variant " + this.component.getVariantType().getName() + " do not support adding resValue");
        }
        ((VariantImpl)this.component).getResValues().put((Object)new ResValueKeyImpl(type, name), (Object)new ResValue(value, "Value from the variant"));
    }

    @Override
    public void missingDimensionStrategy(String dimension, String requestedValue) {
        this.component.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.of((Object)requestedValue));
    }

    @Override
    public void missingDimensionStrategy(String dimension, String ... requestedValues) {
        this.component.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf((Object[])requestedValues));
    }

    @Override
    public void missingDimensionStrategy(String dimension, List<String> requestedValues) {
        this.component.handleMissingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf(requestedValues));
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }

    @Override
    public FileCollection getAllRawAndroidResources() {
        return this.getVariantData().getAllRawAndroidResources();
    }

    @Override
    public void register(Task task) {
        TaskProvider<? extends Zip> bundleLibraryTask;
        MutableTaskContainer taskContainer = this.component.getTaskContainer();
        TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), task);
        TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
        if (bundleTask != null) {
            TaskFactoryUtils.dependsOn(bundleTask, task);
        }
        if ((bundleLibraryTask = taskContainer.getBundleLibraryTask()) != null) {
            TaskFactoryUtils.dependsOn(bundleLibraryTask, task);
        }
    }
}

