/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.VariantInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.ProjectOptions;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b&\u0018\u0000 H2\u00020\u0001:\u0005GHIJKB\u0005\u00a2\u0006\u0002\u0010\u0002J8\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010\u0011\u001a\u00020\u0005J\b\u0010=\u001a\u000202H\u0014J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\t0?H\u0002J\u0018\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020B2\u0006\u00103\u001a\u000204H\u0002J\u0018\u0010@\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010C\u001a\u00020\u0005H\u0002J\b\u0010D\u001a\u000202H\u0002J\u0012\u0010E\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\t0FH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007R\u0014\u0010%\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u0014\u0010)\u001a\u00020*8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006L"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "androidGradlePluginVersion", "", "getAndroidGradlePluginVersion", "androidSdkHome", "getAndroidSdkHome", "checkOnly", "Lorg/gradle/api/provider/ListProperty;", "getCheckOnly", "()Lorg/gradle/api/provider/ListProperty;", "fatalOnly", "getFatalOnly", "javaHome", "getJavaHome", "lintCacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintModelDirectory", "getLintModelDirectory", "lintRulesJar", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLintRulesJar", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "()Lcom/android/build/gradle/internal/lint/LintTool;", "offline", "getOffline", "partialResultsDirectory", "getPartialResultsDirectory", "printStackTrace", "getPrintStackTrace", "projectInputs", "Lcom/android/build/gradle/internal/lint/ProjectInputs;", "getProjectInputs", "()Lcom/android/build/gradle/internal/lint/ProjectInputs;", "variantInputs", "Lcom/android/build/gradle/internal/lint/VariantInputs;", "getVariantInputs", "()Lcom/android/build/gradle/internal/lint/VariantInputs;", "configureForStandalone", "", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "javaPluginConvention", "Lorg/gradle/api/plugins/JavaPluginConvention;", "customLintChecksConfig", "Lorg/gradle/api/file/FileCollection;", "lintOptions", "Lcom/android/build/gradle/internal/dsl/LintOptions;", "doTaskAction", "generateCommandLineArguments", "", "initializeGlobalInputs", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "isAndroid", "writeLintModelFile", "asLintPaths", "", "AndroidLintAnalysisWorkAction", "Companion", "LintVitalCreationAction", "SingleVariantCreationAction", "VariantCreationAction", "gradle-core"})
public abstract class AndroidLintAnalysisTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE = "LINT_PRINT_STACKTRACE";
    @NotNull
    public static final String PARTIAL_RESULTS_DIR_NAME = "out";

    @Nested
    @NotNull
    public abstract LintTool getLintTool();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintModelDirectory();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPartialResultsDirectory();

    @Internal
    @NotNull
    public abstract Property<String> getJavaHome();

    @Internal
    @NotNull
    public abstract Property<String> getAndroidSdkHome();

    @Input
    @NotNull
    public abstract Property<String> getAndroidGradlePluginVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract ListProperty<String> getCheckOnly();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintCacheDirectory();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getLintRulesJar();

    @Nested
    @NotNull
    public abstract ProjectInputs getProjectInputs();

    @Nested
    @NotNull
    public abstract VariantInputs getVariantInputs();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintStackTrace();

    @Override
    protected void doTaskAction() {
        this.writeLintModelFile();
        this.getWorkerExecutor().noIsolation().submit(AndroidLintAnalysisWorkAction.class, (Action)new Action<AndroidLintAnalysisWorkAction.LauncherParameters>(this){
            final /* synthetic */ AndroidLintAnalysisTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(AndroidLintAnalysisWorkAction.LauncherParameters it) {
                it.getArguments().set((Iterable)AndroidLintAnalysisTask.access$generateCommandLineArguments(this.this$0));
                it.getLintTool().set((Object)this.this$0.getLintTool());
                it.getAndroid().set((Provider)this.this$0.getAndroid());
                it.getFatalOnly().set((Provider)this.this$0.getFatalOnly());
            }
        });
    }

    private final void writeLintModelFile() {
        LintModelModule module2 = this.getProjectInputs().convertToLintModelModule$gradle_core();
        LintModelVariant variant2 = this.getVariantInputs().toLintModel(module2, ((Directory)this.getPartialResultsDirectory().get()).getAsFile());
        File file = ((Directory)this.getLintModelDirectory().get()).getAsFile();
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        FileUtils.cleanOutputDir((File)it);
        File destination = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)destination, (String)"destination");
        LintModelSerialization.writeModule$default((LintModelSerialization)LintModelSerialization.INSTANCE, (LintModelModule)module2, (File)destination, (List)CollectionsKt.listOf((Object)variant2), (boolean)true, null, null, (int)48, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateCommandLineArguments() {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Object check2;
        boolean bl = false;
        List arguments = new ArrayList();
        Iterator<Object[]> iterator2 = arguments;
        Object object2 = "--analyze-only";
        boolean bl2 = false;
        iterator2.add((Object[])object2);
        iterator2 = this.getFatalOnly().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"fatalOnly.get()");
        if (((Boolean)((Object)iterator2)).booleanValue()) {
            iterator2 = arguments;
            object2 = "--fatalOnly";
            bl2 = false;
            iterator2.add((Object[])object2);
        }
        iterator2 = arguments;
        object2 = new String[]{"--jdk-home", (String)this.getJavaHome().get()};
        object2 = CollectionsKt.listOf((Object[])object2);
        bl2 = false;
        CollectionsKt.addAll((Collection)((Object)iterator2), (Iterable)object2);
        iterator2 = arguments;
        object2 = new String[]{"--sdk-home", (String)this.getAndroidSdkHome().get()};
        object2 = CollectionsKt.listOf((Object[])object2);
        bl2 = false;
        CollectionsKt.addAll((Collection)((Object)iterator2), (Iterable)object2);
        iterator2 = arguments;
        object2 = "--lint-model";
        bl2 = false;
        iterator2.add((Object[])object2);
        iterator2 = arguments;
        object2 = this.asLintPaths(CollectionsKt.listOf((Object)((Directory)this.getLintModelDirectory().get()).getAsFile().getAbsolutePath()));
        bl2 = false;
        iterator2.add((Object[])object2);
        for (Object check2 : (List)this.getCheckOnly().get()) {
            Collection collection = arguments;
            object = new String[]{"--check", check2};
            object = CollectionsKt.listOf((Object[])object);
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        check2 = this.getLintRulesJar().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)check2, (String)"lintRulesJar.files");
        Iterable $this$filter$iv = (Iterable)check2;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl4 = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        List rules2 = (List)destination$iv$iv;
        object2 = rules2;
        bl2 = false;
        if (!object2.isEmpty()) {
            object2 = arguments;
            String string = "--lint-rule-jars";
            boolean bl6 = false;
            object2.add(string);
            object2 = arguments;
            string = this.asLintPaths(rules2);
            bl6 = false;
            object2.add(string);
        }
        object2 = this.getPrintStackTrace().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"printStackTrace.get()");
        if (((Boolean)object2).booleanValue()) {
            object2 = arguments;
            String string = "--stacktrace";
            boolean bl7 = false;
            object2.add(string);
        }
        object2 = Collections.unmodifiableList(arguments);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"unmodifiableList(arguments)");
        return object2;
    }

    private final String asLintPaths(Collection<String> $this$asLintPaths) {
        return CollectionsKt.joinToString$default((Iterable)$this$asLintPaths, (CharSequence)";", null, (CharSequence)";", (int)0, null, null, (int)58, null);
    }

    private final void initializeGlobalInputs(GlobalScope globalScope, Project project2) {
        this.initializeGlobalInputs(project2, true);
    }

    private final void initializeGlobalInputs(Project project2, boolean isAndroid) {
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroidGradlePluginVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"buildServiceRegistry");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        Provider sdkComponentsBuildService = provider2;
        Property<String> property = this.getAndroidSdkHome();
        Provider provider3 = sdkComponentsBuildService.flatMap((Transformer)initializeGlobalInputs.1.INSTANCE).map((Transformer)initializeGlobalInputs.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"sdkComponentsBuildService.flatMap { it.sdkDirectoryProvider }\n                .map { it.asFile.absolutePath }");
        HasConfigurableValuesKt.setDisallowChanges(property, provider3);
        Property<String> property2 = this.getJavaHome();
        provider3 = project2.getProviders().systemProperty("java.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"project.providers.systemProperty(\"java.home\")");
        HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
        HasConfigurableValuesKt.setDisallowChanges(this.getOffline(), project2.getGradle().getStartParameter().isOffline());
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), isAndroid);
        HasConfigurableValuesKt.setDisallowChanges((Property)this.getLintCacheDirectory(), project2.getLayout().getProjectDirectory().dir("intermediates").dir("lint-cache"));
        if (project2.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            HasConfigurableValuesKt.setDisallowChanges(this.getPrintStackTrace(), true);
        } else {
            Property<Boolean> property3 = this.getPrintStackTrace();
            provider3 = project2.getProviders().environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE).map((Transformer)initializeGlobalInputs.3.INSTANCE).orElse((Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"project.providers\n                    .environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE)\n                    .map { it.equals(\"true\", ignoreCase = true) }\n                    .orElse(false)");
            HasConfigurableValuesKt.setDisallowChanges(property3, provider3);
        }
    }

    public final void configureForStandalone(@NotNull Project project2, @NotNull ProjectOptions projectOptions, @NotNull JavaPluginConvention javaPluginConvention, @NotNull FileCollection customLintChecksConfig, @NotNull LintOptions lintOptions, boolean fatalOnly) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)javaPluginConvention, (String)"javaPluginConvention");
        Intrinsics.checkParameterIsNotNull((Object)customLintChecksConfig, (String)"customLintChecksConfig");
        Intrinsics.checkParameterIsNotNull((Object)lintOptions, (String)"lintOptions");
        this.initializeGlobalInputs(project2, false);
        this.setGroup("verification");
        this.setVariantName("");
        Property<AnalyticsService> property = this.getAnalyticsService();
        Object[] objectArray = project2.getGradle().getSharedServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"project.gradle.sharedServices");
        Object[] buildServiceRegistry$iv = objectArray;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckOnly(), (Iterable)lintOptions.getCheckOnly());
        this.getLintTool().initialize(project2, projectOptions);
        this.getProjectInputs().initializeForStandalone$gradle_core(project2, javaPluginConvention, lintOptions);
        this.getVariantInputs().initializeForStandalone$gradle_core(project2, javaPluginConvention, projectOptions, false);
        objectArray = new Object[]{customLintChecksConfig};
        HasConfigurableValuesKt.fromDisallowChanges(this.getLintRulesJar(), objectArray);
        Property property2 = (Property)this.getLintModelDirectory();
        objectArray = project2.getLayout().getBuildDirectory().dir("intermediates/android-lint-model");
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"project.layout.buildDirectory.dir(\"intermediates/android-lint-model\")");
        HasConfigurableValuesKt.setDisallowChanges(property2, objectArray);
    }

    public static /* synthetic */ void configureForStandalone$default(AndroidLintAnalysisTask androidLintAnalysisTask, Project project2, ProjectOptions projectOptions, JavaPluginConvention javaPluginConvention, FileCollection fileCollection2, LintOptions lintOptions, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        androidLintAnalysisTask.configureForStandalone(project2, projectOptions, javaPluginConvention, fileCollection2, lintOptions, bl);
    }

    public static final /* synthetic */ List access$generateCommandLineArguments(AndroidLintAnalysisTask $this) {
        return $this.generateCommandLineArguments();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$AndroidLintAnalysisWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$AndroidLintAnalysisWorkAction$LauncherParameters;", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "execute", "", "LauncherParameters", "gradle-core"})
    public static abstract class AndroidLintAnalysisWorkAction
    implements WorkAction<LauncherParameters> {
        @Inject
        @NotNull
        public abstract WorkerExecutor getWorkerExecutor();

        public void execute() {
            WorkerExecutor workerExecutor = this.getWorkerExecutor();
            List list = (List)((LauncherParameters)this.getParameters()).getArguments().get();
            Boolean bl = (Boolean)((LauncherParameters)this.getParameters()).getAndroid().get();
            Boolean bl2 = (Boolean)((LauncherParameters)this.getParameters()).getFatalOnly().get();
            LintTool lintTool = (LintTool)((LauncherParameters)this.getParameters()).getLintTool().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"get()");
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"get()");
            boolean bl3 = bl;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"get()");
            lintTool.submit(workerExecutor, "com.android.tools.lint.Main", list, bl3, bl2, false);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$AndroidLintAnalysisWorkAction$LauncherParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "fatalOnly", "getFatalOnly", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "gradle-core"})
        public static abstract class LauncherParameters
        implements WorkParameters {
            @Nested
            @NotNull
            public abstract Property<LintTool> getLintTool();

            @NotNull
            public abstract ListProperty<String> getArguments();

            @NotNull
            public abstract Property<Boolean> getAndroid();

            @NotNull
            public abstract Property<Boolean> getFatalOnly();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "name", "getName", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;
        @NotNull
        private final String description;

        public SingleVariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
            super(variant2);
            this.name = ComponentCreationConfig.DefaultImpls.computeTaskName$default(this.creationConfig, "lintAnalyze", null, 2, null);
            this.description = "Run lint analysis on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            Companion.registerOutputArtifacts(taskProvider, InternalArtifactType.LINT_PARTIAL_RESULTS.INSTANCE, this.creationConfig.getArtifacts());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "name", "getName", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;
        @NotNull
        private final String description;

        public LintVitalCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
            super(variant2);
            this.name = ComponentCreationConfig.DefaultImpls.computeTaskName$default(this.creationConfig, "lintVitalAnalyze", null, 2, null);
            this.fatalOnly = true;
            this.description = "Run lint analysis with only the fatal issues enabled on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            Companion.registerOutputArtifacts(taskProvider, InternalArtifactType.LINT_VITAL_PARTIAL_RESULTS.INSTANCE, this.creationConfig.getArtifacts());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "getVariant", "()Lcom/android/build/gradle/internal/lint/VariantWithTests;", "configure", "", "task", "gradle-core"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintAnalysisTask, ComponentCreationConfig> {
        @NotNull
        private final VariantWithTests variant;

        public VariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
            super((ComponentCreationConfig)variant2.getMain());
            this.variant = variant2;
        }

        @NotNull
        public final VariantWithTests getVariant() {
            return this.variant;
        }

        @Override
        @NotNull
        public final Class<AndroidLintAnalysisTask> getType() {
            return AndroidLintAnalysisTask.class;
        }

        public abstract boolean getFatalOnly();

        @NotNull
        public abstract String getDescription();

        @Override
        public final void configure(@NotNull AndroidLintAnalysisTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setGroup("verification");
            task.setDescription(this.getDescription());
            GlobalScope globalScope = this.creationConfig.getGlobalScope();
            Object[] objectArray = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"task.project");
            task.initializeGlobalInputs(globalScope, (Project)objectArray);
            DirectoryProperty directoryProperty = task.getLintModelDirectory();
            VariantPathHelper variantPathHelper = this.variant.getMain().getPaths();
            objectArray = task.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"task.name");
            directoryProperty.set(variantPathHelper.getIncrementalDir((String)objectArray));
            objectArray = new Object[]{this.creationConfig.getGlobalScope().getLocalCustomLintChecks()};
            task.getLintRulesJar().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRulesJar().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRulesJar().from(objectArray);
            task.getLintRulesJar().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getFatalOnly(), this.getFatalOnly());
            task.getCheckOnly().set(this.creationConfig.getServices().provider((Function0)new Function0<Set<String>>(this){
                final /* synthetic */ VariantCreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Set<String> invoke() {
                    return VariantCreationAction.access$getCreationConfig$p(this.this$0).getGlobalScope().getExtension().getLintOptions().getCheckOnly();
                }
            }));
            task.getProjectInputs().initialize$gradle_core(this.variant);
            VariantInputs.initialize$default(task.getVariantInputs(), this.variant, false, false, false, false, 24, null);
            task.getLintTool().initialize(this.creationConfig.getServices().getProjectInfo().getProject(), this.creationConfig.getServices().getProjectOptions());
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(VariantCreationAction $this) {
            return $this.creationConfig;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$Companion;", "", "()V", "LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE", "", "PARTIAL_RESULTS_DIR_NAME", "registerOutputArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "internalArtifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerOutputArtifacts(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider, @NotNull InternalArtifactType<Directory> internalArtifactType, @NotNull ArtifactsImpl artifacts2) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            Intrinsics.checkParameterIsNotNull(internalArtifactType, (String)"internalArtifactType");
            Intrinsics.checkParameterIsNotNull((Object)artifacts2, (String)"artifacts");
            artifacts2.setInitialProvider(taskProvider, (Function1)registerOutputArtifacts.1.INSTANCE).withName(AndroidLintAnalysisTask.PARTIAL_RESULTS_DIR_NAME).on((Artifact.Single)internalArtifactType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

