/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTask;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTaskKt;
import com.android.build.gradle.internal.tasks.Info;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/TestPreBuildTask;", "Lcom/android/build/gradle/internal/tasks/ClasspathComparisonTask;", "()V", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "onDifferentVersionsFound", "", "group", "module", "runtimeVersion", "compileVersion", "CreationAction", "gradle-core"})
public abstract class TestPreBuildTask
extends ClasspathComparisonTask {
    @Internal(value="only for task execution")
    @NotNull
    public abstract Property<String> getProjectPath();

    @Override
    protected void onDifferentVersionsFound(@NotNull String group, @NotNull String module2, @NotNull String runtimeVersion, @NotNull String compileVersion) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkParameterIsNotNull((Object)compileVersion, (String)"compileVersion");
        throw new GradleException("Conflict with dependency '" + group + ':' + module2 + "' in project '" + this.getProjectPath().get() + "'.\nResolved versions for app (" + compileVersion + ") and test app (" + runtimeVersion + ") differ.\nSee https://d.android.com/r/tools/test-apk-dependency-conflicts.html for details.");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/TestPreBuildTask$CreationAction;", "Lcom/android/build/gradle/internal/TaskManager$AbstractPreBuildCreationAction;", "Lcom/android/build/gradle/internal/tasks/TestPreBuildTask;", "creationConfig", "Lcom/android/build/gradle/internal/component/TestCreationConfig;", "(Lcom/android/build/gradle/internal/component/TestCreationConfig;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends TaskManager.AbstractPreBuildCreationAction<TestPreBuildTask> {
        public CreationAction(@NotNull TestCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public Class<TestPreBuildTask> getType() {
            return TestPreBuildTask.class;
        }

        @Override
        public void configure(@NotNull TestPreBuildTask task) {
            VariantDependencies variantDependencies;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            Configuration runtimeClasspath = this.creationConfig.getVariantDependencies().getRuntimeClasspath();
            VariantCreationConfig variantCreationConfig = this.creationConfig.getTestedConfig();
            Configuration compileClasspath = variantCreationConfig == null ? null : ((variantDependencies = variantCreationConfig.getVariantDependencies()) == null ? null : variantDependencies.getRuntimeClasspath());
            task.getRuntimeVersionMap().set(task.getProject().getProviders().provider((Callable)new Callable<Map<Info, ? extends String>>(runtimeClasspath){
                final /* synthetic */ Configuration $runtimeClasspath;
                {
                    this.$runtimeClasspath = $runtimeClasspath;
                }

                public final Map<Info, String> call() {
                    return ClasspathComparisonTaskKt.toVersionMap(this.$runtimeClasspath);
                }
            }));
            task.getCompileVersionMap().set(task.getProject().getProviders().provider((Callable)new Callable<Map<Info, ? extends String>>(compileClasspath){
                final /* synthetic */ Configuration $compileClasspath;
                {
                    this.$compileClasspath = $compileClasspath;
                }

                @Nullable
                public final Map<Info, String> call() {
                    Configuration configuration = this.$compileClasspath;
                    return configuration == null ? null : ClasspathComparisonTaskKt.toVersionMap(configuration);
                }
            }));
            task.setFakeOutputDirectory(new File(this.creationConfig.getServices().getProjectInfo().getIntermediatesDir(), Intrinsics.stringPlus((String)"prebuild/", (Object)this.creationConfig.getDirName())));
            HasConfigurableValuesKt.setDisallowChanges(task.getProjectPath(), task.getProject().getPath());
        }
    }
}

