/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u001a\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"allPatterns", "", "Lkotlin/text/Regex;", "clangDiagnosticMessagePattern", "clangFileInclusionPattern", "clangLinkerErrorDiagnosticPattern", "clangLinkerErrorPattern", "diagnosticTypeOrPattern", "", "diagnosticTypes", "msvcDiagnosticMessagePattern", "isNinjaWorkingDirectoryLine", "", "message", "shouldElevateToLifeCycle", "gradle-core"})
public final class ClangMessageCategoryKt {
    @NotNull
    private static final List<String> diagnosticTypes;
    @NotNull
    private static final String diagnosticTypeOrPattern;
    @NotNull
    private static final Regex clangLinkerErrorPattern;
    @NotNull
    private static final Regex clangFileInclusionPattern;
    @NotNull
    private static final Regex clangDiagnosticMessagePattern;
    @NotNull
    private static final Regex clangLinkerErrorDiagnosticPattern;
    @NotNull
    private static final Regex msvcDiagnosticMessagePattern;
    @NotNull
    private static final List<Regex> allPatterns;

    public static final boolean isNinjaWorkingDirectoryLine(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return StringsKt.startsWith$default((String)message, (String)"ninja: Entering directory", (boolean)false, (int)2, null);
    }

    public static final boolean shouldElevateToLifeCycle(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (!StringsKt.contains$default((CharSequence)message, (char)':', (boolean)false, (int)2, null)) {
            return false;
        }
        for (Regex pattern : allPatterns) {
            if (!pattern.matches((CharSequence)message)) continue;
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"ignored", "note", "remark", "warning", "error", "fatal error"};
        diagnosticTypes = CollectionsKt.listOf((Object[])objectArray);
        diagnosticTypeOrPattern = CollectionsKt.joinToString$default((Iterable)diagnosticTypes, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        clangLinkerErrorPattern = new Regex("clang(\\+\\+)?(\\.exe)?: error: linker command failed with exit code 1.*");
        clangFileInclusionPattern = new Regex("In file included from (.+):(\\d+):");
        clangDiagnosticMessagePattern = new Regex("((?:[A-Z]:)?[^\\s][^:]+):(\\d+):(\\d+): (" + diagnosticTypeOrPattern + "): (.*)");
        clangLinkerErrorDiagnosticPattern = new Regex("((?:[A-Z]:)?[^\\s][^:]+)(?::(\\d+))?: (" + diagnosticTypeOrPattern + ")?: (.+)");
        msvcDiagnosticMessagePattern = new Regex("((?:[A-Z]:)?[^\\s][^:]+)\\((\\d+),(\\d+)\\): (" + diagnosticTypeOrPattern + "): (.*)");
        objectArray = new Regex[]{clangLinkerErrorPattern, clangFileInclusionPattern, clangDiagnosticMessagePattern, clangLinkerErrorDiagnosticPattern, msvcDiagnosticMessagePattern};
        allPatterns = CollectionsKt.listOf((Object[])objectArray);
    }
}

