/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ<\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/lint/LintTool;", "", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "runInProcess", "Lorg/gradle/api/provider/Property;", "", "getRunInProcess", "()Lorg/gradle/api/provider/Property;", "workerHeapSize", "", "getWorkerHeapSize", "initialize", "", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "submit", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "mainClass", "arguments", "", "android", "fatalOnly", "await", "gradle-core"})
public abstract class LintTool {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @NotNull
    public abstract Property<Boolean> getRunInProcess();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getWorkerHeapSize();

    public final void initialize(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        ConfigurableFileCollection configurableFileCollection = this.getClasspath();
        Object object = new Object[1];
        Configuration configuration = project2.getConfigurations().getByName("lintClassPath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.configurations.getByName(LINT_CLASS_PATH)");
        object[0] = configuration;
        HasConfigurableValuesKt.fromDisallowChanges(configurableFileCollection, (Object[])object);
        Property<Boolean> property = this.getRunInProcess();
        object = projectOptions.getProvider(BooleanOption.RUN_LINT_IN_PROCESS);
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"projectOptions.getProvider(BooleanOption.RUN_LINT_IN_PROCESS)");
        HasConfigurableValuesKt.setDisallowChanges(property, object);
        Property<String> property2 = this.getWorkerHeapSize();
        object = projectOptions.getProvider(StringOption.LINT_HEAP_SIZE);
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"projectOptions.getProvider(StringOption.LINT_HEAP_SIZE)");
        HasConfigurableValuesKt.setDisallowChanges(property2, object);
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkParameterIsNotNull((Object)mainClass, (String)"mainClass");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        this.submit(workerExecutor, mainClass, arguments, true, false, false);
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, boolean android, boolean fatalOnly, boolean await) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkParameterIsNotNull((Object)mainClass, (String)"mainClass");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Object object = this.getRunInProcess().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runInProcess.get()");
        WorkQueue workQueue2 = (Boolean)object != false ? workerExecutor.noIsolation() : workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(this){
            final /* synthetic */ LintTool this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProcessWorkerSpec it) {
                Object object = new Object[]{this.this$0.getClasspath()};
                it.getClasspath().from(object);
                object = (String)this.this$0.getWorkerHeapSize().getOrNull();
                it.getForkOptions().setMaxHeapSize((String)(object == null ? "" + Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024 + 'm' : object));
            }
        });
        workQueue2.submit(AndroidLintWorkAction.class, (Action)new Action<AndroidLintWorkAction.LintWorkActionParameters>(mainClass, arguments, this, android, fatalOnly){
            final /* synthetic */ String $mainClass;
            final /* synthetic */ List<String> $arguments;
            final /* synthetic */ LintTool this$0;
            final /* synthetic */ boolean $android;
            final /* synthetic */ boolean $fatalOnly;
            {
                this.$mainClass = $mainClass;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                this.$android = $android;
                this.$fatalOnly = $fatalOnly;
            }

            public final void execute(AndroidLintWorkAction.LintWorkActionParameters parameters) {
                parameters.getMainClass().set((Object)this.$mainClass);
                parameters.getArguments().set((Iterable)this.$arguments);
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                parameters.getClasspath().from(objectArray);
                parameters.getAndroid().set((Object)this.$android);
                parameters.getFatalOnly().set((Object)this.$fatalOnly);
                parameters.getRunInProcess().set(this.this$0.getRunInProcess().get());
            }
        });
        if (await) {
            workQueue2.await();
        }
    }
}

