/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigVersions;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils;", "", "()V", "Companion", "gradle-core"})
public final class SigningConfigUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Gson> gson$delegate = LazyKt.lazy((Function0)Companion.gson.2.INSTANCE);

    @JvmStatic
    @NotNull
    public static final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
        return Companion.loadSigningConfigVersions(input);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "loadSigningConfigData", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "input", "Ljava/io/File;", "loadSigningConfigVersions", "Lcom/android/build/gradle/internal/signing/SigningConfigVersions;", "saveSigningConfigData", "", "outputFile", "signingConfigData", "saveSigningConfigVersions", "signingConfigVersions", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveSigningConfigData(@NotNull File outputFile, @Nullable SigningConfigData signingConfigData) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            outputFile.createNewFile();
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(outputFile.toPath(), (Set<PosixFilePermission>)perms);
            } else {
                AclFileAttributeView view = Files.getFileAttributeView(outputFile.toPath(), AclFileAttributeView.class, new LinkOption[0]);
                AclEntryPermission[] aclEntryPermissionArray = new AclEntryPermission[]{AclEntryPermission.READ_ACL, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.DELETE};
                AclEntry entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(view.getOwner()).setPermissions(aclEntryPermissionArray).build();
                view.setAcl(CollectionsKt.listOf((Object)entry));
            }
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigData), (Charset)StandardCharsets.UTF_8);
        }

        public final void saveSigningConfigVersions(@NotNull File outputFile, @NotNull SigningConfigVersions signingConfigVersions) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)signingConfigVersions, (String)"signingConfigVersions");
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigVersions), (Charset)StandardCharsets.UTF_8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SigningConfigData loadSigningConfigData(@NotNull File input) {
            SigningConfigData signingConfigData;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl5 = false;
                signingConfigData = (SigningConfigData)Companion.getGson().fromJson((Reader)reader, SigningConfigData.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return signingConfigData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
            SigningConfigVersions signingConfigVersions;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl5 = false;
                signingConfigVersions = (SigningConfigVersions)Companion.getGson().fromJson((Reader)reader, SigningConfigVersions.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            SigningConfigVersions signingConfigVersions2 = signingConfigVersions;
            Intrinsics.checkExpressionValueIsNotNull((Object)signingConfigVersions2, (String)"input.bufferedReader(StandardCharsets.UTF_8).use { reader ->\n                gson.fromJson(reader, SigningConfigVersions::class.java)\n            }");
            return signingConfigVersions2;
        }

        private final Gson getGson() {
            Lazy lazy = gson$delegate;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pyright (C) 2017 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.android.build.gradle.internal.tasks\n\nimport com.android.SdkConstants\nimport com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor\nimport com.android.build.gradle.internal.signing.SigningConfigData\nimport com.android.build.gradle.internal.signing.SigningConfigVersions\nimport com.google.gson.Gson\nimport com.google.gson.GsonBuilder\nimport org.apache.commons.io.FileUtils\nimport java.io.File\nimport java.nio.charset.StandardCharsets\nimport java.nio.file.Files\nimport java.nio.file.attribute.AclEntry\nimport java.nio.file.attribute.AclEntryPermission\nimport java.nio.file.attribute.AclEntryType\nimport java.nio.file.attribute.AclFileAttributeView\nimport java.nio.file.attribute.PosixFilePermission\n\n/**\n * Utility class to save/load the signing config information to/from a json file.\n */\nclass SigningConfigUtils {\n\n    companion object {\n\n        /** Saves the [SigningConfigData] information to the outputFile.  */\n        fun saveSigningConfigData(outputFile: File, signingConfigData: SigningConfigData?) {\n            // create the file if it doesn't already exist, so we can set the permissions on it.\n            outputFile.createNewFile()\n            if (SdkConstants.CURRENT_PLATFORM != SdkConstants.PLATFORM_WINDOWS) {\n                // set read, write permissions for owner only.\n                val perms = HashSet<PosixFilePermission>()\n                perms.add(PosixFilePermission.OWNER_READ)\n                perms.add(PosixFilePermission.OWNER_WRITE)\n                Files.setPosixFilePermissions(outputFile.toPath(), perms)\n            } else {\n                // on windows, use AclEntry to set the owner read/write permission.\n                val view = Files.getFileAttributeView(\n                    outputFile.toPath(), AclFileAttributeView::class.java\n                )\n                val entry = AclEntry.newBuilder()\n                    .setType(AclEntryType.ALLOW)\n                    .setPrincipal(view.owner)\n                    .setPermissions(\n                        AclEntryPermission.READ_ACL,\n                        AclEntryPermission.READ_NAMED_ATTRS,\n                        AclEntryPermission.READ_DATA,\n                        AclEntryPermission.READ_ATTRIBUTES,\n                        AclEntryPermission.WRITE_ACL,\n                        AclEntryPermission.WRITE_DATA,\n                        AclEntryPermission.APPEND_DATA,\n                        AclEntryPermission.WRITE_NAMED_ATTRS,\n                        AclEntryPermission.WRITE_ATTRIBUTES,\n                        AclEntryPermission.WRITE_OWNER,\n                        AclEntryPermission.SYNCHRONIZE,\n                        AclEntryPermission.DELETE\n                    )\n                    .build()\n                view.acl = listOf(entry)\n            }\n\n            FileUtils.write(outputFile, gson.toJson(signingConfigData), StandardCharsets.UTF_8)\n        }\n\n        /** Saves the [SigningConfigVersions] information to the outputFile.  */\n        fun saveSigningConfigVersions(\n            outputFile: File,\n            signingConfigVersions: SigningConfigVersions\n        ) {\n            FileUtils.write(\n                outputFile,\n                gson.toJson(signingConfigVersions),\n                StandardCharsets.UTF_8\n            )\n        }\n\n        /** Loads the [SigningConfigData] information from a json file. */\n        fun loadSigningConfigData(input: File): SigningConfigData? {\n            return input.bufferedReader(StandardCharsets.UTF_8).use { reader ->\n                gson.fromJson(reader, SigningConfigData::class.java)\n            }\n        }\n\n        /** Loads the [SigningConfigVersions] information from a json file. */\n        @JvmStatic\n        fun loadSigningConfigVersions(input: File): SigningConfigVersions {\n            return input.bufferedReader(StandardCharsets.UTF_8).use { reader ->\n                gson.fromJson(reader, SigningConfigVersions::class.java)\n            }\n        }\n\n        private val gson: Gson by lazy {\n            val gsonBuilder = GsonBuilder()\n            gsonBuilder.registerTypeAdapter(File::class.java, PlainFileGsonTypeAdaptor())\n            gsonBuilder.create()\n        }");
            return (Gson)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

