/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.process.GradleProcessResult;
import com.android.build.gradle.internal.process.OutputHandlerFailedGradleProcessResult;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class GradleProcessExecutor
implements ProcessExecutor {
    private final Function<Action<? super ExecSpec>, ExecResult> execOperations;

    public GradleProcessExecutor(Function<Action<? super ExecSpec>, ExecResult> execOperations) {
        this.execOperations = execOperations;
    }

    public ListenableFuture<ProcessResult> submit(final ProcessInfo processInfo, final ProcessOutputHandler processOutputHandler) {
        final SettableFuture res = SettableFuture.create();
        new Thread(){

            @Override
            public void run() {
                try {
                    ProcessResult result2 = GradleProcessExecutor.this.execute(processInfo, processOutputHandler);
                    res.set((Object)result2);
                }
                catch (Throwable e) {
                    res.setException(e);
                }
            }
        }.start();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult execute(ProcessInfo processInfo, ProcessOutputHandler processOutputHandler) {
        ExecResult result2;
        ProcessOutput output2 = processOutputHandler.createOutput();
        try {
            result2 = this.execOperations.apply(new ExecAction(processInfo, output2));
        }
        finally {
            try {
                output2.close();
            }
            catch (IOException e) {
                LoggerWrapper.getLogger(GradleProcessExecutor.class).warning("Exception while closing sub process streams: " + Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            }
        }
        try {
            processOutputHandler.handleOutput(output2);
        }
        catch (ProcessException e) {
            return new OutputHandlerFailedGradleProcessResult(e);
        }
        return new GradleProcessResult(result2, processInfo);
    }

    private static class ExecAction
    implements Action<ExecSpec> {
        private final ProcessInfo processInfo;
        private final ProcessOutput processOutput;

        ExecAction(ProcessInfo processInfo, ProcessOutput processOutput) {
            this.processInfo = processInfo;
            this.processOutput = processOutput;
        }

        public void execute(ExecSpec execSpec) {
            List args = this.processInfo.getArgs().stream().map(a -> a.isEmpty() ? "\"\"" : a).collect(Collectors.toList());
            execSpec.setExecutable(this.processInfo.getExecutable());
            execSpec.args(args);
            execSpec.environment(this.processInfo.getEnvironment());
            execSpec.setStandardOutput(this.processOutput.getStandardOutput());
            execSpec.setErrorOutput(this.processOutput.getErrorOutput());
            execSpec.setIgnoreExitValue(true);
        }
    }
}

