/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.CompressAssetsWorkAction;
import com.android.build.gradle.internal.tasks.CompressAssetsWorkParameters;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.FileType;
import org.gradle.work.FileChange;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CompressAssetsDelegate;", "", "workQueue", "Lorg/gradle/workers/WorkQueue;", "inputDir", "Ljava/io/File;", "outputDir", "noCompressPredicate", "Ljava/util/function/Predicate;", "", "compressionLevel", "", "changes", "", "Lorg/gradle/work/FileChange;", "(Lorg/gradle/workers/WorkQueue;Ljava/io/File;Ljava/io/File;Ljava/util/function/Predicate;ILjava/lang/Iterable;)V", "getChanges", "()Ljava/lang/Iterable;", "getInputDir", "()Ljava/io/File;", "getOutputDir", "run", "", "gradle-core"})
public final class CompressAssetsDelegate {
    @NotNull
    private final WorkQueue workQueue;
    @NotNull
    private final File inputDir;
    @NotNull
    private final File outputDir;
    @NotNull
    private final Predicate<String> noCompressPredicate;
    private final int compressionLevel;
    @NotNull
    private final Iterable<FileChange> changes;

    public CompressAssetsDelegate(@NotNull WorkQueue workQueue2, @NotNull File inputDir, @NotNull File outputDir, @NotNull Predicate<String> noCompressPredicate, int compressionLevel, @NotNull Iterable<? extends FileChange> changes) {
        Intrinsics.checkParameterIsNotNull((Object)workQueue2, (String)"workQueue");
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull(noCompressPredicate, (String)"noCompressPredicate");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        this.workQueue = workQueue2;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.noCompressPredicate = noCompressPredicate;
        this.compressionLevel = compressionLevel;
        this.changes = changes;
    }

    @NotNull
    public final File getInputDir() {
        return this.inputDir;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final Iterable<FileChange> getChanges() {
        return this.changes;
    }

    public final void run() {
        for (FileChange change : this.changes) {
            if (change.getFileType() == FileType.DIRECTORY) continue;
            String entryPath = Intrinsics.stringPlus((String)"assets/", (Object)change.getNormalizedPath());
            File targetFile = new File(this.outputDir, Intrinsics.stringPlus((String)entryPath, (Object)".jar"));
            int entryCompressionLevel = this.noCompressPredicate.test(entryPath) ? 0 : this.compressionLevel;
            this.workQueue.submit(CompressAssetsWorkAction.class, (Action)new Action<CompressAssetsWorkParameters>(change, targetFile, entryPath, entryCompressionLevel){
                final /* synthetic */ FileChange $change;
                final /* synthetic */ File $targetFile;
                final /* synthetic */ String $entryPath;
                final /* synthetic */ int $entryCompressionLevel;
                {
                    this.$change = $change;
                    this.$targetFile = $targetFile;
                    this.$entryPath = $entryPath;
                    this.$entryCompressionLevel = $entryCompressionLevel;
                }

                public final void execute(CompressAssetsWorkParameters it) {
                    it.getInput().set(this.$change.getFile());
                    it.getOutput().set(this.$targetFile);
                    it.getEntryPath().set((Object)this.$entryPath);
                    it.getEntryCompressionLevel().set((Object)this.$entryCompressionLevel);
                    it.getChangeType().set((Object)this.$change.getChangeType());
                }
            });
        }
    }
}

