/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.CxxStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.logging.CxxStructuredLogDecoder;
import com.android.build.gradle.internal.cxx.logging.NewString;
import com.android.build.gradle.internal.cxx.logging.PayloadHeader;
import com.android.build.gradle.internal.cxx.logging.StructuredLogRecord;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.cxx.string.StringTable;
import com.google.protobuf.GeneratedMessageV3;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "output", "Ljava/io/DataOutputStream;", "getOutput", "()Ljava/io/DataOutputStream;", "strings", "Lcom/android/build/gradle/internal/cxx/string/StringTable;", "getStrings", "()Lcom/android/build/gradle/internal/cxx/string/StringTable;", "close", "", "encode", "", "string", "", "write", "message", "Lcom/google/protobuf/GeneratedMessageV3;", "gradle-core"})
public final class CxxStructuredLogEncoder
implements StringEncoder,
AutoCloseable {
    @NotNull
    private final File file;
    @NotNull
    private final DataOutputStream output;
    @NotNull
    private final StringTable strings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CxxStructuredLogEncoder(@NotNull File file) {
        Closeable closeable;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.strings = new StringTable(1, null, null, 6, null);
        if (!this.file.exists()) {
            boolean bl2 = this.file.getParentFile().isDirectory();
            bl = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            bl = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                DataOutputStream output2 = (DataOutputStream)closeable;
                boolean bl5 = false;
                output2.write(CxxStructuredLogCodecKt.access$getMAGIC$p());
                output2 = Unit.INSTANCE;
            }
            catch (Throwable output2) {
                throwable = output2;
                throw output2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (this.file.exists()) {
            closeable = new DataInputStream(new FileInputStream(this.file));
            bl = false;
            boolean bl6 = false;
            Throwable throwable = null;
            try {
                DataInputStream input = (DataInputStream)closeable;
                boolean bl7 = false;
                CxxStructuredLogDecoder reader = new CxxStructuredLogDecoder(input);
                StructuredLogRecord record = reader.read();
                while (record != null) {
                    if (record.getRecordCase() == StructuredLogRecord.RecordCase.NEW_STRING) {
                        StringTable stringTable = this.getStrings();
                        String string = record.getNewString().getData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"record.newString.data");
                        stringTable.encode(string);
                    }
                    record = reader.read();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file, true)));
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final DataOutputStream getOutput() {
        return this.output;
    }

    @NotNull
    public final StringTable getStrings() {
        return this.strings;
    }

    @Override
    public int encode(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        return this.strings.getIdCreateIfAbsent(string, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(string, this){
            final /* synthetic */ String $string;
            final /* synthetic */ CxxStructuredLogEncoder this$0;
            {
                this.$string = $string;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                StructuredLogRecord.newBuilder().setNewString(NewString.newBuilder().setData(this.$string).build()).build().writeDelimitedTo(this.this$0.getOutput());
            }
        }));
    }

    public final void write(@NotNull GeneratedMessageV3 message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        StructuredLogRecord.Builder builder = StructuredLogRecord.newBuilder();
        PayloadHeader.Builder builder2 = PayloadHeader.newBuilder().setTimeStampMs(System.currentTimeMillis());
        String string = message.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.javaClass.name");
        builder.setPayloadHeader(builder2.setTypeId(this.encode(string)).build()).build().writeDelimitedTo(this.output);
        message.writeDelimitedTo((OutputStream)this.output);
    }

    @Override
    public void close() {
        this.output.flush();
        this.output.close();
    }
}

