/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BundleIdeModelProducerTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleIdeModelProducerTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "bundleIdeModel", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleIdeModel", "()Lorg/gradle/api/file/RegularFileProperty;", "finalBundleFile", "getFinalBundleFile", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class BundleIdeModelProducerTask
extends NonIncrementalTask {
    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getFinalBundleFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBundleIdeModel();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Override
    protected void doTaskAction() {
        Artifact artifact = (Artifact)SingleArtifact.BUNDLE.INSTANCE;
        Object object = this.getApplicationId().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"applicationId.get()");
        String string = (String)object;
        String string2 = this.getVariantName();
        object = ((File)this.getFinalBundleFile().getAsFile().get()).getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.asFile.get().absolutePath");
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsImpl(0, artifact, string, string2, CollectionsKt.listOf((Object)BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, (String)object, null, null, null, null, 30, null)), null, 33, null);
        object = this.getBundleIdeModel().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleIdeModel.asFile.get()");
        builtArtifactsImpl.saveToFile((File)object);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleIdeModelProducerTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/BundleIdeModelProducerTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<BundleIdeModelProducerTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("produce", "BundleIdeListingFile");
        }

        @Override
        @NotNull
        public Class<BundleIdeModelProducerTask> getType() {
            return BundleIdeModelProducerTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<BundleIdeModelProducerTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("output-metadata.json").on(InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE);
        }

        @Override
        public void configure(@NotNull BundleIdeModelProducerTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE, (Property)task.getFinalBundleFile());
            HasConfigurableValuesKt.setDisallowChanges(task.getApplicationId(), ((ApkCreationConfig)this.creationConfig).getApplicationId());
            task.getOutputs().doNotCacheIf("This task is fast-running, so the cacheability overhead could outweigh its benefit", (Spec)configure.1.INSTANCE);
        }
    }
}

