/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.utils.DesugarConfigJson;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u001a.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"ATTR_LINT_COMPILE_SDK", "Lorg/gradle/api/attributes/Attribute;", "", "ATTR_LINT_MIN_SDK", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "DESUGAR_LIB_LINT", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibJarFromMaven", "getDesugarLibLintFromTransform", "minSdkVersion", "", "compileSdkVersion", "getDesugaredMethods", "", "coreLibraryDesugaringEnabled", "", "Lcom/android/build/api/variant/AndroidVersion;", "registerDesugarLibConfigTransform", "", "registerDesugarLibLintTransform", "gradle-core"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    @NotNull
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-lib-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    @NotNull
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    @NotNull
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(configuration);
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Configuration configuration;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = (Configuration)project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (configuration2 == null) {
            Intrinsics.throwNpe();
        }
        Configuration configuration3 = configuration = configuration2;
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        configuration = project2.getProviders().of(DesugarConfigJson.class, (Action)new Action<ValueSourceSpec<DesugarConfigJson.Parameters>>(configuration3){
            final /* synthetic */ Configuration $configuration;
            {
                this.$configuration = $configuration;
            }

            public final void execute(ValueSourceSpec<DesugarConfigJson.Parameters> it) {
                ((DesugarConfigJson.Parameters)it.getParameters()).getDesugarJson().setFrom((Iterable)DesugarLibUtils.access$getDesugarLibConfigFromTransform(this.$configuration));
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"val configuration = project.configurations.findByName(CONFIG_NAME_CORE_LIBRARY_DESUGARING)!!\n\n    registerDesugarLibConfigTransform(project)\n\n    return project.providers.of(DesugarConfigJson::class.java) {\n        it.parameters.desugarJson.setFrom(getDesugarLibConfigFromTransform(configuration))\n    }");
        return configuration;
    }

    @NotNull
    public static final List<String> getDesugaredMethods(@NotNull Project project2, boolean coreLibraryDesugaringEnabled, @NotNull com.android.build.api.variant.AndroidVersion minSdkVersion2, @Nullable String compileSdkVersion) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)minSdkVersion2, (String)"minSdkVersion");
        Configuration configuration = (Configuration)project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        Configuration configuration2 = object = configuration;
        if (compileSdkVersion == null || !coreLibraryDesugaringEnabled || configuration2.getDependencies().isEmpty()) {
            object = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"emptyList()");
            return object;
        }
        int minSdk = VariantApiExtensionsKt.getFeatureLevel(minSdkVersion2);
        AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)compileSdkVersion);
        if (androidVersion == null) {
            Intrinsics.throwNpe();
        }
        int compileSdk = androidVersion.getFeatureLevel();
        DesugarLibUtils.registerDesugarLibLintTransform(project2, minSdk, compileSdk);
        Set files2 = DesugarLibUtils.getDesugarLibLintFromTransform(configuration2, minSdk, compileSdk).getFiles();
        boolean bl = false;
        List methods = new ArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)files2, (String)"files");
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            methods.addAll(FilesKt.readLines$default((File)it, null, (int)1, null));
        }
        return methods;
    }

    private static final Configuration getDesugarLibConfiguration(Project project2) {
        Configuration configuration;
        Configuration configuration2;
        Configuration configuration3 = (Configuration)project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (configuration3 == null) {
            Intrinsics.throwNpe();
        }
        if ((configuration2 = (configuration = configuration3)).getDependencies().isEmpty()) {
            throw new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration2;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.artifactView { configuration ->\n        configuration.attributes {\n            it.attribute(\n                ArtifactAttributes.ARTIFACT_FORMAT,\n                DESUGAR_LIB_CONFIG\n            )\n        }\n    }.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.artifactView { config ->\n        config.attributes {\n            it.attribute(\n                ArtifactAttributes.ARTIFACT_FORMAT,\n                ArtifactTypeDefinition.JAR_TYPE\n            )\n        }\n    }.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }

    private static final void registerDesugarLibLintTransform(Project project2, int minSdkVersion2, int compileSdkVersion) {
        project2.getDependencies().registerTransform(DesugarLibLintExtractor.class, (Action)new Action<TransformSpec<DesugarLibLintExtractor.Parameters>>(minSdkVersion2, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(TransformSpec<DesugarLibLintExtractor.Parameters> spec) {
                spec.parameters((Action)new Action<DesugarLibLintExtractor.Parameters>(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(DesugarLibLintExtractor.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.$minSdkVersion);
                        parameters.getCompileSdkVersion().set((Object)this.$compileSdkVersion);
                    }
                });
                spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
            }
        });
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration, int minSdkVersion2, int compileSdkVersion) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(minSdkVersion2, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.attributes((Action)new Action<AttributeContainer>(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                    }
                });
            }
        }).getArtifacts().getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"minSdkVersion: Int,\n    compileSdkVersion: Int\n): FileCollection {\n    return configuration.incoming.artifactView { configuration ->\n        configuration.attributes {\n            it.attribute(\n                ArtifactAttributes.ARTIFACT_FORMAT,\n                DESUGAR_LIB_LINT\n            )\n            it.attribute(ATTR_LINT_MIN_SDK, minSdkVersion.toString())\n            it.attribute(ATTR_LINT_COMPILE_SDK, compileSdkVersion.toString())\n        }\n    }.artifacts.artifactFiles");
        return fileCollection2;
    }

    public static final /* synthetic */ FileCollection access$getDesugarLibConfigFromTransform(Configuration configuration) {
        return DesugarLibUtils.getDesugarLibConfigFromTransform(configuration);
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_MIN_SDK$p() {
        return ATTR_LINT_MIN_SDK;
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_COMPILE_SDK$p() {
        return ATTR_LINT_COMPILE_SDK;
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"of(\"lint-min-sdk\", String::class.java)");
        ATTR_LINT_MIN_SDK = attribute;
        attribute = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"of(\"lint-compile-sdk\", String::class.java)");
        ATTR_LINT_COMPILE_SDK = attribute;
    }
}

