/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitivity;

public abstract class StreamBasedTask
extends AndroidVariantTask {
    protected Collection<TransformStream> consumedInputStreams;
    protected Collection<TransformStream> referencedInputStreams;
    protected IntermediateStream outputStream;

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getStreamOutputFolder();

    protected void registerConsumedAndReferencedStreamInputs() {
        Preconditions.checkNotNull(this.consumedInputStreams, (String)"Consumed input streams not set.", (Object[])new Object[0]);
        Preconditions.checkNotNull(this.referencedInputStreams, (String)"Referenced input streams not set.", (Object[])new Object[0]);
        for (TransformStream stream2 : Iterables.concat(this.consumedInputStreams, this.referencedInputStreams)) {
            this.getInputs().files(new Object[]{stream2.getAsFileTree()}).withPathSensitivity(PathSensitivity.ABSOLUTE);
        }
    }
}

