/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.Version;
import com.android.build.gradle.internal.StartParameterUtils;
import com.android.build.gradle.internal.attribution.BuildAttributionService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.ide.common.attribution.AndroidGradlePluginAttributionData;
import com.android.tools.analytics.HostData;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "initialGarbageCollectionData", "", "", "", "close", "", "onFinish", "p0", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class BuildAttributionService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Long> initialGarbageCollectionData;
    private static boolean initialized;

    /*
     * WARNING - void declaration
     */
    public BuildAttributionService() {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<GarbageCollectorMXBean> iterable = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"getGarbageCollectorMXBeans()");
        iterable = iterable;
        BuildAttributionService buildAttributionService = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getCollectionTime());
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        buildAttributionService.initialGarbageCollectionData = MapsKt.toMap((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        initialized = false;
        Object object = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"getGarbageCollectorMXBeans()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            long l = it.getCollectionTime();
            String string2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
            Pair pair = TuplesKt.to((Object)string, (Object)(l - ((Number)this.initialGarbageCollectionData.getOrDefault(string2, 0L)).longValue()));
            collection.add(pair);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).longValue() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map gcData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        File file = new File((String)((Parameters)this.getParameters()).getAttributionFileLocation().get());
        object = ((Parameters)this.getParameters()).getTaskNameToClassNameMap().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.taskNameToClassNameMap.get()");
        Map map = (Map)object;
        object = ((Parameters)this.getParameters()).getTasksSharingOutputs().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.tasksSharingOutputs.get()");
        Map map2 = (Map)object;
        object = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.javaClass.classLoader");
        Set<String> set = GradlePluginUtils.getBuildSrcPlugins((ClassLoader)object);
        object = ((Parameters)this.getParameters()).getJavaInfo().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.javaInfo.get()");
        AndroidGradlePluginAttributionData.JavaInfo javaInfo = (AndroidGradlePluginAttributionData.JavaInfo)object;
        object = ((Parameters)this.getParameters()).getBuildscriptDependenciesInfo().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.buildscriptDependenciesInfo.get()");
        BuildAttributionService.Companion.saveAttributionData(file, new AndroidGradlePluginAttributionData(map, null, map2, gcData, set, javaInfo, (Set)object, (AndroidGradlePluginAttributionData.BuildInfo)((Parameters)this.getParameters()).getBuildInfo().get(), 2, null));
    }

    public void onFinish(@Nullable FinishEvent p0) {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Companion;", "", "()V", "initialized", "", "getTaskClassName", "", "className", "init", "", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "listenersRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "saveAttributionData", "outputDir", "Ljava/io/File;", "attributionData", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final synchronized void init(@NotNull Project project2, @NotNull String attributionFileLocation, @NotNull BuildEventsListenerRegistry listenersRegistry) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)attributionFileLocation, (String)"attributionFileLocation");
            Intrinsics.checkParameterIsNotNull((Object)listenersRegistry, (String)"listenersRegistry");
            if (initialized) {
                return;
            }
            Object object = project2.getGradle().getSharedServices().getRegistrations().getByName(BuildServicesKt.getBuildServiceName(BuildAttributionService.class));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<com.android.build.gradle.internal.attribution.BuildAttributionService, com.android.build.gradle.internal.attribution.BuildAttributionService.Parameters>");
            }
            BuildServiceRegistration serviceRegistration = (BuildServiceRegistration)object;
            initialized = true;
            project2.getGradle().getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(project2, (BuildServiceRegistration<BuildAttributionService, Parameters>)serviceRegistration, attributionFileLocation, listenersRegistry){
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildServiceRegistration<BuildAttributionService, Parameters> $serviceRegistration;
                final /* synthetic */ String $attributionFileLocation;
                final /* synthetic */ BuildEventsListenerRegistry $listenersRegistry;
                {
                    this.$project = $project;
                    this.$serviceRegistration = $serviceRegistration;
                    this.$attributionFileLocation = $attributionFileLocation;
                    this.$listenersRegistry = $listenersRegistry;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(TaskExecutionGraph taskGraph) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Object object;
                    MapProperty<String, List<String>> mapProperty;
                    void $this$mapTo$iv$iv;
                    Map $this$map$iv;
                    Iterator<Map.Entry<K, V>> iterator2;
                    Object object2;
                    T element$iv2;
                    boolean bl = false;
                    Map outputFileToTasksMap = new LinkedHashMap<K, V>();
                    boolean bl2 = false;
                    Map taskNameToClassNameMap = new LinkedHashMap<K, V>();
                    List list = taskGraph.getAllTasks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskGraph.allTasks");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach22 = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        Task task = (Task)element$iv2;
                        boolean bl3 = false;
                        object2 = taskNameToClassNameMap;
                        String string = task.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.name");
                        iterator2 = task.getClass().getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"task.javaClass.name");
                        iterator2 = com.android.build.gradle.internal.attribution.BuildAttributionService$Companion.access$getTaskClassName(BuildAttributionService.Companion, (String)((Object)iterator2));
                        boolean bl4 = false;
                        object2.put(string, iterator2);
                        object2 = task.getOutputs().getFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"task.outputs.files");
                        Iterable $this$forEach$iv2 = (Iterable)object2;
                        boolean $i$f$forEach = false;
                        for (E element$iv3 : $this$forEach$iv2) {
                            File outputFile = (File)element$iv3;
                            boolean bl5 = false;
                            List list2 = (List)outputFileToTasksMap.computeIfAbsent(outputFile.getAbsolutePath(), init.1.1.1.INSTANCE);
                            String string2 = task.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.path");
                            list2.add(string2);
                        }
                    }
                    Object $i$f$forEach22 = this.$project.getRootProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$forEach22, (String)"project.rootProject");
                    $i$f$forEach22 = GradlePluginUtils.getBuildscriptDependencies($i$f$forEach22);
                    boolean $i$f$map = false;
                    element$iv2 = $this$map$iv;
                    Object destination$iv$iv = (MapProperty<String, List<String>>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        iterator2 = (ModuleComponentIdentifier)item$iv$iv;
                        mapProperty = destination$iv$iv;
                        boolean bl6 = false;
                        object = it.getGroup() + ':' + it.getModule() + ':' + it.getVersion();
                        mapProperty.add(object);
                    }
                    List buildscriptDependenciesInfo = (List)destination$iv$iv;
                    ((Parameters)this.$serviceRegistration.getParameters()).getAttributionFileLocation().set((Object)this.$attributionFileLocation);
                    ((Parameters)this.$serviceRegistration.getParameters()).getTaskNameToClassNameMap().set(taskNameToClassNameMap);
                    $this$map$iv = outputFileToTasksMap;
                    mapProperty = ((Parameters)this.$serviceRegistration.getParameters()).getTasksSharingOutputs();
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    object2 = $this$filterTo$iv$iv;
                    boolean bl7 = false;
                    iterator2 = object2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                        boolean bl8 = false;
                        if (!(((List)it.getValue()).size() > 1)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    object = destination$iv$iv;
                    mapProperty.set(object);
                    Property<AndroidGradlePluginAttributionData.JavaInfo> property = ((Parameters)this.$serviceRegistration.getParameters()).getJavaInfo();
                    StartParameter startParameter = this.$project.getProviders().systemProperty("java.version").forUseAtConfigurationTime().getOrElse((Object)"");
                    Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.providers.systemProperty(\"java.version\")\n                            .forUseAtConfigurationTime().getOrElse(\"\")");
                    String string = (String)startParameter;
                    startParameter = this.$project.getProviders().systemProperty("java.vendor").forUseAtConfigurationTime().getOrElse((Object)"");
                    Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.providers.systemProperty(\"java.vendor\")\n                            .forUseAtConfigurationTime().getOrElse(\"\")");
                    String string3 = (String)startParameter;
                    startParameter = this.$project.getProviders().systemProperty("java.home").forUseAtConfigurationTime().getOrElse((Object)"");
                    Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.providers.systemProperty(\"java.home\")\n                            .forUseAtConfigurationTime().getOrElse(\"\")");
                    String string4 = (String)startParameter;
                    RuntimeMXBean runtimeMXBean = HostData.INSTANCE.getRuntimeBean();
                    startParameter = runtimeMXBean == null ? null : runtimeMXBean.getInputArguments();
                    property.set((Object)new AndroidGradlePluginAttributionData.JavaInfo(string, string3, string4, startParameter == null ? CollectionsKt.emptyList() : startParameter));
                    ((Parameters)this.$serviceRegistration.getParameters()).getBuildscriptDependenciesInfo().set((Iterable)buildscriptDependenciesInfo);
                    Property<AndroidGradlePluginAttributionData.BuildInfo> property2 = ((Parameters)this.$serviceRegistration.getParameters()).getBuildInfo();
                    startParameter = this.$project.getGradle().getStartParameter();
                    Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
                    property2.set((Object)new AndroidGradlePluginAttributionData.BuildInfo(Version.ANDROID_GRADLE_PLUGIN_VERSION, StartParameterUtils.isConfigurationCache(startParameter)));
                    this.$listenersRegistry.onTaskCompletion(this.$serviceRegistration.getService());
                }
            });
        }

        private final void saveAttributionData(File outputDir, AndroidGradlePluginAttributionData attributionData) {
            File file = AndroidGradlePluginAttributionData.Companion.getAttributionFile(outputDir);
            file.getParentFile().mkdirs();
            SynchronizedFile.getInstanceWithMultiProcessLocking((File)file).write((ExceptionFunction)new ExceptionFunction<File, Unit>(file, attributionData){
                final /* synthetic */ File $file;
                final /* synthetic */ AndroidGradlePluginAttributionData $attributionData;
                {
                    this.$file = $file;
                    this.$attributionData = $attributionData;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void accept(File it) {
                    Closeable closeable = new BufferedWriter(new FileWriter(this.$file));
                    AndroidGradlePluginAttributionData androidGradlePluginAttributionData = this.$attributionData;
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedWriter it2 = (BufferedWriter)closeable;
                        boolean bl3 = false;
                        it2.write(AndroidGradlePluginAttributionData.AttributionDataAdapter.INSTANCE.toJson((Object)androidGradlePluginAttributionData));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            });
        }

        private final String getTaskClassName(String className) {
            if (StringsKt.endsWith$default((String)className, (String)"_Decorated", (boolean)false, (int)2, null)) {
                String string = className;
                int n = 0;
                int n2 = className.length() - "_Decorated".length();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return className;
        }

        public static final /* synthetic */ String access$getTaskClassName(Companion $this, String className) {
            return $this.getTaskClassName(className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00160\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "attributionFileLocation", "Lorg/gradle/api/provider/Property;", "", "getAttributionFileLocation", "()Lorg/gradle/api/provider/Property;", "buildInfo", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData$BuildInfo;", "getBuildInfo", "buildscriptDependenciesInfo", "Lorg/gradle/api/provider/SetProperty;", "getBuildscriptDependenciesInfo", "()Lorg/gradle/api/provider/SetProperty;", "javaInfo", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData$JavaInfo;", "getJavaInfo", "taskNameToClassNameMap", "Lorg/gradle/api/provider/MapProperty;", "getTaskNameToClassNameMap", "()Lorg/gradle/api/provider/MapProperty;", "tasksSharingOutputs", "", "getTasksSharingOutputs", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getAttributionFileLocation();

        @NotNull
        public MapProperty<String, List<String>> getTasksSharingOutputs();

        @NotNull
        public MapProperty<String, String> getTaskNameToClassNameMap();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.JavaInfo> getJavaInfo();

        @NotNull
        public SetProperty<String> getBuildscriptDependenciesInfo();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.BuildInfo> getBuildInfo();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<BuildAttributionService, Parameters> {
        public RegistrationAction(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, BuildAttributionService.class, null, 4, null);
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        }
    }
}

