/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.ide.common.attribution.CheckJetifierResult;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\b\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "aggregatedResult", "Lcom/android/ide/common/attribution/CheckJetifierResult;", "addResult", "", "result", "close", "writeResult", "resultFile", "Ljava/io/File;", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class CheckJetifierBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @Nullable
    private CheckJetifierResult aggregatedResult;

    public final synchronized void addResult(@NotNull CheckJetifierResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (((Parameters)this.getParameters()).getResultFile().isPresent()) {
            CheckJetifierResult checkJetifierResult;
            if (this.aggregatedResult != null) {
                CheckJetifierResult checkJetifierResult2 = this.aggregatedResult;
                if (checkJetifierResult2 == null) {
                    Intrinsics.throwNpe();
                }
                checkJetifierResult = CheckJetifierResult.Companion.aggregateResults(checkJetifierResult2, result2);
            } else {
                checkJetifierResult = result2;
            }
            this.aggregatedResult = checkJetifierResult;
        }
    }

    @Override
    public void close() {
        RegularFile regularFile = (RegularFile)((Parameters)this.getParameters()).getResultFile().getOrNull();
        if (regularFile != null) {
            RegularFile regularFile2 = regularFile;
            boolean bl = false;
            boolean bl2 = false;
            RegularFile it = regularFile2;
            boolean bl3 = false;
            if (this.aggregatedResult != null) {
                Object object = this.aggregatedResult;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                CheckJetifierResult checkJetifierResult = object;
                object = it.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.asFile");
                this.writeResult(checkJetifierResult, (File)object);
            }
        }
    }

    private final void writeResult(CheckJetifierResult result2, File resultFile) {
        SynchronizedFile.getInstanceWithSingleProcessLocking((File)resultFile).write((ExceptionFunction)new ExceptionFunction<File, Unit>(result2, resultFile){
            final /* synthetic */ CheckJetifierResult $result;
            final /* synthetic */ File $resultFile;
            {
                this.$result = $result;
                this.$resultFile = $resultFile;
            }

            public final void accept(File it) {
                if (it.exists()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    CheckJetifierResult existingResult = CheckJetifierResult.Companion.load(it);
                    CheckJetifierResult combinedResult = CheckJetifierResult.Companion.aggregateResults(existingResult, this.$result);
                    CheckJetifierResult.Companion.save(combinedResult, it);
                } else {
                    FileUtils.mkdirs((File)this.$resultFile.getParentFile());
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    CheckJetifierResult.Companion.save(this.$result, it);
                }
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "resultFile", "Lorg/gradle/api/file/RegularFileProperty;", "getResultFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getResultFile();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "configure", "", "parameters", "execute", "Lorg/gradle/api/provider/Provider;", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<CheckJetifierBuildService, Parameters> {
        @NotNull
        private final ProjectOptions projectOptions;

        public RegistrationAction(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            super(project2, CheckJetifierBuildService.class, null, 4, null);
            this.projectOptions = projectOptions;
        }

        @Override
        @NotNull
        public Provider<CheckJetifierBuildService> execute() {
            String resultFilePath = this.projectOptions.get(StringOption.IDE_CHECK_JETIFIER_RESULT_FILE);
            if (resultFilePath != null) {
                File resultFile = new File(resultFilePath);
                boolean bl = resultFile.isAbsolute();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = StringOption.IDE_CHECK_JETIFIER_RESULT_FILE.getPropertyName() + " must be an absolute path. Current value is: " + resultFilePath;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                FileUtils.deleteIfExists((File)resultFile);
            }
            return super.execute();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull Parameters parameters) {
            File file;
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            RegularFileProperty regularFileProperty = parameters.getResultFile();
            String string = this.projectOptions.get(StringOption.IDE_CHECK_JETIFIER_RESULT_FILE);
            if (string == null) {
                file = null;
            } else {
                void it;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String string3 = string2;
                RegularFileProperty regularFileProperty2 = regularFileProperty;
                boolean bl3 = false;
                File file2 = new File((String)it);
                regularFileProperty = regularFileProperty2;
                file = file2;
            }
            regularFileProperty.fileValue(file);
        }
    }
}

