/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.attribution.AttributionStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.attribution.BuildAttributionUtilsKt;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttributions;
import com.android.build.gradle.internal.cxx.build.CxxBuilder;
import com.android.build.gradle.internal.cxx.build.CxxRegularBuilder;
import com.android.build.gradle.internal.cxx.build.CxxRegularBuilderKt;
import com.android.build.gradle.internal.cxx.caching.CxxBuildCache;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsConfiguration;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsFactoryKt;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.protobuf.GeneratedMessageV3;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.internal.hash.FileHasher;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u0000 12\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J&\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0006H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00062\u0006\u0010-\u001a\u00020\rH\u0002J\u0016\u0010.\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062\u00b2\u0006\u0012\u00103\u001a\n 5*\u0004\u0018\u00010404X\u008a\u0084\u0002"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder;", "Lcom/android/build/gradle/internal/cxx/build/CxxBuilder;", "configurationModel", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "(Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;)V", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getAbis", "()Ljava/util/List;", "getConfigurationModel", "()Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "nativeBuildConfigValueMinis", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "getNativeBuildConfigValueMinis", "objFolder", "Ljava/io/File;", "getObjFolder", "()Ljava/io/File;", "soFolder", "getSoFolder", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "applyBuildSettings", "", "buildSettings", "Lcom/android/build/gradle/internal/cxx/settings/BuildSettingsConfiguration;", "processBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "build", "ops", "Lorg/gradle/process/ExecOperations;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "buildCacheController", "Lorg/gradle/caching/internal/controller/BuildCacheController;", "executeProcessBatch", "buildCache", "Lcom/android/build/gradle/internal/cxx/caching/CxxBuildCache;", "buildSteps", "Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "findLibrariesToBuild", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "config", "verifyTargetsExist", "miniConfigs", "BuildStep", "Companion", "gradle-core", "attributions", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions;", "kotlin.jvm.PlatformType"})
public final class CxxRegularBuilder
implements CxxBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxxConfigurationModel configurationModel;
    @NotNull
    public static final String BUILD_TARGETS_PLACEHOLDER = "{LIST_OF_TARGETS_TO_BUILD}";

    public CxxRegularBuilder(@NotNull CxxConfigurationModel configurationModel) {
        Intrinsics.checkParameterIsNotNull((Object)configurationModel, (String)"configurationModel");
        this.configurationModel = configurationModel;
    }

    @NotNull
    public final CxxConfigurationModel getConfigurationModel() {
        return this.configurationModel;
    }

    @Override
    @NotNull
    public File getObjFolder() {
        return CxxAbiModelKt.getObjFolder((CxxAbiModel)CollectionsKt.first(this.configurationModel.getActiveAbis()));
    }

    @Override
    @NotNull
    public File getSoFolder() {
        return ((CxxAbiModel)CollectionsKt.first(this.configurationModel.getActiveAbis())).getSoFolder();
    }

    private final CxxVariantModel getVariant() {
        return this.configurationModel.getVariant();
    }

    private final List<CxxAbiModel> getAbis() {
        return this.configurationModel.getActiveAbis();
    }

    private final List<NativeBuildConfigValueMini> getNativeBuildConfigValueMinis() {
        List<NativeBuildConfigValueMini> list = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(this.getAbis(), null);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"getNativeBuildMiniConfigs(abis, null)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void build(@NotNull ExecOperations ops2, @NotNull FileHasher fileHasher, @NotNull BuildCacheController buildCacheController) {
        Object abi;
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        Intrinsics.checkParameterIsNotNull((Object)fileHasher, (String)"fileHasher");
        Intrinsics.checkParameterIsNotNull((Object)buildCacheController, (String)"buildCacheController");
        LoggingEnvironmentKt.infoln("starting build", new Object[0]);
        LoggingEnvironmentKt.infoln("reading expected JSONs", new Object[0]);
        List<NativeBuildConfigValueMini> miniConfigs = this.getNativeBuildConfigValueMinis();
        LoggingEnvironmentKt.infoln("done reading expected JSONs", new Object[0]);
        Set<String> targets = this.getVariant().getBuildTargetSet();
        if (targets.isEmpty()) {
            LoggingEnvironmentKt.infoln("executing build commands for targets that produce .so files or executables", new Object[0]);
        } else {
            this.verifyTargetsExist(miniConfigs);
        }
        CxxBuildCache buildCache = new CxxBuildCache(buildCacheController, fileHasher);
        ArrayList buildSteps = Lists.newArrayList();
        int n = 0;
        int n2 = miniConfigs.size() + -1;
        if (n <= n2) {
            do {
                List<String> $this$mapNotNullTo$iv$iv;
                Boolean bl;
                void $this$single$iv;
                int miniConfigIndex = n++;
                NativeBuildConfigValueMini config2 = miniConfigs.get(miniConfigIndex);
                LoggingEnvironmentKt.infoln("evaluate miniconfig", new Object[0]);
                if (config2.libraries.isEmpty()) {
                    LoggingEnvironmentKt.infoln("no libraries", new Object[0]);
                    continue;
                }
                Iterable iterable = CollectionsKt.plus((Collection)this.configurationModel.getActiveAbis(), (Iterable)this.configurationModel.getUnusedAbis());
                boolean $i$f$single22 = false;
                Iterable<Object> single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    CxxAbiModel it = (CxxAbiModel)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getAbi().getTag(), (Object)((NativeLibraryValueMini)CollectionsKt.first((Iterable)((Iterable)config2.libraries.values()))).abi)) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                abi = (CxxAbiModel)((Object)single$iv);
                List<NativeLibraryValueMini> librariesToBuild22 = this.findLibrariesToBuild(config2);
                if (librariesToBuild22.isEmpty()) {
                    LoggingEnvironmentKt.infoln("no libraries to build", new Object[0]);
                    continue;
                }
                List<String> $i$f$single22 = config2.buildTargetsCommandComponents;
                if ($i$f$single22 == null) {
                    bl = null;
                } else {
                    single$iv = $i$f$single22;
                    found$iv = false;
                    bl = !single$iv.isEmpty();
                }
                if (Intrinsics.areEqual(bl, (Object)true)) {
                    void $this$mapNotNull$iv;
                    single$iv = librariesToBuild22;
                    boolean $i$f$mapNotNull22 = false;
                    Iterator iterator2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        String string;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                        boolean bl3 = false;
                        NativeLibraryValueMini library = (NativeLibraryValueMini)element$iv$iv;
                        boolean bl4 = false;
                        if (library.artifactName == null) continue;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        String it$iv$iv = string;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List artifactNames = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                    $this$mapNotNullTo$iv$iv = config2.buildTargetsCommandComponents;
                    if ($this$mapNotNullTo$iv$iv == null) {
                        Intrinsics.throwNpe();
                    }
                    Object $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv;
                    List buildTargetsCommand = CxxRegularBuilder.Companion.substituteBuildTargetsCommand($i$f$mapNotNull22, artifactNames);
                    Set<String> set = this.getVariant().getBuildTargetSet();
                    $i$f$mapNotNull22 = CxxAbiModelKt.getJsonFile(this.getAbis().get(miniConfigIndex)).getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$mapNotNull22, (String)"abis[miniConfigIndex].jsonFile.parentFile");
                    buildSteps.add(new BuildStep((CxxAbiModel)abi, buildTargetsCommand, librariesToBuild22, set, (File)$i$f$mapNotNull22));
                    LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"about to build targets ", (Object)CollectionsKt.joinToString$default((Iterable)artifactNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
                    continue;
                }
                for (NativeLibraryValueMini libraryValue : librariesToBuild22) {
                    List<String> $i$f$mapNotNull22;
                    $this$mapNotNullTo$iv$iv = libraryValue.buildCommandComponents;
                    if ($this$mapNotNullTo$iv$iv == null) {
                        Intrinsics.throwNpe();
                    }
                    List<String> list = $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv;
                    List list2 = CollectionsKt.listOf((Object)libraryValue);
                    Set<String> set = this.getVariant().getBuildTargetSet();
                    $i$f$mapNotNull22 = CxxAbiModelKt.getJsonFile(this.getAbis().get(miniConfigIndex)).getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$mapNotNull22, (String)"abis[miniConfigIndex].jsonFile.parentFile");
                    buildSteps.add(new BuildStep((CxxAbiModel)abi, list, list2, set, (File)((Object)$i$f$mapNotNull22)));
                    $this$mapNotNullTo$iv$iv = libraryValue.buildCommandComponents;
                    if ($this$mapNotNullTo$iv$iv == null) {
                        Intrinsics.throwNpe();
                    }
                    $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv;
                    LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"about to build ", (Object)CollectionsKt.joinToString$default((Iterable)$i$f$mapNotNull22, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
                }
            } while (n <= n2);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)buildSteps, (String)"buildSteps");
        this.executeProcessBatch(buildCache, ops2, buildSteps);
        LoggingEnvironmentKt.infoln("check expected build outputs", new Object[0]);
        for (NativeBuildConfigValueMini config3 : miniConfigs) {
            for (NativeLibraryValueMini library : config3.libraries.values()) {
                Object object;
                Object artifactNames;
                Preconditions.checkState((!Strings.isNullOrEmpty((String)library.artifactName) ? 1 : 0) != 0);
                abi = targets;
                boolean librariesToBuild22 = false;
                if (!abi.isEmpty() && !CollectionsKt.contains((Iterable)targets, (Object)library.artifactName) || buildSteps.stream().noneMatch((Predicate)new Predicate<BuildStep>(library){
                    final /* synthetic */ NativeLibraryValueMini $library;
                    {
                        this.$library = $library;
                    }

                    public final boolean test(BuildStep step) {
                        return step.getLibraries().contains(this.$library);
                    }
                }) || (artifactNames = library.output) == null) continue;
                Object librariesToBuild22 = artifactNames;
                File output2 = librariesToBuild22;
                if (!output2.exists()) {
                    throw new GradleException("Expected output file at " + output2 + " for target " + library.artifactName + " but there was none");
                }
                if (library.abi == null) {
                    throw new GradleException("Expected NativeLibraryValue to have non-null abi");
                }
                String $i$f$mapNotNull22 = library.abi;
                if ($i$f$mapNotNull22 == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = Abi.getByName($i$f$mapNotNull22)) == null) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Unknown ABI seen ", (Object)library.abi));
                }
                Object abi2 = artifactNames = object;
                object = new String[]{((Abi)((Object)abi2)).getTag(), output2.getName()};
                File expectedOutputFile = FileUtils.join((File)this.getVariant().getSoFolder(), (String[])object);
                if (!FileUtils.isSameFile((File)output2, (File)expectedOutputFile)) {
                    LoggingEnvironmentKt.infoln("external build set its own library output location for '" + output2.getName() + "', hard link or copy to expected location", new Object[0]);
                    if (expectedOutputFile.getParentFile().mkdirs()) {
                        LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"created folder ", (Object)expectedOutputFile.getParentFile()), new Object[0]);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)expectedOutputFile, (String)"expectedOutputFile");
                    CxxRegularBuilderKt.hardLinkOrCopy(output2, expectedOutputFile);
                }
                object = library.runtimeFiles.iterator();
                while (object.hasNext()) {
                    File runtimeFile = (File)object.next();
                    String[] stringArray = new String[]{((Abi)((Object)abi2)).getTag(), runtimeFile.getName()};
                    File dest = FileUtils.join((File)this.getVariant().getSoFolder(), (String[])stringArray);
                    Intrinsics.checkExpressionValueIsNotNull((Object)runtimeFile, (String)"runtimeFile");
                    Intrinsics.checkExpressionValueIsNotNull((Object)dest, (String)"dest");
                    CxxRegularBuilderKt.hardLinkOrCopy(runtimeFile, dest);
                }
            }
        }
        for (CxxAbiModel abi3 : this.getAbis()) {
            if (abi3.getStlLibraryFile() == null || !abi3.getStlLibraryFile().isFile()) continue;
            if (!abi3.getSoFolder().isDirectory()) {
                LoggingEnvironmentKt.infoln("didn't copy STL file to " + abi3.getSoFolder() + " because that folder wasn't created by the build ", new Object[0]);
                continue;
            }
            File file = abi3.getSoFolder();
            String string = abi3.getStlLibraryFile().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.stlLibraryFile.name");
            File objAbi = FilesKt.resolve((File)file, (String)string);
            CxxRegularBuilderKt.hardLinkOrCopy(abi3.getStlLibraryFile(), objAbi);
        }
        LoggingEnvironmentKt.infoln("build complete", new Object[0]);
    }

    private final void verifyTargetsExist(List<? extends NativeBuildConfigValueMini> miniConfigs) {
        Set<String> targets = this.getVariant().getBuildTargetSet();
        LoggingEnvironmentKt.infoln("executing build commands for targets: '" + Joiner.on((String)", ").join((Iterable)targets) + '\'', new Object[0]);
        HashSet matchingTargets = Sets.newHashSet();
        HashSet unmatchedTargets = Sets.newHashSet();
        for (NativeBuildConfigValueMini nativeBuildConfigValueMini : miniConfigs) {
            for (NativeLibraryValueMini libraryValue : nativeBuildConfigValueMini.libraries.values()) {
                if (CollectionsKt.contains((Iterable)targets, (Object)libraryValue.artifactName)) {
                    matchingTargets.add(libraryValue.artifactName);
                    continue;
                }
                unmatchedTargets.add(libraryValue.artifactName);
            }
        }
        for (String string : targets) {
            if (matchingTargets.contains(string)) continue;
            throw new GradleException("Unexpected native build target " + string + ". Valid values are: " + Joiner.on((String)", ").join((Iterable)unmatchedTargets));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<NativeLibraryValueMini> findLibrariesToBuild(NativeBuildConfigValueMini config) {
        librariesToBuild = Lists.newArrayList();
        targets = this.getVariant().getBuildTargetSet();
        implicitTargets = CollectionsKt.toMutableSet((Iterable)this.getVariant().getImplicitBuildTargetSet());
        block10: for (NativeLibraryValueMini libraryValue : config.libraries.values()) {
            block27: {
                block28: {
                    LoggingEnvironmentKt.infoln("evaluate library " + libraryValue.artifactName + " (" + libraryValue.abi + ')', new Object[0]);
                    var7_8 = (List<String>)targets;
                    var8_10 = false;
                    if (var7_8.isEmpty() == false && !CollectionsKt.contains((Iterable)targets, (Object)libraryValue.artifactName)) {
                        v0 = new StringBuilder().append("not building target ");
                        var7_8 = libraryValue.artifactName;
                        if (var7_8 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v0.append((String)var7_8).append(" because it isn't in targets set").toString(), new Object[0]);
                        continue;
                    }
                    var7_8 = config.buildTargetsCommandComponents;
                    if (!Intrinsics.areEqual((Object)(var7_8 == null ? null : Boolean.valueOf(var7_8.isEmpty())), (Object)false) && !Intrinsics.areEqual((Object)((var7_8 = libraryValue.buildCommandComponents) == null ? null : Boolean.valueOf(var7_8.isEmpty())), (Object)false)) {
                        v1 = new StringBuilder().append("not building target ");
                        var7_8 = libraryValue.artifactName;
                        if (var7_8 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v1.append((String)var7_8).append(" because there was no buildCommandComponents for the target, nor a buildTargetsCommandComponents for the config").toString(), new Object[0]);
                        continue;
                    }
                    if (!targets.isEmpty()) break block27;
                    output = libraryValue.output;
                    if (output == null) {
                        v2 = new StringBuilder().append("not building target ");
                        var8_11 = libraryValue.artifactName;
                        if (var8_11 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v2.append(var8_11).append(" because no targets are specified and library build output file is null").toString(), new Object[0]);
                        continue;
                    }
                    if (!CollectionsKt.contains((Iterable)this.getVariant().getImplicitBuildTargetSet(), (Object)libraryValue.artifactName)) break block28;
                    LoggingEnvironmentKt.infoln("building target " + libraryValue.artifactName + " because it is required by the build", new Object[0]);
                    break block27;
                }
                var8_12 = Files.getFileExtension((String)output.getName());
                if (var8_12 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var8_12.hashCode()) {
                    case 0: {
                        if (var8_12.equals("")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 97: {
                        if (var8_12.equals("a")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3676: {
                        if (var8_12.equals("so")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        v3 = new StringBuilder().append("not building target library ");
                        var9_14 = libraryValue.artifactName;
                        if (var9_14 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v3.append(var9_14).append(" because static libraries are not build by default.").toString(), new Object[0]);
                        continue block10;
                    }
                    case 3: {
                        v4 = new StringBuilder().append("building target library ");
                        var9_14 = libraryValue.artifactName;
                        if (var9_14 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v4.append(var9_14).append(" because no targets are specified.").toString(), new Object[0]);
                        break;
                    }
                    case 1: {
                        v5 = new StringBuilder().append("building target executable ");
                        var9_14 = libraryValue.artifactName;
                        if (var9_14 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v5.append(var9_14).append(" because no targets are specified.").toString(), new Object[0]);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v6 = new StringBuilder().append("not building target ");
                        var9_14 = libraryValue.artifactName;
                        if (var9_14 == null) {
                            Intrinsics.throwNpe();
                        }
                        LoggingEnvironmentKt.infoln(v6.append(var9_14).append(" because the type cannot be determined.").toString(), new Object[0]);
                        continue block10;
                    }
                }
            }
            librariesToBuild.add(libraryValue);
        }
        var5_5 = implicitTargets;
        Intrinsics.checkExpressionValueIsNotNull((Object)librariesToBuild, (String)"librariesToBuild");
        $this$map$iv = librariesToBuild;
        $i$f$map = false;
        var8_13 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_18 = (NativeLibraryValueMini)item$iv$iv;
            var15_20 = destination$iv$iv;
            $i$a$-map-CxxRegularBuilder$findLibrariesToBuild$1 = false;
            var16_21 = it.artifactName;
            var15_20.add(var16_21);
        }
        var6_6 = (List)destination$iv$iv;
        var7_9 = false;
        v7 = var5_5;
        if (v7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)v7).removeAll(var6_6);
        var5_5 = implicitTargets;
        var6_7 = false;
        if (var5_5.isEmpty() == false) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.REQUIRED_BUILD_TARGETS_MISSING, Intrinsics.stringPlus((String)"did not find implicitly required targets: ", (Object)CollectionsKt.joinToString$default((Iterable)implicitTargets, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
        }
        return librariesToBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessBatch(CxxBuildCache buildCache, ExecOperations ops2, List<BuildStep> buildSteps) {
        for (BuildStep buildStep : buildSteps) {
            int n;
            List<String> tokens = buildStep.getBuildCommandComponents();
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable(tokens.get(0));
            int n2 = 1;
            int n3 = tokens.size();
            if (n2 < n3) {
                do {
                    int i2 = n2++;
                    processBuilder.addArgs(tokens.get(i2));
                } while (n2 < n3);
            }
            LoggingEnvironmentKt.infoln(String.valueOf(processBuilder), new Object[0]);
            String logFileSuffix = null;
            String abiName = buildStep.getLibraries().get((int)0).abi;
            CxxAbiModel abi = buildStep.getAbi();
            if (buildStep.getLibraries().size() > 1) {
                logFileSuffix = "targets";
                Stream stream2 = buildStep.getLibraries().stream().map(executeProcessBatch.targetNames.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"buildStep\n                    .libraries\n                    .stream()\n                    .map { library -> library.artifactName + \"_\" + library.abi }");
                List targetNames2 = StreamsKt.toList(stream2);
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Build multiple targets ", (Object)CollectionsKt.joinToString$default((Iterable)targetNames2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
            } else {
                Preconditions.checkElementIndex((int)0, (int)buildStep.getLibraries().size());
                logFileSuffix = buildStep.getLibraries().get((int)0).artifactName + '_' + abiName;
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Build ", (Object)logFileSuffix), new Object[0]);
            }
            this.applyBuildSettings(abi.getBuildSettings(), processBuilder);
            long buildStartTime = Clock.systemUTC().millis();
            if (CxxAbiModelKt.getNinjaLogFile(abi).isFile()) {
                File $this$useLines$iv = CxxAbiModelKt.getNinjaLogFile(abi);
                Charset charset$iv = Charsets.UTF_8;
                boolean $i$f$useLines = false;
                Object object = $this$useLines$iv;
                int n4 = 8192;
                boolean bl = false;
                Object object2 = object;
                boolean bl2 = false;
                Object object3 = object2;
                boolean bl3 = false;
                object3 = new FileInputStream((File)object3);
                bl3 = false;
                object2 = new InputStreamReader((InputStream)object3, charset$iv);
                bl2 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n4);
                n4 = 0;
                bl = false;
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl4 = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl5 = false;
                    int n5 = SequencesKt.count((Sequence)it);
                    n = n5;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                n = 0;
            }
            int linesToSkip = n;
            buildCache.cacheBuild(abi, buildStep.getTargetsFromDsl(), (Function0<Unit>)((Function0)new Function0<Unit>(buildStep, logFileSuffix, processBuilder, abi, ops2){
                final /* synthetic */ BuildStep $buildStep;
                final /* synthetic */ String $logFileSuffix;
                final /* synthetic */ ProcessInfoBuilder $processBuilder;
                final /* synthetic */ CxxAbiModel $abi;
                final /* synthetic */ ExecOperations $ops;
                {
                    this.$buildStep = $buildStep;
                    this.$logFileSuffix = $logFileSuffix;
                    this.$processBuilder = $processBuilder;
                    this.$abi = $abi;
                    this.$ops = $ops;
                    super(0);
                }

                public final void invoke() {
                    Boolean bl;
                    ProcessOutputJunctionKt.createProcessOutputJunction(FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_command_" + this.$logFileSuffix + ".txt")), FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_stdout_" + this.$logFileSuffix + ".txt")), FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_stderr_" + this.$logFileSuffix + ".txt")), this.$processBuilder, "").logStderr().logStdout().logFullStdout((bl = (Boolean)CxxAbiModelKt.ifLogNativeBuildToLifecycle(this.$abi, executeProcessBatch.1.INSTANCE)) == null ? false : bl).execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super ExecSpec>, ExecResult>(this.$ops){

                        public final ExecResult invoke(Action<? super ExecSpec> p0) {
                            return ((ExecOperations)this.receiver).exec(p0);
                        }

                        @NotNull
                        public final String getSignature() {
                            return "exec(Lorg/gradle/api/Action;)Lorg/gradle/process/ExecResult;";
                        }

                        @NotNull
                        public final String getName() {
                            return "exec";
                        }

                        @NotNull
                        public final KDeclarationContainer getOwner() {
                            return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExecOperations.class);
                        }
                    }));
                }
            }));
            CxxAbiModelKt.ifCMake(abi, (Function0)new Function0<Unit>(abi, linesToSkip, buildStartTime, buildStep){
                final /* synthetic */ CxxAbiModel $abi;
                final /* synthetic */ int $linesToSkip;
                final /* synthetic */ long $buildStartTime;
                final /* synthetic */ BuildStep $buildStep;
                {
                    this.$abi = $abi;
                    this.$linesToSkip = $linesToSkip;
                    this.$buildStartTime = $buildStartTime;
                    this.$buildStep = $buildStep;
                    super(0);
                }

                public final void invoke() {
                    Lazy attributions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildTaskAttributions>(this.$abi, this.$linesToSkip, this.$buildStartTime, this.$buildStep){
                        final /* synthetic */ CxxAbiModel $abi;
                        final /* synthetic */ int $linesToSkip;
                        final /* synthetic */ long $buildStartTime;
                        final /* synthetic */ BuildStep $buildStep;
                        {
                            this.$abi = $abi;
                            this.$linesToSkip = $linesToSkip;
                            this.$buildStartTime = $buildStartTime;
                            this.$buildStep = $buildStep;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final BuildTaskAttributions invoke() {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = this.$buildStep.getLibraries();
                            BuildTaskAttributions.Builder builder = BuildAttributionUtilsKt.generateNinjaSourceFileAttribution(this.$abi, this.$linesToSkip, this.$buildStartTime).toBuilder();
                            boolean $i$f$map = false;
                            void var3_4 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                NativeLibraryValueMini nativeLibraryValueMini = (NativeLibraryValueMini)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                String string = it.artifactName;
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            return builder.addAllLibrary((Iterable<String>)collection).build();
                        }
                    }));
                    File file = this.$abi.getVariant().getModule().getProject().getChromeTraceJsonFolder();
                    if (file != null) {
                        File file2 = file;
                        CxxAbiModel cxxAbiModel = this.$abi;
                        long l = this.$buildStartTime;
                        boolean bl = false;
                        boolean bl2 = false;
                        File traceFolder = file2;
                        boolean bl3 = false;
                        BuildTaskAttributions buildTaskAttributions = executeProcessBatch.2.invoke$lambda-0((Lazy<BuildTaskAttributions>)attributions$delegate);
                        Intrinsics.checkExpressionValueIsNotNull((Object)buildTaskAttributions, (String)"attributions");
                        BuildAttributionUtilsKt.generateChromeTrace(buildTaskAttributions, cxxAbiModel, l, traceFolder);
                    }
                    LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>((Lazy<BuildTaskAttributions>)attributions$delegate){
                        final /* synthetic */ Lazy<BuildTaskAttributions> $attributions$delegate;
                        {
                            this.$attributions$delegate = $attributions$delegate;
                            super(1);
                        }

                        @NotNull
                        public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
                            BuildTaskAttributions buildTaskAttributions = executeProcessBatch.2.access$invoke$lambda-0(this.$attributions$delegate);
                            Intrinsics.checkExpressionValueIsNotNull((Object)buildTaskAttributions, (String)"attributions");
                            return AttributionStructuredLogCodecKt.encode(buildTaskAttributions, encoder);
                        }
                    }));
                }

                private static final BuildTaskAttributions invoke$lambda-0(Lazy<BuildTaskAttributions> $attributions$delegate) {
                    Lazy<BuildTaskAttributions> lazy = $attributions$delegate;
                    Object var2_2 = null;
                    boolean bl = false;
                    return (BuildTaskAttributions)lazy.getValue();
                }

                public static final /* synthetic */ BuildTaskAttributions access$invoke$lambda-0(Lazy $attributions$delegate) {
                    return executeProcessBatch.2.invoke$lambda-0((Lazy<BuildTaskAttributions>)$attributions$delegate);
                }

                static {
                }
            });
        }
    }

    private final void applyBuildSettings(BuildSettingsConfiguration buildSettings, ProcessInfoBuilder processBuilder) {
        processBuilder.addEnvironments(BuildSettingsFactoryKt.getEnvironmentVariableMap(buildSettings));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "buildCommandComponents", "", "", "libraries", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "targetsFromDsl", "", "outputFolder", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Ljava/util/List;Ljava/util/List;Ljava/util/Set;Ljava/io/File;)V", "getAbi", "()Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getBuildCommandComponents", "()Ljava/util/List;", "getLibraries", "getOutputFolder", "()Ljava/io/File;", "getTargetsFromDsl", "()Ljava/util/Set;", "gradle-core"})
    private static final class BuildStep {
        @NotNull
        private final CxxAbiModel abi;
        @NotNull
        private final List<String> buildCommandComponents;
        @NotNull
        private final List<NativeLibraryValueMini> libraries;
        @NotNull
        private final Set<String> targetsFromDsl;
        @NotNull
        private final File outputFolder;

        public BuildStep(@NotNull CxxAbiModel abi, @NotNull List<String> buildCommandComponents, @NotNull List<? extends NativeLibraryValueMini> libraries, @NotNull Set<String> targetsFromDsl, @NotNull File outputFolder) {
            Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
            Intrinsics.checkParameterIsNotNull(buildCommandComponents, (String)"buildCommandComponents");
            Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
            Intrinsics.checkParameterIsNotNull(targetsFromDsl, (String)"targetsFromDsl");
            Intrinsics.checkParameterIsNotNull((Object)outputFolder, (String)"outputFolder");
            this.abi = abi;
            this.buildCommandComponents = buildCommandComponents;
            this.libraries = libraries;
            this.targetsFromDsl = targetsFromDsl;
            this.outputFolder = outputFolder;
        }

        @NotNull
        public final CxxAbiModel getAbi() {
            return this.abi;
        }

        @NotNull
        public final List<String> getBuildCommandComponents() {
            return this.buildCommandComponents;
        }

        @NotNull
        public final List<NativeLibraryValueMini> getLibraries() {
            return this.libraries;
        }

        @NotNull
        public final Set<String> getTargetsFromDsl() {
            return this.targetsFromDsl;
        }

        @NotNull
        public final File getOutputFolder() {
            return this.outputFolder;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$Companion;", "", "()V", "BUILD_TARGETS_PLACEHOLDER", "", "substituteBuildTargetsCommand", "", "buildTargetsCommandComponents", "artifactNames", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> substituteBuildTargetsCommand(List<String> buildTargetsCommandComponents, List<String> artifactNames) {
            List list;
            Collection collection;
            block8: {
                void $this$takeLastWhile$iv;
                if (!buildTargetsCommandComponents.contains(CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) {
                    return buildTargetsCommandComponents;
                }
                List<String> $this$takeWhile$iv = buildTargetsCommandComponents;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object t : $this$takeWhile$iv) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER))) break;
                    list$iv.add(t);
                }
                $this$takeWhile$iv = buildTargetsCommandComponents;
                collection = CollectionsKt.plus((Collection)list$iv, (Iterable)artifactNames);
                boolean $i$f$takeLastWhile = false;
                if ($this$takeLastWhile$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) continue;
                        iterator$iv.next();
                        int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                        if (expectedSize$iv == 0) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList arrayList = new ArrayList(expectedSize$iv);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ArrayList $this$apply$iv = arrayList;
                            boolean bl4 = false;
                            while (iterator$iv.hasNext()) {
                                $this$apply$iv.add(iterator$iv.next());
                            }
                            list = arrayList;
                        }
                        break block8;
                    }
                    list = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
                }
            }
            List list2 = list;
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

