/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutputHandler;
import com.android.build.gradle.internal.cxx.process.EncodedExecuteProcess;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.cxx.timing.TimingEnvironmentKt;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.protobuf.GeneratedMessageV3;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00124\u0010\n\u001a0\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\u0002\u0010\u0013J$\u0010\n\u001a\u00020\u00192\u001c\u0010\u001a\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000eJ,\u0010\n\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u001c\u0010\u001a\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000eJ\u0006\u0010\u001d\u001a\u00020\u0000J\u0010\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\n\u001a0\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/cxx/process/ProcessOutputJunction;", "", "process", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "commandFile", "Ljava/io/File;", "stdoutFile", "stderrFile", "logPrefix", "", "execute", "Lkotlin/Function3;", "Lcom/android/ide/common/process/ProcessInfo;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "Lkotlin/Function1;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/BaseExecSpec;", "Lorg/gradle/process/ExecResult;", "Lcom/android/ide/common/process/ProcessResult;", "(Lcom/android/ide/common/process/ProcessInfoBuilder;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "isJavaProcess", "", "logFullStdout", "logStderr", "logStdout", "", "execOperations", "processHandler", "Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "javaProcess", "value", "gradle-core"})
public final class ProcessOutputJunction {
    @NotNull
    private final ProcessInfoBuilder process;
    @NotNull
    private final File commandFile;
    @NotNull
    private final File stdoutFile;
    @NotNull
    private final File stderrFile;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final Function3<ProcessInfo, ProcessOutputHandler, Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>, ProcessResult> execute;
    private boolean logStderr;
    private boolean logStdout;
    private boolean logFullStdout;
    private boolean isJavaProcess;

    public ProcessOutputJunction(@NotNull ProcessInfoBuilder process2, @NotNull File commandFile, @NotNull File stdoutFile, @NotNull File stderrFile, @NotNull String logPrefix, @NotNull Function3<? super ProcessInfo, ? super ProcessOutputHandler, ? super Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>, ? extends ProcessResult> execute2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandFile, (String)"commandFile");
        Intrinsics.checkParameterIsNotNull((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkParameterIsNotNull((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkParameterIsNotNull((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkParameterIsNotNull(execute2, (String)"execute");
        this.process = process2;
        this.commandFile = commandFile;
        this.stdoutFile = stdoutFile;
        this.stderrFile = stderrFile;
        this.logPrefix = logPrefix;
        this.execute = execute2;
    }

    @NotNull
    public final ProcessOutputJunction javaProcess() {
        this.isJavaProcess = true;
        return this;
    }

    @NotNull
    public final ProcessOutputJunction logStdout() {
        this.logStdout = true;
        return this;
    }

    @NotNull
    public final ProcessOutputJunction logFullStdout(boolean value) {
        this.logFullStdout = value;
        return this;
    }

    public static /* synthetic */ ProcessOutputJunction logFullStdout$default(ProcessOutputJunction processOutputJunction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return processOutputJunction.logFullStdout(bl);
    }

    @NotNull
    public final ProcessOutputJunction logStderr() {
        this.logStderr = true;
        return this;
    }

    public final void execute(@NotNull DefaultProcessOutputHandler processHandler, @NotNull Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult> execOperations) {
        Intrinsics.checkParameterIsNotNull((Object)processHandler, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(execOperations, (String)"execOperations");
        this.commandFile.getParentFile().mkdirs();
        Files.deleteIfExists(this.commandFile.toPath());
        String string = this.process.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"process.toString()");
        LoggingEnvironmentKt.infoln(string, new Object[0]);
        string = this.process.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"process.toString()");
        FilesKt.writeText$default((File)this.commandFile, (String)string, null, (int)2, null);
        Files.deleteIfExists(this.stderrFile.toPath());
        Files.deleteIfExists(this.stdoutFile.toPath());
        try {
            TimingEnvironmentKt.time("execute-process", (Function0)new Function0<ProcessResult>(this, processHandler, execOperations){
                final /* synthetic */ ProcessOutputJunction this$0;
                final /* synthetic */ DefaultProcessOutputHandler $processHandler;
                final /* synthetic */ Function1<Action<? super BaseExecSpec>, ExecResult> $execOperations;
                {
                    this.this$0 = $receiver;
                    this.$processHandler = $processHandler;
                    this.$execOperations = $execOperations;
                    super(0);
                }

                public final ProcessResult invoke() {
                    ProcessInfo proc = ProcessOutputJunction.access$isJavaProcess$p(this.this$0) ? (ProcessInfo)ProcessOutputJunction.access$getProcess$p(this.this$0).createJavaProcess() : ProcessOutputJunction.access$getProcess$p(this.this$0).createProcess();
                    Function3 function3 = ProcessOutputJunction.access$getExecute$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)proc, (String)"proc");
                    ProcessResult result2 = (ProcessResult)function3.invoke((Object)proc, (Object)this.$processHandler, this.$execOperations);
                    LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(proc, result2){
                        final /* synthetic */ ProcessInfo $proc;
                        final /* synthetic */ ProcessResult $result;
                        {
                            this.$proc = $proc;
                            this.$result = $result;
                            super(1);
                        }

                        @NotNull
                        public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                            String string;
                            Map.Entry<K, V> it;
                            Collection<String> collection;
                            Map.Entry<K, V> item$iv$iv;
                            Map $this$mapTo$iv$iv;
                            Map $this$map$iv;
                            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
                            EncodedExecuteProcess.Builder info2 = EncodedExecuteProcess.newBuilder();
                            Object object = this.$proc.getExecutable();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.executable");
                            info2.setExecutableId(encoder.encode((String)object));
                            object = this.$proc.getDescription();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.description");
                            info2.setDescriptionId(encoder.encode((String)object));
                            object = this.$proc.getArgs();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.args");
                            info2.setArgsId(encoder.encodeList((List<String>)object));
                            object = this.$proc.getEnvironment();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.environment");
                            StringEncoder stringEncoder = encoder;
                            EncodedExecuteProcess.Builder builder = info2;
                            boolean $i$f$map = false;
                            void var5_7 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            Map map = $this$mapTo$iv$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator2 = map.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                                collection = destination$iv$iv;
                                boolean bl2 = false;
                                string = (String)it.getKey();
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            builder.setEnvironmentKeysId(stringEncoder.encodeList(CollectionsKt.toList((Iterable)collection)));
                            $this$map$iv = this.$proc.getEnvironment();
                            Intrinsics.checkExpressionValueIsNotNull((Object)$this$map$iv, (String)"proc.environment");
                            stringEncoder = encoder;
                            builder = info2;
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                            $i$f$mapTo = false;
                            map = $this$mapTo$iv$iv;
                            bl = false;
                            iterator2 = map.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                it = item$iv$iv = iterator2.next();
                                collection = destination$iv$iv;
                                boolean bl3 = false;
                                string = String.valueOf(it.getValue());
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            builder.setEnvironmentValuesId(stringEncoder.encodeList(CollectionsKt.toList((Iterable)collection)));
                            info2.setExitCode(this.$result.getExitValue());
                            if (this.$proc instanceof JavaProcessInfo) {
                                object = ((JavaProcessInfo)this.$proc).getClasspath();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.classpath");
                                info2.setJvmClassPathId(encoder.encode((String)object));
                                object = ((JavaProcessInfo)this.$proc).getMainClass();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.mainClass");
                                info2.setJvmMainClassId(encoder.encode((String)object));
                                object = ((JavaProcessInfo)this.$proc).getJvmArgs();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proc.jvmArgs");
                                info2.setJvmArgsId(encoder.encodeList((List<String>)object));
                            }
                            object = info2.build();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"info.build()");
                            return (GeneratedMessageV3)object;
                        }
                    }));
                    return result2.rethrowFailure().assertNormalExitValue();
                }
            });
        }
        catch (ProcessException e) {
            throw new BuildCommandException(StringsKt.trimMargin$default((String)("\n                |" + e.getMessage() + "\n                |" + FilesKt.readText$default((File)this.stdoutFile, null, (int)1, null) + "\n                |" + FilesKt.readText$default((File)this.stderrFile, null, (int)1, null) + "\n                "), null, (int)1, null));
        }
    }

    public final void execute(@NotNull Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult> execOperations) throws BuildCommandException, IOException {
        Intrinsics.checkParameterIsNotNull(execOperations, (String)"execOperations");
        DefaultProcessOutputHandler handler2 = new DefaultProcessOutputHandler(this.stderrFile, this.stdoutFile, this.logPrefix, this.logStderr, this.logStdout, this.logFullStdout);
        this.execute(handler2, execOperations);
    }

    public static final /* synthetic */ boolean access$isJavaProcess$p(ProcessOutputJunction $this) {
        return $this.isJavaProcess;
    }

    public static final /* synthetic */ ProcessInfoBuilder access$getProcess$p(ProcessOutputJunction $this) {
        return $this.process;
    }

    public static final /* synthetic */ Function3 access$getExecute$p(ProcessOutputJunction $this) {
        return $this.execute;
    }
}

