/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.model.LintModelModuleType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a.\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"createLintClasspathConfiguration", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "getLintMavenArtifactVersion", "", "versionOverride", "reporter", "Lcom/android/builder/errors/IssueReporter;", "defaultVersion", "agpVersion", "toLintModelModuleType", "Lcom/android/tools/lint/model/LintModelModuleType;", "Lcom/android/builder/core/VariantType;", "gradle-core"})
@JvmName(name="AndroidLintInputs")
public final class AndroidLintInputs {
    @NotNull
    public static final LintModelModuleType toLintModelModuleType(@NotNull VariantType $this$toLintModelModuleType) {
        LintModelModuleType lintModelModuleType;
        Intrinsics.checkParameterIsNotNull((Object)$this$toLintModelModuleType, (String)"<this>");
        VariantType variantType = $this$toLintModelModuleType;
        if (variantType == VariantTypeImpl.BASE_APK) {
            lintModelModuleType = LintModelModuleType.APP;
        } else if (variantType == VariantTypeImpl.LIBRARY) {
            lintModelModuleType = LintModelModuleType.LIBRARY;
        } else if (variantType == VariantTypeImpl.OPTIONAL_APK) {
            lintModelModuleType = LintModelModuleType.DYNAMIC_FEATURE;
        } else if (variantType == VariantTypeImpl.TEST_APK) {
            lintModelModuleType = LintModelModuleType.TEST;
        } else {
            throw new RuntimeException("Unsupported VariantTypeImpl value");
        }
        return lintModelModuleType;
    }

    @NotNull
    public static final FileCollection createLintClasspathConfiguration(@NotNull Project project2, @NotNull ProjectServices projectServices2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectServices2, (String)"projectServices");
        Configuration config2 = (Configuration)project2.getConfigurations().create("lintClassPath");
        config2.setVisible(false);
        config2.setTransitive(true);
        config2.setCanBeConsumed(false);
        config2.setCanBeResolved(true);
        config2.setDescription("The lint embedded classpath");
        Pair[] pairArray = projectServices2.getProjectOptions().get(StringOption.LINT_VERSION_OVERRIDE);
        if (pairArray == null) {
            string = null;
        } else {
            Pair[] pairArray2 = pairArray;
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)pairArray2))).toString();
        }
        String lintVersion = AndroidLintInputs.getLintMavenArtifactVersion$default(string, projectServices2.getIssueReporter(), null, null, 12, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.lint"), TuplesKt.to((Object)"name", (Object)"lint-gradle"), TuplesKt.to((Object)"version", (Object)lintVersion)};
        project2.getDependencies().add(config2.getName(), (Object)project2.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray)));
        Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"config");
        return (FileCollection)config2;
    }

    @NotNull
    public static final String getLintMavenArtifactVersion(@Nullable String versionOverride, @NotNull IssueReporter reporter, @NotNull String defaultVersion, @NotNull String agpVersion) {
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        Intrinsics.checkParameterIsNotNull((Object)defaultVersion, (String)"defaultVersion");
        Intrinsics.checkParameterIsNotNull((Object)agpVersion, (String)"agpVersion");
        if (versionOverride == null) {
            return defaultVersion;
        }
        GradleVersion parsed = GradleVersion.tryParseAndroidGradlePluginVersion((String)versionOverride);
        if (parsed == null) {
            IssueReporter.reportError$default((IssueReporter)reporter, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Could not parse lint version override '" + versionOverride + "'\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            return defaultVersion;
        }
        GradleVersion gradleVersion = GradleVersion.parseAndroidGradlePluginVersion((String)defaultVersion);
        String normalizedOverride = parsed.getMajor() + 23 + StringsKt.removePrefix((String)versionOverride, (CharSequence)String.valueOf(parsed.getMajor()));
        GradleVersion gradleVersion2 = GradleVersion.tryParseAndroidGradlePluginVersion((String)normalizedOverride);
        if (gradleVersion2 == null) {
            String string = "Unexpected parse error";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        GradleVersion normalizedParsed = gradleVersion2;
        if (normalizedParsed.getMajor() < gradleVersion.getMajor()) {
            IssueReporter.reportError$default((IssueReporter)reporter, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Lint must be at least version " + StringsKt.substringBefore$default((String)agpVersion, (String)".", null, (int)2, null) + ".0.0, and is recommended to be at least " + agpVersion + "\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            return defaultVersion;
        }
        if (normalizedParsed.compareTo(gradleVersion) < 0) {
            IssueReporter.reportWarning$default((IssueReporter)reporter, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    The build will use lint version " + versionOverride + " which is older than the default.\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
        }
        return normalizedOverride;
    }

    public static /* synthetic */ String getLintMavenArtifactVersion$default(String string, IssueReporter issueReporter2, String string2, String string3, int n, Object object) {
        String string4;
        if ((n & 4) != 0) {
            string4 = Version.ANDROID_TOOLS_BASE_VERSION;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ANDROID_TOOLS_BASE_VERSION");
            string2 = string4;
        }
        if ((n & 8) != 0) {
            string4 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            string3 = string4;
        }
        return AndroidLintInputs.getLintMavenArtifactVersion(string, issueReporter2, string2, string3);
    }
}

