/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.attribution.CheckJetifierBuildService;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.CheckJetifierTask;
import com.android.build.gradle.internal.tasks.ConfigurationAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.ide.common.attribution.CheckJetifierResult;
import com.android.ide.common.attribution.DependencyPath;
import com.android.ide.common.attribution.FullDependencyPath;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "()V", "checkJetifierBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "getCheckJetifierBuildService", "()Lorg/gradle/api/provider/Property;", "jetifierEnabled", "", "getJetifierEnabled", "detect", "Lcom/android/ide/common/attribution/CheckJetifierResult;", "doTaskAction", "", "reportToConsole", "result", "CreationAction", "gradle-core"})
public abstract class CheckJetifierTask
extends NonIncrementalGlobalTask {
    @Internal
    @NotNull
    public abstract Property<Boolean> getJetifierEnabled();

    @Internal
    @NotNull
    public abstract Property<CheckJetifierBuildService> getCheckJetifierBuildService();

    @Override
    protected void doTaskAction() {
        if (!((Boolean)this.getJetifierEnabled().get()).booleanValue()) {
            this.getLogger().quiet("Skipping '" + this.getPath() + "' task as Jetifier is already disabled (" + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false).");
            return;
        }
        CheckJetifierResult result2 = this.detect();
        this.reportToConsole(result2);
        ((CheckJetifierBuildService)this.getCheckJetifierBuildService().get()).addResult(result2);
    }

    private final CheckJetifierResult detect() {
        LinkedHashMap dependenciesDependingOnSupportLibs = new LinkedHashMap();
        for (Configuration configuration : this.getProject().getConfigurations()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configuration");
            for (DependencyPath pathToSupportLib : new ConfigurationAnalyzer(configuration).findPathsToSupportLibs()) {
                String directDependency = (String)CollectionsKt.first((List)pathToSupportLib.getElements());
                dependenciesDependingOnSupportLibs.computeIfAbsent(directDependency, (Function)new Function<String, FullDependencyPath>(this, configuration, pathToSupportLib){
                    final /* synthetic */ CheckJetifierTask this$0;
                    final /* synthetic */ Configuration $configuration;
                    final /* synthetic */ DependencyPath $pathToSupportLib;
                    {
                        this.this$0 = $receiver;
                        this.$configuration = $configuration;
                        this.$pathToSupportLib = $pathToSupportLib;
                    }

                    @NotNull
                    public final FullDependencyPath apply(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String string = this.this$0.getProject().getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.path");
                        String string2 = string;
                        string = this.$configuration.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
                        return new FullDependencyPath(string2, string, this.$pathToSupportLib);
                    }
                });
            }
        }
        return new CheckJetifierResult(dependenciesDependingOnSupportLibs);
    }

    private final void reportToConsole(CheckJetifierResult result2) {
        if (result2.isEmpty()) {
            this.getLogger().quiet("Project '" + this.getProject().getPath() + "' does not use any legacy support libraries. If this is the case for all other projects, you can disable Jetifier by setting " + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false in gradle.properties.");
        } else {
            this.getLogger().quiet("The following libraries used by project '" + this.getProject().getPath() + "' depend on legacy support libraries. To disable Jetifier, you will need to use AndroidX-supported versions of these libraries.");
            this.getLogger().quiet(Intrinsics.stringPlus((String)"\t", (Object)StringsKt.replace$default((String)result2.getDisplayString(), (String)"\n", (String)"\n\t", (boolean)false, (int)4, null)));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "checkJetifierBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/options/ProjectOptions;Lorg/gradle/api/provider/Provider;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<CheckJetifierTask> {
        @NotNull
        private final ProjectOptions projectOptions;
        @NotNull
        private final Provider<CheckJetifierBuildService> checkJetifierBuildService;
        @NotNull
        private final String name;
        @NotNull
        private final Class<CheckJetifierTask> type;

        public CreationAction(@NotNull GlobalScope globalScope, @NotNull ProjectOptions projectOptions, @NotNull Provider<CheckJetifierBuildService> checkJetifierBuildService) {
            Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            Intrinsics.checkParameterIsNotNull(checkJetifierBuildService, (String)"checkJetifierBuildService");
            super(globalScope);
            this.projectOptions = projectOptions;
            this.checkJetifierBuildService = checkJetifierBuildService;
            this.name = "checkJetifier";
            this.type = CheckJetifierTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<CheckJetifierTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull CheckJetifierTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((BaseTask)task);
            task.setDescription("Checks whether Jetifier is needed for the current project");
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getJetifierEnabled(), this.projectOptions.get(BooleanOption.ENABLE_JETIFIER));
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckJetifierBuildService(), this.checkJetifierBuildService);
            task.getOutputs().upToDateWhen((Spec)configure.1.INSTANCE);
        }
    }
}

