/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.IntegrityConfigParser;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.bundle.AppIntegrityConfigOuterClass;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "appIntegrityConfigProto", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIntegrityConfigProto", "()Lorg/gradle/api/file/RegularFileProperty;", "integrityConfigDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIntegrityConfigDir", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "CreationAction", "Params", "ParseIntegrityConfigRunnable", "gradle-core"})
public abstract class ParseIntegrityConfigTask
extends NonIncrementalTask {
    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getIntegrityConfigDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAppIntegrityConfigProto();

    @Override
    public void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(ParseIntegrityConfigRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ ParseIntegrityConfigTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getIntegrityConfigDir().set((Provider)this.this$0.getIntegrityConfigDir());
                it.getAppIntegrityConfigProto().set((Provider)this.this$0.getAppIntegrityConfigProto());
            }
        });
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "appIntegrityConfigProto", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIntegrityConfigProto", "()Lorg/gradle/api/file/RegularFileProperty;", "integrityConfigDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIntegrityConfigDir", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getIntegrityConfigDir();

        @NotNull
        public abstract RegularFileProperty getAppIntegrityConfigProto();
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$ParseIntegrityConfigRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "()V", "loadXML", "Lorg/w3c/dom/Document;", "xmlFile", "Ljava/io/File;", "run", "", "storeProto", "configProto", "Lcom/android/bundle/AppIntegrityConfigOuterClass$AppIntegrityConfig;", "output", "gradle-core"})
    public static abstract class ParseIntegrityConfigRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            block3: {
                Unit unit;
                boolean bl;
                Unit unit2;
                Object object = (File)((Params)this.getParameters()).getIntegrityConfigDir().getAsFile().getOrNull();
                if (object == null) {
                    unit2 = null;
                } else {
                    File file = object;
                    bl = false;
                    boolean bl2 = false;
                    File it = file;
                    boolean bl3 = false;
                    if (!it.isDirectory()) {
                        throw new FileNotFoundException(Intrinsics.stringPlus((String)"Could not find directory ", (Object)it.getAbsolutePath()));
                    }
                    Document doc = this.loadXML(FilesKt.resolve((File)it, (String)"IntegrityConfig.xml"));
                    AppIntegrityConfigOuterClass.AppIntegrityConfig configProto = new IntegrityConfigParser(doc).parseConfig();
                    Object object2 = ((Params)this.getParameters()).getAppIntegrityConfigProto().getAsFile().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.appIntegrityConfigProto.asFile.get()");
                    this.storeProto(configProto, (File)object2);
                    unit2 = unit = Unit.INSTANCE;
                }
                if (unit != null) break block3;
                object = this;
                boolean bl4 = false;
                bl = false;
                ParseIntegrityConfigRunnable $this$run_u24lambda_u2d1 = (ParseIntegrityConfigRunnable)object;
                boolean bl5 = false;
                Files.deleteIfExists(((File)((Params)$this$run_u24lambda_u2d1.getParameters()).getAppIntegrityConfigProto().getAsFile().get()).toPath());
            }
        }

        private final Document loadXML(File xmlFile) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(xmlFile)");
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void storeProto(AppIntegrityConfigOuterClass.AppIntegrityConfig configProto, File output2) {
            Closeable closeable = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl3 = false;
                configProto.writeTo(outputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "getIntegrityConfigFolder", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "component", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ParseIntegrityConfigTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("parse", "IntegrityConfig");
        }

        @Override
        @NotNull
        public Class<ParseIntegrityConfigTask> getType() {
            return ParseIntegrityConfigTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ParseIntegrityConfigTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("AppIntegrityConfig.pb").on(InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ParseIntegrityConfigTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.getIntegrityConfigDir().set(this.getIntegrityConfigFolder((VariantCreationConfig)this.creationConfig));
        }

        private final Provider<? extends Directory> getIntegrityConfigFolder(VariantCreationConfig component2) {
            return (Provider)((BaseAppModuleExtension)component2.getGlobalScope().getExtension()).getBundle().getIntegrityConfigDir();
        }
    }
}

