/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.internal.StringCachingService;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00017BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eBU\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0015J\t\u0010$\u001a\u00020\u0010H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0013H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\u0015\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010+\u001a\u00020\rH\u00c6\u0003J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u000bJi\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001fR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "", "mainArtifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "secondaryArtifactResult", "dependencyType", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "isWrappedModule", "", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;)V", "componentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "variantName", "artifactFile", "Ljava/io/File;", "extractedFolder", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;Ljava/lang/String;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;)V", "getArtifactFile", "()Ljava/io/File;", "getBuildMapping", "()Lcom/google/common/collect/ImmutableMap;", "getComponentIdentifier", "()Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getDependencyType", "()Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "getExtractedFolder", "()Z", "getMavenCoordinatesCache", "()Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "getVariantName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "computeMavenCoordinates", "Lcom/android/builder/model/MavenCoordinates;", "stringCachingService", "Lcom/android/builder/internal/StringCachingService;", "computeModelAddress", "copy", "equals", "other", "hashCode", "", "toString", "DependencyType", "gradle-core"})
public final class ResolvedArtifact {
    @NotNull
    private final ComponentIdentifier componentIdentifier;
    @Nullable
    private final String variantName;
    @NotNull
    private final File artifactFile;
    @Nullable
    private final File extractedFolder;
    @NotNull
    private final DependencyType dependencyType;
    private final boolean isWrappedModule;
    @NotNull
    private final ImmutableMap<String, String> buildMapping;
    @NotNull
    private final MavenCoordinatesCacheBuildService mavenCoordinatesCache;

    public ResolvedArtifact(@NotNull ComponentIdentifier componentIdentifier, @Nullable String variantName, @NotNull File artifactFile, @Nullable File extractedFolder, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping, @NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        this.componentIdentifier = componentIdentifier;
        this.variantName = variantName;
        this.artifactFile = artifactFile;
        this.extractedFolder = extractedFolder;
        this.dependencyType = dependencyType;
        this.isWrappedModule = isWrappedModule;
        this.buildMapping = buildMapping;
        this.mavenCoordinatesCache = mavenCoordinatesCache;
    }

    @NotNull
    public final ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    @NotNull
    public final File getArtifactFile() {
        return this.artifactFile;
    }

    @Nullable
    public final File getExtractedFolder() {
        return this.extractedFolder;
    }

    @NotNull
    public final DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public final boolean isWrappedModule() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> getBuildMapping() {
        return this.buildMapping;
    }

    @NotNull
    public final MavenCoordinatesCacheBuildService getMavenCoordinatesCache() {
        return this.mavenCoordinatesCache;
    }

    public ResolvedArtifact(@NotNull ResolvedArtifactResult mainArtifactResult, @Nullable ResolvedArtifactResult secondaryArtifactResult, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping, @NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        Intrinsics.checkNotNullParameter((Object)mainArtifactResult, (String)"mainArtifactResult");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        Object object = mainArtifactResult.getId().getComponentIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mainArtifactResult.id.componentIdentifier");
        ComponentIdentifier componentIdentifier = object;
        String string = LibraryUtils.getVariantName(mainArtifactResult);
        object = mainArtifactResult.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mainArtifactResult.file");
        Object object2 = object;
        object = secondaryArtifactResult;
        this(componentIdentifier, string, (File)object2, object == null ? null : object.getFile(), dependencyType, isWrappedModule, buildMapping, mavenCoordinatesCache);
    }

    @NotNull
    public final MavenCoordinates computeMavenCoordinates(@NotNull StringCachingService stringCachingService) {
        MavenCoordinates mavenCoordinates;
        Intrinsics.checkNotNullParameter((Object)stringCachingService, (String)"stringCachingService");
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            String module2 = ((ModuleComponentIdentifier)this.componentIdentifier).getModule();
            String version = ((ModuleComponentIdentifier)this.componentIdentifier).getVersion();
            String extension = this.dependencyType.getExtension();
            String classifier = null;
            if (!this.artifactFile.isDirectory() && (m = (p = Pattern.compile(pattern = '^' + module2 + '-' + version + "-(.+)\\." + extension + '$')).matcher(this.artifactFile.getName())).matches()) {
                classifier = m.group(1);
            }
            String string = ((ModuleComponentIdentifier)this.componentIdentifier).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentIdentifier.group");
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create(stringCachingService, string, module2, version, extension, classifier);
        } else if (componentIdentifier instanceof ProjectComponentIdentifier) {
            String string = ((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentIdentifier.projectPath");
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create$default((MavenCoordinatesImpl.Companion)MavenCoordinatesImpl.Companion, (StringCachingService)stringCachingService, (String)"artifacts", (String)string, (String)"unspecified", null, null, (int)48, null);
        } else if (componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinatesImpl mavenCoordinatesImpl;
            if (this.dependencyType == DependencyType.JAVA) {
                mavenCoordinatesImpl = this.mavenCoordinatesCache.getMavenCoordForLocalFile(this.artifactFile);
            } else {
                boolean bl = this.artifactFile.isDirectory();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                mavenCoordinatesImpl = this.mavenCoordinatesCache.getMavenCoordForLocalFile(this.artifactFile);
            }
            mavenCoordinates = (MavenCoordinates)mavenCoordinatesImpl;
        } else {
            throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + this.componentIdentifier.getDisplayName() + "' with component identifier of type '" + this.componentIdentifier.getClass() + "'.");
        }
        return mavenCoordinates;
    }

    @NotNull
    public final String computeModelAddress() {
        String string;
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            StringBuilder stringBuilder = new StringBuilder(100).append(BuildMappingUtils.getBuildId((ProjectComponentIdentifier)this.componentIdentifier, this.buildMapping)).append("@@").append(((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath());
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder sb = stringBuilder;
            boolean bl3 = false;
            String string2 = this.getVariantName();
            if (string2 != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string3;
                boolean bl6 = false;
                sb.append("::").append(it);
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder(100)\n                .append(componentIdentifier.getBuildId(buildMapping))\n                .append(\"@@\")\n                .append(componentIdentifier.projectPath)\n                .also { sb ->\n                    this.variantName?.let{ sb.append(\"::\").append(it) }\n                }\n                .toString()");
            boolean bl7 = false;
            String string5 = string4.intern();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).intern()");
        } else if (componentIdentifier instanceof ModuleComponentIdentifier ? true : componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            String string6 = this.mavenCoordinatesCache.getMavenCoordinates(this).toString();
            boolean bl = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.intern();
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).intern()");
        } else {
            throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + this.componentIdentifier.getDisplayName() + "'of type " + this.componentIdentifier.getClass());
        }
        return string;
    }

    @NotNull
    public final ComponentIdentifier component1() {
        return this.componentIdentifier;
    }

    @Nullable
    public final String component2() {
        return this.variantName;
    }

    @NotNull
    public final File component3() {
        return this.artifactFile;
    }

    @Nullable
    public final File component4() {
        return this.extractedFolder;
    }

    @NotNull
    public final DependencyType component5() {
        return this.dependencyType;
    }

    public final boolean component6() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> component7() {
        return this.buildMapping;
    }

    @NotNull
    public final MavenCoordinatesCacheBuildService component8() {
        return this.mavenCoordinatesCache;
    }

    @NotNull
    public final ResolvedArtifact copy(@NotNull ComponentIdentifier componentIdentifier, @Nullable String variantName, @NotNull File artifactFile, @Nullable File extractedFolder, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping, @NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        return new ResolvedArtifact(componentIdentifier, variantName, artifactFile, extractedFolder, dependencyType, isWrappedModule, buildMapping, mavenCoordinatesCache);
    }

    public static /* synthetic */ ResolvedArtifact copy$default(ResolvedArtifact resolvedArtifact, ComponentIdentifier componentIdentifier, String string, File file, File file2, DependencyType dependencyType, boolean bl, ImmutableMap immutableMap, MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService, int n, Object object) {
        if ((n & 1) != 0) {
            componentIdentifier = resolvedArtifact.componentIdentifier;
        }
        if ((n & 2) != 0) {
            string = resolvedArtifact.variantName;
        }
        if ((n & 4) != 0) {
            file = resolvedArtifact.artifactFile;
        }
        if ((n & 8) != 0) {
            file2 = resolvedArtifact.extractedFolder;
        }
        if ((n & 0x10) != 0) {
            dependencyType = resolvedArtifact.dependencyType;
        }
        if ((n & 0x20) != 0) {
            bl = resolvedArtifact.isWrappedModule;
        }
        if ((n & 0x40) != 0) {
            immutableMap = resolvedArtifact.buildMapping;
        }
        if ((n & 0x80) != 0) {
            mavenCoordinatesCacheBuildService = resolvedArtifact.mavenCoordinatesCache;
        }
        return resolvedArtifact.copy(componentIdentifier, string, file, file2, dependencyType, bl, immutableMap, mavenCoordinatesCacheBuildService);
    }

    @NotNull
    public String toString() {
        return "ResolvedArtifact(componentIdentifier=" + this.componentIdentifier + ", variantName=" + this.variantName + ", artifactFile=" + this.artifactFile + ", extractedFolder=" + this.extractedFolder + ", dependencyType=" + (Object)((Object)this.dependencyType) + ", isWrappedModule=" + this.isWrappedModule + ", buildMapping=" + this.buildMapping + ", mavenCoordinatesCache=" + this.mavenCoordinatesCache + ')';
    }

    public int hashCode() {
        int result2 = this.componentIdentifier.hashCode();
        result2 = result2 * 31 + (this.variantName == null ? 0 : this.variantName.hashCode());
        result2 = result2 * 31 + this.artifactFile.hashCode();
        result2 = result2 * 31 + (this.extractedFolder == null ? 0 : this.extractedFolder.hashCode());
        result2 = result2 * 31 + this.dependencyType.hashCode();
        int n = this.isWrappedModule ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + this.buildMapping.hashCode();
        result2 = result2 * 31 + this.mavenCoordinatesCache.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact resolvedArtifact = (ResolvedArtifact)other;
        if (!Intrinsics.areEqual((Object)this.componentIdentifier, (Object)resolvedArtifact.componentIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variantName, (Object)resolvedArtifact.variantName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifactFile, (Object)resolvedArtifact.artifactFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extractedFolder, (Object)resolvedArtifact.extractedFolder)) {
            return false;
        }
        if (this.dependencyType != resolvedArtifact.dependencyType) {
            return false;
        }
        if (this.isWrappedModule != resolvedArtifact.isWrappedModule) {
            return false;
        }
        if (!Intrinsics.areEqual(this.buildMapping, resolvedArtifact.buildMapping)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mavenCoordinatesCache, (Object)resolvedArtifact.mavenCoordinatesCache);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "", "extension", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "JAVA", "ANDROID", "gradle-core"})
    public static final class DependencyType
    extends Enum<DependencyType> {
        @NotNull
        private final String extension;
        public static final /* enum */ DependencyType JAVA = new DependencyType("jar");
        public static final /* enum */ DependencyType ANDROID = new DependencyType("aar");
        private static final /* synthetic */ DependencyType[] $VALUES;

        private DependencyType(String extension) {
            this.extension = extension;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public static DependencyType[] values() {
            DependencyType[] dependencyTypeArray = $VALUES;
            DependencyType[] dependencyTypeArray2 = new DependencyType[dependencyTypeArray.length];
            System.arraycopy(dependencyTypeArray, 0, dependencyTypeArray2, 0, dependencyTypeArray.length);
            return dependencyTypeArray2;
        }

        public static DependencyType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(DependencyType.class, value);
        }

        static {
            DependencyType[] dependencyTypeArray = new DependencyType[]{JAVA, ANDROID};
            $VALUES = dependencyTypeArray;
        }
    }
}

