/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.EnvironmentVariableInputs;
import com.android.build.gradle.internal.lint.LintFixBuildService;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.SystemPropertyInputs;
import com.android.build.gradle.internal.lint.VariantInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\b'\u0018\u0000 \u008c\u00012\u00020\u0001:\f\u008b\u0001\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020t2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020v0u2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0005J\u0010\u0010y\u001a\u00020j2\u0006\u0010s\u001a\u00020tH\u0002J\b\u0010z\u001a\u00020jH\u0014J\b\u0010{\u001a\u00020jH\u0002J\u0013\u0010|\u001a\b\u0012\u0004\u0012\u00020\t0}H\u0001\u00a2\u0006\u0002\b~J\u0019\u0010\u007f\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0007\u0010\u0080\u0001\u001a\u00020\u0005H\u0002J\t\u0010\u0081\u0001\u001a\u00020jH\u0002J\t\u0010\u0082\u0001\u001a\u00020jH\u0002J&\u0010\u0083\u0001\u001a\u00020j*\t\u0012\u0004\u0012\u00020\t0\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\tH\u0002J'\u0010\u0083\u0001\u001a\u00020j*\t\u0012\u0004\u0012\u00020\t0\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020\t2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0014\u0010\u0089\u0001\u001a\u00020\t*\t\u0012\u0004\u0012\u00020\t0\u008a\u0001H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0014\u0010#\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u0014\u0010'\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\u00020.8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0007R\u001a\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0007R\u0014\u00107\u001a\u00020.8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00100R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0007R\u0014\u0010;\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0010R\u0014\u0010=\u001a\u00020>8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0010R\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0007R\u0014\u0010E\u001a\u00020.8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u00100R\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0007R\u0014\u0010I\u001a\u00020J8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0007R\u0014\u0010O\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010*R\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u0007R\u0014\u0010S\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010*R\u0014\u0010U\u001a\u00020V8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u001a\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u0007R\u0014\u0010[\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010*R\u001a\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010\u0007R\u0014\u0010_\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u0010R\u0014\u0010a\u001a\u00020b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010\u0007R\u0014\u0010g\u001a\u00020(8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010*\u00a8\u0006\u0091\u0001"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "androidGradlePluginVersion", "", "getAndroidGradlePluginVersion", "androidSdkHome", "getAndroidSdkHome", "androidTestDependencyLintModels", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidTestDependencyLintModels", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "autoFix", "getAutoFix", "checkDependencies", "getCheckDependencies", "checkOnly", "Lorg/gradle/api/provider/ListProperty;", "getCheckOnly", "()Lorg/gradle/api/provider/ListProperty;", "dependencyPartialResults", "getDependencyPartialResults", "dynamicFeatureLintModels", "getDynamicFeatureLintModels", "environmentVariableInputs", "Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "getEnvironmentVariableInputs", "()Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "fatalOnly", "getFatalOnly", "globalRuleJars", "getGlobalRuleJars", "htmlReportEnabled", "getHtmlReportEnabled", "htmlReportOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getHtmlReportOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "intermediateTextReport", "getIntermediateTextReport", "lintCacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintClassLoaderBuildService", "Lcom/android/build/gradle/internal/services/LintClassLoaderBuildService;", "getLintClassLoaderBuildService", "lintFixBuildService", "Lcom/android/build/gradle/internal/lint/LintFixBuildService;", "getLintFixBuildService", "lintModelDirectory", "getLintModelDirectory", "lintModelWriterTaskOutputPath", "getLintModelWriterTaskOutputPath", "lintRulesJar", "getLintRulesJar", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "()Lcom/android/build/gradle/internal/lint/LintTool;", "mainDependencyLintModels", "getMainDependencyLintModels", "offline", "getOffline", "partialResults", "getPartialResults", "printStackTrace", "getPrintStackTrace", "projectInputs", "Lcom/android/build/gradle/internal/lint/ProjectInputs;", "getProjectInputs", "()Lcom/android/build/gradle/internal/lint/ProjectInputs;", "reportOnly", "getReportOnly", "returnValueOutputFile", "getReturnValueOutputFile", "sarifReportEnabled", "getSarifReportEnabled", "sarifReportOutputFile", "getSarifReportOutputFile", "systemPropertyInputs", "Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "getSystemPropertyInputs", "()Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "textReportEnabled", "getTextReportEnabled", "textReportOutputFile", "getTextReportOutputFile", "textReportToStdOut", "getTextReportToStdOut", "unitTestDependencyLintModels", "getUnitTestDependencyLintModels", "variantInputs", "Lcom/android/build/gradle/internal/lint/VariantInputs;", "getVariantInputs", "()Lcom/android/build/gradle/internal/lint/VariantInputs;", "xmlReportEnabled", "getXmlReportEnabled", "xmlReportOutputFile", "getXmlReportOutputFile", "configureForStandalone", "", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "javaPluginConvention", "Lorg/gradle/api/plugins/JavaPluginConvention;", "customLintChecksConfig", "Lorg/gradle/api/file/FileCollection;", "lintOptions", "Lcom/android/build/gradle/internal/dsl/LintOptions;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "lintModelWriterTaskOutputDir", "Ljava/io/File;", "configureOutputSettings", "doTaskAction", "finalizeOutputTypes", "generateCommandLineArguments", "", "generateCommandLineArguments$gradle_core", "initializeGlobalInputs", "isAndroid", "initializeOutputTypesConvention", "writeLintModelFile", "add", "", "arg", "value", "path", "Lorg/gradle/api/file/RegularFile;", "asLintPaths", "", "AndroidLintLauncherWorkAction", "Companion", "FixSingleVariantCreationAction", "LintVitalCreationAction", "SingleVariantCreationAction", "VariantCreationAction", "gradle-core"})
public abstract class AndroidLintTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE = "LINT_PRINT_STACKTRACE";
    @NotNull
    private static final String ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE = "ANDROID_LINT_JARS";
    @NotNull
    public static final String LINT_CLASS_PATH = "lintClassPath";

    @Nested
    @NotNull
    public abstract LintTool getLintTool();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getLintModelDirectory();

    @Input
    @NotNull
    public abstract Property<String> getLintModelWriterTaskOutputPath();

    @Input
    @NotNull
    public abstract Property<Boolean> getTextReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getTextReportOutputFile();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getIntermediateTextReport();

    @Input
    @NotNull
    public abstract Property<Boolean> getHtmlReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getHtmlReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getXmlReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getXmlReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getSarifReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getSarifReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getTextReportToStdOut();

    @Internal
    @NotNull
    public abstract Property<String> getAndroidSdkHome();

    @Input
    @NotNull
    public abstract Property<String> getAndroidGradlePluginVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract Property<Boolean> getAutoFix();

    @Input
    @NotNull
    public abstract Property<Boolean> getReportOnly();

    @Internal
    @NotNull
    public abstract Property<LintFixBuildService> getLintFixBuildService();

    @Internal
    @NotNull
    public abstract Property<LintClassLoaderBuildService> getLintClassLoaderBuildService();

    @Input
    @NotNull
    public abstract Property<Boolean> getCheckDependencies();

    @Input
    @NotNull
    public abstract ListProperty<String> getCheckOnly();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintCacheDirectory();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getLintRulesJar();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getGlobalRuleJars();

    @Nested
    @NotNull
    public abstract ProjectInputs getProjectInputs();

    @Nested
    @NotNull
    public abstract VariantInputs getVariantInputs();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getMainDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getAndroidTestDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getUnitTestDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getDynamicFeatureLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract DirectoryProperty getPartialResults();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getDependencyPartialResults();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintStackTrace();

    @Nested
    @NotNull
    public abstract SystemPropertyInputs getSystemPropertyInputs();

    @Nested
    @NotNull
    public abstract EnvironmentVariableInputs getEnvironmentVariableInputs();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getReturnValueOutputFile();

    @Override
    protected void doTaskAction() {
        ((LintClassLoaderBuildService)this.getLintClassLoaderBuildService().get()).setShouldDispose(true);
        if (Intrinsics.areEqual((Object)this.getSystemPropertyInputs().getLintAutofix().getOrNull(), (Object)"true")) {
            this.getLogger().warn("Running lint with -Dlint.autofix=true is not supported by the Android Gradle Plugin. Please try running the lintFix task instead.");
        }
        this.writeLintModelFile();
        this.getWorkerExecutor().noIsolation().submit(AndroidLintLauncherWorkAction.class, (Action)new Action<AndroidLintLauncherWorkAction.LauncherParameters>(this){
            final /* synthetic */ AndroidLintTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(AndroidLintLauncherWorkAction.LauncherParameters parameters) {
                parameters.getArguments().set((Iterable)this.this$0.generateCommandLineArguments$gradle_core());
                parameters.getLintTool().set((Object)this.this$0.getLintTool());
                parameters.getAndroid().set((Provider)this.this$0.getAndroid());
                parameters.getFatalOnly().set((Provider)this.this$0.getFatalOnly());
                parameters.getLintFixBuildService().set((Provider)this.this$0.getLintFixBuildService());
                parameters.getReturnValueOutputFile().set((Provider)this.this$0.getReturnValueOutputFile());
            }
        });
    }

    private final void writeLintModelFile() {
        Object object;
        LintModelModule module2 = this.getProjectInputs().convertToLintModelModule$gradle_core();
        LintModelVariant variant2 = this.getVariantInputs().toLintModel(module2, (object = (Directory)this.getPartialResults().getOrNull()) == null ? null : object.getAsFile());
        object = ((Directory)this.getLintModelDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lintModelDirectory.get().asFile");
        LintModelSerialization.writeModule$default((LintModelSerialization)LintModelSerialization.INSTANCE, (LintModelModule)module2, (File)object, (List)CollectionsKt.listOf((Object)variant2), (boolean)true, null, null, (int)48, null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> generateCommandLineArguments$gradle_core() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Object object4;
        Object check2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object2;
        boolean bl4 = false;
        List arguments = new ArrayList();
        Object object3 = this.getAutoFix().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"autoFix.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = arguments;
            object2 = "--apply-suggestions";
            bl3 = false;
            object3.add(object2);
            object3 = arguments;
            object2 = "--abort-if-suggestions-applied";
            bl3 = false;
            object3.add(object2);
        }
        object3 = this.getFatalOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fatalOnly.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = arguments;
            object2 = "--fatalOnly";
            bl3 = false;
            object3.add(object2);
        }
        object3 = this.getReportOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"reportOnly.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = arguments;
            object2 = "--report-only";
            bl3 = false;
            object3.add(object2);
        }
        object3 = arguments;
        object2 = new String[]{"--jdk-home", (String)this.getSystemPropertyInputs().getJavaHome().get()};
        object2 = CollectionsKt.listOf((Object[])object2);
        bl3 = false;
        CollectionsKt.addAll((Collection)object3, (Iterable)object2);
        object3 = arguments;
        object2 = new String[]{"--sdk-home", (String)this.getAndroidSdkHome().get()};
        object2 = CollectionsKt.listOf((Object[])object2);
        bl3 = false;
        CollectionsKt.addAll((Collection)object3, (Iterable)object2);
        object3 = this.getTextReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"textReportEnabled.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = this.getTextReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"textReportOutputFile.get()");
            this.add((List<String>)arguments, "--text", (RegularFile)object3);
        }
        if ((object3 = (RegularFile)this.getIntermediateTextReport().getOrNull()) != null) {
            object2 = object3;
            bl3 = false;
            bl2 = false;
            Object it2 = object2;
            bl = false;
            this.add((List<String>)arguments, "--text", (RegularFile)it2);
        }
        object3 = this.getHtmlReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"htmlReportEnabled.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = this.getHtmlReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"htmlReportOutputFile.get()");
            this.add((List<String>)arguments, "--html", (RegularFile)object3);
        }
        object3 = this.getXmlReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"xmlReportEnabled.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = this.getXmlReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"xmlReportOutputFile.get()");
            this.add((List<String>)arguments, "--xml", (RegularFile)object3);
        }
        object3 = this.getSarifReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sarifReportEnabled.get()");
        if (((Boolean)object3).booleanValue()) {
            object3 = this.getSarifReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sarifReportOutputFile.get()");
            this.add((List<String>)arguments, "--sarif", (RegularFile)object3);
        }
        object3 = this.getTextReportToStdOut().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"textReportToStdOut.get()");
        if (((Boolean)object3).booleanValue()) {
            this.add((List<String>)arguments, "--text", "stdout");
        }
        LinkedHashSet<String> models = new LinkedHashSet<String>(1);
        object2 = models;
        String string = ((Directory)this.getLintModelDirectory().get()).getAsFile().getAbsolutePath();
        bl2 = false;
        object2.add(string);
        for (File model : this.getDynamicFeatureLintModels()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getMainDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getAndroidTestDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getUnitTestDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        models.remove(this.getLintModelWriterTaskOutputPath().get());
        object2 = this.getCheckDependencies().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"checkDependencies.get()");
        boolean bl5 = (Boolean)object2 != false || models.size() == 1 + this.getDynamicFeatureLintModels().getFiles().size();
        boolean model22 = false;
        bl2 = false;
        if (!bl5) {
            boolean object4 = false;
            String string2 = "Library dependency models should not be an input unless check dependencies is being used.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Object object5 = arguments;
        String model22 = "--lint-model";
        bl2 = false;
        object5.add(model22);
        object5 = arguments;
        model22 = this.asLintPaths((Collection<String>)models);
        bl2 = false;
        object5.add(model22);
        for (Object check2 : (List)this.getCheckOnly().get()) {
            Collection collection = arguments;
            object4 = new String[]{"--check", check2};
            object4 = CollectionsKt.listOf((Object[])object4);
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object4);
        }
        check2 = this.getLintRulesJar().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)check2, (String)"lintRulesJar.files");
        Iterable $this$filter$iv = (Iterable)check2;
        boolean $i$f$filter = false;
        object4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl6 = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            String string3 = it.getAbsolutePath();
            collection.add(string3);
        }
        List rules2 = (List)destination$iv$iv;
        List<String> list = rules2;
        bl2 = false;
        if (!list.isEmpty()) {
            list = arguments;
            String string4 = "--lint-rule-jars";
            boolean bl8 = false;
            list.add(string4);
            list = arguments;
            string4 = this.asLintPaths(rules2);
            bl8 = false;
            list.add(string4);
        }
        list = this.getPrintStackTrace().get();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"printStackTrace.get()");
        if (((Boolean)((Object)list)).booleanValue()) {
            list = arguments;
            String string5 = "--stacktrace";
            boolean bl9 = false;
            list.add(string5);
        }
        list = arguments;
        Object object6 = new String[]{"--cache-dir", ((Directory)this.getLintCacheDirectory().get()).getAsFile().getAbsolutePath()};
        object6 = CollectionsKt.listOf((Object[])object6);
        boolean bl10 = false;
        CollectionsKt.addAll((Collection)list, (Iterable)object6);
        if (Intrinsics.areEqual((Object)this.getSystemPropertyInputs().getLintBaselinesContinue().getOrNull(), (Object)"true")) {
            list = arguments;
            object6 = "--continue-after-baseline-created";
            bl10 = false;
            list.add((String)object6);
        }
        this.add((List<String>)arguments, "--client-id", "gradle");
        this.add((List<String>)arguments, "--client-name", "AGP");
        list = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        this.add((List<String>)arguments, "--client-version", (String)((Object)list));
        list = Collections.unmodifiableList(arguments);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(arguments)");
        return list;
    }

    private final String asLintPaths(Collection<String> $this$asLintPaths) {
        return CollectionsKt.joinToString$default((Iterable)$this$asLintPaths, (CharSequence)";", null, (CharSequence)";", (int)0, null, null, (int)58, null);
    }

    private final void add(List<String> $this$add, String arg, RegularFile path) {
        $this$add.add(arg);
        String string = path.getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.asFile.absolutePath");
        $this$add.add(string);
    }

    private final void add(List<String> $this$add, String arg, String value) {
        $this$add.add(arg);
        $this$add.add(value);
    }

    private final void initializeOutputTypesConvention() {
        this.getTextReportEnabled().convention((Object)false);
        this.getHtmlReportEnabled().convention((Object)false);
        this.getXmlReportEnabled().convention((Object)false);
        this.getSarifReportEnabled().convention((Object)false);
        this.getTextReportToStdOut().convention((Object)false);
    }

    private final void finalizeOutputTypes() {
        this.getTextReportEnabled().disallowChanges();
        this.getHtmlReportEnabled().disallowChanges();
        this.getXmlReportEnabled().disallowChanges();
        this.getSarifReportEnabled().disallowChanges();
        this.getTextReportToStdOut().disallowChanges();
    }

    private final void initializeGlobalInputs(Project project2, boolean isAndroid) {
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroidGradlePluginVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"buildServiceRegistry");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Object[] objectArray = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        Provider sdkComponentsBuildService = objectArray;
        Property<String> property = this.getAndroidSdkHome();
        buildServiceRegistry$iv = sdkComponentsBuildService.flatMap((Transformer)initializeGlobalInputs.1.INSTANCE).map((Transformer)initializeGlobalInputs.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry$iv, (String)"sdkComponentsBuildService.flatMap { it.sdkDirectoryProvider }.map { it.asFile.absolutePath }");
        HasConfigurableValuesKt.setDisallowChanges(property, buildServiceRegistry$iv);
        HasConfigurableValuesKt.setDisallowChanges(this.getOffline(), project2.getGradle().getStartParameter().isOffline());
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), isAndroid);
        Property property2 = (Property)this.getLintCacheDirectory();
        buildServiceRegistry$iv = project2.getLayout().getBuildDirectory().dir("intermediates/lint-cache");
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry$iv, (String)"project.layout.buildDirectory.dir(\"${AndroidProject.FD_INTERMEDIATES}/lint-cache\")");
        HasConfigurableValuesKt.setDisallowChanges(property2, buildServiceRegistry$iv);
        BuildServiceRegistry buildServiceRegistry$iv2 = buildServiceRegistry;
        boolean $i$f$getBuildService22 = false;
        objectArray = buildServiceRegistry$iv2.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AndroidLocationsBuildService.class));
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)objectArray).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        Provider locationBuildService = provider2;
        objectArray = project2.fileTree((Object)locationBuildService.map((Transformer)initializeGlobalInputs.globalLintJarsInPrefsDir.1.INSTANCE));
        boolean bl = false;
        boolean bl2 = false;
        Object it = objectArray;
        boolean bl3 = false;
        String[] stringArray = new String[]{"*.jar"};
        it.include(stringArray);
        Object[] $i$f$getBuildService22 = objectArray;
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$getBuildService22, (String)"project.fileTree(locationBuildService.map {\n                it.prefsLocation.resolve(\"lint\")\n            }).also { it.include(\"*$DOT_JAR\") }");
        Object globalLintJarsInPrefsDir2 = $i$f$getBuildService22;
        $i$f$getBuildService22 = new Object[]{globalLintJarsInPrefsDir2};
        this.getGlobalRuleJars().from($i$f$getBuildService22);
        objectArray = project2.getProviders().environmentVariable(ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE).orElse((Object)"").map((Transformer)initializeGlobalInputs.globalLintJarsFromEnvVariable.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.providers.environmentVariable(ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE)\n                        .orElse(\"\")\n                        .map { it.split(File.pathSeparator).filter(String::isNotEmpty) }");
        Object globalLintJarsFromEnvVariable2 = objectArray;
        objectArray = new Object[]{globalLintJarsFromEnvVariable2};
        this.getGlobalRuleJars().from(objectArray);
        this.getGlobalRuleJars().disallowChanges();
        if (project2.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            HasConfigurableValuesKt.setDisallowChanges(this.getPrintStackTrace(), true);
        } else {
            Property<Boolean> property3 = this.getPrintStackTrace();
            objectArray = project2.getProviders().environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE).map((Transformer)initializeGlobalInputs.3.INSTANCE).orElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.providers.environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE)\n                    .map { it.equals(\"true\", ignoreCase = true) }.orElse(false)");
            HasConfigurableValuesKt.setDisallowChanges(property3, objectArray);
        }
        SystemPropertyInputs systemPropertyInputs = this.getSystemPropertyInputs();
        objectArray = project2.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.providers");
        systemPropertyInputs.initialize((ProviderFactory)objectArray, false);
        EnvironmentVariableInputs environmentVariableInputs = this.getEnvironmentVariableInputs();
        objectArray = project2.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.providers");
        environmentVariableInputs.initialize((ProviderFactory)objectArray, false);
    }

    public final void configureForStandalone(@NotNull Project project2, @NotNull ProjectOptions projectOptions, @NotNull JavaPluginConvention javaPluginConvention, @NotNull FileCollection customLintChecksConfig, @NotNull LintOptions lintOptions2, @NotNull Provider<Directory> partialResults, @NotNull File lintModelWriterTaskOutputDir, boolean fatalOnly, boolean autoFix) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)javaPluginConvention, (String)"javaPluginConvention");
        Intrinsics.checkNotNullParameter((Object)customLintChecksConfig, (String)"customLintChecksConfig");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        Intrinsics.checkNotNullParameter(partialResults, (String)"partialResults");
        Intrinsics.checkNotNullParameter((Object)lintModelWriterTaskOutputDir, (String)"lintModelWriterTaskOutputDir");
        this.initializeGlobalInputs(project2, false);
        this.setGroup("verification");
        this.setVariantName("");
        Property<AnalyticsService> property = this.getAnalyticsService();
        Object[] objectArray = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.gradle.sharedServices");
        Object[] buildServiceRegistry$iv = objectArray;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
        HasConfigurableValuesKt.setDisallowChanges(this.getAutoFix(), autoFix);
        if (autoFix) {
            Property<LintFixBuildService> property2 = this.getLintFixBuildService();
            buildServiceRegistry$iv = project2.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry$iv, (String)"project.gradle.sharedServices");
            $i$f$getBuildService = false;
            object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(LintFixBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
            property2.set(provider2);
        }
        this.getLintFixBuildService().disallowChanges();
        Property<LintClassLoaderBuildService> property3 = this.getLintClassLoaderBuildService();
        buildServiceRegistry$iv = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry$iv, (String)"project.gradle.sharedServices");
        $i$f$getBuildService = false;
        object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(LintClassLoaderBuildService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property3, provider2);
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckDependencies(), false);
        HasConfigurableValuesKt.setDisallowChanges(this.getReportOnly(), true);
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckOnly(), (Iterable)lintOptions2.getCheckOnly());
        this.getLintTool().initialize(project2, projectOptions);
        this.getProjectInputs().initializeForStandalone$gradle_core(project2, javaPluginConvention, lintOptions2, false);
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(this){
            final /* synthetic */ AndroidLintTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean isSatisfiedBy(Task it) {
                boolean bl;
                RegularFile regularFile = (RegularFile)this.this$0.getProjectInputs().getLintOptions().getBaselineFile().getOrNull();
                File file = regularFile == null ? null : regularFile.getAsFile();
                return file == null ? true : (bl = file.exists());
            }
        });
        this.getVariantInputs().initializeForStandalone$gradle_core(project2, javaPluginConvention, projectOptions, false, false);
        objectArray = new Object[]{customLintChecksConfig};
        HasConfigurableValuesKt.fromDisallowChanges(this.getLintRulesJar(), objectArray);
        Property property4 = (Property)this.getLintModelDirectory();
        objectArray = project2.getLayout().getBuildDirectory().dir("intermediates/" + this.getName() + "/android-lint-model");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.layout.buildDirectory.dir(\"intermediates/${this.name}/android-lint-model\")");
        HasConfigurableValuesKt.setDisallowChanges(property4, objectArray);
        HasConfigurableValuesKt.setDisallowChanges((Property)this.getPartialResults(), partialResults);
        HasConfigurableValuesKt.setDisallowChanges(this.getLintModelWriterTaskOutputPath(), lintModelWriterTaskOutputDir.getAbsolutePath());
        this.initializeOutputTypesConvention();
        if (!fatalOnly) {
            if (autoFix) {
                HasConfigurableValuesKt.setDisallowChanges(this.getTextReportToStdOut(), true);
                this.getOutputs().upToDateWhen((Spec)configureForStandalone.2.INSTANCE);
            } else {
                this.configureOutputSettings(lintOptions2);
            }
        }
        this.finalizeOutputTypes();
    }

    public static /* synthetic */ void configureForStandalone$default(AndroidLintTask androidLintTask, Project project2, ProjectOptions projectOptions, JavaPluginConvention javaPluginConvention, FileCollection fileCollection2, LintOptions lintOptions2, Provider provider2, File file, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        androidLintTask.configureForStandalone(project2, projectOptions, javaPluginConvention, fileCollection2, lintOptions2, (Provider<Directory>)provider2, file, bl, bl2);
    }

    private final void configureOutputSettings(LintOptions lintOptions2) {
        HasConfigurableValuesKt.setDisallowChanges(this.getTextReportEnabled(), lintOptions2.getTextReport());
        HasConfigurableValuesKt.setDisallowChanges(this.getHtmlReportEnabled(), lintOptions2.getHtmlReport());
        HasConfigurableValuesKt.setDisallowChanges(this.getXmlReportEnabled(), lintOptions2.getXmlReport());
        HasConfigurableValuesKt.setDisallowChanges(this.getSarifReportEnabled(), lintOptions2.getSarifReport());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction$LauncherParameters;", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "execute", "", "LauncherParameters", "gradle-core"})
    public static abstract class AndroidLintLauncherWorkAction
    implements WorkAction<LauncherParameters> {
        @Inject
        @NotNull
        public abstract WorkerExecutor getWorkerExecutor();

        public void execute() {
            LintFixBuildService lintFixBuildService = (LintFixBuildService)((LauncherParameters)this.getParameters()).getLintFixBuildService().getOrNull();
            WorkerExecutor workerExecutor = this.getWorkerExecutor();
            List list = (List)((LauncherParameters)this.getParameters()).getArguments().get();
            Boolean bl = (Boolean)((LauncherParameters)this.getParameters()).getAndroid().get();
            Boolean bl2 = (Boolean)((LauncherParameters)this.getParameters()).getFatalOnly().get();
            boolean bl3 = lintFixBuildService != null;
            RegularFile regularFile = (RegularFile)((LauncherParameters)this.getParameters()).getReturnValueOutputFile().getOrNull();
            File file = regularFile == null ? null : regularFile.getAsFile();
            LintTool lintTool = (LintTool)((LauncherParameters)this.getParameters()).getLintTool().get();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get()");
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get()");
            boolean bl4 = bl;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get()");
            lintTool.submit(workerExecutor, "com.android.tools.lint.Main", list, bl4, bl2, bl3, file);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction$LauncherParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "fatalOnly", "getFatalOnly", "lintFixBuildService", "Lcom/android/build/gradle/internal/lint/LintFixBuildService;", "getLintFixBuildService", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "returnValueOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
        public static abstract class LauncherParameters
        implements WorkParameters {
            @Nested
            @NotNull
            public abstract Property<LintTool> getLintTool();

            @NotNull
            public abstract ListProperty<String> getArguments();

            @NotNull
            public abstract Property<Boolean> getAndroid();

            @NotNull
            public abstract Property<Boolean> getFatalOnly();

            @NotNull
            public abstract Property<LintFixBuildService> getLintFixBuildService();

            @NotNull
            public abstract RegularFileProperty getReturnValueOutputFile();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "name", "getName", "reportOnly", "getReportOnly", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Companion", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        public SingleVariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = ComponentCreationConfig.DefaultImpls.computeTaskName$default(this.creationConfig, "lintReport", null, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return false;
        }

        @Override
        public boolean getAutoFix() {
            return false;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Run lint on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return this.creationConfig.getGlobalScope().getExtension().getLintOptions().isCheckDependencies() && !this.getVariant().getMain().getVariantType().isDynamicFeature();
        }

        @Override
        public boolean getReportOnly() {
            return this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_LINT_PARTIAL_ANALYSIS);
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            VariantCreationAction.Companion.registerLintIntermediateArtifacts$default(VariantCreationAction.Companion, taskProvider, this.creationConfig.getArtifacts(), false, this.creationConfig.getName(), 4, null);
            Companion.registerLintReportArtifacts(taskProvider, this.creationConfig.getArtifacts(), this.creationConfig.getName(), this.creationConfig.getServices().getProjectInfo().getReportsDir());
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.configureOutputSettings(this.creationConfig.getGlobalScope().getExtension().getLintOptions());
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$SingleVariantCreationAction$Companion;", "", "()V", "registerLintReportArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "variantName", "", "reportsDirectory", "Ljava/io/File;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public final void registerLintReportArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, @Nullable String variantName, @NotNull File reportsDirectory) {
                Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
                Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
                Intrinsics.checkNotNullParameter((Object)reportsDirectory, (String)"reportsDirectory");
                String name = Intrinsics.stringPlus((String)"lint-results", (Object)(variantName != null ? Intrinsics.stringPlus((String)"-", (Object)variantName) : ""));
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.1.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(Intrinsics.stringPlus((String)name, (Object)".txt")).on(InternalArtifactType.LINT_TEXT_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.2.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(Intrinsics.stringPlus((String)name, (Object)".html")).on(InternalArtifactType.LINT_HTML_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.3.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(Intrinsics.stringPlus((String)name, (Object)".xml")).on(InternalArtifactType.LINT_XML_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.4.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(Intrinsics.stringPlus((String)name, (Object)".sarif")).on(InternalArtifactType.LINT_SARIF_REPORT.INSTANCE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$FixSingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "name", "getName", "reportOnly", "getReportOnly", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "gradle-core"})
    public static final class FixSingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;

        public FixSingleVariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = ComponentCreationConfig.DefaultImpls.computeTaskName$default(this.creationConfig, "lintFix", null, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return false;
        }

        @Override
        public boolean getAutoFix() {
            return true;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Fix lint on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return this.creationConfig.getGlobalScope().getExtension().getLintOptions().isCheckDependencies() && !this.getVariant().getMain().getVariantType().isDynamicFeature();
        }

        @Override
        public boolean getReportOnly() {
            return this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_LINT_PARTIAL_ANALYSIS);
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            HasConfigurableValuesKt.setDisallowChanges(task.getTextReportToStdOut(), true);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "name", "getName", "reportOnly", "getReportOnly", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;

        public LintVitalCreationAction(@NotNull ConsumableCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(new VariantWithTests(variant2, null, null));
            this.name = ComponentCreationConfig.DefaultImpls.computeTaskName$default(this.creationConfig, "lintVitalReport", null, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return true;
        }

        @Override
        public boolean getAutoFix() {
            return false;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Run lint with only the fatal issues enabled on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return false;
        }

        @Override
        public boolean getReportOnly() {
            return this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_LINT_PARTIAL_ANALYSIS);
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            VariantCreationAction.Companion.registerLintIntermediateArtifacts(taskProvider, this.creationConfig.getArtifacts(), true, this.creationConfig.getName());
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0012\u0010\u0013\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "reportOnly", "getReportOnly", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "getVariant", "()Lcom/android/build/gradle/internal/lint/VariantWithTests;", "configure", "", "task", "configureOutputSettings", "Companion", "gradle-core"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintTask, ComponentCreationConfig> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VariantWithTests variant;

        public VariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super((ComponentCreationConfig)variant2.getMain());
            this.variant = variant2;
        }

        @NotNull
        public final VariantWithTests getVariant() {
            return this.variant;
        }

        @Override
        @NotNull
        public final Class<AndroidLintTask> getType() {
            return AndroidLintTask.class;
        }

        public abstract boolean getFatalOnly();

        public abstract boolean getAutoFix();

        @NotNull
        public abstract String getDescription();

        public abstract boolean getCheckDependencies();

        public abstract boolean getReportOnly();

        @Override
        public final void configure(@NotNull AndroidLintTask task) {
            Object[] objectArray;
            Object[] objectArray2;
            boolean $i$f$getBuildService;
            BuildServiceRegistry buildServiceRegistry$iv;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setGroup("verification");
            task.setDescription(this.getDescription());
            task.initializeGlobalInputs(this.creationConfig.getServices().getProjectInfo().getProject(), true);
            DirectoryProperty directoryProperty = task.getLintModelDirectory();
            VariantPathHelper variantPathHelper = this.variant.getMain().getPaths();
            Object[] objectArray3 = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"task.name");
            directoryProperty.set(variantPathHelper.getIncrementalDir((String)objectArray3));
            objectArray3 = new Object[]{this.creationConfig.getGlobalScope().getLocalCustomLintChecks()};
            task.getLintRulesJar().from(objectArray3);
            objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRulesJar().from(objectArray3);
            objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRulesJar().from(objectArray3);
            task.getLintRulesJar().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getFatalOnly(), this.getFatalOnly());
            HasConfigurableValuesKt.setDisallowChanges(task.getAutoFix(), this.getAutoFix());
            if (this.getAutoFix()) {
                Property<LintFixBuildService> property = task.getLintFixBuildService();
                buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
                $i$f$getBuildService = false;
                objectArray2 = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(LintFixBuildService.class));
                if (objectArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
                }
                objectArray = ((BuildServiceRegistration)objectArray2).getService();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
                property.set((Provider)objectArray);
            }
            task.getLintFixBuildService().disallowChanges();
            Property<LintClassLoaderBuildService> property = task.getLintClassLoaderBuildService();
            buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            $i$f$getBuildService = false;
            objectArray2 = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(LintClassLoaderBuildService.class));
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            objectArray = ((BuildServiceRegistration)objectArray2).getService();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buildServiceRegistry.registrations.getByName(getBuildServiceName(ServiceT::class.java)) as BuildServiceRegistration<ServiceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, objectArray);
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckDependencies(), this.getCheckDependencies());
            HasConfigurableValuesKt.setDisallowChanges(task.getReportOnly(), this.getReportOnly());
            task.getCheckOnly().set(this.creationConfig.getServices().provider((Function0)new Function0<Set<String>>(this){
                final /* synthetic */ VariantCreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Set<String> invoke() {
                    return VariantCreationAction.access$getCreationConfig$p(this.this$0).getGlobalScope().getExtension().getLintOptions().getCheckOnly();
                }
            }));
            task.getProjectInputs().initialize$gradle_core(this.variant, false);
            task.getOutputs().upToDateWhen((Spec)new Spec<Task>(task){
                final /* synthetic */ AndroidLintTask $task;
                {
                    this.$task = $task;
                }

                public final boolean isSatisfiedBy(Task it) {
                    boolean bl;
                    RegularFile regularFile = (RegularFile)this.$task.getProjectInputs().getLintOptions().getBaselineFile().getOrNull();
                    File file = regularFile == null ? null : regularFile.getAsFile();
                    return file == null ? true : (bl = file.exists());
                }
            });
            boolean hasDynamicFeatures = this.creationConfig.getGlobalScope().hasDynamicFeatures();
            boolean includeDynamicFeatureSourceProviders = !this.getReportOnly() && hasDynamicFeatures;
            VariantInputs.initialize$default(task.getVariantInputs(), this.variant, this.getCheckDependencies(), true, false, false, includeDynamicFeatureSourceProviders, 16, null);
            if (this.getReportOnly()) {
                Provider partialResults = this.getFatalOnly() ? this.creationConfig.getArtifacts().get(InternalArtifactType.LINT_VITAL_PARTIAL_RESULTS.INSTANCE) : this.creationConfig.getArtifacts().get(InternalArtifactType.LINT_PARTIAL_RESULTS.INSTANCE);
                task.getPartialResults().set(partialResults);
                if (hasDynamicFeatures) {
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, this.getFatalOnly() ? AndroidArtifacts.ArtifactType.LINT_VITAL_LINT_MODEL : AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getDynamicFeatureLintModels().from(objectArray);
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, this.getFatalOnly() ? AndroidArtifacts.ArtifactType.LINT_VITAL_PARTIAL_RESULTS : AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                    task.getDependencyPartialResults().from(objectArray);
                }
            }
            task.getPartialResults().disallowChanges();
            task.getDynamicFeatureLintModels().disallowChanges();
            if (this.getCheckDependencies()) {
                Object[] objectArray4;
                Object[] it;
                boolean bl;
                boolean bl2;
                objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                task.getMainDependencyLintModels().from(objectArray2);
                objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                task.getMainDependencyLintModels().from(objectArray2);
                objectArray2 = this.variant.getAndroidTest();
                if (objectArray2 != null) {
                    objectArray = objectArray2;
                    bl2 = false;
                    bl = false;
                    it = objectArray;
                    boolean bl3 = false;
                    objectArray4 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getAndroidTestDependencyLintModels().from(objectArray4);
                    objectArray4 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getAndroidTestDependencyLintModels().from(objectArray4);
                }
                objectArray2 = this.variant.getUnitTest();
                if (objectArray2 != null) {
                    objectArray = objectArray2;
                    bl2 = false;
                    bl = false;
                    it = objectArray;
                    boolean bl4 = false;
                    objectArray4 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getUnitTestDependencyLintModels().from(objectArray4);
                    objectArray4 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getUnitTestDependencyLintModels().from(objectArray4);
                }
                if (this.getReportOnly()) {
                    objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                    task.getDependencyPartialResults().from(objectArray2);
                    objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                    task.getDependencyPartialResults().from(objectArray2);
                }
            }
            task.getMainDependencyLintModels().disallowChanges();
            task.getAndroidTestDependencyLintModels().disallowChanges();
            task.getUnitTestDependencyLintModels().disallowChanges();
            task.getDependencyPartialResults().disallowChanges();
            task.getLintTool().initialize(this.creationConfig.getServices().getProjectInfo().getProject(), this.creationConfig.getServices().getProjectOptions());
            HasConfigurableValuesKt.setDisallowChanges(task.getLintModelWriterTaskOutputPath(), this.creationConfig.getArtifacts().getOutputPath$gradle_core((Artifact)InternalArtifactType.LINT_MODEL.INSTANCE, new String[0]).getAbsolutePath());
            if (this.getCheckDependencies() && !this.getReportOnly()) {
                task.getOutputs().upToDateWhen((Spec)configure.5.INSTANCE);
            }
            if (this.getAutoFix()) {
                task.getOutputs().upToDateWhen((Spec)configure.6.INSTANCE);
            }
            if (includeDynamicFeatureSourceProviders) {
                task.getOutputs().upToDateWhen((Spec)configure.7.INSTANCE);
            }
            task.initializeOutputTypesConvention();
            this.configureOutputSettings(task);
            task.finalizeOutputTypes();
        }

        public abstract void configureOutputSettings(@NotNull AndroidLintTask var1);

        @JvmStatic
        public static final void registerLintIntermediateArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, boolean fatalOnly, @Nullable String variantName) {
            Companion.registerLintIntermediateArtifacts(taskProvider, artifacts2, fatalOnly, variantName);
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(VariantCreationAction $this) {
            return $this.creationConfig;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction$Companion;", "", "()V", "registerLintIntermediateArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "fatalOnly", "", "variantName", "", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final void registerLintIntermediateArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, boolean fatalOnly, @Nullable String variantName) {
                Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
                Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
                String reportName = Intrinsics.stringPlus((String)"lint-results", (Object)(variantName != null ? Intrinsics.stringPlus((String)"-", (Object)variantName) : ""));
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintIntermediateArtifacts.1.INSTANCE).withName(Intrinsics.stringPlus((String)reportName, (Object)".txt")).on(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_INTERMEDIATE_TEXT_REPORT.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_INTERMEDIATE_TEXT_REPORT.INSTANCE);
                String returnValueName = Intrinsics.stringPlus((String)"return-value", (Object)(variantName != null ? Intrinsics.stringPlus((String)"-", (Object)variantName) : ""));
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintIntermediateArtifacts.2.INSTANCE).withName(Intrinsics.stringPlus((String)returnValueName, (Object)".txt")).on(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_RETURN_VALUE.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_RETURN_VALUE.INSTANCE);
            }

            public static /* synthetic */ void registerLintIntermediateArtifacts$default(Companion companion, TaskProvider taskProvider, ArtifactsImpl artifactsImpl, boolean bl, String string, int n, Object object) {
                if ((n & 4) != 0) {
                    bl = false;
                }
                if ((n & 8) != 0) {
                    string = null;
                }
                companion.registerLintIntermediateArtifacts((TaskProvider<AndroidLintTask>)taskProvider, artifactsImpl, bl, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$Companion;", "", "()V", "ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE", "", "LINT_CLASS_PATH", "LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

