/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.options.StringOption;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "()V", "execute", "", "invokeLintMainRunMethod", "", "classLoader", "Ljava/lang/ClassLoader;", "arguments", "", "", "runLint", "Companion", "LintWorkActionParameters", "gradle-core"})
public abstract class AndroidLintWorkAction
implements WorkAction<LintWorkActionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ERRNO_SUCCESS = 0;
    public static final int ERRNO_ERRORS = 1;
    private static final int ERRNO_USAGE = 2;
    private static final int ERRNO_EXISTS = 3;
    private static final int ERRNO_HELP = 4;
    private static final int ERRNO_INVALID_ARGS = 5;
    public static final int ERRNO_CREATED_BASELINE = 6;
    private static final int ERRNO_APPLIED_SUGGESTIONS = 7;
    @Nullable
    private static URLClassLoader _cachedClassLoader;
    @NotNull
    private static List<URI> cachedClassLoaderUris;

    public void execute() {
        File file;
        Logger logger = Logging.getLogger(this.getClass());
        List arguments = (List)((LintWorkActionParameters)this.getParameters()).getArguments().get();
        Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
        logger.debug(Intrinsics.stringPlus((String)"Running lint ", (Object)CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        if (!((Boolean)((LintWorkActionParameters)this.getParameters()).getRunInProcess().get()).booleanValue()) {
            logger.info("Max memory for Android Lint: {}m\n(can be configured by {}=2G in gradle.properties)", (Object)(Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024), (Object)StringOption.LINT_HEAP_SIZE.getPropertyName());
        }
        int execResult = this.runLint(arguments);
        logger.debug(Intrinsics.stringPlus((String)"Lint returned ", (Object)execResult));
        Object object = (RegularFile)((LintWorkActionParameters)this.getParameters()).getReturnValueOutputFile().getOrNull();
        if (object != null && (file = object.getAsFile()) != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            FilesKt.writeText$default((File)it, (String)String.valueOf(execResult), null, (int)2, null);
            if (AndroidLintTextOutputTask.Companion.getHANDLED_ERRORS().contains(execResult)) {
                return;
            }
        }
        object = ((LintWorkActionParameters)this.getParameters()).getAndroid().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.android.get()");
        boolean bl = (Boolean)object;
        object = ((LintWorkActionParameters)this.getParameters()).getFatalOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.fatalOnly.get()");
        Companion.maybeThrowException(execResult, bl, (Boolean)object);
    }

    private final int runLint(List<String> arguments) {
        ClassLoader classLoader = AndroidLintWorkAction.Companion.getClassloader((FileCollection)((LintWorkActionParameters)this.getParameters()).getClasspath());
        return this.invokeLintMainRunMethod(classLoader, arguments);
    }

    private final int invokeLintMainRunMethod(ClassLoader classLoader, List<String> arguments) {
        Class<?> cls = classLoader.loadClass((String)((LintWorkActionParameters)this.getParameters()).getMainClass().get());
        Class[] classArray = new Class[]{String[].class};
        Method method = cls.getMethod("run", classArray);
        Object lintMain = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object[] objectArray = new Object[1];
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        if (thisCollection$iv.toArray(new String[0]) == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = method.invoke(lintMain, objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int returnValue = (Integer)object;
        if (!((Boolean)((LintWorkActionParameters)this.getParameters()).getRunInProcess().get()).booleanValue()) {
            Companion.dispose();
        }
        return returnValue;
    }

    @JvmStatic
    public static final void maybeThrowException(int execResult, boolean android, boolean fatalOnly) {
        Companion.maybeThrowException(execResult, android, fatalOnly);
    }

    static {
        boolean bl = false;
        cachedClassLoaderUris = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "fatalOnly", "getFatalOnly", "mainClass", "getMainClass", "returnValueOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "runInProcess", "getRunInProcess", "gradle-core"})
    public static abstract class LintWorkActionParameters
    implements WorkParameters {
        @NotNull
        public abstract Property<String> getMainClass();

        @NotNull
        public abstract ListProperty<String> getArguments();

        @NotNull
        public abstract ConfigurableFileCollection getClasspath();

        @NotNull
        public abstract Property<Boolean> getAndroid();

        @NotNull
        public abstract Property<Boolean> getFatalOnly();

        @NotNull
        public abstract Property<Boolean> getRunInProcess();

        @NotNull
        public abstract RegularFileProperty getReturnValueOutputFile();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$Companion;", "", "()V", "ERRNO_APPLIED_SUGGESTIONS", "", "ERRNO_CREATED_BASELINE", "ERRNO_ERRORS", "ERRNO_EXISTS", "ERRNO_HELP", "ERRNO_INVALID_ARGS", "ERRNO_SUCCESS", "ERRNO_USAGE", "_cachedClassLoader", "Ljava/net/URLClassLoader;", "cachedClassLoaderUris", "", "Ljava/net/URI;", "createClassLoader", "classpath", "dispose", "", "getClassloader", "Ljava/lang/ClassLoader;", "Lorg/gradle/api/file/FileCollection;", "getErrorMessage", "", "android", "", "fatalOnly", "getPlatformClassLoader", "maybeThrowException", "execResult", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final synchronized ClassLoader getClassloader(FileCollection classpath) {
            void $this$mapTo$iv$iv;
            Object object = classpath.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classpath.files");
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                URI uRI = it.toURI();
                collection.add(uRI);
            }
            List uris = (List)destination$iv$iv;
            if (!Intrinsics.areEqual((Object)uris, (Object)cachedClassLoaderUris)) {
                cachedClassLoaderUris = uris;
                _cachedClassLoader = this.createClassLoader(uris);
            }
            object = _cachedClassLoader;
            Intrinsics.checkNotNull((Object)object);
            return (ClassLoader)object;
        }

        /*
         * WARNING - void declaration
         */
        private final URLClassLoader createClassLoader(List<URI> classpath) {
            void $this$mapTo$iv$iv;
            Logging.getLogger(AndroidLintWorkAction.class).info("Creating lint class loader.");
            Iterable $this$map$iv = classpath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                URI uRI = (URI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toURL();
                collection.add(uRL);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            URL[] classpathUrls = uRLArray;
            return new URLClassLoader(classpathUrls, this.getPlatformClassLoader());
        }

        private final ClassLoader getPlatformClassLoader() {
            Object object = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.ClassLoader");
            }
            return (ClassLoader)object;
        }

        public final synchronized void dispose() {
            Class<?> clazz;
            Object object = _cachedClassLoader;
            Class<?> clazz2 = clazz = object == null ? null : ((ClassLoader)object).loadClass("com.android.tools.lint.UastEnvironment");
            if (clazz != null && (object = clazz.getDeclaredMethod("disposeApplicationEnvironment", new Class[0])) != null) {
                ((Method)object).invoke(null, new Object[0]);
            }
        }

        @JvmStatic
        public final void maybeThrowException(int execResult, boolean android, boolean fatalOnly) {
            int n = execResult;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new RuntimeException(this.getErrorMessage(android, fatalOnly));
                }
                case 2: {
                    throw new IllegalStateException("Internal Error: Unexpected lint usage");
                }
                case 3: {
                    throw new RuntimeException("Unable to write lint output");
                }
                case 4: {
                    throw new IllegalStateException("Internal error: Unexpected lint help call");
                }
                case 5: {
                    throw new IllegalStateException("Internal error: Unexpected lint invalid arguments");
                }
                case 6: {
                    throw new RuntimeException("Aborting build since new baseline file was created");
                }
                case 7: {
                    throw new RuntimeException("Aborting build since sources were modified to apply quickfixes after compilation");
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Internal error: unexpected lint return value ", (Object)execResult));
                }
            }
        }

        private final String getErrorMessage(boolean android, boolean fatalOnly) {
            return !android ? "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or create a baseline to see only new errors:\n```\nlint {\n    baseline = file(\"lint-baseline.xml\")\n}\n```\n\nFor more details, see https://developer.android.com/studio/write/lint#snapshot" : (fatalOnly ? "Lint found fatal errors while assembling a release target.\n\nFix the issues identified by lint, or create a baseline to see only new errors:\n```\nandroid {\n    lint {\n        baseline = file(\"lint-baseline.xml\")\n    }\n}\n```\n\nFor more details, see https://developer.android.com/studio/write/lint#snapshot" : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or create a baseline to see only new errors:\n```\nandroid {\n    lint {\n        baseline = file(\"lint-baseline.xml\")\n    }\n}\n```\n\nFor more details, see https://developer.android.com/studio/write/lint#snapshot");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

