/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.transform.Format;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.InternalMultipleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.D8BundleMainDexListTaskKt;
import com.android.build.gradle.internal.tasks.ProguardConfigurableTask;
import com.android.build.gradle.internal.tasks.R8Task;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.dexing.MainDexListConfig;
import com.android.builder.dexing.ProguardConfig;
import com.android.builder.dexing.ProguardOutputFiles;
import com.android.builder.dexing.R8OutputType;
import com.android.builder.dexing.R8Tool;
import com.android.builder.dexing.ToolConfig;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.android.zipflinger.ZipArchive;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 V2\u00020\u0001:\u0002VWB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010O\u001a\u00020PH\u0014J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u0002090RH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0014\u0010)\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u0014\u0010+\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u0014\u0010-\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0010R\u0014\u0010/\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0014\u00101\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\fR\u0014\u00103\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0010R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0015R\u001a\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015R\u0014\u0010;\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\fR\u0014\u0010=\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\fR\u0014\u0010?\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\bR\u0014\u0010A\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\fR,\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130C2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130C8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\bR\u0014\u0010I\u001a\u00020J8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0015\u00a8\u0006X"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task;", "Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "baseDexDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseDexDir", "()Lorg/gradle/api/file/DirectoryProperty;", "baseJar", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseJar", "()Lorg/gradle/api/file/RegularFileProperty;", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "coreLibDesugarConfig", "Lorg/gradle/api/provider/Property;", "", "getCoreLibDesugarConfig", "()Lorg/gradle/api/provider/Property;", "debuggable", "", "getDebuggable", "<set-?>", "Lcom/android/builder/dexing/DexingType;", "dexingType", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "disableMinification", "getDisableMinification", "disableTreeShaking", "getDisableTreeShaking", "duplicateClassesCheck", "getDuplicateClassesCheck", "enableDesugaring", "getEnableDesugaring", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "featureClassJars", "getFeatureClassJars", "featureDexDir", "getFeatureDexDir", "featureJavaResourceJars", "getFeatureJavaResourceJars", "featureJavaResourceOutputDir", "getFeatureJavaResourceOutputDir", "mainDexListOutput", "getMainDexListOutput", "mainDexRulesFiles", "getMainDexRulesFiles", "minSdkVersion", "", "getMinSdkVersion", "multiDexKeepFile", "Ljava/io/File;", "getMultiDexKeepFile", "multiDexKeepProguard", "getMultiDexKeepProguard", "outputClasses", "getOutputClasses", "outputDex", "getOutputDex", "outputResources", "getOutputResources", "", "proguardConfigurations", "getProguardConfigurations", "()Ljava/util/List;", "projectOutputKeepRules", "getProjectOutputKeepRules", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "getProviderFactory", "()Lorg/gradle/api/provider/ProviderFactory;", "useFullR8", "getUseFullR8", "doTaskAction", "", "getMissingKeepRulesOutput", "Lorg/gradle/api/provider/Provider;", "getProguardConfigurationOutput", "getProguardSeedsOutput", "getProguardUsageOutput", "Companion", "CreationAction", "gradle-core"})
public abstract class R8Task
extends ProguardConfigurableTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<String> proguardConfigurations;
    private DexingType dexingType;

    @Inject
    public R8Task(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        super(projectLayout);
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableDesugaring();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract Property<File> getMultiDexKeepFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getMultiDexKeepProguard();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getMainDexRulesFiles();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Internal
    @NotNull
    public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();

    @Input
    @NotNull
    public abstract Property<Integer> getMinSdkVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebuggable();

    @Input
    @NotNull
    public abstract Property<Boolean> getDisableTreeShaking();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getDuplicateClassesCheck();

    @Input
    @NotNull
    public abstract Property<Boolean> getDisableMinification();

    @Input
    @NotNull
    public final List<String> getProguardConfigurations() {
        List<String> list = this.proguardConfigurations;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"proguardConfigurations");
        throw null;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getUseFullR8();

    @Input
    @NotNull
    public final DexingType getDexingType() {
        DexingType dexingType = this.dexingType;
        if (dexingType != null) {
            return dexingType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dexingType");
        throw null;
    }

    @Optional
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getFeatureClassJars();

    @Optional
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getFeatureJavaResourceJars();

    @Optional
    @Classpath
    @NotNull
    public abstract RegularFileProperty getBaseJar();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCoreLibDesugarConfig();

    @Optional
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputClasses();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDex();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getProjectOutputKeepRules();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getBaseDexDir();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFeatureDexDir();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFeatureJavaResourceOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputResources();

    @OutputFile
    @NotNull
    public final Provider<File> getProguardSeedsOutput() {
        Provider provider2 = this.getMappingFile().flatMap((Transformer)new Transformer<Provider<? extends File>, RegularFile>(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider((Callable)new Callable<File>(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"seeds.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getProguardSeedsOutput(): Provider<File> =\n            mappingFile.flatMap {\n                providerFactory.provider { it.asFile.resolveSibling(\"seeds.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getProguardUsageOutput() {
        Provider provider2 = this.getMappingFile().flatMap((Transformer)new Transformer<Provider<? extends File>, RegularFile>(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider((Callable)new Callable<File>(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"usage.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getProguardUsageOutput(): Provider<File> =\n            mappingFile.flatMap {\n                providerFactory.provider { it.asFile.resolveSibling(\"usage.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getProguardConfigurationOutput() {
        Provider provider2 = this.getMappingFile().flatMap((Transformer)new Transformer<Provider<? extends File>, RegularFile>(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider((Callable)new Callable<File>(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"configuration.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getProguardConfigurationOutput(): Provider<File> =\n            mappingFile.flatMap {\n                providerFactory.provider { it.asFile.resolveSibling(\"configuration.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getMissingKeepRulesOutput() {
        Provider provider2 = this.getMappingFile().flatMap((Transformer)new Transformer<Provider<? extends File>, RegularFile>(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider((Callable)new Callable<File>(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"missing_rules.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getMissingKeepRulesOutput(): Provider<File> =\n            mappingFile.flatMap {\n                providerFactory.provider { it.asFile.resolveSibling(\"missing_rules.txt\") }\n            }");
        return provider2;
    }

    @Optional
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMainDexListOutput();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        List it;
        Object object;
        Property property;
        Object object2 = (VariantType)this.getVariantType().getOrNull();
        if (Intrinsics.areEqual((Object)(object2 == null ? null : Boolean.valueOf(object2.isAar())), (Object)true)) {
            property = (Property)this.getOutputClasses();
        } else {
            object2 = this.getIncludeFeaturesInScopes().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"includeFeaturesInScopes.get()");
            property = (Boolean)object2 != false ? (Property)this.getBaseDexDir() : (Property)this.getOutputDex();
        }
        Property output2 = property;
        List featureJavaResourceJarsList = CollectionsKt.toList((Iterable)((Iterable)this.getFeatureJavaResourceJars()));
        Object object3 = featureJavaResourceJarsList;
        boolean bl = false;
        if (!object3.isEmpty()) {
            bl = false;
            Set paths = new LinkedHashSet();
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)this.getResources())), (Iterable)featureJavaResourceJarsList);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                Closeable closeable = (Closeable)new ZipArchive(file.toPath());
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    ZipArchive jar = (ZipArchive)closeable;
                    boolean bl5 = false;
                    List list = jar.listEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jar.listEntries()");
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String path = (String)element$iv2;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                        if (StringsKt.startsWith$default((String)path, (String)"META-INF/services/", (boolean)false, (int)2, null) || paths.add(path)) continue;
                        throw new RuntimeException("Multiple dynamic-feature and/or base APKs will contain entries with the same path, '" + path + "', which can cause unexpected behavior or errors at runtime. Please consider using android.packagingOptions in the dynamic-feature and/or application modules to ensure that only one of the APKs contains this path.");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        List list = CollectionsKt.toList((Iterable)((Iterable)this.getBootClasspath()));
        object3 = this.getMinSdkVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"minSdkVersion.get()");
        int n = ((Number)object3).intValue();
        object3 = this.getDebuggable().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"debuggable.get()");
        boolean bl7 = (Boolean)object3;
        object3 = this.getEnableDesugaring().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"enableDesugaring.get()");
        boolean bl8 = (Boolean)object3;
        object3 = this.getDisableTreeShaking().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"disableTreeShaking.get()");
        boolean bl9 = (Boolean)object3;
        object3 = this.getDisableMinification().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"disableMinification.get()");
        boolean bl10 = false;
        List list2 = new ArrayList();
        bl = false;
        boolean bl11 = false;
        List list3 = list2;
        boolean bl12 = (Boolean)object3;
        boolean bl13 = bl9;
        boolean bl14 = bl8;
        boolean bl15 = bl7;
        int n2 = n;
        List list4 = list;
        Companion companion = Companion;
        boolean bl16 = false;
        if (this.getMultiDexKeepFile().isPresent()) {
            object = this.getMultiDexKeepFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"multiDexKeepFile.get()");
            it.add(object);
        }
        Object object4 = Unit.INSTANCE;
        boolean bl17 = false;
        Object object5 = new ArrayList();
        bl = false;
        bl11 = false;
        it = object5;
        object4 = list2;
        boolean bl18 = false;
        it.addAll(CollectionsKt.toList((Iterable)((Iterable)this.getMainDexRulesFiles())));
        if (this.getMultiDexKeepProguard().isPresent()) {
            object = ((RegularFile)this.getMultiDexKeepProguard().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"multiDexKeepProguard.get().asFile");
            it.add(object);
        }
        Unit unit = Unit.INSTANCE;
        List list5 = object5;
        File file = this.getTestedMappingFile().isEmpty() ? (File)null : this.getTestedMappingFile().getSingleFile();
        Collection<File> collection = this.reconcileDefaultProguardFile$gradle_core((FileCollection)this.getConfigurationFiles(), (Provider<Directory>)((Provider)this.getExtractedDefaultProguardFile()));
        List<String> list6 = this.getProguardConfigurations();
        VariantType variantType = (VariantType)this.getVariantType().getOrNull();
        object5 = this.getErrorFormatMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"errorFormatMode.get()");
        SyncOptions.ErrorFormatMode errorFormatMode = (SyncOptions.ErrorFormatMode)((Object)object5);
        object5 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"logger");
        MessageReceiver messageReceiver = new MessageReceiverImpl(errorFormatMode, (Logger)object5);
        DexingType dexingType = this.getDexingType();
        object5 = this.getUseFullR8().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"useFullR8.get()");
        boolean bl19 = (Boolean)object5;
        object5 = this.getReferencedClasses().plus((FileCollection)this.getReferencedResources());
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"referencedClasses + referencedResources");
        List list7 = CollectionsKt.toList((Iterable)((Iterable)object5));
        object5 = this.getIncludeFeaturesInScopes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"includeFeaturesInScopes.get()");
        List list8 = (Boolean)object5 != false ? CollectionsKt.listOf((Object)((RegularFile)this.getBaseJar().get()).getAsFile()) : CollectionsKt.toList((Iterable)((Iterable)this.getClasses()));
        List list9 = CollectionsKt.toList((Iterable)((Iterable)this.getResources()));
        object5 = ((RegularFile)this.getMappingFile().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"mappingFile.get().asFile.toPath()");
        Object object6 = object5;
        object5 = ((File)this.getProguardSeedsOutput().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getProguardSeedsOutput().get().toPath()");
        Object object7 = object5;
        object5 = ((File)this.getProguardUsageOutput().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getProguardUsageOutput().get().toPath()");
        Object object8 = object5;
        object5 = ((File)this.getProguardConfigurationOutput().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getProguardConfigurationOutput().get().toPath()");
        Object object9 = object5;
        object5 = ((File)this.getMissingKeepRulesOutput().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"getMissingKeepRulesOutput().get().toPath()");
        ProguardOutputFiles proguardOutputFiles = new ProguardOutputFiles((Path)object6, (Path)object7, (Path)object8, (Path)object9, (Path)object5);
        object5 = ((FileSystemLocation)output2.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"output.get().asFile");
        Object object10 = object5;
        object5 = ((RegularFile)this.getOutputResources().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"outputResources.get().asFile");
        Object object11 = object5;
        object5 = (RegularFile)this.getMainDexListOutput().getOrNull();
        companion.shrink(list4, n2, bl15, bl14, bl13, bl12, (List<? extends File>)object4, list5, file, collection, list6, variantType, messageReceiver, dexingType, bl19, list7, list8, list9, proguardOutputFiles, (File)object10, (File)object11, object5 == null ? null : object5.getAsFile(), CollectionsKt.toList((Iterable)((Iterable)this.getFeatureClassJars())), featureJavaResourceJarsList, (File)this.getFeatureDexDir().getAsFile().getOrNull(), (File)this.getFeatureJavaResourceOutputDir().getAsFile().getOrNull(), (String)this.getCoreLibDesugarConfig().getOrNull(), (File)this.getProjectOutputKeepRules().getAsFile().getOrNull());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\fH\u0014J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\fH\u0014J\b\u0010\u001d\u001a\u00020\u0016H\u0014J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$CreationAction;", "Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/R8Task;", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "creationConfig", "isTestApplication", "", "addCompileRClass", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;ZZ)V", "disableMinification", "disableTreeShaking", "name", "", "getName", "()Ljava/lang/String;", "proguardConfigurations", "", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "dontWarn", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "keep", "keepAttributes", "setActions", "actions", "Lcom/android/build/gradle/internal/PostprocessingFeatures;", "setBootClasspathForCodeShrinker", "gradle-core"})
    public static final class CreationAction
    extends ProguardConfigurableTask.CreationAction<R8Task, ConsumableCreationConfig> {
        @NotNull
        private final Class<R8Task> type;
        @NotNull
        private final String name;
        private boolean disableTreeShaking;
        private boolean disableMinification;
        @NotNull
        private final List<String> proguardConfigurations;

        public CreationAction(@NotNull ConsumableCreationConfig creationConfig, boolean isTestApplication, boolean addCompileRClass) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, isTestApplication, addCompileRClass);
            this.type = R8Task.class;
            this.name = this.computeTaskName("minify", "WithR8");
            boolean bl = false;
            this.proguardConfigurations = new ArrayList();
        }

        public /* synthetic */ CreationAction(ConsumableCreationConfig consumableCreationConfig, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consumableCreationConfig, bl, bl2);
        }

        @Override
        @NotNull
        public Class<R8Task> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<R8Task> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            if (this.getVariantType().isAar()) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("shrunkClasses.jar").on(InternalArtifactType.SHRUNK_CLASSES.INSTANCE);
            } else if (((ConsumableCreationConfig)this.creationConfig).getVariantScope().consumesFeatureJars()) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).on(InternalArtifactType.BASE_DEX.INSTANCE);
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.3.INSTANCE).on(InternalArtifactType.FEATURE_DEX.INSTANCE);
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.4.INSTANCE).on(InternalArtifactType.FEATURE_SHRUNK_JAVA_RES.INSTANCE);
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsShrinkDesugarLibrary()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.5.INSTANCE).on(InternalArtifactType.DESUGAR_LIB_PROJECT_KEEP_RULES.INSTANCE);
                }
            } else {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWith((Function1)handleProvider.6.INSTANCE).toAppendTo((Artifact.Multiple)InternalMultipleArtifactType.DEX.INSTANCE);
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsShrinkDesugarLibrary()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.7.INSTANCE).on(InternalArtifactType.DESUGAR_LIB_PROJECT_KEEP_RULES.INSTANCE);
                }
            }
            ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.8.INSTANCE).withName("shrunkJavaRes.jar").on(InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE);
            if (this.creationConfig instanceof ApkCreationConfig) {
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsMainDexListForBundle()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.9.INSTANCE).withName("mainDexList.txt").on(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE.INSTANCE);
                } else if (((ConsumableCreationConfig)this.creationConfig).getDexingType().getNeedsMainDexList()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.10.INSTANCE).withName("mainDexList.txt").on(InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST.INSTANCE);
                }
            }
        }

        @Override
        public void configure(@NotNull R8Task task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((ProguardConfigurableTask)task);
            ArtifactsImpl artifacts2 = ((ConsumableCreationConfig)this.creationConfig).getArtifacts();
            task.getEnableDesugaring().set((Object)(((ConsumableCreationConfig)this.creationConfig).getJava8LangSupportType() == VariantScope.Java8LangSupport.R8 && !this.getVariantType().isAar() ? 1 : 0));
            this.setBootClasspathForCodeShrinker(task);
            task.getMinSdkVersion().set((Object)((ConsumableCreationConfig)this.creationConfig).getMinSdkVersion().getApiLevel());
            HasConfigurableValuesKt.setDisallowChanges(task.getDebuggable(), ((ConsumableCreationConfig)this.creationConfig).getDebuggable());
            task.getDisableTreeShaking().set((Object)this.disableTreeShaking);
            task.getDisableMinification().set((Object)this.disableMinification);
            task.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions()));
            task.dexingType = ((ConsumableCreationConfig)this.creationConfig).getDexingType();
            HasConfigurableValuesKt.setDisallowChanges(task.getUseFullR8(), ((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.FULL_R8));
            if (!((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.R8_FAIL_ON_MISSING_CLASSES)) {
                this.proguardConfigurations.add("-ignorewarnings");
            }
            task.proguardConfigurations = this.proguardConfigurations;
            if (this.getVariantType().isApk()) {
                Object[] objectArray = new Object[]{artifacts2.get(InternalArtifactType.DUPLICATE_CLASSES_CHECK.INSTANCE)};
                task.getDuplicateClassesCheck().from(objectArray);
                objectArray = new Object[]{artifacts2.getAll((MultipleArtifact)MultipleArtifact.MULTIDEX_KEEP_PROGUARD.INSTANCE)};
                task.getMainDexRulesFiles().from(objectArray);
                if (((ConsumableCreationConfig)this.creationConfig).getDexingType().getNeedsMainDexList() && !((ConsumableCreationConfig)this.creationConfig).getServices().getProjectInfo().getExtension().getAaptOptions().getNamespaced()) {
                    objectArray = new Object[]{artifacts2.get(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES.INSTANCE)};
                    task.getMainDexRulesFiles().from(objectArray);
                }
                if (this.creationConfig instanceof ApkCreationConfig) {
                    HasConfigurableValuesKt.setDisallowChanges(task.getMultiDexKeepFile(), ((ApkCreationConfig)this.creationConfig).getMultiDexKeepFile());
                }
                if (((ConsumableCreationConfig)this.creationConfig).getVariantScope().consumesFeatureJars()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MODULE_AND_RUNTIME_DEPS_CLASSES.INSTANCE, (Property)task.getBaseJar());
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ConsumableCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_CLASSES, null, 8, null)};
                    task.getFeatureClassJars().from(objectArray);
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ConsumableCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_JAVA_RES, null, 8, null)};
                    task.getFeatureJavaResourceJars().from(objectArray);
                }
                if (((ConsumableCreationConfig)this.creationConfig).isCoreLibraryDesugaringEnabled()) {
                    task.getCoreLibDesugarConfig().set(DesugarLibUtils.getDesugarLibConfig(((ConsumableCreationConfig)this.creationConfig).getServices().getProjectInfo().getProject()));
                }
            }
            task.getBaseJar().disallowChanges();
            task.getFeatureClassJars().disallowChanges();
            task.getFeatureJavaResourceJars().disallowChanges();
        }

        @Override
        protected void keep(@NotNull String keep) {
            Intrinsics.checkNotNullParameter((Object)keep, (String)"keep");
            this.proguardConfigurations.add(Intrinsics.stringPlus((String)"-keep ", (Object)keep));
        }

        @Override
        protected void keepAttributes() {
            this.proguardConfigurations.add("-keepattributes *");
        }

        @Override
        protected void dontWarn(@NotNull String dontWarn) {
            Intrinsics.checkNotNullParameter((Object)dontWarn, (String)"dontWarn");
            this.proguardConfigurations.add(Intrinsics.stringPlus((String)"-dontwarn ", (Object)dontWarn));
        }

        @Override
        protected void setActions(@NotNull PostprocessingFeatures actions) {
            Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
            this.disableTreeShaking = !actions.isRemoveUnusedCode();
            boolean bl = this.disableMinification = !actions.isObfuscate();
            if (!actions.isOptimize()) {
                this.proguardConfigurations.add("-dontoptimize");
            }
        }

        private final void setBootClasspathForCodeShrinker(R8Task task) {
            Object[] objectArray = ((ConsumableCreationConfig)this.creationConfig).getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"creationConfig.globalScope.extension.compileOptions.targetCompatibility");
            Object[] javaTarget = objectArray;
            objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobalScope().getFullBootClasspath()};
            task.getBootClasspath().from(objectArray);
            if (javaTarget.isJava9Compatible()) {
                objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobalScope().getVersionedSdkLoader().flatMap((Transformer)setBootClasspathForCodeShrinker.1.INSTANCE)};
                task.getBootClasspath().from(objectArray);
            } else if (javaTarget.isJava8Compatible()) {
                objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobalScope().getVersionedSdkLoader().flatMap((Transformer)setBootClasspathForCodeShrinker.2.INSTANCE)};
                task.getBootClasspath().from(objectArray);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u00b0\u0002\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010/\u001a\u0004\u0018\u00010\u001b2\b\u00100\u001a\u0004\u0018\u00010\u0007\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$Companion;", "", "()V", "filterMissingFiles", "", "Ljava/nio/file/Path;", "files", "Ljava/io/File;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "shrink", "", "bootClasspath", "minSdkVersion", "", "isDebuggable", "", "enableDesugaring", "disableTreeShaking", "disableMinification", "mainDexListFiles", "mainDexRulesFiles", "inputProguardMapping", "proguardConfigurationFiles", "", "proguardConfigurations", "", "", "variantType", "Lcom/android/builder/core/VariantType;", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "useFullR8", "referencedInputs", "classes", "resources", "proguardOutputFiles", "Lcom/android/builder/dexing/ProguardOutputFiles;", "output", "outputResources", "mainDexListOutput", "featureClassJars", "featureJavaResourceJars", "featureDexDir", "featureJavaResourceOutputDir", "libConfiguration", "outputKeepRulesDir", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void shrink(@NotNull List<? extends File> bootClasspath, int minSdkVersion2, boolean isDebuggable, boolean enableDesugaring, boolean disableTreeShaking, boolean disableMinification, @NotNull List<? extends File> mainDexListFiles, @NotNull List<? extends File> mainDexRulesFiles, @Nullable File inputProguardMapping, @NotNull Collection<? extends File> proguardConfigurationFiles, @NotNull List<String> proguardConfigurations, @Nullable VariantType variantType, @NotNull MessageReceiver messageReceiver, @NotNull DexingType dexingType, boolean useFullR8, @NotNull List<? extends File> referencedInputs, @NotNull List<? extends File> classes, @NotNull List<? extends File> resources, @NotNull ProguardOutputFiles proguardOutputFiles, @NotNull File output2, @NotNull File outputResources, @Nullable File mainDexListOutput, @NotNull List<? extends File> featureClassJars, @NotNull List<? extends File> featureJavaResourceJars, @Nullable File featureDexDir, @Nullable File featureJavaResourceOutputDir, @Nullable String libConfiguration, @Nullable File outputKeepRulesDir) {
            Iterable<Path> iterable;
            Collection<Path> collection;
            Iterable<Path> iterable2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            MainDexListConfig mainDexListConfig;
            Iterable<Path> iterable3;
            Object object;
            Collection<Path> collection2;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(bootClasspath, (String)"bootClasspath");
            Intrinsics.checkNotNullParameter(mainDexListFiles, (String)"mainDexListFiles");
            Intrinsics.checkNotNullParameter(mainDexRulesFiles, (String)"mainDexRulesFiles");
            Intrinsics.checkNotNullParameter(proguardConfigurationFiles, (String)"proguardConfigurationFiles");
            Intrinsics.checkNotNullParameter(proguardConfigurations, (String)"proguardConfigurations");
            Intrinsics.checkNotNullParameter((Object)messageReceiver, (String)"messageReceiver");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            Intrinsics.checkNotNullParameter(referencedInputs, (String)"referencedInputs");
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(resources, (String)"resources");
            Intrinsics.checkNotNullParameter((Object)proguardOutputFiles, (String)"proguardOutputFiles");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)outputResources, (String)"outputResources");
            Intrinsics.checkNotNullParameter(featureClassJars, (String)"featureClassJars");
            Intrinsics.checkNotNullParameter(featureJavaResourceJars, (String)"featureJavaResourceJars");
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(R8Task.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(R8Task::class.java)");
            LoggerWrapper logger = loggerWrapper;
            logger.info(StringsKt.trimMargin$default((String)("\n                |R8 is a new Android code shrinker. If you experience any issues, please file a bug at\n                |https://issuetracker.google.com, using 'Shrinker (R8)' as component name.\n                |Current version is: " + R8Tool.getR8Version() + ".\n                |"), null, (int)1, null), new Object[0]);
            R8OutputType r8OutputType = null;
            Format outputFormat = null;
            VariantType variantType2 = variantType;
            if (Intrinsics.areEqual((Object)(variantType2 == null ? null : Boolean.valueOf(variantType2.isAar())), (Object)true)) {
                r8OutputType = R8OutputType.CLASSES;
                outputFormat = Format.JAR;
            } else {
                r8OutputType = R8OutputType.DEX;
                outputFormat = Format.DIRECTORY;
            }
            FileUtils.deleteIfExists((File)outputResources);
            variantType2 = outputFormat;
            int n = WhenMappings.$EnumSwitchMapping$0[variantType2.ordinal()];
            switch (n) {
                case 1: {
                    Unit unit;
                    Unit unit2;
                    File it;
                    boolean bl;
                    boolean bl2;
                    File file;
                    Unit unit3;
                    FileUtils.cleanOutputDir((File)output2);
                    File file2 = featureDexDir;
                    if (file2 == null) {
                        unit3 = null;
                    } else {
                        file = file2;
                        bl2 = false;
                        bl = false;
                        it = file;
                        boolean bl3 = false;
                        FileUtils.cleanOutputDir((File)it);
                        unit3 = Unit.INSTANCE;
                    }
                    file2 = featureJavaResourceOutputDir;
                    if (file2 == null) {
                        unit2 = null;
                    } else {
                        file = file2;
                        bl2 = false;
                        bl = false;
                        it = file;
                        boolean bl4 = false;
                        FileUtils.cleanOutputDir((File)it);
                        unit2 = Unit.INSTANCE;
                    }
                    file2 = outputKeepRulesDir;
                    if (file2 == null) {
                        unit = null;
                        break;
                    }
                    file = file2;
                    bl2 = false;
                    bl = false;
                    it = file;
                    boolean bl5 = false;
                    FileUtils.cleanOutputDir((File)it);
                    unit = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    FileUtils.deleteIfExists((File)output2);
                }
            }
            ToolConfig toolConfig = new ToolConfig(minSdkVersion2, isDebuggable, disableTreeShaking, !enableDesugaring, disableMinification, r8OutputType);
            Object $this$map$iv2 = proguardConfigurationFiles;
            boolean $i$f$map = false;
            Iterable iterable4 = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Iterator iterator2 = (File)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                object = it.toPath();
                collection2.add((Path)object);
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv2 = inputProguardMapping;
            Path path = $this$map$iv2 == null ? null : ((File)$this$map$iv2).toPath();
            ProguardOutputFiles proguardOutputFiles2 = proguardOutputFiles;
            List<String> list = proguardConfigurations;
            Path path2 = path;
            List list2 = collection2;
            ProguardConfig proguardConfig = new ProguardConfig(list2, path2, list, proguardOutputFiles2);
            if (dexingType == DexingType.LEGACY_MULTIDEX) {
                Iterable $this$mapTo$iv$iv3;
                Object $this$map$iv3 = mainDexRulesFiles;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it;
                    File bl = (File)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl6 = false;
                    object = it.toPath();
                    collection2.add((Path)object);
                }
                collection2 = (List)destination$iv$iv2;
                $this$map$iv3 = mainDexListFiles;
                $i$f$map2 = false;
                $this$mapTo$iv$iv3 = $this$map$iv3;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    File it = (File)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    iterable3 = it.toPath();
                    object.add(iterable3);
                }
                object = (List)destination$iv$iv2;
                $this$map$iv3 = mainDexListOutput;
                Path path3 = $this$map$iv3 == null ? null : ((File)$this$map$iv3).toPath();
                List<String> list3 = D8BundleMainDexListTaskKt.getPlatformRules();
                Collection collection3 = (Collection)object;
                Collection<Path> collection4 = collection2;
                mainDexListConfig = new MainDexListConfig(collection4, collection3, list3, path3);
            } else {
                mainDexListConfig = new MainDexListConfig(null, null, null, null, 15, null);
            }
            MainDexListConfig mainDexListConfig2 = mainDexListConfig;
            Object $i$f$map3 = outputKeepRulesDir;
            File outputKeepRulesFile = $i$f$map3 == null ? null : FilesKt.resolve((File)$i$f$map3, (String)"output");
            Collection collection5 = this.filterMissingFiles(classes, logger);
            $i$f$map3 = output2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map3, (String)"output.toPath()");
            Comparable<File> comparable = $i$f$map3;
            Collection collection6 = this.filterMissingFiles(resources, logger);
            $i$f$map3 = outputResources.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map3, (String)"outputResources.toPath()");
            Comparable<File> comparable2 = $i$f$map3;
            $i$f$map3 = bootClasspath;
            object = comparable2;
            collection2 = collection6;
            Comparable<File> comparable3 = comparable;
            Collection collection7 = collection5;
            boolean $i$f$map4 = false;
            void destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File bl = (File)item$iv$iv;
                iterable3 = destination$iv$iv4;
                boolean bl7 = false;
                iterable2 = it.toPath();
                iterable3.add(iterable2);
            }
            iterable3 = (List)destination$iv$iv4;
            $this$map$iv = featureClassJars;
            boolean bl = useFullR8;
            MessageReceiver messageReceiver2 = messageReceiver;
            MainDexListConfig mainDexListConfig3 = mainDexListConfig2;
            ProguardConfig proguardConfig2 = proguardConfig;
            ToolConfig toolConfig2 = toolConfig;
            iterable2 = this.filterMissingFiles(referencedInputs, logger);
            iterable3 = (Collection)iterable3;
            $i$f$map4 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl8 = false;
                iterable = it.toPath();
                collection.add((Path)iterable);
            }
            collection = (List)destination$iv$iv4;
            $this$map$iv = featureJavaResourceJars;
            $i$f$map4 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                iterable = destination$iv$iv4;
                boolean bl9 = false;
                Path path4 = it.toPath();
                iterable.add(path4);
            }
            iterable = (List)destination$iv$iv4;
            File file = featureDexDir;
            Path path5 = file == null ? null : file.toPath();
            file = featureJavaResourceOutputDir;
            Path path6 = file == null ? null : file.toPath();
            file = outputKeepRulesFile;
            R8Tool.runR8((Collection)collection7, (Path)comparable3, collection2, (Path)object, iterable3, (Collection)iterable2, (ToolConfig)toolConfig2, (ProguardConfig)proguardConfig2, (MainDexListConfig)mainDexListConfig3, (MessageReceiver)messageReceiver2, (boolean)bl, collection, (Collection)((Collection)iterable), (Path)path5, (Path)path6, (String)libConfiguration, (Path)(file == null ? null : file.toPath()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Path> filterMissingFiles(List<? extends File> files2, LoggerWrapper logger) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = files2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Path path;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File file = (File)element$iv$iv;
                boolean bl2 = false;
                if (file.exists()) {
                    path = file.toPath();
                } else {
                    logger.verbose(file + " is ignored as it does not exist.", new Object[0]);
                    path = null;
                }
                if (path == null) continue;
                Path path2 = path;
                boolean bl3 = false;
                boolean bl4 = false;
                Path it$iv$iv = path2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Format.values().length];
                nArray[Format.DIRECTORY.ordinal()] = 1;
                nArray[Format.JAR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

