/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.TLSUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListenerServer;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListenerServerMetadata;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\"\b\u0002\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServerRunner;", "Ljava/io/Closeable;", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "startServerFunc", "Lkotlin/Function3;", "Ljava/io/File;", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer;", "(Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;Lkotlin/jvm/functions/Function3;)V", "clientCert", "clientPrivateKey", "metadata", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServerMetadata;", "getMetadata", "()Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServerMetadata;", "server", "serverCert", "serverPrivateKey", "close", "", "Companion", "gradle-core"})
public final class UtpTestResultListenerServerRunner
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File serverCert;
    @NotNull
    private final File serverPrivateKey;
    @NotNull
    private final File clientCert;
    @NotNull
    private final File clientPrivateKey;
    @NotNull
    private final UtpTestResultListenerServer server;
    @NotNull
    private final UtpTestResultListenerServerMetadata metadata;
    private static final Logger logger = Logging.getLogger(UtpTestResultListenerServerRunner.class);

    public UtpTestResultListenerServerRunner(@Nullable UtpTestResultListener listener, @NotNull Function3<? super File, ? super File, ? super File, UtpTestResultListenerServer> startServerFunc) {
        Intrinsics.checkNotNullParameter(startServerFunc, (String)"startServerFunc");
        File utpRsaKeysDir = new File(AndroidLocationsSingleton.INSTANCE.getPrefsLocation().toFile(), "utp");
        if (!utpRsaKeysDir.exists()) {
            utpRsaKeysDir.mkdirs();
        }
        Object object = File.createTempFile("resultListenerServerCert", ".pem", utpRsaKeysDir);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempFile(\"resultListenerServerCert\", \".pem\", utpRsaKeysDir)");
        this.serverCert = object;
        object = File.createTempFile("resultListenerServer", ".key", utpRsaKeysDir);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempFile(\"resultListenerServer\", \".key\", utpRsaKeysDir)");
        this.serverPrivateKey = object;
        object = File.createTempFile("resultListenerClientCert", ".pem", utpRsaKeysDir);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempFile(\"resultListenerClientCert\", \".pem\", utpRsaKeysDir)");
        this.clientCert = object;
        object = File.createTempFile("resultListenerClient", ".key", utpRsaKeysDir);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempFile(\"resultListenerClient\", \".key\", utpRsaKeysDir)");
        this.clientPrivateKey = object;
        TLSUtilsKt.generateRsaKeyPair(this.serverCert, this.serverPrivateKey);
        TLSUtilsKt.generateRsaKeyPair(this.clientCert, this.clientPrivateKey);
        object = (UtpTestResultListenerServer)startServerFunc.invoke((Object)this.serverCert, (Object)this.serverPrivateKey, (Object)this.clientCert);
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            UtpTestResultListenerServerRunner utpTestResultListenerServerRunner = this;
            boolean bl3 = false;
            String string = "Unable to start the UTP test results listener gRPC server.";
            UtpTestResultListenerServerRunner utpTestResultListenerServerRunner2 = utpTestResultListenerServerRunner;
            String string2 = string;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.server = object;
        this.metadata = new UtpTestResultListenerServerMetadata(this.serverCert, this.server.getPort(), this.clientCert, this.clientPrivateKey);
    }

    public /* synthetic */ UtpTestResultListenerServerRunner(final UtpTestResultListener utpTestResultListener, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function3 = (Function3)new Function3<File, File, File, UtpTestResultListenerServer>(){

                @Nullable
                public final UtpTestResultListenerServer invoke(@NotNull File certChainFile, @NotNull File privateKeyFile, @NotNull File trustCertCollectionFile) {
                    Intrinsics.checkNotNullParameter((Object)certChainFile, (String)"certChainFile");
                    Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
                    Intrinsics.checkNotNullParameter((Object)trustCertCollectionFile, (String)"trustCertCollectionFile");
                    return UtpTestResultListenerServer.Companion.startServer$default(UtpTestResultListenerServer.Companion, certChainFile, privateKeyFile, trustCertCollectionFile, utpTestResultListener, 0, 0, null, 112, null);
                }
            };
        }
        this(utpTestResultListener, (Function3<? super File, ? super File, ? super File, UtpTestResultListenerServer>)function3);
    }

    @NotNull
    public final UtpTestResultListenerServerMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        this.server.close();
        try {
            FileUtils.deleteIfExists((File)this.serverCert);
            FileUtils.deleteIfExists((File)this.serverPrivateKey);
            FileUtils.deleteIfExists((File)this.clientCert);
            FileUtils.deleteIfExists((File)this.clientPrivateKey);
        }
        catch (IOException e) {
            logger.warn(Intrinsics.stringPlus((String)"Failed to cleanup temporary directories: ", (Object)e));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServerRunner$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

