/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.builder.model.SourceProvider;
import com.android.utils.StringHelper;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a,\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000e\u001a\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"KOTLIN_ANDROID_PLUGIN_ID", "", "KOTLIN_KAPT_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_IDS", "", "addComposeArgsToKotlinCompile", "", "task", "Lorg/gradle/api/Task;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "useLiveLiterals", "", "findKaptConfigurationsForVariant", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "getKotlinCompile", "Lorg/gradle/api/tasks/TaskProvider;", "isKotlinAndroidPluginApplied", "isKotlinKaptPluginApplied", "isKotlinPluginApplied", "recordIrBackendForAnalytics", "allPropertiesList", "extension", "Lcom/android/build/gradle/BaseExtension;", "composeIsEnabled", "setIrUsedInAnalytics", "syncAgpAndKgpSources", "sourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "gradle-core"})
@JvmName(name="KgpUtils")
public final class KgpUtils {
    @NotNull
    public static final String KOTLIN_ANDROID_PLUGIN_ID = "org.jetbrains.kotlin.android";
    @NotNull
    public static final String KOTLIN_KAPT_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    private static final List<String> KOTLIN_MPP_PLUGIN_IDS;

    public static final boolean isKotlinPluginApplied(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            boolean bl2;
            block5: {
                PluginContainer pluginContainer = project2.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
                Iterable $this$any$iv = (Iterable)pluginContainer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KotlinBasePluginWrapper)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable ignored) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isKotlinAndroidPluginApplied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_ANDROID_PLUGIN_ID);
    }

    public static final boolean isKotlinKaptPluginApplied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_KAPT_PLUGIN_ID);
    }

    @NotNull
    public static final TaskProvider<Task> getKotlinCompile(@NotNull Project project2, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        TaskProvider taskProvider = project2.getTasks().named(creationConfig.computeTaskName("compile", "Kotlin"));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.named(creationConfig.computeTaskName(\"compile\", \"Kotlin\"))");
        return taskProvider;
    }

    public static final void recordIrBackendForAnalytics(@NotNull List<? extends ComponentCreationConfig> allPropertiesList, @NotNull BaseExtension extension, @NotNull Project project2, boolean composeIsEnabled) {
        Intrinsics.checkNotNullParameter(allPropertiesList, (String)"allPropertiesList");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        for (ComponentCreationConfig componentCreationConfig : allPropertiesList) {
            try {
                TaskProvider<Task> compileKotlin = KgpUtils.getKotlinCompile(project2, componentCreationConfig);
                compileKotlin.configure((Action)new Action<Task>(composeIsEnabled, componentCreationConfig, project2, extension){
                    final /* synthetic */ boolean $composeIsEnabled;
                    final /* synthetic */ ComponentCreationConfig $creationConfig;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BaseExtension $extension;
                    {
                        this.$composeIsEnabled = $composeIsEnabled;
                        this.$creationConfig = $creationConfig;
                        this.$project = $project;
                        this.$extension = $extension;
                    }

                    public final void execute(@NotNull Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        try {
                            if (this.$composeIsEnabled) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                            Method getKotlinOptions = task.getClass().getMethod("getKotlinOptions", new Class[0]);
                            Object taskOptions = getKotlinOptions.invoke((Object)task, new Object[0]);
                            Method getUseIR = taskOptions.getClass().getMethod("getUseIR", new Class[0]);
                            Object object = getUseIR.invoke(taskOptions, new Object[0]);
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                            }
                            if (((Boolean)object).booleanValue()) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                            Object kotlinDslOptions = ((ExtensionAware)this.$extension).getExtensions().getByName("kotlinOptions");
                            Object object2 = getUseIR.invoke(kotlinDslOptions, new Object[0]);
                            if (object2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                            }
                            if (((Boolean)object2).booleanValue()) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private static final void setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2) {
        Object object = BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBuildService(\n                    creationConfig.services.buildServiceRegistry,\n                    AnalyticsConfiguratorService::class.java)\n                    .get()");
        AnalyticsConfiguratorService buildService = (AnalyticsConfiguratorService)object;
        String string = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        object = buildService.getVariantBuilder(string, creationConfig.getName());
        if (object != null) {
            object.setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setUseIr(true));
        }
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull Task task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension, boolean useLiveLiterals) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)compilerExtension, (String)"compilerExtension");
        KotlinCompile cfr_ignored_0 = (KotlinCompile)task;
        Object[] objectArray = new Object[]{compilerExtension};
        ((KotlinCompile)task).getInputs().files(objectArray).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
        ((KotlinCompile)task).getInputs().property("useLiveLiterals", (Object)useLiveLiterals);
        boolean debuggable = creationConfig instanceof ApkCreationConfig || creationConfig instanceof LibraryCreationConfig ? creationConfig.getDebuggable() : false;
        task.doFirst((Action)new Action<Task>(compilerExtension, debuggable, useLiveLiterals){
            final /* synthetic */ FileCollection $compilerExtension;
            final /* synthetic */ boolean $debuggable;
            final /* synthetic */ boolean $useLiveLiterals;
            {
                this.$compilerExtension = $compilerExtension;
                this.$debuggable = $debuggable;
                this.$useLiveLiterals = $useLiveLiterals;
            }

            public final void execute(Task it) {
                if (it == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                }
                KotlinCompile cfr_ignored_0 = (KotlinCompile)it;
                ((KotlinCompile)it).getKotlinOptions().setUseIR(true);
                Object object = new String[5];
                Object object2 = this.$compilerExtension.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"compilerExtension.files");
                object[0] = Intrinsics.stringPlus((String)"-Xplugin=", (Object)((File)CollectionsKt.first((Iterable)((Iterable)object2))).getAbsolutePath());
                object[1] = "-XXLanguage:+NonParenthesizedAnnotationsOnFunctionalTypes";
                object[2] = "-P";
                object[3] = "plugin:androidx.compose.plugins.idea:enabled=true";
                object[4] = "-Xallow-unstable-dependencies";
                List extraFreeCompilerArgs = CollectionsKt.mutableListOf((Object[])object);
                if (this.$debuggable) {
                    object = extraFreeCompilerArgs;
                    object2 = new String[]{"-P", "plugin:androidx.compose.compiler.plugins.kotlin:sourceInformation=true"};
                    object2 = CollectionsKt.listOf((Object[])object2);
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)object, (Iterable)object2);
                    if (this.$useLiveLiterals) {
                        object = extraFreeCompilerArgs;
                        object2 = new String[]{"-P", "plugin:androidx.compose.compiler.plugins.kotlin:liveLiterals=true"};
                        object2 = CollectionsKt.listOf((Object[])object2);
                        bl = false;
                        CollectionsKt.addAll((Collection)object, (Iterable)object2);
                    }
                }
                object = ((KotlinCompile)it).getKotlinOptions();
                object.setFreeCompilerArgs(CollectionsKt.plus((Collection)object.getFreeCompilerArgs(), (Iterable)extraFreeCompilerArgs));
            }
        });
    }

    public static final void syncAgpAndKgpSources(@NotNull Project project2, @NotNull NamedDomainObjectContainer<AndroidSourceSet> sourceSets) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
            Iterable $this$any$iv = KOTLIN_MPP_PLUGIN_IDS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!project2.getPluginManager().hasPlugin(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasMpp = bl;
        sourceSets.all((Action)new Action<AndroidSourceSet>(hasMpp){
            final /* synthetic */ boolean $hasMpp;
            {
                this.$hasMpp = $hasMpp;
            }

            public final void execute(AndroidSourceSet it) {
                if (it == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.HasConvention");
                }
                V kotlinConvention = ((HasConvention)it).getConvention().getPlugins().get("kotlin");
                if (kotlinConvention != null) {
                    Object[] objectArray = kotlinConvention.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinConvention, new Object[0]);
                    if (objectArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
                    }
                    SourceDirectorySet sourceDir = (SourceDirectorySet)objectArray;
                    if (!this.$hasMpp) {
                        objectArray = new Object[]{((DefaultAndroidSourceDirectorySet)it.getKotlin()).getSrcDirs()};
                        sourceDir.srcDirs(objectArray);
                    }
                    it.getKotlin().setSrcDirs((Iterable)CollectionsKt.listOf((Object)sourceDir.getSourceDirectories()));
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Configuration> findKaptConfigurationsForVariant(@NotNull Project project2, @NotNull ComponentCreationConfig creationConfig) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Iterable $this$mapNotNull$iv = creationConfig.getVariantSources().getSortedSourceProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Configuration configuration;
            String kaptConfigurationName;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SourceProvider sourceSet = (SourceProvider)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)sourceSet.getName(), (Object)"main")) {
                String string2 = sourceSet.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceSet.name");
                string = StringHelper.appendCapitalized((String)"kapt", (String)string2);
            } else {
                string = kaptConfigurationName = "kapt";
            }
            if ((Configuration)project2.getConfigurations().findByName(kaptConfigurationName) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Configuration it$iv$iv = configuration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ void access$setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2) {
        KgpUtils.setIrUsedInAnalytics(creationConfig, project2);
    }

    static {
        Object[] objectArray = new String[]{"kotlin-multiplatform", "org.jetbrains.kotlin.multiplatform"};
        KOTLIN_MPP_PLUGIN_IDS = CollectionsKt.listOf((Object[])objectArray);
    }
}

