/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Charsets;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005*\b\u0012\u0004\u0012\u00020\u00110\u0005R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "applicationMk", "Ljava/io/File;", "getApplicationMk", "()Ljava/io/File;", "makeFile", "getMakeFile", "ndkBuild", "", "getNdkBuild", "()Ljava/lang/String;", "executeProcess", "", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "parseDryRunOutput", "removeJobsFlagIfPresent", "gradle-core"})
public final class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    public NdkBuildExternalNativeJsonGenerator(@NotNull CxxVariantModel variant2, @NotNull List<CxxAbiModel> abis2, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter(abis2, (String)"abis");
        super(variant2, abis2, (GradleBuildVariant.Builder)variantBuilder);
        Object[] objectArray = variantBuilder;
        if (objectArray != null) {
            objectArray.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        }
        if (this.getVariant().getModule().getMakeFile().isDirectory()) {
            objectArray = new Object[]{this.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", objectArray);
        } else if (!this.getVariant().getModule().getMakeFile().exists()) {
            objectArray = new Object[]{this.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path is %s but that file doesn't exist", objectArray);
        }
    }

    @Override
    @NotNull
    public ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        Object[] objectArray = new String[]{(Object)((Object)NdkBuildProperty.APP_SHORT_COMMANDS) + "=false", (Object)((Object)NdkBuildProperty.LOCAL_SHORT_COMMANDS) + "=false", "-B", "-n"};
        builder.setExecutable(this.getNdkBuild()).addArgs(CollectionsKt.plus((Collection)abi.getConfigurationArguments(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        return builder;
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        ProcessOutputJunctionKt.createProcessOutputJunction(CxxAbiModelKt.getMetadataGenerationCommandFile(abi), CxxAbiModelKt.getMetadataGenerationStdoutFile(abi), CxxAbiModelKt.getMetadataGenerationStderrFile(abi), this.getProcessBuilder(abi), "").logStderr().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super ExecSpec>, ExecResult>(ops2){

            public final ExecResult invoke(Action<? super ExecSpec> p0) {
                return ((ExecOperations)this.receiver).exec(p0);
            }
        }));
        this.parseDryRunOutput(abi);
    }

    public final void parseDryRunOutput(@NotNull CxxAbiModel abi) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        LoggingEnvironmentKt.infoln("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        String buildOutput = FilesKt.readText$default((File)CxxAbiModelKt.getMetadataGenerationStdoutFile(abi), null, (int)1, null);
        List commandLine = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getNdkBuild()), (Iterable)abi.getConfigurationArguments());
        NativeBuildConfigValueBuilder builder = new NativeBuildConfigValueBuilder(this.getMakeFile(), this.getVariant().getModule().getModuleRootFolder(), CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), null, 8, null).setCommands(commandLine, CollectionsKt.plus((Collection)this.removeJobsFlagIfPresent(commandLine), (Iterable)CollectionsKt.listOf((Object)"clean")), this.getVariant().getVariantName(), buildOutput);
        builder.setSkipProcessingCompilerFlags(true);
        NativeBuildConfigValue buildConfig = builder.build();
        File file = this.getApplicationMk();
        if (file != null) {
            object = file;
            boolean bl2 = false;
            bl = false;
            File it = object;
            boolean bl3 = false;
            Object object2 = new Object[1];
            String string = it.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
            object2[0] = string;
            LoggingEnvironmentKt.infoln("found application make file %s", (Object[])object2);
            object2 = buildConfig.buildFiles;
            Intrinsics.checkNotNull((Object)object2);
            object2.add(it);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Path path = CxxAbiModelKt.getJsonFile(abi).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)actualResult, (String)"actualResult");
        object = actualResult;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final String getNdkBuild() {
        String string;
        String tool = "ndk-build";
        if (ExternalNativeJsonGenerator.Companion.isWindows()) {
            tool = Intrinsics.stringPlus((String)tool, (Object)".cmd");
        }
        File toolFile = new File(this.getVariant().getModule().getNdkFolder().getPath(), tool);
        try {
            string = toolFile.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                // Attempt to shorten ndkFolder which may have segments of \"path\\..\"\n                // File#getAbsolutePath doesn't do this.\n                toolFile.canonicalPath\n            }");
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e};
            LoggingEnvironmentKt.warnln("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", objectArray);
            String string2 = toolFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                warnln(\n                    \"\"\"\n                Attempted to get ndkFolder canonical path and failed: %s\n                Falling back to absolute path.\n                \"\"\".trimIndent(),\n                    e\n                )\n                toolFile.absolutePath\n            }");
            string = string2;
        }
        return string;
    }

    private final File getApplicationMk() {
        File file = new File(this.getMakeFile().getParent(), "Application.mk");
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        return it.exists() ? file : null;
    }

    private final File getMakeFile() {
        return this.getVariant().getModule().getMakeFile().isDirectory() ? new File(this.getVariant().getModule().getMakeFile(), "Android.mk") : this.getVariant().getModule().getMakeFile();
    }

    @NotNull
    public final List<String> removeJobsFlagIfPresent(@NotNull List<String> $this$removeJobsFlagIfPresent) {
        Intrinsics.checkNotNullParameter($this$removeJobsFlagIfPresent, (String)"<this>");
        return BuildSystemCommandLineKt.toStringList(BuildSystemCommandLineKt.removeNdkBuildJobs(BuildSystemCommandLineKt.toNdkBuildArguments($this$removeJobsFlagIfPresent)));
    }
}

