/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.dsl.decorator.annotation.NonNullableSetter;
import com.android.build.gradle.internal.dsl.decorator.annotation.WithLazyInitialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;

public abstract class CompileOptions
implements com.android.build.api.dsl.CompileOptions {
    private static final String VERSION_PREFIX = "VERSION_";
    private Boolean incremental = null;
    private Boolean coreLibraryDesugaringEnabled = null;
    @VisibleForTesting
    JavaVersion defaultJavaVersion = JavaVersion.VERSION_1_8;

    protected void lazyInit() {
        this.setEncoding(Charsets.UTF_8.name());
        this.setSourceCompatibility(this.defaultJavaVersion);
        this.setTargetCompatibility(this.defaultJavaVersion);
    }

    @Inject
    @WithLazyInitialization(methodName="lazyInit")
    public CompileOptions() {
    }

    public void setSourceCompatibility(Object sourceCompatibility) {
        this.setSourceCompatibility(CompileOptions.convert(sourceCompatibility));
    }

    public void sourceCompatibility(Object sourceCompatibility) {
        this.setSourceCompatibility(CompileOptions.convert(sourceCompatibility));
    }

    @NonNullableSetter
    public abstract void setSourceCompatibility(JavaVersion var1);

    public abstract JavaVersion getSourceCompatibility();

    public void setTargetCompatibility(Object targetCompatibility) {
        this.setTargetCompatibility(CompileOptions.convert(targetCompatibility));
    }

    public void targetCompatibility(Object targetCompatibility) {
        this.setTargetCompatibility(CompileOptions.convert(targetCompatibility));
    }

    @NonNullableSetter
    public abstract void setTargetCompatibility(JavaVersion var1);

    public abstract JavaVersion getTargetCompatibility();

    @NonNullableSetter
    public abstract void setEncoding(String var1);

    public abstract String getEncoding();

    public void setDefaultJavaVersion(JavaVersion defaultJavaVersion) {
        this.defaultJavaVersion = (JavaVersion)Preconditions.checkNotNull((Object)defaultJavaVersion);
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public Boolean getCoreLibraryDesugaringEnabled() {
        return this.coreLibraryDesugaringEnabled;
    }

    public boolean isCoreLibraryDesugaringEnabled() {
        return this.coreLibraryDesugaringEnabled != null ? this.coreLibraryDesugaringEnabled : false;
    }

    public void setCoreLibraryDesugaringEnabled(boolean coreLibraryDesugaringEnabled) {
        this.coreLibraryDesugaringEnabled = coreLibraryDesugaringEnabled;
    }

    private static JavaVersion convert(Object version) {
        String versionString;
        if (version instanceof String && (versionString = (String)version).toUpperCase(Locale.ENGLISH).startsWith(VERSION_PREFIX)) {
            version = versionString.substring(VERSION_PREFIX.length()).replace('_', '.');
        }
        return JavaVersion.toVersion((Object)version);
    }
}

