/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dependency.BaseDexingTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dexing.DexWorkActionKt;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DependencyGraphUpdater;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexParameters;
import com.android.builder.dexing.DexUtilsKt;
import com.android.builder.dexing.MutableDependencyGraph;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTransform
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH$J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002JT\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u001b2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010 H\u0002J0\u0010!\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J4\u0010%\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/dependency/BaseDexingTransform;", "T", "Lcom/android/build/gradle/internal/dependency/BaseDexingTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "()V", "inputChanges", "Lorg/gradle/work/InputChanges;", "getInputChanges", "()Lorg/gradle/work/InputChanges;", "primaryInput", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getPrimaryInput", "()Lorg/gradle/api/provider/Provider;", "computeClasspathFiles", "", "Ljava/nio/file/Path;", "doTransform", "", "inputFile", "Ljava/io/File;", "outputDir", "process", "input", "inputFilter", "Lkotlin/Function2;", "", "", "dexOutputDir", "keepRulesOutputFile", "provideIncrementalSupport", "desugarGraphUpdater", "Lcom/android/builder/dexing/DependencyGraphUpdater;", "processIncrementally", "Lcom/android/builder/files/SerializableFileChanges;", "classpathChanges", "desugarGraphFile", "processNonIncrementally", "transform", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "gradle-core"})
public abstract class BaseDexingTransform<T extends Parameters>
implements TransformAction<T> {
    @Inject
    @NotNull
    public abstract InputChanges getInputChanges();

    @Classpath
    @InputArtifact
    @Incremental
    @NotNull
    public abstract Provider<FileSystemLocation> getPrimaryInput();

    @NotNull
    protected abstract List<Path> computeClasspathFiles();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File input = ((FileSystemLocation)this.getPrimaryInput().get()).getAsFile();
        File outputDir = outputs.dir((Object)Files.getNameWithoutExtension((String)input.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        this.doTransform(input, outputDir);
    }

    private final void doTransform(File inputFile, File outputDir) {
        File desugarGraphFile;
        boolean outputKeepRulesEnabled = ((Parameters)this.getParameters()).getLibConfiguration().isPresent() && (Boolean)((Parameters)this.getParameters()).getDebuggable().get() == false;
        boolean provideIncrementalSupport = (Boolean)DexUtilsKt.isJarFile().invoke((Object)inputFile) == false && !outputKeepRulesEnabled;
        File dexOutputDir = outputKeepRulesEnabled ? FilesKt.resolve((File)outputDir, (String)"dex") : outputDir;
        File keepRulesOutputFile = outputKeepRulesEnabled ? FilesKt.resolve((File)outputDir, (String)"keep_rules") : null;
        File file = desugarGraphFile = provideIncrementalSupport ? FilesKt.resolve((File)outputDir, (String)"../desugar_graph.bin") : null;
        if (provideIncrementalSupport && this.getInputChanges().isIncremental()) {
            List classpathChanges = CollectionsKt.emptyList();
            boolean bl = keepRulesOutputFile == null;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = this.getInputChanges().getFileChanges(this.getPrimaryInput());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(primaryInput)");
            SerializableFileChanges serializableFileChanges = IncrementalChangesUtils.toSerializable(iterable);
            SerializableFileChanges serializableFileChanges2 = IncrementalChangesUtils.toSerializable(classpathChanges);
            Intrinsics.checkNotNull((Object)desugarGraphFile);
            this.processIncrementally(inputFile, serializableFileChanges, serializableFileChanges2, dexOutputDir, desugarGraphFile);
        } else {
            this.processNonIncrementally(inputFile, dexOutputDir, keepRulesOutputFile, provideIncrementalSupport, desugarGraphFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processIncrementally(File input, SerializableFileChanges inputChanges, SerializableFileChanges classpathChanges, File dexOutputDir, File desugarGraphFile) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        File file;
        Collection collection;
        void $this$mapTo$iv$iv3;
        MutableDependencyGraph<File> mutableDependencyGraph;
        try {
            mutableDependencyGraph = DexWorkActionKt.readDesugarGraph(desugarGraphFile);
        }
        catch (Exception e) {
            LoggerWrapper.getLogger(BaseDexingTransform.class).warning("Failed to read desugaring graph. Cause: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ".\nFall back to non-incremental mode.", new Object[0]);
            this.processNonIncrementally(input, dexOutputDir, null, true, desugarGraphFile);
            return;
        }
        MutableDependencyGraph<File> desugarGraph = mutableDependencyGraph;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)inputChanges.getRemovedFiles(), (Iterable)classpathChanges.getRemovedFiles());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            SerializableChange serializableChange = (SerializableChange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            file = it.getFile();
            collection.add(file);
        }
        Set removedFiles2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = CollectionsKt.plus((Collection)inputChanges.getModifiedFiles(), (Iterable)classpathChanges.getModifiedFiles());
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            SerializableChange bl = (SerializableChange)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            file = it.getFile();
            collection.add(file);
        }
        Set modifiedFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = CollectionsKt.plus((Collection)inputChanges.getAddedFiles(), (Iterable)classpathChanges.getAddedFiles());
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializableChange bl2 = (SerializableChange)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            file = it.getFile();
            collection.add(file);
        }
        Set addedFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Set unchangedButImpactedFiles = desugarGraph.getAllDependents(SetsKt.plus((Set)removedFiles2, (Iterable)modifiedFiles));
        Set modifiedImpactedOrAddedFiles = SetsKt.plus((Set)SetsKt.plus((Set)modifiedFiles, (Iterable)unchangedButImpactedFiles), (Iterable)addedFiles);
        Set removedModifiedOrImpactedFiles = SetsKt.plus((Set)SetsKt.plus((Set)removedFiles2, (Iterable)modifiedFiles), (Iterable)unchangedButImpactedFiles);
        Iterable $this$forEach$iv = inputChanges.getRemovedFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerializableChange it = (SerializableChange)element$iv;
            boolean bl = false;
            if (!ClassFileInput.CLASS_MATCHER.test(it.getFile().getPath())) continue;
            String string = ClassFileEntry.withDexExtension((String)it.getNormalizedPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"withDexExtension(it.normalizedPath)");
            File staleOutputFile = FilesKt.resolve((File)dexOutputDir, (String)string);
            FileUtils.deleteRecursivelyIfExists((File)staleOutputFile);
        }
        $this$forEach$iv = removedModifiedOrImpactedFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            desugarGraph.removeNode((Object)it);
        }
        Function2 filter2 = (Function2)new Function2<File, String, Boolean>((Set<? extends File>)modifiedImpactedOrAddedFiles){
            final /* synthetic */ Set<File> $modifiedImpactedOrAddedFiles;
            {
                this.$modifiedImpactedOrAddedFiles = $modifiedImpactedOrAddedFiles;
                super(2);
            }

            public final boolean invoke(@NotNull File rootPath, @NotNull String relativePath) {
                Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                return this.$modifiedImpactedOrAddedFiles.contains(rootPath) || this.$modifiedImpactedOrAddedFiles.contains(FilesKt.resolve((File)rootPath, (String)relativePath));
            }
        };
        this.process(input, (Function2<File, String, Boolean>)filter2, dexOutputDir, null, true, (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
        DexWorkActionKt.writeDesugarGraph(desugarGraphFile, desugarGraph);
    }

    private final void processNonIncrementally(File input, File dexOutputDir, File keepRulesOutputFile, boolean provideIncrementalSupport, File desugarGraphFile) {
        MutableDependencyGraph mutableDependencyGraph;
        File it;
        boolean bl;
        boolean bl2;
        File file;
        FileUtils.deleteRecursivelyIfExists((File)dexOutputDir);
        FileUtils.mkdirs((File)dexOutputDir);
        File file2 = keepRulesOutputFile;
        if (file2 != null) {
            file = file2;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl3 = false;
            FileUtils.deleteIfExists((File)it);
            FileUtils.mkdirs((File)it.getParentFile());
        }
        file2 = desugarGraphFile;
        if (file2 != null) {
            file = file2;
            bl2 = false;
            bl = false;
            it = file;
            boolean bl4 = false;
            FileUtils.deleteIfExists((File)it);
            FileUtils.mkdirs((File)it.getParentFile());
        }
        file = desugarGraphFile;
        if (file == null) {
            mutableDependencyGraph = null;
        } else {
            File file3 = file;
            bl = false;
            boolean bl5 = false;
            File it2 = file3;
            boolean bl6 = false;
            mutableDependencyGraph = new MutableDependencyGraph();
        }
        MutableDependencyGraph desugarGraph = mutableDependencyGraph;
        this.process(input, (Function2<File, String, Boolean>)((Function2)processNonIncrementally.3.INSTANCE), dexOutputDir, keepRulesOutputFile, provideIncrementalSupport, (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
        file = desugarGraphFile;
        if (file != null) {
            File file4 = file;
            bl = false;
            boolean bl7 = false;
            File it3 = file4;
            boolean bl8 = false;
            Intrinsics.checkNotNull((Object)desugarGraph);
            DexWorkActionKt.writeDesugarGraph(it3, (MutableDependencyGraph<File>)desugarGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void process(File input, Function2<? super File, ? super String, Boolean> inputFilter2, File dexOutputDir, File keepRulesOutputFile, boolean provideIncrementalSupport, DependencyGraphUpdater<File> desugarGraphUpdater) {
        Closeable closeable = (Closeable)Closer.create();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object it;
            Collection<Path> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Closer closer = (Closer)closeable;
            boolean bl3 = false;
            Object object = ((Parameters)this.getParameters()).getMinSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.minSdkVersion.get()");
            int n = ((Number)object).intValue();
            object = ((Parameters)this.getParameters()).getDebuggable().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.debuggable.get()");
            boolean bl4 = (Boolean)object;
            object = ((Parameters)this.getParameters()).getEnableDesugaring().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.enableDesugaring.get()");
            boolean bl5 = (Boolean)object;
            object = ((Parameters)this.getParameters()).getBootClasspath().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.bootClasspath.files");
            object = (Iterable)object;
            boolean bl6 = bl5;
            boolean bl7 = provideIncrementalSupport;
            boolean bl8 = bl4;
            int n2 = n;
            DexArchiveBuilder.Companion companion = DexArchiveBuilder.Companion;
            boolean $i$f$map = false;
            void var23_22 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                Path path = p0.toPath();
                collection.add(path);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            object = new ClassFileProviderFactory(collection2);
            boolean bl10 = false;
            boolean bl11 = false;
            destination$iv$iv = object;
            boolean bl12 = false;
            closer.register((Closeable)it);
            Object object2 = Unit.INSTANCE;
            Object object3 = object;
            object = new ClassFileProviderFactory((Collection)this.computeClasspathFiles());
            bl10 = false;
            bl11 = false;
            it = object;
            object2 = object3;
            boolean bl13 = false;
            closer.register((Closeable)it);
            Unit unit = Unit.INSTANCE;
            Object object4 = object;
            String string = (String)((Parameters)this.getParameters()).getLibConfiguration().getOrNull();
            object = ((Parameters)this.getParameters()).getErrorFormat().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.errorFormat.get()");
            SyncOptions.ErrorFormatMode errorFormatMode = (SyncOptions.ErrorFormatMode)((Object)object);
            object = LoggerFactory.getLogger(BaseDexingTransform.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(BaseDexingTransform::class.java)");
            MessageReceiver messageReceiver = new MessageReceiverImpl(errorFormatMode, (Logger)object);
            File file = keepRulesOutputFile;
            String string2 = string;
            Object object5 = object4;
            Object object6 = object2;
            boolean bl14 = bl6;
            boolean bl15 = bl7;
            boolean bl16 = bl8;
            int n3 = n2;
            DexArchiveBuilder d8DexBuilder = companion.createD8DexBuilder(new DexParameters(n3, bl16, bl15, bl14, (ClassFileProviderFactory)object6, (ClassFileProviderFactory)object5, string2, file, messageReceiver));
            object = (Closeable)ClassFileInputs.fromPath((Path)input.toPath());
            bl10 = false;
            bl11 = false;
            Throwable throwable2 = null;
            try {
                ClassFileInput classFileInput = (ClassFileInput)object;
                boolean bl17 = false;
                AutoCloseable autoCloseable = classFileInput.entries((BiPredicate)new BiPredicate<Path, String>(inputFilter2){
                    final /* synthetic */ Function2<File, String, Boolean> $inputFilter;
                    {
                        this.$inputFilter = $inputFilter;
                    }

                    public final boolean test(Path rootPath, String relativePath) {
                        File file = rootPath.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootPath.toFile()");
                        Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"relativePath");
                        return (Boolean)this.$inputFilter.invoke((Object)file, (Object)relativePath);
                    }
                });
                boolean bl18 = false;
                boolean bl19 = false;
                Throwable throwable3 = null;
                try {
                    Stream classesInput = (Stream)autoCloseable;
                    boolean bl20 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)classesInput, (String)"classesInput");
                    Path path = dexOutputDir.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dexOutputDir.toPath()");
                    d8DexBuilder.convert(classesInput, path, desugarGraphUpdater);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable3);
                }
                Unit unit3 = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Unit unit4 = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/dependency/BaseDexingTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "debuggable", "Lorg/gradle/api/provider/Property;", "", "getDebuggable", "()Lorg/gradle/api/provider/Property;", "enableDesugaring", "getEnableDesugaring", "errorFormat", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormat", "libConfiguration", "", "getLibConfiguration", "minSdkVersion", "", "getMinSdkVersion", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        @NotNull
        public Property<Integer> getMinSdkVersion();

        @Input
        @NotNull
        public Property<Boolean> getDebuggable();

        @Input
        @NotNull
        public Property<Boolean> getEnableDesugaring();

        @Classpath
        @NotNull
        public ConfigurableFileCollection getBootClasspath();

        @Internal
        @NotNull
        public Property<SyncOptions.ErrorFormatMode> getErrorFormat();

        @Optional
        @Input
        @NotNull
        public Property<String> getLibConfiguration();
    }
}

