/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.variant.impl.ApplicationVariantBuilderImpl;
import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.AnchorTaskNames;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.ApplicationTaskManager;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.BundleIdeModelProducerTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.CompileArtProfileTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.ListingFileRedirectTask;
import com.android.build.gradle.internal.tasks.MergeArtProfileTask;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureNamespacesTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.sync.ApplicationVariantModelTask;
import com.android.builder.core.VariantType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Bc\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001c\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u001c\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0014J \u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006H\u0014J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/ApplicationTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/impl/ApplicationVariantBuilderImpl;", "Lcom/android/build/api/variant/impl/ApplicationVariantImpl;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/api/component/impl/TestComponentImpl;", "testFixturesComponents", "Lcom/android/build/api/component/impl/TestFixturesImpl;", "hasFlavors", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "extension", "Lcom/android/build/gradle/BaseExtension;", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/BaseExtension;Lcom/android/build/gradle/internal/scope/ProjectInfo;)V", "createAssetPackTasks", "", "appVariant", "createDynamicBundleTask", "variantInfo", "createGenerateMicroApkDataTask", "config", "Lorg/gradle/api/file/FileCollection;", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "createSoftwareComponent", "componentName", "", "publication", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$PublishedConfigType;", "doCreateTasksForVariant", "handleMicroApp", "gradle-core"})
public final class ApplicationTaskManager
extends AbstractAppTaskManager<ApplicationVariantBuilderImpl, ApplicationVariantImpl> {
    public ApplicationTaskManager(@NotNull List<? extends ComponentInfo<ApplicationVariantBuilderImpl, ApplicationVariantImpl>> variants, @NotNull List<? extends TestComponentImpl> testComponents, @NotNull List<? extends TestFixturesImpl> testFixturesComponents, boolean hasFlavors, @NotNull ProjectOptions projectOptions, @NotNull GlobalScope globalScope, @NotNull BaseExtension extension, @NotNull ProjectInfo projectInfo) {
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)projectInfo, (String)"projectInfo");
        super(variants, testComponents, testFixturesComponents, hasFlavors, projectOptions, globalScope, extension, projectInfo);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<ApplicationVariantBuilderImpl, ApplicationVariantImpl> variantInfo) {
        Intrinsics.checkNotNullParameter(variantInfo, (String)"variantInfo");
        this.createCommonTasks(variantInfo);
        ApplicationVariantImpl variant2 = variantInfo.getVariant();
        this.taskFactory.register(new ApplicationVariantModelTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variant2));
        this.createValidateSigningTask(variant2);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variant2));
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(variant2));
        Object object = new TaskProvider[]{variant2.getTaskContainer().getPreBuildTask()};
        TaskFactoryUtils.dependsOn(this.taskFactory.register(new AppMetadataTask.CreationAction(variant2)), object);
        object = ((BaseAppModuleExtension)this.extension).getAssetPacks();
        boolean bl = false;
        if (!object.isEmpty()) {
            this.createAssetPackTasks(variant2);
        }
        this.taskFactory.register(new MergeArtProfileTask.CreationAction(variant2));
        this.taskFactory.register(new CompileArtProfileTask.CreationAction(variant2));
        if (variant2.getBuildFeatures().getDataBinding() && variant2.getGlobalScope().hasDynamicFeatures()) {
            this.taskFactory.register(new DataBindingExportFeatureNamespacesTask.CreationAction(variant2));
        }
        this.createDynamicBundleTask(variantInfo);
        this.handleMicroApp(variant2);
        VariantPublishingInfo variantPublishingInfo = variant2.getVariantDslInfo().getPublishInfo();
        Intrinsics.checkNotNull((Object)variantPublishingInfo);
        VariantPublishingInfo publishInfo = variantPublishingInfo;
        for (ComponentPublishingInfo component2 : publishInfo.getComponents()) {
            AndroidArtifacts.PublishedConfigType configType = component2.getType() == AbstractPublishing.Type.APK ? AndroidArtifacts.PublishedConfigType.APK_PUBLICATION : AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION;
            this.createSoftwareComponent(variant2, component2.getComponentName(), configType);
        }
    }

    private final void handleMicroApp(ApplicationVariantImpl appVariant) {
        VariantDslInfo<?> variantDslInfo = appVariant.getVariantDslInfo();
        VariantType variantType = appVariant.getVariantType();
        if (variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantDslInfo.isWearAppUnbundled();
            if (!Intrinsics.areEqual((Object)unbundledWearApp, (Object)true) && variantDslInfo.isEmbedMicroApp()) {
                Configuration configuration = appVariant.getVariantDependencies().getWearAppConfiguration();
                if (configuration == null) {
                    String string = "Wear app with no wearApp configuration";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Configuration wearApp = configuration;
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact2 = handleMicroApp.setApkArtifact.1.INSTANCE;
                    FileCollection files2 = wearApp.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>((Action<AttributeContainer>)setApkArtifact2){
                        final /* synthetic */ Action<AttributeContainer> $setApkArtifact;
                        {
                            this.$setApkArtifact = $setApkArtifact;
                        }

                        public final void execute(@NotNull ArtifactView.ViewConfiguration config2) {
                            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                            config2.attributes(this.$setApkArtifact);
                        }
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(appVariant, files2);
                }
            } else if (Intrinsics.areEqual((Object)unbundledWearApp, (Object)true)) {
                ApplicationTaskManager.createGenerateMicroApkDataTask$default(this, appVariant, null, 2, null);
            }
        }
    }

    private final void createGenerateMicroApkDataTask(ApplicationVariantImpl appVariant, FileCollection config2) {
        TaskProvider generateMicroApkTask = this.taskFactory.register(new GenerateApkDataTask.CreationAction(appVariant, config2));
        TaskProvider[] taskProviderArray = new TaskProvider[]{generateMicroApkTask};
        TaskFactoryUtils.dependsOn(appVariant.getTaskContainer().getResourceGenTask(), taskProviderArray);
    }

    static /* synthetic */ void createGenerateMicroApkDataTask$default(ApplicationTaskManager applicationTaskManager, ApplicationVariantImpl applicationVariantImpl, FileCollection fileCollection2, int n, Object object) {
        if ((n & 2) != 0) {
            fileCollection2 = null;
        }
        applicationTaskManager.createGenerateMicroApkDataTask(applicationVariantImpl, fileCollection2);
    }

    private final void createAssetPackTasks(ApplicationVariantImpl appVariant) {
        Configuration assetPackFilesConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackManifest");
        Set<String> assetPacks = ((BaseAppModuleExtension)this.extension).getAssetPacks();
        IssueReporter issueReporter2 = appVariant.getServices().getIssueReporter();
        Intrinsics.checkNotNullExpressionValue((Object)assetPackFilesConfiguration, (String)"assetPackFilesConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)assetPackManifestConfiguration, (String)"assetPackManifestConfiguration");
        AssetPackUtilKt.populateAssetPacksConfigurations(this.project, issueReporter2, assetPacks, assetPackFilesConfiguration, assetPackManifestConfiguration);
        Collection collection = assetPacks;
        boolean bl = false;
        if (!collection.isEmpty()) {
            FileCollection assetPackManifest = assetPackManifestConfiguration.getIncoming().getFiles();
            FileCollection assetFiles = assetPackFilesConfiguration.getIncoming().getFiles();
            ApkCreationConfig apkCreationConfig = appVariant;
            Intrinsics.checkNotNullExpressionValue((Object)assetPackManifest, (String)"assetPackManifest");
            Set<String> set = assetPacks.stream().map(createAssetPackTasks.1.INSTANCE).collect(Collectors.toSet());
            Intrinsics.checkNotNullExpressionValue(set, (String)"assetPacks\n                        .stream()\n                        .map { assetPackName: String ->\n                            assetPackName.replace(\n                                \":\",\n                                File.separator\n                            )\n                        }\n                        .collect(Collectors.toSet())");
            this.taskFactory.register(new ProcessAssetPackManifestTask.CreationAction(apkCreationConfig, assetPackManifest, set));
            this.taskFactory.register(new LinkManifestForAssetPackTask.CreationAction(appVariant));
            VariantCreationConfig variantCreationConfig = appVariant;
            Intrinsics.checkNotNullExpressionValue((Object)assetFiles, (String)"assetFiles");
            this.taskFactory.register(new AssetPackPreBundleTask.CreationAction(variantCreationConfig, assetFiles));
        }
    }

    private final void createDynamicBundleTask(ComponentInfo<ApplicationVariantBuilderImpl, ApplicationVariantImpl> variantInfo) {
        ApplicationVariantImpl variant2 = variantInfo.getVariant();
        if (variant2.getServices().getProjectInfo().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variant2));
        boolean debuggable = variantInfo.getVariantBuilder().getDebuggable();
        boolean includeSdkInfoInApk = variantInfo.getVariantBuilder().getDependenciesInfo().getIncludedInApk();
        boolean includeSdkInfoInBundle = variantInfo.getVariantBuilder().getDependenciesInfo().getIncludedInBundle();
        if (!debuggable) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variant2));
        }
        if (variant2.getVariantType().isBaseModule()) {
            this.taskFactory.register(new ParseIntegrityConfigTask.CreationAction(variant2));
            this.taskFactory.register(new PackageBundleTask.CreationAction(variant2));
            if (!debuggable) {
                if (includeSdkInfoInBundle) {
                    this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(variant2));
                }
                if (includeSdkInfoInApk && variant2.getServices().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                    this.taskFactory.register(new SdkDependencyDataGeneratorTask.CreationAction(variant2));
                }
            }
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(variant2));
            this.taskFactory.register(new BundleIdeModelProducerTask.CreationAction(variant2));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant2, "Bundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            this.taskFactory.register(new BundleToApkTask.CreationAction(variant2));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(variant2));
            this.taskFactory.register(new ExtractApksTask.CreationAction(variant2));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant2, "ApksFromBundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            this.taskFactory.register(AnchorTaskNames.INSTANCE.getExtractApksAnchorTaskName(variant2), (Action<? super Task>)((Action)new Action<Task>(variant2){
                final /* synthetic */ ApplicationVariantImpl $variant;
                {
                    this.$variant = $variant;
                }

                public final void execute(Task it) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE)};
                    it.dependsOn(objectArray);
                }
            }));
            this.taskFactory.register(new MergeNativeDebugMetadataTask.CreationAction(variant2));
            variant2.getTaskContainer().getAssembleTask().configure((Action)new Action<Task>(variant2){
                final /* synthetic */ ApplicationVariantImpl $variant;
                {
                    this.$variant = $variant;
                }

                public final void execute(Task task) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.MERGED_NATIVE_DEBUG_METADATA.INSTANCE)};
                    task.dependsOn(objectArray);
                }
            });
        }
    }

    private final void createSoftwareComponent(ApplicationVariantImpl appVariant, String componentName, AndroidArtifacts.PublishedConfigType publication) {
        AdhocComponentWithVariants component2 = this.globalScope.getComponentFactory().adhoc(componentName);
        Configuration configuration = appVariant.getVariantDependencies().getElements(new PublishedConfigSpec(publication, componentName, false));
        Intrinsics.checkNotNull((Object)configuration);
        Configuration config2 = configuration;
        component2.addVariantsFromConfiguration(config2, (Action)createSoftwareComponent.1.INSTANCE);
        this.project.getComponents().add((Object)component2);
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (this.extension instanceof BaseAppModuleExtension && ((BaseAppModuleExtension)this.extension).getDynamicFeatures().isEmpty() || creationConfig instanceof AndroidTestCreationConfig) {
            super.createInstallTask(creationConfig);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(creationConfig));
        }
    }
}

