/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public class LintCompile
extends DefaultTask {
    private File outputDirectory;

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @TaskAction
    public void compile() {
        FileUtils.mkdirs((File)this.getOutputDirectory());
    }

    public static class CreationAction
    extends TaskCreationAction<LintCompile> {
        private final ProjectInfo projectInfo;

        public CreationAction(ProjectInfo projectInfo) {
            this.projectInfo = projectInfo;
        }

        @Override
        public String getName() {
            return "compileLint";
        }

        @Override
        public Class<LintCompile> getType() {
            return LintCompile.class;
        }

        @Override
        public void configure(LintCompile task) {
            task.setOutputDirectory(new File(this.projectInfo.getIntermediatesDir(), "lint"));
        }
    }
}

