/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.VariantOutput;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantTypeImpl;

public class ApiObjectFactory {
    private final BaseExtension extension;
    private final VariantFactory<?, ?> variantFactory;
    private final GlobalScope globalScope;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(BaseExtension extension, VariantFactory<?, ?> variantFactory, GlobalScope globalScope) {
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.globalScope = globalScope;
    }

    public BaseVariantImpl create(VariantImpl variant2) {
        BaseVariantData variantData = variant2.getVariantData();
        BaseVariantImpl variantApi = this.variantFactory.createVariantApi(this.globalScope, variant2, variantData, this.readOnlyObjectProvider);
        if (variantApi == null) {
            return null;
        }
        if (this.variantFactory.getVariantType().getHasTestComponents()) {
            ComponentImpl unitTestVariantProperties;
            BaseServices services = this.variantFactory.getServicesForOldVariantObjectsOnly();
            ComponentImpl androidTestVariantProperties = variant2.getTestComponents().get(VariantTypeImpl.ANDROID_TEST);
            if (androidTestVariantProperties != null) {
                TestVariantImpl androidTestVariant = services.newInstance(TestVariantImpl.class, androidTestVariantProperties.getVariantData(), androidTestVariantProperties, variantApi, services, this.readOnlyObjectProvider, services.getProjectInfo().getProject().container(VariantOutput.class));
                this.createVariantOutput(androidTestVariantProperties, androidTestVariant);
                ((TestedAndroidConfig)((Object)this.extension)).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)((Object)variantApi)).setTestVariant(androidTestVariant);
            }
            if ((unitTestVariantProperties = variant2.getTestComponents().get(VariantTypeImpl.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = services.newInstance(UnitTestVariantImpl.class, unitTestVariantProperties.getVariantData(), unitTestVariantProperties, variantApi, services, this.readOnlyObjectProvider, services.getProjectInfo().getProject().container(VariantOutput.class));
                ((TestedAndroidConfig)((Object)this.extension)).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)((Object)variantApi)).setUnitTestVariant(unitTestVariant);
            }
        }
        this.createVariantOutput(variant2, variantApi);
        try {
            this.extension.addVariant(variantApi);
        }
        catch (Throwable t) {
            throw new ExternalApiUsageException(t);
        }
        return variantApi;
    }

    private void createVariantOutput(ComponentImpl component2, BaseVariantImpl variantApi) {
        BaseServices services = this.variantFactory.getServicesForOldVariantObjectsOnly();
        VariantOutputFactory variantOutputFactory = new VariantOutputFactory(component2.getVariantType().isAar() ? LibraryVariantOutputImpl.class : ApkVariantOutputImpl.class, services, this.extension, variantApi, component2.getVariantType(), component2.getTaskContainer());
        component2.getOutputs().forEach(variantOutputFactory::create);
    }
}

