/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.JdkImageTransformDelegate;
import com.android.build.gradle.internal.dependency.JdkTools;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.util.function.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/dependency/JdkImageTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/JdkImageTransform$Parameters;", "()V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "gradle-core"})
public abstract class JdkImageTransform
implements TransformAction<Parameters> {
    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File outputDir = outputs.dir((Object)"output");
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        File tempDir = FilesKt.resolve((File)outputDir, (String)"temp");
        File jdkImageDir = FilesKt.resolve((File)outputDir, (String)"jdkImage");
        Object object = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputArtifact.get().asFile");
        File file = object;
        object = ((Parameters)this.getParameters()).getJavaHome().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.javaHome.get()");
        File file2 = (File)object;
        object = this.getExecOperations();
        ProcessExecutor processExecutor2 = new GradleProcessExecutor(new Function<Action<? super ExecSpec>, ExecResult>((ExecOperations)object){
            final /* synthetic */ ExecOperations $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ExecResult apply(Action<? super ExecSpec> p0) {
                return this.$tmp0.exec(p0);
            }
        });
        object = LoggerWrapper.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(this::class.java)");
        new JdkImageTransformDelegate(file, tempDir, jdkImageDir, new JdkTools(file2, processExecutor2, (ILogger)object)).run();
        FileUtils.deleteRecursivelyIfExists((File)tempDir);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/dependency/JdkImageTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "javaHome", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getJavaHome", "()Lorg/gradle/api/provider/Property;", "jdkId", "", "getJdkId", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        @NotNull
        public Property<String> getJdkId();

        @Internal
        @NotNull
        public Property<File> getJavaHome();
    }
}

