/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.CompileData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"ADDON_PATTERN", "Ljava/util/regex/Pattern;", "API_PATTERN", "parseTargetHash", "Lcom/android/build/gradle/internal/utils/CompileData;", "targetHash", "", "gradle-core"})
public final class SdkUtilsKt {
    @NotNull
    private static final Pattern API_PATTERN;
    @NotNull
    private static final Pattern ADDON_PATTERN;

    @NotNull
    public static final CompileData parseTargetHash(@NotNull String targetHash) {
        Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
        Matcher m = API_PATTERN.matcher(targetHash);
        if (m.matches()) {
            CompileData compileData;
            String api = m.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)api, (String)"api");
            Integer apiLevel = StringsKt.toIntOrNull((String)api);
            if (apiLevel != null) {
                String string = m.group(3);
                Integer n = string == null ? null : StringsKt.toIntOrNull((String)string);
                compileData = new CompileData(apiLevel, null, n, null, null, 26, null);
            } else {
                compileData = new CompileData(null, api, null, null, null, 29, null);
            }
            return compileData;
        }
        Matcher m2 = ADDON_PATTERN.matcher(targetHash);
        if (!m2.matches()) {
            throw new RuntimeException(StringsKt.trimIndent((String)("\n                            Unsupported value: " + targetHash + ". Format must be one of:\n                            - android-31\n                            - android-31-ext2\n                            - android-T\n                            - vendorName:addonName:31\n                            ")));
        }
        String string = m2.group(1);
        String string2 = m2.group(2);
        String string3 = m2.group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"m2.group(3)");
        boolean bl = false;
        int n = Integer.parseInt(string3);
        return new CompileData(n, null, null, string, string2, 6, null);
    }

    static {
        Pattern pattern = Pattern.compile("^android-([0-9A-Za-z]+)(-ext(\\d+))?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^android-([0-9A-Za-z]+)(-ext(\\\\d+))?$\")");
        API_PATTERN = pattern;
        pattern = Pattern.compile("^(.+):(.+):(\\d+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^(.+):(.+):(\\\\d+)$\")");
        ADDON_PATTERN = pattern;
    }
}

