/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\t"}, d2={"getApkFiles", "", "Ljava/nio/file/Path;", "apkBundle", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "moduleName", "", "getDeviceJson", "gradle-core"})
@JvmName(name="BundleInstallUtils")
public final class BundleInstallUtils {
    @NotNull
    public static final Path getDeviceJson(@NotNull DeviceConfigProvider device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getApiCodeName();
        String api = string == null ? Integer.valueOf(device.getApiLevel()) : string;
        int density = device.getDensity();
        List abis2 = device.getAbis();
        Set languages = device.getLanguageSplits();
        Path path = Files.createTempFile("apkSelect", "", new FileAttribute[0]);
        boolean bl = false;
        boolean bl2 = false;
        Path $this$getDeviceJson_u24lambda_u2d0 = path;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder().append("{\n  \"supportedAbis\": [");
        Intrinsics.checkNotNullExpressionValue((Object)abis2, (String)"abis");
        String json = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)abis2, null, null, null, (int)0, null, null, (int)63, null)).append("],\n  \"screenDensity\": ").append(density).append(",\n  \"sdkVersion\": ").append((Object)api).toString();
        if (languages != null && !languages.isEmpty()) {
            json = json + ",\n  \"supportedLocales\": [ " + Joiner.on((char)',').join((Iterable)languages) + " ]\n";
        }
        String string2 = json = Intrinsics.stringPlus((String)json, (Object)"}");
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write($this$getDeviceJson_u24lambda_u2d0, byArray, new OpenOption[0]);
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(\"apkSelect\", \"\").apply {\n        var json = \"{\\n\" +\n                \"  \\\"supportedAbis\\\": [${abis.joinToString()}],\\n\" +\n                \"  \\\"screenDensity\\\": $density,\\n\" +\n                \"  \\\"sdkVersion\\\": $api\"\n\n        if (languages != null && !languages.isEmpty()) {\n            json = \"$json,\\n  \\\"supportedLocales\\\": [ ${Joiner.on(',').join(languages)} ]\\n\"\n        }\n\n        json = \"$json}\"\n\n        Files.write(this, json.toByteArray(Charsets.UTF_8))\n    }");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> getApkFiles(@NotNull Path apkBundle, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Path jsonFile = BundleInstallUtils.getDeviceJson(device);
        Path path = Files.createTempDirectory("apkSelect", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(\"apkSelect\")");
        Path tempFolder = path;
        Object object = Devices.DeviceSpec.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Devices.DeviceSpec.Builder builder = object;
        object = Files.newBufferedReader(jsonFile, Charsets.UTF_8);
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl3 = false;
            JsonFormat.parser().merge((Reader)it, (Message.Builder)builder);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(apkBundle).setDeviceSpec(builder.build()).setOutputDirectory(tempFolder);
        String string = moduleName;
        if (string != null) {
            object2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it = object2;
            boolean bl6 = false;
            command.setModules(ImmutableSet.of((Object)it));
        }
        string = command.build().execute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.build().execute()");
        return (List)((Object)string);
    }

    public static /* synthetic */ List getApkFiles$default(Path path, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(path, deviceConfigProvider, string);
    }
}

