/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"generatePrefabPackages", "", "ops", "Lorg/gradle/process/ExecOperations;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "gradle-core"})
public final class GeneratePrefabPackagesKt {
    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abiModel) {
        String string;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abiModel, (String)"abiModel");
        Iterable $this$map$iv = CreateCxxVariantModelKt.getPrefabPackageDirectoryList(abiModel.getVariant());
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getPath();
            collection.add(string2);
        }
        List packagePaths = (List)destination$iv$iv;
        NativeBuildSystem $i$f$map22 = abiModel.getVariant().getModule().getBuildSystem();
        int $this$mapTo$iv$iv2 = WhenMappings.$EnumSwitchMapping$0[$i$f$map22.ordinal()];
        switch ($this$mapTo$iv$iv2) {
            case 1: {
                string = "ndk-build";
                break;
            }
            case 2: {
                string = "cmake";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String buildSystem2 = string;
        int osVersion = abiModel.getAbiPlatformVersion();
        destination$iv$iv = CreateCxxVariantModelKt.getPrefabClassPath(abiModel.getVariant());
        if (destination$iv$iv == null) {
            throw new RuntimeException("CxxAbiModule.prefabClassPath cannot be null when Prefab is used");
        }
        Object prefabClassPath = destination$iv$iv;
        ProcessInfoBuilder builder = new ProcessInfoBuilder().setClasspath(((File)prefabClassPath).toString()).setMain("com.google.prefab.cli.AppKt").addArgs("--build-system", buildSystem2).addArgs("--platform", "android").addArgs("--abi", abiModel.getAbi().getTag()).addArgs("--os-version", String.valueOf(osVersion)).addArgs("--stl", abiModel.getVariant().getStlType()).addArgs("--ndk-version", String.valueOf(abiModel.getVariant().getModule().getNdkVersion().getMajor())).addArgs("--output", FilesKt.resolve((File)abiModel.getPrefabFolder(), (String)"prefab").toString()).addArgs(packagePaths);
        File file = FilesKt.resolve((File)abiModel.getSoFolder(), (String)("prefab_command_" + buildSystem2 + '_' + abiModel.getAbi().getTag() + ".txt"));
        File file2 = FilesKt.resolve((File)abiModel.getSoFolder(), (String)("prefab_stdout_" + buildSystem2 + '_' + abiModel.getAbi().getTag() + ".txt"));
        File file3 = FilesKt.resolve((File)abiModel.getSoFolder(), (String)("prefab_stderr_" + buildSystem2 + '_' + abiModel.getAbi().getTag() + ".txt"));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        ProcessOutputJunctionKt.createProcessOutputJunction(file, file2, file3, builder, "prefab").javaProcess().logStderr().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super JavaExecSpec>, ExecResult>(ops2){

            public final ExecResult invoke(Action<? super JavaExecSpec> p0) {
                return ((ExecOperations)this.receiver).javaexec(p0);
            }
        }));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 1;
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

