/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.variant.HasAndroidResources;
import com.android.build.api.variant.ResValue;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.generators.ResValueGenerator;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/tasks/GenerateResValues;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "items", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/api/variant/ResValue$Key;", "Lcom/android/build/api/variant/ResValue;", "getItems", "()Lorg/gradle/api/provider/MapProperty;", "resOutputDir", "Ljava/io/File;", "getResOutputDir", "()Ljava/io/File;", "setResOutputDir", "(Ljava/io/File;)V", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class GenerateResValues
extends NonIncrementalTask {
    public File resOutputDir;

    @OutputDirectory
    @NotNull
    public final File getResOutputDir() {
        File file = this.resOutputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resOutputDir");
        throw null;
    }

    public final void setResOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.resOutputDir = file;
    }

    @Input
    @NotNull
    public abstract MapProperty<ResValue.Key, ResValue> getItems();

    @Override
    protected void doTaskAction() {
        File folder = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)folder);
        Object object = this.getItems().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"items.get()");
        object = (Map)object;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = this.getItems().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"items.get()");
            new ResValueGenerator(folder, (Map)object).generate();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/GenerateResValues$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateResValues;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateResValues, ComponentCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateResValues> type;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = this.computeTaskName("generate", "ResValues");
            this.type = GenerateResValues.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateResValues> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateResValues> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setGenerateResValuesTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateResValues task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            if (this.creationConfig instanceof HasAndroidResources) {
                task.getItems().set((Provider)((HasAndroidResources)this.creationConfig).getResValues());
            } else {
                task.getItems().empty();
            }
            File file = ((Directory)this.creationConfig.getPaths().getGeneratedResOutputDir().forUseAtConfigurationTime().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"creationConfig.paths.generatedResOutputDir.forUseAtConfigurationTime().get().asFile");
            task.setResOutputDir(file);
        }
    }
}

