/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.AndroidResources;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.BooleanOption;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public abstract class AaptOptions
implements com.android.build.api.dsl.AaptOptions,
AndroidResources {
    @Inject
    public AaptOptions(DslServices dslServices) {
        this.setNamespaced(dslServices.getProjectOptions().get(BooleanOption.ENABLE_RESOURCE_NAMESPACING_DEFAULT));
    }

    protected abstract List<String> getInternalNoCompressList();

    public void setIgnoreAssets(String ignoreAssetsPattern) {
        this.setIgnoreAssetsPattern(ignoreAssetsPattern);
    }

    public String getIgnoreAssets() {
        return this.getIgnoreAssetsPattern();
    }

    public abstract void setIgnoreAssetsPattern(String var1);

    public abstract String getIgnoreAssetsPattern();

    public void setNoCompress(String noCompress) {
        this.setNoCompress(Collections.singletonList(noCompress));
    }

    public void setNoCompress(Iterable<String> noCompress) {
        this.setNoCompress((String[])Iterables.toArray(noCompress, String.class));
    }

    public void setNoCompress(String ... noCompress) {
        this.getInternalNoCompressList().clear();
        this.noCompress(noCompress);
    }

    public Collection<String> getNoCompress() {
        return this.getInternalNoCompressList();
    }

    public void useNewCruncher(boolean value) {
        LoggerWrapper.getLogger(AaptOptions.class).warning("useNewCruncher has been deprecated. It will be removed in a future version of the gradle plugin. New cruncher is now always enabled.", new Object[0]);
    }

    public void setUseNewCruncher(boolean value) {
        LoggerWrapper.getLogger(AaptOptions.class).warning("useNewCruncher has been deprecated. It will be removed in a future version of the gradle plugin. New cruncher is now always enabled.", new Object[0]);
    }

    public void setCruncherEnabled(boolean value) {
        this.setCruncherEnabledOverride(value);
    }

    @Deprecated
    public boolean getCruncherEnabled() {
        Boolean cruncherEnabled = this.getCruncherEnabledOverride();
        return cruncherEnabled == null ? true : cruncherEnabled;
    }

    public abstract Boolean getCruncherEnabledOverride();

    protected abstract void setCruncherEnabledOverride(Boolean var1);

    public boolean getUseNewCruncher() {
        return true;
    }

    public void failOnMissingConfigEntry(boolean value) {
        this.setFailOnMissingConfigEntry(value);
    }

    public abstract void setFailOnMissingConfigEntry(boolean var1);

    public abstract boolean getFailOnMissingConfigEntry();

    public void noCompress(String noCompress) {
        this.getNoCompress().add(noCompress);
    }

    public void noCompress(String ... noCompress) {
        for (String p : noCompress) {
            if (!p.equals("\"\"")) continue;
            LoggerWrapper.getLogger(AaptOptions.class).warning("noCompress pattern '\"\"' no longer matches every file. It now matches exactly two double quote characters. Please use '' instead.", new Object[0]);
        }
        Collections.addAll(this.getNoCompress(), noCompress);
    }

    public void additionalParameters(String param) {
        this.getAdditionalParameters().add(param);
    }

    public void additionalParameters(String ... params) {
        Collections.addAll(this.getAdditionalParameters(), params);
    }

    public abstract void setAdditionalParameters(List<String> var1);

    public abstract List<String> getAdditionalParameters();

    public abstract void setCruncherProcesses(int var1);

    public abstract int getCruncherProcesses();

    public abstract boolean getNamespaced();

    public abstract void setNamespaced(boolean var1);

    public void namespaced(boolean namespaced) {
        this.setNamespaced(namespaced);
    }
}

