/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.ide.dependencies.LibraryService;
import com.android.build.gradle.internal.ide.dependencies.LibraryServiceImpl;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.LocalJarCache;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.StringCache;
import com.android.build.gradle.internal.ide.v2.LibraryImpl;
import com.android.build.gradle.internal.ide.v2.LibraryInfoImpl;
import com.android.build.gradle.internal.ide.v2.ProjectInfoImpl;
import com.android.builder.model.v2.ide.Library;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0002JH\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\f2*\u0010\u001a\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001c0\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/LibraryServiceImpl;", "Lcom/android/build/gradle/internal/ide/dependencies/LibraryService;", "stringCache", "Lcom/android/build/gradle/internal/ide/dependencies/StringCache;", "localJarCache", "Lcom/android/build/gradle/internal/ide/dependencies/LocalJarCache;", "(Lcom/android/build/gradle/internal/ide/dependencies/StringCache;Lcom/android/build/gradle/internal/ide/dependencies/LocalJarCache;)V", "libraryCache", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "Lcom/android/builder/model/v2/ide/Library;", "libraryInfoCache", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "Lcom/android/build/gradle/internal/ide/v2/LibraryInfoImpl;", "libraryInfoForLocalJarsCache", "Ljava/io/File;", "projectInfoCache", "Lcom/android/build/gradle/internal/ide/v2/ProjectInfoImpl;", "createLibrary", "artifact", "getAllLibraries", "", "getAttributeMap", "", "", "variant", "attributeTransform", "Lkotlin/Function1;", "Lkotlin/Pair;", "getCapabilityList", "", "getLibrary", "getLibraryInfo", "getProjectInfo", "gradle-core"})
public final class LibraryServiceImpl
implements LibraryService {
    @NotNull
    private final StringCache stringCache;
    @NotNull
    private final LocalJarCache localJarCache;
    @NotNull
    private final Map<ResolvedArtifact, Library> libraryCache;
    @NotNull
    private final Map<ResolvedVariantResult, ProjectInfoImpl> projectInfoCache;
    @NotNull
    private final Map<ResolvedVariantResult, LibraryInfoImpl> libraryInfoCache;
    @NotNull
    private final Map<File, LibraryInfoImpl> libraryInfoForLocalJarsCache;

    public LibraryServiceImpl(@NotNull StringCache stringCache, @NotNull LocalJarCache localJarCache) {
        Intrinsics.checkNotNullParameter((Object)stringCache, (String)"stringCache");
        Intrinsics.checkNotNullParameter((Object)localJarCache, (String)"localJarCache");
        this.stringCache = stringCache;
        this.localJarCache = localJarCache;
        boolean bl = false;
        this.libraryCache = new LinkedHashMap();
        bl = false;
        this.projectInfoCache = new LinkedHashMap();
        bl = false;
        this.libraryInfoCache = new LinkedHashMap();
        bl = false;
        this.libraryInfoForLocalJarsCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Library getLibrary(@NotNull ResolvedArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Library library = this.libraryCache.computeIfAbsent(artifact, arg_0 -> LibraryServiceImpl.getLibrary$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"libraryCache.computeIfAb\u2026Library(it)\n            }");
        return library;
    }

    @NotNull
    public final Collection<Library> getAllLibraries() {
        return this.libraryCache.values();
    }

    private final ProjectInfoImpl getProjectInfo(ResolvedVariantResult variant2) {
        ProjectInfoImpl projectInfoImpl = this.projectInfoCache.computeIfAbsent(variant2, arg_0 -> LibraryServiceImpl.getProjectInfo$lambda-1(variant2, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)projectInfoImpl, (String)"projectInfoCache.compute\u2026          )\n            }");
        return projectInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibraryInfoImpl getLibraryInfo(ResolvedArtifact artifact) {
        LibraryInfoImpl libraryInfoImpl;
        ComponentIdentifier component2 = artifact.getVariant().getOwner();
        if (component2 instanceof ModuleComponentIdentifier) {
            LibraryInfoImpl libraryInfoImpl2 = this.libraryInfoCache.computeIfAbsent(artifact.getVariant(), arg_0 -> LibraryServiceImpl.getLibraryInfo$lambda-2(this, component2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)libraryInfoImpl2, (String)"{\n                    //\u2026      }\n                }");
            libraryInfoImpl = libraryInfoImpl2;
        } else if (component2 instanceof OpaqueComponentArtifactIdentifier) {
            LibraryInfoImpl libraryInfoImpl3 = this.libraryInfoForLocalJarsCache.computeIfAbsent(artifact.getArtifactFile(), arg_0 -> LibraryServiceImpl.getLibraryInfo$lambda-3(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)libraryInfoImpl3, (String)"{\n                    li\u2026      }\n                }");
            libraryInfoImpl = libraryInfoImpl3;
        } else if (component2 instanceof ProjectComponentIdentifier) {
            if (!artifact.isWrappedModule()) {
                throw new IllegalArgumentException(artifact.getVariant() + " is not wrapped");
            }
            Map<ResolvedVariantResult, LibraryInfoImpl> map = this.libraryInfoCache;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (map) {
                boolean bl3 = false;
                LibraryInfoImpl libraryInfoImpl4 = this.libraryInfoCache.computeIfAbsent(artifact.getVariant(), arg_0 -> LibraryServiceImpl.getLibraryInfo$lambda-5$lambda-4(this, component2, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)libraryInfoImpl4, (String)"libraryInfoCache.compute\u2026                        }");
                LibraryInfoImpl libraryInfoImpl5 = libraryInfoImpl4;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 8] lbl25 : MonitorExitStatement: MONITOREXIT : var3_5
                libraryInfoImpl = libraryInfoImpl5;
            }
        } else {
            throw new IllegalArgumentException(artifact.getVariant().getOwner().getClass() + " is not supported for LibraryInfo");
        }
        return libraryInfoImpl;
    }

    private final Library createLibrary(ResolvedArtifact artifact) {
        Library library;
        ComponentIdentifier id = artifact.getComponentIdentifier();
        if (!(id instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) {
            LibraryImpl libraryImpl;
            LibraryInfoImpl libraryInfo = this.getLibraryInfo(artifact);
            if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                Iterable iterable;
                File file = artifact.getExtractedFolder();
                if (file == null) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Null extracted folder for artifact: ", (Object)artifact));
                }
                File folder = file;
                String[] stringArray = new String[]{"api.jar"};
                File apiJar = FileUtils.join((File)folder, (String[])stringArray);
                String[] stringArray2 = new String[]{"jars", "classes.jar"};
                File runtimeJar = FileUtils.join((File)folder, (String[])stringArray2);
                Collection collection = CollectionsKt.listOf((Object)runtimeJar);
                List<File> list = this.localJarCache.getLocalJarsForAar(folder);
                if (list == null) {
                    boolean bl = false;
                    iterable = CollectionsKt.emptyList();
                } else {
                    iterable = list;
                }
                List runtimeJarFiles = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
                list = LibraryImpl.Companion;
                String string = this.stringCache.cacheString(libraryInfo.computeKey());
                File file2 = new File(folder, "AndroidManifest.xml");
                List list2 = apiJar.isFile() ? CollectionsKt.listOf((Object)apiJar) : runtimeJarFiles;
                File file3 = new File(folder, "res");
                File file4 = new File(folder, "res.apk");
                File file5 = new File(folder, "assets");
                File file6 = new File(folder, "jni");
                File file7 = new File(folder, "aidl");
                File file8 = new File(folder, "rs");
                File file9 = new File(folder, "proguard.txt");
                File file10 = new File(folder, "annotations.zip");
                File file11 = new File(folder, "public.txt");
                File file12 = new File(folder, "R.txt");
                File file13 = artifact.getPublishedLintJar();
                File file14 = artifact.getArtifactFile();
                libraryImpl = ((LibraryImpl.Companion)((Object)list)).createAndroidLibrary(string, libraryInfo, file14, file2, list2, runtimeJarFiles, file3, file4, file5, file6, file7, file8, file9, file13, file10, file11, file12);
            } else {
                libraryImpl = LibraryImpl.Companion.createJavaLibrary(this.stringCache.cacheString(libraryInfo.computeKey()), libraryInfo, artifact.getArtifactFile());
            }
            library = libraryImpl;
        } else {
            ProjectInfoImpl projectInfo = this.getProjectInfo(artifact.getVariant());
            library = LibraryImpl.Companion.createProjectLibrary(this.stringCache.cacheString(projectInfo.computeKey()), projectInfo, artifact.getPublishedLintJar());
        }
        return library;
    }

    private final Map<String, String> getAttributeMap(ResolvedVariantResult variant2) {
        return this.getAttributeMap(variant2, (Function1<? super Pair<String, String>, Pair<String, String>>)((Function1)getAttributeMap.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getAttributeMap(ResolvedVariantResult variant2, Function1<? super Pair<String, String>, Pair<String, String>> attributeTransform) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Set set = variant2.getAttributes().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"variant.attributes.keySet()");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Attribute key = (Attribute)element$iv$iv;
            boolean bl2 = false;
            Object attr = variant2.getAttributes().getAttribute(key);
            Object object = attr;
            if (object == null) {
                pair = null;
            } else {
                Object object2 = object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                Pair attribute = (Pair)attributeTransform.invoke((Object)TuplesKt.to((Object)key.getName(), (Object)it.toString()));
                pair = TuplesKt.to((Object)this.stringCache.cacheString((String)attribute.getFirst()), (Object)this.stringCache.cacheString((String)attribute.getSecond()));
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getFirst(), (Object)"artifactType"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getCapabilityList(ResolvedVariantResult variant2) {
        void $this$mapTo$iv$iv;
        List list = variant2.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.capabilities");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Capability capability = (Capability)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.stringCache.cacheString(it.getGroup() + ':' + it.getName() + ':' + it.getVersion());
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private static final Library getLibrary$lambda-0(LibraryServiceImpl this$0, ResolvedArtifact it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createLibrary(it);
    }

    private static final ProjectInfoImpl getProjectInfo$lambda-1(ResolvedVariantResult $variant, LibraryServiceImpl this$0, ResolvedVariantResult it) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ComponentIdentifier componentIdentifier = it.getOwner();
        if (componentIdentifier == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
        }
        ProjectComponentIdentifier component2 = (ProjectComponentIdentifier)componentIdentifier;
        boolean isTestFixturesVariant = LibraryUtils.isTestFixturesVariant($variant);
        Map<String, String> map = this$0.getAttributeMap(it, (Function1<? super Pair<String, String>, Pair<String, String>>)((Function1)new Function1<Pair<? extends String, ? extends String>, Pair<? extends String, ? extends String>>(isTestFixturesVariant){
            final /* synthetic */ boolean $isTestFixturesVariant;
            {
                this.$isTestFixturesVariant = $isTestFixturesVariant;
                super(1);
            }

            @NotNull
            public final Pair<String, String> invoke(@NotNull Pair<String, String> attribute) {
                Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
                return this.$isTestFixturesVariant && Intrinsics.areEqual((Object)attribute.getFirst(), (Object)VariantAttr.class.getName()) ? TuplesKt.to((Object)attribute.getFirst(), (Object)Intrinsics.stringPlus((String)((String)attribute.getSecond()), (Object)"TestFixtures")) : attribute;
            }
        }));
        List<String> list = this$0.getCapabilityList(it);
        StringCache stringCache = this$0.stringCache;
        String string = component2.getBuild().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.build.name");
        String string2 = stringCache.cacheString(string);
        StringCache stringCache2 = this$0.stringCache;
        string = component2.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.projectPath");
        return new ProjectInfoImpl(map, list, string2, stringCache2.cacheString(string));
    }

    private static final LibraryInfoImpl getLibraryInfo$lambda-2(LibraryServiceImpl this$0, ComponentIdentifier $component, ResolvedVariantResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, String> map = this$0.getAttributeMap(it);
        List<String> list = this$0.getCapabilityList(it);
        StringCache stringCache = this$0.stringCache;
        String string = ((ModuleComponentIdentifier)$component).getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.group");
        String string2 = stringCache.cacheString(string);
        StringCache stringCache2 = this$0.stringCache;
        string = ((ModuleComponentIdentifier)$component).getModule();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.module");
        String string3 = stringCache2.cacheString(string);
        StringCache stringCache3 = this$0.stringCache;
        string = ((ModuleComponentIdentifier)$component).getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.version");
        return new LibraryInfoImpl(map, list, string2, string3, stringCache3.cacheString(string));
    }

    private static final LibraryInfoImpl getLibraryInfo$lambda-3(LibraryServiceImpl this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        bl = false;
        List list = CollectionsKt.emptyList();
        String string = this$0.stringCache.cacheString("__local_aars__");
        StringCache stringCache = this$0.stringCache;
        String string2 = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.absolutePath");
        return new LibraryInfoImpl(map, list, string, stringCache.cacheString(string2), this$0.stringCache.cacheString("unspecified"));
    }

    private static final LibraryInfoImpl getLibraryInfo$lambda-5$lambda-4(LibraryServiceImpl this$0, ComponentIdentifier $component, ResolvedVariantResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LibraryInfoImpl(this$0.getAttributeMap(it), this$0.getCapabilityList(it), "__wrapped_aars__", this$0.stringCache.cacheString(((ProjectComponentIdentifier)$component).getBuild().getName() + '|' + ((ProjectComponentIdentifier)$component).getProjectPath()), this$0.stringCache.cacheString("unspecified"));
    }
}

