/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.lint.ProjectKey;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a0\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u0000\u00a8\u0006\f"}, d2={"asProjectKey", "Lcom/android/build/gradle/internal/lint/ProjectKey;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "asProjectKeyedMap", "", "Ljava/io/File;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "gradle-core"})
public final class ProjectKeyKt {
    @NotNull
    public static final ProjectKey asProjectKey(@NotNull ImmutableMap<String, String> buildMapping, @NotNull ResolvedArtifactResult artifact) {
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Object object = artifact.getId().getComponentIdentifier();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
        }
        ProjectComponentIdentifier id = (ProjectComponentIdentifier)object;
        String string = BuildMappingUtils.getBuildId(id, buildMapping);
        Intrinsics.checkNotNull((Object)string);
        object = id.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id.projectPath");
        return new ProjectKey(string, (String)object, LibraryUtils.getVariantName(artifact));
    }

    @NotNull
    public static final Map<ProjectKey, File> asProjectKeyedMap(@NotNull ArtifactCollection $this$asProjectKeyedMap, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$asProjectKeyedMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        Set set = $this$asProjectKeyedMap.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"artifacts");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<ResolvedArtifactResult, Pair<? extends ProjectKey, ? extends File>>(buildMapping){
            final /* synthetic */ ImmutableMap<String, String> $buildMapping;
            {
                this.$buildMapping = $buildMapping;
                super(1);
            }

            @NotNull
            public final Pair<ProjectKey, File> invoke(ResolvedArtifactResult artifact) {
                Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
                return TuplesKt.to((Object)ProjectKeyKt.asProjectKey(this.$buildMapping, artifact), (Object)artifact.getFile());
            }
        })));
    }
}

