/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.process.GradleProcessResult;
import com.android.build.gradle.internal.process.OutputHandlerFailedGradleProcessResult;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public class GradleJavaProcessExecutor
implements JavaProcessExecutor {
    private final Function<Action<? super JavaExecSpec>, ExecResult> execOperations;

    public GradleJavaProcessExecutor(Function<Action<? super JavaExecSpec>, ExecResult> execOperations) {
        this.execOperations = execOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult execute(JavaProcessInfo javaProcessInfo, ProcessOutputHandler processOutputHandler) {
        ExecResult result;
        LoggerWrapper.getLogger(GradleJavaProcessExecutor.class).info("Executing java process: ", javaProcessInfo.toString());
        ProcessOutput output2 = processOutputHandler.createOutput();
        try {
            result = this.execOperations.apply(new ExecAction(javaProcessInfo, output2));
        }
        catch (Throwable throwable) {
            try {
                output2.close();
            }
            catch (IOException e) {
                LoggerWrapper.getLogger(GradleJavaProcessExecutor.class).warning("Exception while closing sub process streams", e);
            }
            throw throwable;
        }
        try {
            output2.close();
        }
        catch (IOException e) {
            LoggerWrapper.getLogger(GradleJavaProcessExecutor.class).warning("Exception while closing sub process streams", e);
        }
        try {
            processOutputHandler.handleOutput(output2);
        }
        catch (ProcessException e) {
            return new OutputHandlerFailedGradleProcessResult(e);
        }
        return new GradleProcessResult(result, (ProcessInfo)javaProcessInfo);
    }

    private static class ExecAction
    implements Action<JavaExecSpec> {
        private final JavaProcessInfo javaProcessInfo;
        private final ProcessOutput processOutput;

        private ExecAction(JavaProcessInfo javaProcessInfo, ProcessOutput processOutput) {
            this.javaProcessInfo = javaProcessInfo;
            this.processOutput = processOutput;
        }

        public void execute(JavaExecSpec javaExecSpec) {
            javaExecSpec.classpath(new Object[]{new File(this.javaProcessInfo.getClasspath())});
            javaExecSpec.getMainClass().set((Object)this.javaProcessInfo.getMainClass());
            javaExecSpec.args((Iterable)this.javaProcessInfo.getArgs());
            javaExecSpec.jvmArgs((Iterable)this.javaProcessInfo.getJvmArgs());
            javaExecSpec.environment(this.javaProcessInfo.getEnvironment());
            javaExecSpec.setStandardOutput(this.processOutput.getStandardOutput());
            javaExecSpec.setErrorOutput(this.processOutput.getErrorOutput());
            javaExecSpec.systemProperty("java.awt.headless", (Object)"true");
            javaExecSpec.setIgnoreExitValue(true);
        }
    }
}

