/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.StartParameterUtils;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProjectData;
import com.android.build.gradle.internal.profile.TaskMetadata;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.profile.AnalyticsProfileWriter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.NameAnonymizerSerializer;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u0002022\u0006\u00106\u001a\u000207J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0006J\u0010\u0010E\u001a\u0002002\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0018\u0010H\u001a\u00020\u00062\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0006H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0006H\u0002J\u0010\u0010O\u001a\u0004\u0018\u00010,2\u0006\u0010G\u001a\u00020\u0006J\u0012\u0010P\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0016\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010S\u001a\u00020\u0006J\u001a\u0010T\u001a\u0002002\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010U\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u000e\u0010V\u001a\u0002022\u0006\u0010W\u001a\u00020\u000bJ(\u0010X\u001a\u0002022\u0006\u0010Y\u001a\u00020Z2\u0006\u0010D\u001a\u00020\u00062\b\u0010[\u001a\u0004\u0018\u00010\u00062\u0006\u0010\\\u001a\u00020]J2\u0010^\u001a\u0002022\u0006\u0010Y\u001a\u00020Z2\b\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u00062\u0006\u0010\\\u001a\u00020]J\u000e\u0010a\u001a\u0002022\u0006\u0010b\u001a\u00020(J\u000e\u0010c\u001a\u0002022\u0006\u0010d\u001a\u00020eJ\u0010\u0010f\u001a\u0002022\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010g\u001a\u0002022\b\u0010h\u001a\u0004\u0018\u00010iJ\u000e\u0010j\u001a\u0002022\u0006\u00103\u001a\u000204J\u0006\u0010k\u001a\u000202J.\u0010l\u001a\u0002022\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u00062\u0006\u0010m\u001a\u00020n2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00170*R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00158\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010&\u001a&\u0012\f\u0012\n )*\u0004\u0018\u00010(0( )*\u0012\u0012\f\u0012\n )*\u0004\u0018\u00010(0(\u0018\u00010*0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "", "profileBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/build/gradle/internal/profile/ProjectData;", "enableProfileJson", "", "profileDir", "Ljava/io/File;", "taskMetadata", "Lcom/android/build/gradle/internal/profile/TaskMetadata;", "rootProjectPath", "nameAnonymizer", "Lcom/android/builder/profile/NameAnonymizer;", "(Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;Ljava/util/concurrent/ConcurrentHashMap;ZLjava/io/File;Ljava/util/concurrent/ConcurrentHashMap;Ljava/lang/String;Lcom/android/builder/profile/NameAnonymizer;)V", "analyticsWriter", "Lcom/android/builder/profile/AnalyticsProfileWriter;", "applicationIds", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "configurationSpans", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "getConfigurationSpans", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "executionSpans", "getExecutionSpans$annotations", "()V", "getExecutionSpans", "initialMemorySample", "Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "getInitialMemorySample", "()Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "setInitialMemorySample", "(Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;)V", "lastRecordId", "Ljava/util/concurrent/atomic/AtomicLong;", "otherEvents", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "", "taskRecords", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "threadRecorder", "Lcom/android/builder/profile/Recorder;", "allocateRecordId", "", "collectTaskMetadata", "", "graph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "configureAnalyticsService", "params", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "createAndRecordMemorySample", "createMemorySample", "getFinalProfile", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile;", "getProfileDir", "Ljava/nio/file/Path;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "getProjectId", "getProjectPath", "taskPath", "getSystemProperty", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "propertyName", "getTaskExecutionType", "Lcom/android/tools/build/gradle/internal/profile/GradleTaskExecutionType;", "taskName", "getTaskRecord", "getTypeName", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "getVariantId", "getVariantName", "recordApplicationId", "metadataFile", "recordBlockAtConfiguration", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "recordBlockAtExecution", "transform", "Lcom/google/wireless/android/sdk/stats/GradleTransformExecution;", "recordEvent", "event", "recordGlobalProperties", "project", "Lorg/gradle/api/Project;", "recordPlugins", "recordTaskExecutionSpan", "finishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "recordTaskNames", "writeAndFinish", "writeRecord", "executionRecord", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "taskExecutionPhases", "gradle-core"})
public final class AnalyticsResourceManager {
    @NotNull
    private final GradleBuildProfile.Builder profileBuilder;
    @NotNull
    private final ConcurrentHashMap<String, ProjectData> projects;
    private boolean enableProfileJson;
    @Nullable
    private File profileDir;
    @NotNull
    private final ConcurrentHashMap<String, TaskMetadata> taskMetadata;
    @Nullable
    private String rootProjectPath;
    @NotNull
    private final NameAnonymizer nameAnonymizer;
    @NotNull
    private GradleBuildMemorySample initialMemorySample;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> configurationSpans;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> executionSpans;
    @NotNull
    private final ConcurrentLinkedQueue<String> applicationIds;
    @Nullable
    private AtomicLong lastRecordId;
    @NotNull
    private final ConcurrentHashMap<String, TaskProfilingRecord> taskRecords;
    private final List<AndroidStudioEvent.Builder> otherEvents;
    @NotNull
    private final Recorder threadRecorder;
    @NotNull
    private final AnalyticsProfileWriter analyticsWriter;

    public AnalyticsResourceManager(@NotNull GradleBuildProfile.Builder profileBuilder, @NotNull ConcurrentHashMap<String, ProjectData> projects, boolean enableProfileJson, @Nullable File profileDir, @NotNull ConcurrentHashMap<String, TaskMetadata> taskMetadata, @Nullable String rootProjectPath, @NotNull NameAnonymizer nameAnonymizer) {
        Intrinsics.checkNotNullParameter((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(taskMetadata, (String)"taskMetadata");
        Intrinsics.checkNotNullParameter((Object)nameAnonymizer, (String)"nameAnonymizer");
        this.profileBuilder = profileBuilder;
        this.projects = projects;
        this.enableProfileJson = enableProfileJson;
        this.profileDir = profileDir;
        this.taskMetadata = taskMetadata;
        this.rootProjectPath = rootProjectPath;
        this.nameAnonymizer = nameAnonymizer;
        this.initialMemorySample = this.createMemorySample();
        this.configurationSpans = new ConcurrentLinkedQueue();
        this.executionSpans = new ConcurrentLinkedQueue();
        this.applicationIds = new ConcurrentLinkedQueue();
        this.taskRecords = new ConcurrentHashMap();
        boolean bl = false;
        this.otherEvents = Collections.synchronizedList(new ArrayList());
        this.threadRecorder = (Recorder)new ThreadRecorder();
        this.analyticsWriter = new AnalyticsProfileWriter();
    }

    public /* synthetic */ AnalyticsResourceManager(GradleBuildProfile.Builder builder, ConcurrentHashMap concurrentHashMap, boolean bl, File file, ConcurrentHashMap concurrentHashMap2, String string, NameAnonymizer nameAnonymizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            nameAnonymizer = new NameAnonymizer();
        }
        this(builder, concurrentHashMap, bl, file, concurrentHashMap2, string, nameAnonymizer);
    }

    @NotNull
    public final GradleBuildMemorySample getInitialMemorySample() {
        return this.initialMemorySample;
    }

    public final void setInitialMemorySample(@NotNull GradleBuildMemorySample gradleBuildMemorySample) {
        Intrinsics.checkNotNullParameter((Object)gradleBuildMemorySample, (String)"<set-?>");
        this.initialMemorySample = gradleBuildMemorySample;
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getConfigurationSpans() {
        return this.configurationSpans;
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getExecutionSpans() {
        return this.executionSpans;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExecutionSpans$annotations() {
    }

    public final void writeAndFinish() {
        GradleBuildProfile gradleBuildProfile = this.getFinalProfile();
        List<AndroidStudioEvent.Builder> list = this.otherEvents;
        Intrinsics.checkNotNullExpressionValue(list, (String)"otherEvents");
        this.analyticsWriter.writeAndFinish(gradleBuildProfile, list, this.profileDir, this.enableProfileJson);
    }

    @NotNull
    public final GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.projects.computeIfAbsent(projectPath, arg_0 -> AnalyticsResourceManager.getProjectBuilder$lambda-0(this, arg_0)).getProjectBuilder();
    }

    @NotNull
    public final GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        ProjectData projectData = this.projects.computeIfAbsent(projectPath, arg_0 -> AnalyticsResourceManager.getVariantBuilder$lambda-1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)projectData, (String)"projects.computeIfAbsent\u2026projectBuilder)\n        }");
        ProjectData projectData2 = projectData;
        projectData = projectData2.getVariantBuilders().computeIfAbsent(variantName, arg_0 -> AnalyticsResourceManager.getVariantBuilder$lambda-2(this, projectPath, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)projectData, (String)"projectData.variantBuild\u2026 variantBuilder\n        }");
        return (GradleBuildVariant.Builder)projectData;
    }

    @Nullable
    public final TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        if (!this.taskRecords.containsKey(taskPath)) {
            GradleBuildProfileSpan.Builder builder = GradleBuildProfileSpan.newBuilder();
            boolean bl = false;
            boolean bl2 = false;
            GradleBuildProfileSpan.Builder $this$getTaskRecord_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$getTaskRecord_u24lambda_u2d3.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
            $this$getTaskRecord_u24lambda_u2d3.setId(this.allocateRecordId());
            $this$getTaskRecord_u24lambda_u2d3.setThreadId(Thread.currentThread().getId());
            GradleBuildProfileSpan.Builder builder2 = builder;
            String string = this.getProjectPath(taskPath);
            if (string == null) {
                return null;
            }
            String projectPath = string;
            String variantName = this.getVariantName(taskPath);
            Map map = this.taskRecords;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
            TaskProfilingRecord taskProfilingRecord = new TaskProfilingRecord(this, builder2, taskPath, projectPath, variantName);
            boolean bl4 = false;
            map.put(taskPath, taskProfilingRecord);
        }
        return this.taskRecords.get(taskPath);
    }

    public final void recordTaskExecutionSpan(@Nullable FinishEvent finishEvent) {
        if (finishEvent == null || !(finishEvent instanceof TaskFinishEvent)) {
            return;
        }
        String taskPath = ((TaskFinishEvent)finishEvent).getDescriptor().getTaskPath();
        Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        if (taskProfilingRecord == null) {
            return;
        }
        TaskProfilingRecord taskRecord2 = taskProfilingRecord;
        String string = this.getTypeName(taskPath);
        if (string == null) {
            return;
        }
        String typeName = string;
        GradleTaskExecutionType taskType = this.getTaskExecutionType(typeName);
        TaskOperationResult taskResult = ((TaskFinishEvent)finishEvent).getResult();
        taskRecord2.getSpanBuilder().getTaskBuilder().setType(taskType.getNumber()).setDidWork(!(taskResult instanceof TaskSkippedResult)).setSkipped(taskResult instanceof TaskSkippedResult).setUpToDate(taskResult instanceof TaskSuccessResult && ((TaskSuccessResult)taskResult).isUpToDate()).setFailed(taskResult instanceof TaskFailureResult);
        taskRecord2.setTaskStartTime(taskResult.getStartTime());
        taskRecord2.setTaskEndTime(taskResult.getEndTime());
        taskRecord2.writeTaskSpan();
        this.createAndRecordMemorySample();
    }

    public final synchronized long allocateRecordId() {
        if (this.lastRecordId == null) {
            int spansCount = this.configurationSpans.size();
            this.lastRecordId = new AtomicLong(1 + spansCount);
        }
        AtomicLong atomicLong = this.lastRecordId;
        Intrinsics.checkNotNull((Object)atomicLong);
        return atomicLong.incrementAndGet();
    }

    public final void recordBlockAtConfiguration(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant2, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variant2)), Long.valueOf(this.allocateRecordId()), block);
        this.configurationSpans.add(span);
    }

    public final void recordBlockAtExecution(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @Nullable GradleTransformExecution transform2, @NotNull String projectPath, @Nullable String variantName, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, transform2, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variantName)), Long.valueOf(this.allocateRecordId()), block);
        this.executionSpans.add(span);
    }

    public final void writeRecord(@NotNull String projectPath, @Nullable String variantName, @NotNull GradleBuildProfileSpan.Builder executionRecord, @NotNull List<GradleBuildProfileSpan> taskExecutionPhases) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)executionRecord, (String)"executionRecord");
        Intrinsics.checkNotNullParameter(taskExecutionPhases, (String)"taskExecutionPhases");
        long l = this.getProjectId(projectPath);
        boolean bl = false;
        boolean bl2 = false;
        long it = l;
        boolean bl3 = false;
        executionRecord.setProject(it);
        if (variantName == null) {
            executionRecord.setVariant(0L);
        } else {
            l = this.getVariantId(projectPath, variantName);
            bl = false;
            bl2 = false;
            it = l;
            boolean bl4 = false;
            executionRecord.setVariant(it);
        }
        this.executionSpans.add(executionRecord.build());
        Collection collection = taskExecutionPhases;
        bl = false;
        if (!collection.isEmpty()) {
            GradleBuildProfileSpan firstPhase = taskExecutionPhases.get(0);
            this.executionSpans.add(GradleBuildProfileSpan.newBuilder().setType(GradleBuildProfileSpan.ExecutionType.GRADLE_PRE_TASK_SPAN).setParentId(executionRecord.getId()).setThreadId(executionRecord.getThreadId()).setStartTimeInMs(executionRecord.getStartTimeInMs()).setDurationInMs(firstPhase.getStartTimeInMs() - executionRecord.getStartTimeInMs()).build());
        }
        this.executionSpans.addAll((Collection<GradleBuildProfileSpan>)taskExecutionPhases);
    }

    public final void configureAnalyticsService(@NotNull AnalyticsService.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        params.getProfile().set((Object)Base64.getEncoder().encodeToString(this.profileBuilder.build().toByteArray()));
        params.getAnonymizer().set((Object)new NameAnonymizerSerializer().toJson((Object)this.nameAnonymizer));
        params.getProjects().set((Map)this.projects);
        params.getEnableProfileJson().set((Object)this.enableProfileJson);
        params.getProfileDir().set((Object)this.profileDir);
        params.getTaskMetadata().set((Map)this.taskMetadata);
        params.getRootProjectPath().set((Object)this.rootProjectPath);
    }

    /*
     * WARNING - void declaration
     */
    public final void recordGlobalProperties(@NotNull Project project2) {
        void buildServiceRegistry$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(ProjectOptionService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        ProjectOptions projectOptions = ((ProjectOptionService)provider.get()).getProjectOptions();
        ProviderFactory providers = project2.getProviders();
        this.recordPlugins(project2);
        Intrinsics.checkNotNullExpressionValue((Object)providers, (String)"providers");
        this.profileBuilder.setOsName(this.getSystemProperty(providers, "os.name")).setOsVersion(this.getSystemProperty(providers, "os.version")).setJavaVersion(this.getSystemProperty(providers, "java.version")).setJavaVmVersion(this.getSystemProperty(providers, "java.vm.version")).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(project2.getGradle().getGradleVersion());
        object = project2.getGradle().getStartParameter();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.gradle.startParameter");
        Boolean configCachingEnabled = StartParameterUtils.isConfigurationCache((StartParameter)object);
        if (configCachingEnabled != null) {
            this.profileBuilder.setConfigurationCachingEnabled(configCachingEnabled.booleanValue());
        }
        this.profileBuilder.setParallelTaskExecution(project2.getGradle().getStartParameter().isParallelProjectExecutionEnabled());
        object = project2.getRootProject().getProjectDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.rootProject.projectDir.absolutePath");
        this.rootProjectPath = StringsKt.replace$default((String)object, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        this.enableProfileJson = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        provider = project2.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.gradle");
        object = this.getProfileDir(projectOptions, (Gradle)provider);
        this.profileDir = object == null ? null : object.toFile();
    }

    public final void collectTaskMetadata(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        for (Task task : graph.getAllTasks()) {
            String variantName = task instanceof VariantAwareTask ? ((VariantAwareTask)task).getVariantName() : (String)task.getExtensions().findByName("AGP_VARIANT_NAME");
            Map map = this.taskMetadata;
            String string = task.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.path");
            Object object = task.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.project.path");
            String string2 = object;
            object = AnalyticsUtil.getPotentialTaskExecutionTypeName(task.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPotentialTaskExecutionTypeName(task.javaClass)");
            object = new TaskMetadata(string2, variantName, (String)object);
            boolean bl = false;
            map.put(string, object);
        }
    }

    public final void recordEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.otherEvents.add(event);
    }

    public final void recordApplicationId(@NotNull File metadataFile) {
        Intrinsics.checkNotNullParameter((Object)metadataFile, (String)"metadataFile");
        this.applicationIds.add(FilesKt.readText$default((File)metadataFile, null, (int)1, null));
    }

    private final long getProjectId(String projectPath) {
        Long id;
        Long l;
        ProjectData projectData = this.projects.get(projectPath);
        if (projectData == null) {
            l = null;
        } else {
            GradleBuildProject.Builder builder = projectData.getProjectBuilder();
            l = id = Long.valueOf(builder.getId());
        }
        if (id != null) {
            return id;
        }
        return this.nameAnonymizer.anonymizeProjectPath(projectPath);
    }

    private final long getVariantId(String projectPath, String variantName) {
        Long variantId;
        Long l;
        ProjectData projectData = this.projects.get(projectPath);
        if (projectData == null) {
            l = null;
        } else {
            Map<String, GradleBuildVariant.Builder> map;
            Map<String, GradleBuildVariant.Builder> map2 = map = projectData.getVariantBuilders();
            boolean bl = false;
            GradleBuildVariant.Builder builder = map2.get(variantName);
            l = variantId = builder == null ? null : Long.valueOf(builder.getId());
        }
        if (variantId != null) {
            return variantId;
        }
        return this.nameAnonymizer.anonymizeVariant(projectPath, variantName);
    }

    private final String getProjectPath(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata == null ? null : taskMetadata.getProjectPath();
    }

    private final String getVariantName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata == null ? null : taskMetadata.getVariantName();
    }

    private final String getTypeName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata == null ? null : taskMetadata.getTypeName();
    }

    private final void recordPlugins(Project project2) {
        project2.getGradle().allprojects(arg_0 -> AnalyticsResourceManager.recordPlugins$lambda-7(this, arg_0));
    }

    public final void recordTaskNames(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        for (Task task : graph.getAllTasks()) {
            String string = task.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.project.path");
            this.getProjectBuilder(string).addTaskNames(task.getClass().getName());
        }
    }

    private final GradleTaskExecutionType getTaskExecutionType(String taskName) {
        GradleTaskExecutionType gradleTaskExecutionType;
        try {
            gradleTaskExecutionType = GradleTaskExecutionType.valueOf((String)taskName);
        }
        catch (IllegalArgumentException ignored) {
            gradleTaskExecutionType = GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
        return gradleTaskExecutionType;
    }

    private final String getSystemProperty(ProviderFactory providerFactory, String propertyName) {
        Object object = providerFactory.systemProperty(propertyName).forUseAtConfigurationTime().orElse((Object)"").get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"providerFactory\n        \u2026se(\"\")\n            .get()");
        return (String)object;
    }

    private final GradleBuildProfile getFinalProfile() {
        Object object;
        this.profileBuilder.addMemorySample(this.initialMemorySample);
        GradleBuildMemorySample endMemorySample = this.createAndRecordMemorySample();
        this.profileBuilder.addAllSpan((Iterable)this.configurationSpans);
        this.profileBuilder.addAllSpan((Iterable)this.executionSpans);
        Map $this$forEach$iv = this.projects;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl2 = false;
            GradleBuildProject.Builder projectBuilder = ((ProjectData)it.getValue()).getProjectBuilder();
            Map<String, GradleBuildVariant.Builder> $this$forEach$iv2 = ((ProjectData)it.getValue()).getVariantBuilders();
            boolean $i$f$forEach2 = false;
            Map<String, GradleBuildVariant.Builder> map2 = $this$forEach$iv2;
            boolean bl3 = false;
            Iterator<Map.Entry<String, GradleBuildVariant.Builder>> iterator3 = map2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<String, GradleBuildVariant.Builder> element$iv2;
                Map.Entry<String, GradleBuildVariant.Builder> entry = element$iv2 = iterator3.next();
                boolean bl4 = false;
                projectBuilder.addVariant(entry.getValue());
            }
            this.profileBuilder.addProject(projectBuilder);
        }
        this.profileBuilder.setBuildTime(endMemorySample.getTimestamp() - this.initialMemorySample.getTimestamp()).setGcCount(endMemorySample.getGcCount() - this.initialMemorySample.getGcCount()).setGcTime(endMemorySample.getGcTimeMs() - this.initialMemorySample.getGcTimeMs());
        try {
            object = LoggerWrapper.getLogger(AnalyticsResourceManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(AnalyticsResourceManager::class.java)");
            object = Anonymizer.anonymizeUtf8((ILogger)((ILogger)object), (String)this.rootProjectPath);
        }
        catch (IOException e) {
            object = "*ANONYMIZATION_ERROR*";
        }
        Object anonymizedProjectId = object;
        this.profileBuilder.addAllRawProjectId((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)this.applicationIds)))).setProjectId((String)anonymizedProjectId);
        object = this.profileBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"profileBuilder.build()");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GradleBuildMemorySample createAndRecordMemorySample() {
        GradleBuildMemorySample stats = this.createMemorySample();
        GradleBuildProfile.Builder builder = this.profileBuilder;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (builder) {
            boolean bl3 = false;
            GradleBuildProfile.Builder builder2 = this.profileBuilder.addMemorySample(stats);
        }
        return stats;
    }

    private final GradleBuildMemorySample createMemorySample() {
        GradleBuildMemorySample gradleBuildMemorySample = GradleBuildMemorySample.newBuilder().setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setTimestamp(System.currentTimeMillis()).build();
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildMemorySample, (String)"newBuilder()\n           \u2026s())\n            .build()");
        return gradleBuildMemorySample;
    }

    private final Path getProfileDir(ProjectOptions projectOptions, Gradle gradle) {
        String profileDir = projectOptions.get(StringOption.PROFILE_OUTPUT_DIR);
        boolean enableJsonProfile = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        return profileDir != null ? gradle.getRootProject().file((Object)profileDir).toPath() : (enableJsonProfile ? gradle.getRootProject().getBuildDir().toPath().resolve("android-profile") : (Path)null);
    }

    private static final ProjectData getProjectBuilder$lambda-0(AnalyticsResourceManager this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleBuildProject.Builder projectBuilder = GradleBuildProject.newBuilder();
        projectBuilder.setId(this$0.nameAnonymizer.anonymizeProjectPath(it));
        Intrinsics.checkNotNullExpressionValue((Object)projectBuilder, (String)"projectBuilder");
        return new ProjectData(projectBuilder);
    }

    private static final ProjectData getVariantBuilder$lambda-1(AnalyticsResourceManager this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleBuildProject.Builder projectBuilder = GradleBuildProject.newBuilder();
        projectBuilder.setId(this$0.nameAnonymizer.anonymizeProjectPath(it));
        Intrinsics.checkNotNullExpressionValue((Object)projectBuilder, (String)"projectBuilder");
        return new ProjectData(projectBuilder);
    }

    private static final GradleBuildVariant.Builder getVariantBuilder$lambda-2(AnalyticsResourceManager this$0, String $projectPath, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$projectPath, (String)"$projectPath");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleBuildVariant.Builder variantBuilder = GradleBuildVariant.newBuilder();
        variantBuilder.setId(this$0.nameAnonymizer.anonymizeVariant($projectPath, it));
        return variantBuilder;
    }

    private static final void recordPlugins$lambda-7(AnalyticsResourceManager this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
        GradleBuildProject.Builder projectBuilder = this$0.getProjectBuilder(string);
        string = it.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.plugins");
        Iterable $this$forEach$iv = (Iterable)((Object)string);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Plugin plugin = (Plugin)element$iv;
            boolean bl = false;
            projectBuilder.addPlugin(AnalyticsUtil.toProto(plugin));
            projectBuilder.addPluginNames(plugin.getClass().getName());
        }
    }
}

