/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker.usages;

import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerModel;
import com.android.build.gradle.internal.res.shrinker.usages.ResourceUsageRecorder;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/res/shrinker/usages/ToolsAttributeUsageRecorder;", "Lcom/android/build/gradle/internal/res/shrinker/usages/ResourceUsageRecorder;", "rawResourcesPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getRawResourcesPath", "()Ljava/nio/file/Path;", "processRawXml", "", "path", "model", "Lcom/android/build/gradle/internal/res/shrinker/ResourceShrinkerModel;", "processResourceToolsAttributes", "", "", "recordUsages", "Companion", "gradle-core"})
public final class ToolsAttributeUsageRecorder
implements ResourceUsageRecorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path rawResourcesPath;
    @NotNull
    private static final String TOOLS_NAMESPACE = "http://schemas.android.com/tools";

    public ToolsAttributeUsageRecorder(@NotNull Path rawResourcesPath) {
        Intrinsics.checkNotNullParameter((Object)rawResourcesPath, (String)"rawResourcesPath");
        this.rawResourcesPath = rawResourcesPath;
    }

    @NotNull
    public final Path getRawResourcesPath() {
        return this.rawResourcesPath;
    }

    @Override
    public void recordUsages(@NotNull ResourceShrinkerModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Files.walk(this.rawResourcesPath, new FileVisitOption[0]).filter(ToolsAttributeUsageRecorder::recordUsages$lambda-0).forEach(arg_0 -> ToolsAttributeUsageRecorder.recordUsages$lambda-1(this, model, arg_0));
    }

    private final void processRawXml(Path path, ResourceShrinkerModel model) {
        this.processResourceToolsAttributes(path).forEach((arg_0, arg_1) -> ToolsAttributeUsageRecorder.processRawXml$lambda-2(model, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> processResourceToolsAttributes(Path path) {
        boolean bl = false;
        Map toolsAttributes = new LinkedHashMap();
        Closeable closeable = Files.newBufferedReader(path);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl4 = false;
            XMLInputFactory factory2 = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = factory2.createXMLStreamReader(reader);
            boolean rootElementProcessed = false;
            while (!rootElementProcessed && xmlStreamReader.hasNext()) {
                int n;
                int n2;
                xmlStreamReader.next();
                if (!xmlStreamReader.isStartElement()) continue;
                if (Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)"resources") && (n2 = 0) < (n = xmlStreamReader.getAttributeCount())) {
                    do {
                        int i;
                        if (!Intrinsics.areEqual((Object)xmlStreamReader.getAttributeNamespace(i = n2++), (Object)TOOLS_NAMESPACE)) continue;
                        String string = xmlStreamReader.getAttributeLocalName(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlStreamReader.getAttributeLocalName(i)");
                        String string2 = string;
                        string = xmlStreamReader.getAttributeValue(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlStreamReader.getAttributeValue(i)");
                        toolsAttributes.put(string2, string);
                    } while (n2 < n);
                }
                rootElementProcessed = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = ImmutableMap.copyOf((Map)toolsAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"copyOf(toolsAttributes)");
        return (Map)((Object)closeable);
    }

    private static final boolean recordUsages$lambda-0(Path it) {
        return StringsKt.endsWith((String)((Object)it.getFileName()).toString(), (String)".xml", (boolean)true);
    }

    private static final void recordUsages$lambda-1(ToolsAttributeUsageRecorder this$0, ResourceShrinkerModel $model, Path it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.processRawXml(it, $model);
    }

    private static final void processRawXml$lambda-2(ResourceShrinkerModel $model, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (key) {
            case "keep": {
                $model.getResourceStore().recordKeepToolAttribute(value);
                break;
            }
            case "discard": {
                $model.getResourceStore().recordDiscardToolAttribute(value);
                break;
            }
            case "shrinkMode": {
                int n = -1;
                switch (value.hashCode()) {
                    case -891986231: {
                        if (value.equals("strict")) {
                            n = 1;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        $model.getResourceStore().setSafeMode(false);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/res/shrinker/usages/ToolsAttributeUsageRecorder$Companion;", "", "()V", "TOOLS_NAMESPACE", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

