/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.workers.WorkerExecutorException;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110 H\u0002J\"\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0%R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/services/AsyncResourceProcessor;", "ServiceT", "Ljava/io/Closeable;", "owner", "", "executor", "Ljava/util/concurrent/ExecutorService;", "service", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "(Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/lang/Object;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;)V", "counter", "", "getErrorFormatMode", "()Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "futures", "", "Ljava/util/concurrent/Future;", "iLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getILogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "Ljava/lang/Object;", "await", "", "close", "drainFutures", "", "submit", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "action", "Lkotlin/Function1;", "gradle-core"})
@ThreadSafe
public final class AsyncResourceProcessor<ServiceT>
implements Closeable {
    @NotNull
    private final String owner;
    @NotNull
    private final ExecutorService executor;
    private final ServiceT service;
    @NotNull
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    private final Logger logger;
    @NotNull
    private final LoggerWrapper iLogger;
    private int counter;
    @NotNull
    private final List<Future<?>> futures;

    public AsyncResourceProcessor(@NotNull String owner, @NotNull ExecutorService executor, ServiceT service, @NotNull SyncOptions.ErrorFormatMode errorFormatMode) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        this.owner = owner;
        this.executor = executor;
        this.service = service;
        this.errorFormatMode = errorFormatMode;
        this.logger = Logging.getLogger(this.getClass());
        this.iLogger = new LoggerWrapper(this.logger);
        boolean bl = false;
        this.futures = new ArrayList();
    }

    @NotNull
    public final SyncOptions.ErrorFormatMode getErrorFormatMode() {
        return this.errorFormatMode;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final LoggerWrapper getILogger() {
        return this.iLogger;
    }

    public final synchronized void submit(@NotNull AnalyticsService analyticsService, @NotNull Function1<? super ServiceT, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String workerKey = Intrinsics.stringPlus((String)this.owner, (Object)(this.counter + 1));
        Object object = analyticsService.getTaskRecord(this.owner);
        if (object != null) {
            ((TaskProfilingRecord)object).addWorker(workerKey, GradleBuildProfileSpan.ExecutionType.THREAD_EXECUTION);
        }
        object = this.executor.submit(() -> AsyncResourceProcessor.submit$lambda-0(analyticsService, this, workerKey, action));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executor.submit {\n      \u2026ner, workerKey)\n        }");
        this.futures.add((Future<?>)object);
    }

    private final synchronized List<Future<?>> drainFutures() {
        boolean bl = false;
        List currentTasks = new ArrayList();
        currentTasks.addAll((Collection)this.futures);
        this.futures.clear();
        return currentTasks;
    }

    public final void await() {
        List<Future<?>> currentTasks = this.drainFutures();
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        for (Future<?> task : currentTasks) {
            try {
                task.get();
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        Collection collection = exceptions;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new WorkerExecutorException((Iterable)exceptions);
        }
    }

    @Override
    public void close() {
        this.await();
    }

    private static final void submit$lambda-0(AnalyticsService $analyticsService, AsyncResourceProcessor this$0, String $workerKey, Function1 $action) {
        Intrinsics.checkNotNullParameter((Object)$analyticsService, (String)"$analyticsService");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$workerKey, (String)"$workerKey");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        $analyticsService.workerStarted(this$0.owner, $workerKey);
        $action.invoke(this$0.service);
        $analyticsService.workerFinished(this$0.owner, $workerKey);
    }
}

